/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.utils.json.resourcerecords;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.xbill.DNS.Name;
import org.xbill.DNS.TLSARecord;
import org.xbill.DNS.utils.json.exception.JsonDeserializationException;
import org.xbill.DNS.utils.json.resourcerecords.AbstractRecordDeserializer;

public class TLSARecordDeserializer
extends AbstractRecordDeserializer<TLSARecord> {
    private static final long serialVersionUID = -9043318764404295577L;

    public TLSARecordDeserializer() {
        super(TLSARecord.class);
    }

    @Override
    protected TLSARecord createRecord(Name name, int dclass, long ttl, ObjectNode recordNode) {
        try {
            return new TLSARecord(name, dclass, ttl, (int)this.getNodeIntegerValue(recordNode, "certificateUsage"), (int)this.getNodeIntegerValue(recordNode, "selector"), (int)this.getNodeIntegerValue(recordNode, "matchingType"), this.getNodeStringValue(recordNode, "certificateAssociationData"));
        }
        catch (IOException e) {
            throw new JsonDeserializationException(JsonDeserializationException.JsonDeserializationExceptionCode.unexpectedMappingError, (Throwable)e, this.getTextualBeanType(), e.getMessage());
        }
    }

    @Override
    protected String getTextualRecordType() {
        return "TLSA";
    }
}

