/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.utils.json.resourcerecords;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.CharMatcher;
import java.util.ArrayList;
import org.xbill.DNS.Name;
import org.xbill.DNS.TXTRecord;
import org.xbill.DNS.utils.json.exception.JsonDeserializationException;
import org.xbill.DNS.utils.json.resourcerecords.AbstractRecordDeserializer;

public class TXTRecordDeserializer
extends AbstractRecordDeserializer<TXTRecord> {
    private static final String STRINGS_FIELD_NAME = "strings";
    private static final long serialVersionUID = -6018035758494572491L;

    public TXTRecordDeserializer() {
        super(TXTRecord.class);
    }

    @Override
    protected TXTRecord createRecord(Name name, int dclass, long ttl, ObjectNode recordNode) {
        try {
            JsonNode fieldNode = this.findFieldNode(recordNode, STRINGS_FIELD_NAME);
            if (fieldNode.isArray()) {
                ArrayList<String> strings = new ArrayList<String>(fieldNode.size());
                for (JsonNode jsonNode : fieldNode) {
                    String string = jsonNode.textValue();
                    this.checkStringIsASCII(string);
                    strings.add(string);
                }
                return new TXTRecord(name, dclass, ttl, strings);
            }
            String strings = fieldNode.textValue();
            this.checkStringIsASCII(strings);
            return new TXTRecord(name, dclass, ttl, strings);
        }
        catch (JsonDeserializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JsonDeserializationException(JsonDeserializationException.JsonDeserializationExceptionCode.unexpectedMappingError, (Throwable)e, this.getTextualBeanType(), e.getMessage());
        }
    }

    private void checkStringIsASCII(String string) {
        if (!CharMatcher.ASCII.matchesAllOf((CharSequence)string)) {
            throw new JsonDeserializationException(JsonDeserializationException.JsonDeserializationExceptionCode.invalidFieldValue, STRINGS_FIELD_NAME, this.getTextualBeanType(), "Non-ASCII character found");
        }
    }

    @Override
    protected String getTextualRecordType() {
        return "TXT";
    }
}

