/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.utils.json.resourcerecords;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.xbill.DNS.Name;
import org.xbill.DNS.URLRecord;
import org.xbill.DNS.utils.json.exception.JsonDeserializationException;
import org.xbill.DNS.utils.json.exception.MissingFieldJsonDeserializationException;
import org.xbill.DNS.utils.json.resourcerecords.AbstractRecordDeserializer;

public class URLRecordDeserializer
extends AbstractRecordDeserializer<URLRecord> {
    private static final long serialVersionUID = -1483861586185167072L;

    protected URLRecordDeserializer() {
        super(URLRecord.class);
    }

    @Override
    protected URLRecord createRecord(Name name, int dclass, long ttl, ObjectNode recordNode) {
        Integer redirectType;
        try {
            redirectType = this.getNodeIntegerValue(recordNode, "redirectType");
        }
        catch (MissingFieldJsonDeserializationException e) {
            return new URLRecord(name, dclass, ttl, this.getNodeStringValue(recordNode, "template"));
        }
        return new URLRecord(name, dclass, ttl, this.getNodeStringValue(recordNode, "template"), redirectType, this.getOptionalNodeStringValue(recordNode, "title"), this.getOptionalNodeStringValue(recordNode, "description"), this.getOptionalNodeStringValue(recordNode, "keywords"));
    }

    @Override
    protected String getTextualRecordType() {
        return "URL";
    }

    private String getOptionalNodeStringValue(ObjectNode recordNode, String nodeName) {
        String nodeValue;
        try {
            nodeValue = this.getNodeStringValue(recordNode, nodeName);
            this.checkStringLength(nodeValue, nodeName);
        }
        catch (MissingFieldJsonDeserializationException e) {
            nodeValue = null;
        }
        return nodeValue;
    }

    private void checkStringLength(String string, String field) {
        if (string != null && string.length() > 255) {
            throw new JsonDeserializationException(JsonDeserializationException.JsonDeserializationExceptionCode.invalidFieldValue, field, this.getTextualBeanType(), "String too long. Maximum is 255 characters");
        }
    }
}

