/*
 *  Copyright 2021-2025 Disney Streaming
 *
 *  Licensed under the Tomorrow Open Source Technology License, Version 1.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *     https://disneystreaming.github.io/TOST-1.0.txt
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package smithy4s.codegen

object AwsSpecs {
  val org = "com.disneystreaming.smithy"
  val knownVersion = "2025.04.08"

  val accessanalyzer = "aws-accessanalyzer-spec"
  val account = "aws-account-spec"
  val acmPca = "aws-acm-pca-spec"
  val acm = "aws-acm-spec"
  val amp = "aws-amp-spec"
  val amplify = "aws-amplify-spec"
  val amplifybackend = "aws-amplifybackend-spec"
  val amplifyuibuilder = "aws-amplifyuibuilder-spec"
  val apiGateway = "aws-api-gateway-spec"
  val apigatewaymanagementapi = "aws-apigatewaymanagementapi-spec"
  val apigatewayv2 = "aws-apigatewayv2-spec"
  val appMesh = "aws-app-mesh-spec"
  val appconfig = "aws-appconfig-spec"
  val appconfigdata = "aws-appconfigdata-spec"
  val appfabric = "aws-appfabric-spec"
  val appflow = "aws-appflow-spec"
  val appintegrations = "aws-appintegrations-spec"
  val applicationAutoScaling = "aws-application-auto-scaling-spec"
  val applicationDiscoveryService = "aws-application-discovery-service-spec"
  val applicationInsights = "aws-application-insights-spec"
  val applicationSignals = "aws-application-signals-spec"
  val applicationcostprofiler = "aws-applicationcostprofiler-spec"
  val apprunner = "aws-apprunner-spec"
  val appstream = "aws-appstream-spec"
  val appsync = "aws-appsync-spec"
  val apptest = "aws-apptest-spec"
  val arcZonalShift = "aws-arc-zonal-shift-spec"
  val artifact = "aws-artifact-spec"
  val athena = "aws-athena-spec"
  val auditmanager = "aws-auditmanager-spec"
  val autoScalingPlans = "aws-auto-scaling-plans-spec"
  val autoScaling = "aws-auto-scaling-spec"
  val b2bi = "aws-b2bi-spec"
  val backupGateway = "aws-backup-gateway-spec"
  val backup = "aws-backup-spec"
  val backupsearch = "aws-backupsearch-spec"
  val batch = "aws-batch-spec"
  val bcmDataExports = "aws-bcm-data-exports-spec"
  val bcmPricingCalculator = "aws-bcm-pricing-calculator-spec"
  val bedrockAgentRuntime = "aws-bedrock-agent-runtime-spec"
  val bedrockAgent = "aws-bedrock-agent-spec"
  val bedrockDataAutomationRuntime = "aws-bedrock-data-automation-runtime-spec"
  val bedrockDataAutomation = "aws-bedrock-data-automation-spec"
  val bedrockRuntime = "aws-bedrock-runtime-spec"
  val bedrock = "aws-bedrock-spec"
  val billing = "aws-billing-spec"
  val billingconductor = "aws-billingconductor-spec"
  val braket = "aws-braket-spec"
  val budgets = "aws-budgets-spec"
  val chatbot = "aws-chatbot-spec"
  val chimeSdkIdentity = "aws-chime-sdk-identity-spec"
  val chimeSdkMediaPipelines = "aws-chime-sdk-media-pipelines-spec"
  val chimeSdkMeetings = "aws-chime-sdk-meetings-spec"
  val chimeSdkMessaging = "aws-chime-sdk-messaging-spec"
  val chimeSdkVoice = "aws-chime-sdk-voice-spec"
  val chime = "aws-chime-spec"
  val cleanrooms = "aws-cleanrooms-spec"
  val cleanroomsml = "aws-cleanroomsml-spec"
  val cloud9 = "aws-cloud9-spec"
  val cloudcontrol = "aws-cloudcontrol-spec"
  val clouddirectory = "aws-clouddirectory-spec"
  val cloudformation = "aws-cloudformation-spec"
  val cloudfrontKeyvaluestore = "aws-cloudfront-keyvaluestore-spec"
  val cloudfront = "aws-cloudfront-spec"
  val cloudhsmV2 = "aws-cloudhsm-v2-spec"
  val cloudhsm = "aws-cloudhsm-spec"
  val cloudsearchDomain = "aws-cloudsearch-domain-spec"
  val cloudsearch = "aws-cloudsearch-spec"
  val cloudtrailData = "aws-cloudtrail-data-spec"
  val cloudtrail = "aws-cloudtrail-spec"
  val cloudwatchEvents = "aws-cloudwatch-events-spec"
  val cloudwatchLogs = "aws-cloudwatch-logs-spec"
  val cloudwatch = "aws-cloudwatch-spec"
  val codeartifact = "aws-codeartifact-spec"
  val codebuild = "aws-codebuild-spec"
  val codecatalyst = "aws-codecatalyst-spec"
  val codecommit = "aws-codecommit-spec"
  val codeconnections = "aws-codeconnections-spec"
  val codedeploy = "aws-codedeploy-spec"
  val codeguruReviewer = "aws-codeguru-reviewer-spec"
  val codeguruSecurity = "aws-codeguru-security-spec"
  val codeguruprofiler = "aws-codeguruprofiler-spec"
  val codepipeline = "aws-codepipeline-spec"
  val codestarConnections = "aws-codestar-connections-spec"
  val codestarNotifications = "aws-codestar-notifications-spec"
  val cognitoIdentityProvider = "aws-cognito-identity-provider-spec"
  val cognitoIdentity = "aws-cognito-identity-spec"
  val cognitoSync = "aws-cognito-sync-spec"
  val comprehend = "aws-comprehend-spec"
  val comprehendmedical = "aws-comprehendmedical-spec"
  val computeOptimizer = "aws-compute-optimizer-spec"
  val configService = "aws-config-service-spec"
  val connectContactLens = "aws-connect-contact-lens-spec"
  val connect = "aws-connect-spec"
  val connectcampaigns = "aws-connectcampaigns-spec"
  val connectcampaignsv2 = "aws-connectcampaignsv2-spec"
  val connectcases = "aws-connectcases-spec"
  val connectparticipant = "aws-connectparticipant-spec"
  val controlcatalog = "aws-controlcatalog-spec"
  val controltower = "aws-controltower-spec"
  val costAndUsageReportService = "aws-cost-and-usage-report-service-spec"
  val costExplorer = "aws-cost-explorer-spec"
  val costOptimizationHub = "aws-cost-optimization-hub-spec"
  val customerProfiles = "aws-customer-profiles-spec"
  val dataPipeline = "aws-data-pipeline-spec"
  val databaseMigrationService = "aws-database-migration-service-spec"
  val databrew = "aws-databrew-spec"
  val dataexchange = "aws-dataexchange-spec"
  val datasync = "aws-datasync-spec"
  val datazone = "aws-datazone-spec"
  val dax = "aws-dax-spec"
  val deadline = "aws-deadline-spec"
  val detective = "aws-detective-spec"
  val deviceFarm = "aws-device-farm-spec"
  val devopsGuru = "aws-devops-guru-spec"
  val directConnect = "aws-direct-connect-spec"
  val directoryServiceData = "aws-directory-service-data-spec"
  val directoryService = "aws-directory-service-spec"
  val dlm = "aws-dlm-spec"
  val docdbElastic = "aws-docdb-elastic-spec"
  val docdb = "aws-docdb-spec"
  val drs = "aws-drs-spec"
  val dsql = "aws-dsql-spec"
  val dynamodbStreams = "aws-dynamodb-streams-spec"
  val dynamodb = "aws-dynamodb-spec"
  val ebs = "aws-ebs-spec"
  val ec2InstanceConnect = "aws-ec2-instance-connect-spec"
  val ec2 = "aws-ec2-spec"
  val ecrPublic = "aws-ecr-public-spec"
  val ecr = "aws-ecr-spec"
  val ecs = "aws-ecs-spec"
  val efs = "aws-efs-spec"
  val eksAuth = "aws-eks-auth-spec"
  val eks = "aws-eks-spec"
  val elasticBeanstalk = "aws-elastic-beanstalk-spec"
  val elasticLoadBalancingV2 = "aws-elastic-load-balancing-v2-spec"
  val elasticLoadBalancing = "aws-elastic-load-balancing-spec"
  val elasticTranscoder = "aws-elastic-transcoder-spec"
  val elasticache = "aws-elasticache-spec"
  val elasticsearchService = "aws-elasticsearch-service-spec"
  val emrContainers = "aws-emr-containers-spec"
  val emrServerless = "aws-emr-serverless-spec"
  val emr = "aws-emr-spec"
  val entityresolution = "aws-entityresolution-spec"
  val eventbridge = "aws-eventbridge-spec"
  val evidently = "aws-evidently-spec"
  val finspaceData = "aws-finspace-data-spec"
  val finspace = "aws-finspace-spec"
  val firehose = "aws-firehose-spec"
  val fis = "aws-fis-spec"
  val fms = "aws-fms-spec"
  val forecast = "aws-forecast-spec"
  val forecastquery = "aws-forecastquery-spec"
  val frauddetector = "aws-frauddetector-spec"
  val freetier = "aws-freetier-spec"
  val fsx = "aws-fsx-spec"
  val gamelift = "aws-gamelift-spec"
  val gameliftstreams = "aws-gameliftstreams-spec"
  val geoMaps = "aws-geo-maps-spec"
  val geoPlaces = "aws-geo-places-spec"
  val geoRoutes = "aws-geo-routes-spec"
  val glacier = "aws-glacier-spec"
  val globalAccelerator = "aws-global-accelerator-spec"
  val glue = "aws-glue-spec"
  val grafana = "aws-grafana-spec"
  val greengrass = "aws-greengrass-spec"
  val greengrassv2 = "aws-greengrassv2-spec"
  val groundstation = "aws-groundstation-spec"
  val guardduty = "aws-guardduty-spec"
  val health = "aws-health-spec"
  val healthlake = "aws-healthlake-spec"
  val iam = "aws-iam-spec"
  val identitystore = "aws-identitystore-spec"
  val imagebuilder = "aws-imagebuilder-spec"
  val inspectorScan = "aws-inspector-scan-spec"
  val inspector = "aws-inspector-spec"
  val inspector2 = "aws-inspector2-spec"
  val internetmonitor = "aws-internetmonitor-spec"
  val invoicing = "aws-invoicing-spec"
  val iotDataPlane = "aws-iot-data-plane-spec"
  val iotEventsData = "aws-iot-events-data-spec"
  val iotEvents = "aws-iot-events-spec"
  val iotJobsDataPlane = "aws-iot-jobs-data-plane-spec"
  val iotManagedIntegrations = "aws-iot-managed-integrations-spec"
  val iotWireless = "aws-iot-wireless-spec"
  val iot = "aws-iot-spec"
  val iotanalytics = "aws-iotanalytics-spec"
  val iotdeviceadvisor = "aws-iotdeviceadvisor-spec"
  val iotfleethub = "aws-iotfleethub-spec"
  val iotfleetwise = "aws-iotfleetwise-spec"
  val iotsecuretunneling = "aws-iotsecuretunneling-spec"
  val iotsitewise = "aws-iotsitewise-spec"
  val iotthingsgraph = "aws-iotthingsgraph-spec"
  val iottwinmaker = "aws-iottwinmaker-spec"
  val ivsRealtime = "aws-ivs-realtime-spec"
  val ivs = "aws-ivs-spec"
  val ivschat = "aws-ivschat-spec"
  val kafka = "aws-kafka-spec"
  val kafkaconnect = "aws-kafkaconnect-spec"
  val kendraRanking = "aws-kendra-ranking-spec"
  val kendra = "aws-kendra-spec"
  val keyspaces = "aws-keyspaces-spec"
  val kinesisAnalyticsV2 = "aws-kinesis-analytics-v2-spec"
  val kinesisAnalytics = "aws-kinesis-analytics-spec"
  val kinesisVideoArchivedMedia = "aws-kinesis-video-archived-media-spec"
  val kinesisVideoMedia = "aws-kinesis-video-media-spec"
  val kinesisVideoSignaling = "aws-kinesis-video-signaling-spec"
  val kinesisVideoWebrtcStorage = "aws-kinesis-video-webrtc-storage-spec"
  val kinesisVideo = "aws-kinesis-video-spec"
  val kinesis = "aws-kinesis-spec"
  val kms = "aws-kms-spec"
  val lakeformation = "aws-lakeformation-spec"
  val lambda = "aws-lambda-spec"
  val launchWizard = "aws-launch-wizard-spec"
  val lexModelBuildingService = "aws-lex-model-building-service-spec"
  val lexModelsV2 = "aws-lex-models-v2-spec"
  val lexRuntimeService = "aws-lex-runtime-service-spec"
  val lexRuntimeV2 = "aws-lex-runtime-v2-spec"
  val licenseManagerLinuxSubscriptions = "aws-license-manager-linux-subscriptions-spec"
  val licenseManagerUserSubscriptions = "aws-license-manager-user-subscriptions-spec"
  val licenseManager = "aws-license-manager-spec"
  val lightsail = "aws-lightsail-spec"
  val location = "aws-location-spec"
  val lookoutequipment = "aws-lookoutequipment-spec"
  val lookoutmetrics = "aws-lookoutmetrics-spec"
  val lookoutvision = "aws-lookoutvision-spec"
  val m2 = "aws-m2-spec"
  val machineLearning = "aws-machine-learning-spec"
  val macie2 = "aws-macie2-spec"
  val mailmanager = "aws-mailmanager-spec"
  val managedblockchainQuery = "aws-managedblockchain-query-spec"
  val managedblockchain = "aws-managedblockchain-spec"
  val marketplaceAgreement = "aws-marketplace-agreement-spec"
  val marketplaceCatalog = "aws-marketplace-catalog-spec"
  val marketplaceCommerceAnalytics = "aws-marketplace-commerce-analytics-spec"
  val marketplaceDeployment = "aws-marketplace-deployment-spec"
  val marketplaceEntitlementService = "aws-marketplace-entitlement-service-spec"
  val marketplaceMetering = "aws-marketplace-metering-spec"
  val marketplaceReporting = "aws-marketplace-reporting-spec"
  val mediaconnect = "aws-mediaconnect-spec"
  val mediaconvert = "aws-mediaconvert-spec"
  val medialive = "aws-medialive-spec"
  val mediapackageVod = "aws-mediapackage-vod-spec"
  val mediapackage = "aws-mediapackage-spec"
  val mediapackagev2 = "aws-mediapackagev2-spec"
  val mediastoreData = "aws-mediastore-data-spec"
  val mediastore = "aws-mediastore-spec"
  val mediatailor = "aws-mediatailor-spec"
  val medicalImaging = "aws-medical-imaging-spec"
  val memorydb = "aws-memorydb-spec"
  val mgn = "aws-mgn-spec"
  val migrationHubRefactorSpaces = "aws-migration-hub-refactor-spaces-spec"
  val migrationHub = "aws-migration-hub-spec"
  val migrationhubConfig = "aws-migrationhub-config-spec"
  val migrationhuborchestrator = "aws-migrationhuborchestrator-spec"
  val migrationhubstrategy = "aws-migrationhubstrategy-spec"
  val mq = "aws-mq-spec"
  val mturk = "aws-mturk-spec"
  val mwaa = "aws-mwaa-spec"
  val neptuneGraph = "aws-neptune-graph-spec"
  val neptune = "aws-neptune-spec"
  val neptunedata = "aws-neptunedata-spec"
  val networkFirewall = "aws-network-firewall-spec"
  val networkflowmonitor = "aws-networkflowmonitor-spec"
  val networkmanager = "aws-networkmanager-spec"
  val networkmonitor = "aws-networkmonitor-spec"
  val notifications = "aws-notifications-spec"
  val notificationscontacts = "aws-notificationscontacts-spec"
  val oam = "aws-oam-spec"
  val observabilityadmin = "aws-observabilityadmin-spec"
  val omics = "aws-omics-spec"
  val opensearch = "aws-opensearch-spec"
  val opensearchserverless = "aws-opensearchserverless-spec"
  val opsworks = "aws-opsworks-spec"
  val opsworkscm = "aws-opsworkscm-spec"
  val organizations = "aws-organizations-spec"
  val osis = "aws-osis-spec"
  val outposts = "aws-outposts-spec"
  val panorama = "aws-panorama-spec"
  val partnercentralSelling = "aws-partnercentral-selling-spec"
  val paymentCryptographyData = "aws-payment-cryptography-data-spec"
  val paymentCryptography = "aws-payment-cryptography-spec"
  val pcaConnectorAd = "aws-pca-connector-ad-spec"
  val pcaConnectorScep = "aws-pca-connector-scep-spec"
  val pcs = "aws-pcs-spec"
  val personalizeEvents = "aws-personalize-events-spec"
  val personalizeRuntime = "aws-personalize-runtime-spec"
  val personalize = "aws-personalize-spec"
  val pi = "aws-pi-spec"
  val pinpointEmail = "aws-pinpoint-email-spec"
  val pinpointSmsVoiceV2 = "aws-pinpoint-sms-voice-v2-spec"
  val pinpointSmsVoice = "aws-pinpoint-sms-voice-spec"
  val pinpoint = "aws-pinpoint-spec"
  val pipes = "aws-pipes-spec"
  val polly = "aws-polly-spec"
  val pricing = "aws-pricing-spec"
  val privatenetworks = "aws-privatenetworks-spec"
  val proton = "aws-proton-spec"
  val qapps = "aws-qapps-spec"
  val qbusiness = "aws-qbusiness-spec"
  val qconnect = "aws-qconnect-spec"
  val qldbSession = "aws-qldb-session-spec"
  val qldb = "aws-qldb-spec"
  val quicksight = "aws-quicksight-spec"
  val ram = "aws-ram-spec"
  val rbin = "aws-rbin-spec"
  val rdsData = "aws-rds-data-spec"
  val rds = "aws-rds-spec"
  val redshiftData = "aws-redshift-data-spec"
  val redshiftServerless = "aws-redshift-serverless-spec"
  val redshift = "aws-redshift-spec"
  val rekognition = "aws-rekognition-spec"
  val rekognitionstreaming = "aws-rekognitionstreaming-spec"
  val repostspace = "aws-repostspace-spec"
  val resiliencehub = "aws-resiliencehub-spec"
  val resourceExplorer2 = "aws-resource-explorer-2-spec"
  val resourceGroupsTaggingApi = "aws-resource-groups-tagging-api-spec"
  val resourceGroups = "aws-resource-groups-spec"
  val robomaker = "aws-robomaker-spec"
  val rolesanywhere = "aws-rolesanywhere-spec"
  val route53Domains = "aws-route-53-domains-spec"
  val route53 = "aws-route-53-spec"
  val route53RecoveryCluster = "aws-route53-recovery-cluster-spec"
  val route53RecoveryControlConfig = "aws-route53-recovery-control-config-spec"
  val route53RecoveryReadiness = "aws-route53-recovery-readiness-spec"
  val route53profiles = "aws-route53profiles-spec"
  val route53resolver = "aws-route53resolver-spec"
  val rum = "aws-rum-spec"
  val s3Control = "aws-s3-control-spec"
  val s3 = "aws-s3-spec"
  val s3outposts = "aws-s3outposts-spec"
  val s3tables = "aws-s3tables-spec"
  val sagemakerA2iRuntime = "aws-sagemaker-a2i-runtime-spec"
  val sagemakerEdge = "aws-sagemaker-edge-spec"
  val sagemakerFeaturestoreRuntime = "aws-sagemaker-featurestore-runtime-spec"
  val sagemakerGeospatial = "aws-sagemaker-geospatial-spec"
  val sagemakerMetrics = "aws-sagemaker-metrics-spec"
  val sagemakerRuntime = "aws-sagemaker-runtime-spec"
  val sagemaker = "aws-sagemaker-spec"
  val savingsplans = "aws-savingsplans-spec"
  val scheduler = "aws-scheduler-spec"
  val schemas = "aws-schemas-spec"
  val secretsManager = "aws-secrets-manager-spec"
  val securityIr = "aws-security-ir-spec"
  val securityhub = "aws-securityhub-spec"
  val securitylake = "aws-securitylake-spec"
  val serverlessapplicationrepository = "aws-serverlessapplicationrepository-spec"
  val serviceCatalogAppregistry = "aws-service-catalog-appregistry-spec"
  val serviceCatalog = "aws-service-catalog-spec"
  val serviceQuotas = "aws-service-quotas-spec"
  val servicediscovery = "aws-servicediscovery-spec"
  val ses = "aws-ses-spec"
  val sesv2 = "aws-sesv2-spec"
  val sfn = "aws-sfn-spec"
  val shield = "aws-shield-spec"
  val signer = "aws-signer-spec"
  val simspaceweaver = "aws-simspaceweaver-spec"
  val sms = "aws-sms-spec"
  val snowDeviceManagement = "aws-snow-device-management-spec"
  val snowball = "aws-snowball-spec"
  val sns = "aws-sns-spec"
  val socialmessaging = "aws-socialmessaging-spec"
  val sqs = "aws-sqs-spec"
  val ssmContacts = "aws-ssm-contacts-spec"
  val ssmIncidents = "aws-ssm-incidents-spec"
  val ssmQuicksetup = "aws-ssm-quicksetup-spec"
  val ssmSap = "aws-ssm-sap-spec"
  val ssm = "aws-ssm-spec"
  val ssoAdmin = "aws-sso-admin-spec"
  val ssoOidc = "aws-sso-oidc-spec"
  val sso = "aws-sso-spec"
  val storageGateway = "aws-storage-gateway-spec"
  val sts = "aws-sts-spec"
  val supplychain = "aws-supplychain-spec"
  val supportApp = "aws-support-app-spec"
  val support = "aws-support-spec"
  val swf = "aws-swf-spec"
  val synthetics = "aws-synthetics-spec"
  val taxsettings = "aws-taxsettings-spec"
  val textract = "aws-textract-spec"
  val timestreamInfluxdb = "aws-timestream-influxdb-spec"
  val timestreamQuery = "aws-timestream-query-spec"
  val timestreamWrite = "aws-timestream-write-spec"
  val tnb = "aws-tnb-spec"
  val transcribeStreaming = "aws-transcribe-streaming-spec"
  val transcribe = "aws-transcribe-spec"
  val transfer = "aws-transfer-spec"
  val translate = "aws-translate-spec"
  val trustedadvisor = "aws-trustedadvisor-spec"
  val verifiedpermissions = "aws-verifiedpermissions-spec"
  val voiceId = "aws-voice-id-spec"
  val vpcLattice = "aws-vpc-lattice-spec"
  val wafRegional = "aws-waf-regional-spec"
  val waf = "aws-waf-spec"
  val wafv2 = "aws-wafv2-spec"
  val wellarchitected = "aws-wellarchitected-spec"
  val wisdom = "aws-wisdom-spec"
  val workdocs = "aws-workdocs-spec"
  val workmail = "aws-workmail-spec"
  val workmailmessageflow = "aws-workmailmessageflow-spec"
  val workspacesThinClient = "aws-workspaces-thin-client-spec"
  val workspacesWeb = "aws-workspaces-web-spec"
  val workspaces = "aws-workspaces-spec"
  val xray = "aws-xray-spec"
}
      