/*
 * Decompiled with CFR 0.152.
 */
package smithy4s.json;

import com.github.plokhotnyuk.jsoniter_scala.core.JsonCodec;
import com.github.plokhotnyuk.jsoniter_scala.core.WriterConfig$;
import java.io.Serializable;
import scala.Predef$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import smithy4s.Blob;
import smithy4s.Blob$;
import smithy4s.Document;
import smithy4s.codecs.Decoder;
import smithy4s.codecs.Encoder;
import smithy4s.codecs.PayloadError;
import smithy4s.json.JsonPayloadCodecCompiler;
import smithy4s.json.JsoniterCodecCompiler;
import smithy4s.json.internals.JsonPayloadCodecCompilerImpl$;
import smithy4s.json.internals.JsoniterCodecCompilerImpl$;
import smithy4s.schema.CachedSchemaCompiler;
import smithy4s.schema.Schema;
import smithy4s.schema.Schema$;

public final class Json$
implements Serializable {
    private static final Blob NullBlob;
    private static final Blob EmptyObjectBlob;
    private static final JsoniterCodecCompiler jsoniter;
    private static final Object jsoniterCodecGlobalCache;
    private static final JsonPayloadCodecCompiler payloadCodecs;
    private static final CachedSchemaCompiler payloadEncoders;
    private static final CachedSchemaCompiler payloadDecoders;
    private static final Object payloadEncodersGlobalCache;
    private static final Object payloadDecodersGlobalCache;
    private static final Encoder<Blob, Document> documentWriter;
    private static final Decoder<?, Blob, Document> documentDecoder;
    private static final Encoder<Blob, Document> prettyDocumentWriters;
    public static final Json$ MODULE$;

    private Json$() {
    }

    static {
        MODULE$ = new Json$();
        NullBlob = Blob$.MODULE$.apply("null");
        EmptyObjectBlob = Blob$.MODULE$.apply("{}");
        jsoniter = JsoniterCodecCompilerImpl$.MODULE$.defaultJsoniterCodecCompiler();
        jsoniterCodecGlobalCache = MODULE$.jsoniter().createCache();
        payloadCodecs = JsonPayloadCodecCompilerImpl$.MODULE$.defaultJsonPayloadCodecCompiler();
        payloadEncoders = MODULE$.payloadCodecs().encoders();
        payloadDecoders = MODULE$.payloadCodecs().decoders();
        payloadEncodersGlobalCache = MODULE$.payloadEncoders().createCache();
        payloadDecodersGlobalCache = MODULE$.payloadDecoders().createCache();
        documentWriter = (Encoder)MODULE$.payloadEncoders().fromSchema(Schema$.MODULE$.document());
        documentDecoder = (Decoder)MODULE$.payloadDecoders().fromSchema(Schema$.MODULE$.document());
        prettyDocumentWriters = (Encoder)MODULE$.payloadCodecs().withJsoniterWriterConfig(WriterConfig$.MODULE$.withIndentionStep(2)).encoders().fromSchema(Schema$.MODULE$.document());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Json$.class);
    }

    public Blob NullBlob() {
        return NullBlob;
    }

    public Blob EmptyObjectBlob() {
        return EmptyObjectBlob;
    }

    public <A> Either<PayloadError, A> read(Blob blob, Schema<A> evidence$1) {
        return (Either)((Decoder)this.payloadDecoders().fromSchema(Schema$.MODULE$.apply(evidence$1), payloadDecodersGlobalCache)).decode((Object)blob);
    }

    public <A> Blob writeBlob(A a, Schema<A> evidence$1) {
        return (Blob)((Encoder)this.payloadEncoders().fromSchema(Schema$.MODULE$.apply(evidence$1), payloadEncodersGlobalCache)).encode(a);
    }

    public <A> String writePrettyString(A a, Schema<A> evidence$1) {
        return ((Blob)((Encoder)this.payloadCodecs().withJsoniterWriterConfig(WriterConfig$.MODULE$.withIndentionStep(2)).encoders().fromSchema(Schema$.MODULE$.apply(evidence$1))).encode(a)).toUTF8String();
    }

    public Either<PayloadError, Document> readDocument(Blob blob) {
        return (Either)documentDecoder.decode((Object)blob);
    }

    public Either<PayloadError, Document> readDocument(String string) {
        return (Either)documentDecoder.decode((Object)Blob$.MODULE$.apply(string));
    }

    public Either<PayloadError, Document> readDocument(byte[] bytes) {
        return (Either)documentDecoder.decode((Object)Blob$.MODULE$.apply(bytes));
    }

    public Blob writeDocumentAsBlob(Document document) {
        return (Blob)documentWriter.encode((Object)document);
    }

    public String writeDocumentAsPrettyString(Document document) {
        return ((Blob)prettyDocumentWriters.encode((Object)document)).toUTF8String();
    }

    public JsoniterCodecCompiler jsoniter() {
        return jsoniter;
    }

    public <A> JsonCodec<A> deriveJsonCodec(Schema<A> evidence$1) {
        return (JsonCodec)this.jsoniter().fromSchema((Schema)Predef$.MODULE$.implicitly(evidence$1), jsoniterCodecGlobalCache);
    }

    public JsonPayloadCodecCompiler payloadCodecs() {
        return payloadCodecs;
    }

    public CachedSchemaCompiler<Encoder<Blob, Object>> payloadEncoders() {
        return payloadEncoders;
    }

    public CachedSchemaCompiler<Decoder<?, Blob, Object>> payloadDecoders() {
        return payloadDecoders;
    }
}

