/*
 * Decompiled with CFR 0.152.
 */
package smithy4s.json.internals;

import com.github.plokhotnyuk.jsoniter_scala.core.JsonReader;
import java.util.Arrays;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.collection.immutable.List;
import scala.package$;
import scala.runtime.Nothing$;
import smithy4s.codecs.PayloadError;
import smithy4s.codecs.PayloadPath;
import smithy4s.json.internals.Cursor$;
import smithy4s.json.internals.JCodec;

public class Cursor {
    private int[] indexStack = new int[8];
    private String[] labelStack = new String[8];
    private int top;
    private String expecting;

    public static <A> A withCursor(String string, Function1<Cursor, A> function1) {
        return Cursor$.MODULE$.withCursor(string, function1);
    }

    private String expecting() {
        return this.expecting;
    }

    public void smithy4s$json$internals$Cursor$$expecting_$eq(String x$0) {
        this.expecting = x$0;
    }

    public <A> A decode(JCodec<A> codec, JsonReader in) {
        this.smithy4s$json$internals$Cursor$$expecting_$eq(codec.expecting());
        return codec.decodeValue(this, in);
    }

    public <A> A under(PayloadPath.Segment segment, Function0<A> f) {
        PayloadPath.Segment segment2 = segment;
        if (segment2 instanceof PayloadPath.Segment$.Index) {
            PayloadPath.Segment$.Index i = (PayloadPath.Segment$.Index)segment2;
            return this.under(i.index(), f);
        }
        if (segment2 instanceof PayloadPath.Segment$.Label) {
            PayloadPath.Segment$.Label l = (PayloadPath.Segment$.Label)segment2;
            return this.under(l.label(), f);
        }
        throw new MatchError((Object)segment2);
    }

    public <A> A under(String label, Function0<A> f) {
        this.push(label);
        Object res = f.apply();
        this.pop();
        return (A)res;
    }

    public <A> A under(int index, Function0<A> f) {
        this.push(index);
        Object res = f.apply();
        this.pop();
        return (A)res;
    }

    public void push(String label) {
        if (this.top >= this.labelStack.length) {
            this.growStacks();
        }
        this.labelStack[this.top] = label;
        ++this.top;
    }

    public void push(int index) {
        if (this.top >= this.indexStack.length) {
            this.growStacks();
        }
        this.indexStack[this.top] = index;
        ++this.top;
    }

    public void pop() {
        if (this.top > 0) {
            --this.top;
        }
        this.labelStack[this.top] = null;
    }

    public <A> Nothing$ payloadError(JCodec<A> codec, String message) {
        throw new PayloadError(this.getPath((List<PayloadPath.Segment>)package$.MODULE$.Nil()), codec.expecting(), message);
    }

    public <A> Nothing$ requiredFieldError(JCodec<A> codec, String field) {
        return this.requiredFieldError(codec.expecting(), field);
    }

    public <A> Nothing$ requiredFieldError(String expecting, String field) {
        PayloadPath.Segment$.Label label = new PayloadPath.Segment$.Label(field);
        PayloadPath path = this.getPath((List<PayloadPath.Segment>)package$.MODULE$.Nil().$colon$colon((Object)label));
        throw new PayloadError(path, expecting, "Missing required field");
    }

    public PayloadPath getPath(List<PayloadPath.Segment> segments) {
        int top = this.top;
        List list = segments;
        while (top > 0) {
            String label;
            PayloadPath.Segment segment = (PayloadPath.Segment)((label = this.labelStack[--top]) != null ? new PayloadPath.Segment$.Label(label) : new PayloadPath.Segment$.Index(this.indexStack[top]));
            list = list.$colon$colon((Object)segment);
        }
        return new PayloadPath(list);
    }

    public String smithy4s$json$internals$Cursor$$getExpected() {
        if (this.expecting() != null) {
            return this.expecting();
        }
        throw new IllegalStateException("Expected should have been fulfilled");
    }

    private void growStacks() {
        int size = this.top << 1;
        this.labelStack = Arrays.copyOf(this.labelStack, size);
        this.indexStack = Arrays.copyOf(this.indexStack, size);
    }
}

