/*
 * Decompiled with CFR 0.152.
 */
package smithy4s.json.internals;

import alloy.Discriminated$;
import alloy.JsonUnknown$;
import alloy.Nullable$;
import alloy.Untagged;
import alloy.Untagged$;
import com.github.plokhotnyuk.jsoniter_scala.core.JsonReader;
import com.github.plokhotnyuk.jsoniter_scala.core.JsonWriter;
import com.github.plokhotnyuk.jsoniter_scala.core.JsonWriter$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.HashMap;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.immutable.VectorBuilder;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.Builder;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.ReusableBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.function.JProcedure2;
import scala.runtime.function.JProcedure3;
import scala.util.Either;
import smithy.api.JsonName$;
import smithy.api.Required$;
import smithy.api.TimestampFormat;
import smithy.api.TimestampFormat$;
import smithy4s.Bijection;
import smithy4s.Document;
import smithy4s.Document$;
import smithy4s.Hints;
import smithy4s.Hints$;
import smithy4s.Lazy;
import smithy4s.Newtype;
import smithy4s.Refinement;
import smithy4s.ShapeId;
import smithy4s.ShapeTag;
import smithy4s.Timestamp;
import smithy4s.capability.EncoderK$;
import smithy4s.codecs.Decoder;
import smithy4s.codecs.PayloadPath;
import smithy4s.internals.DiscriminatedUnionMember;
import smithy4s.internals.DiscriminatedUnionMember$;
import smithy4s.json.internals.Cursor;
import smithy4s.json.internals.JCodec;
import smithy4s.json.internals.SchemaVisitorJCodec$;
import smithy4s.json.internals.SchemaVisitorJCodec$PrimitiveJCodecs$;
import smithy4s.json.internals.SchemaVisitorJCodec$UnionJCodec$;
import smithy4s.kinds.PolyFunction;
import smithy4s.schema.Alt;
import smithy4s.schema.CollectionTag;
import smithy4s.schema.CompilationCache;
import smithy4s.schema.EnumTag;
import smithy4s.schema.EnumValue;
import smithy4s.schema.Field;
import smithy4s.schema.Field$;
import smithy4s.schema.FieldFilter;
import smithy4s.schema.Primitive;
import smithy4s.schema.Schema;
import smithy4s.schema.Schema$;
import smithy4s.schema.SchemaVisitor;

public class SchemaVisitorJCodec
extends SchemaVisitor.Cached<JCodec> {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(SchemaVisitorJCodec.class.getDeclaredField("UnionJCodec$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(SchemaVisitorJCodec.class.getDeclaredField("PrimitiveJCodecs$lzy1"));
    public final int smithy4s$json$internals$SchemaVisitorJCodec$$maxArity;
    public final boolean smithy4s$json$internals$SchemaVisitorJCodec$$infinitySupport;
    private final boolean flexibleCollectionsSupport;
    public final boolean smithy4s$json$internals$SchemaVisitorJCodec$$preserveMapOrder;
    private final boolean lenientTaggedUnionDecoding;
    private final CompilationCache cache;
    private final FieldFilter fieldFilter;
    public final Map<String, Object> smithy4s$json$internals$SchemaVisitorJCodec$$emptyMetadata;
    public final boolean smithy4s$json$internals$SchemaVisitorJCodec$$allowJsonStringNumerics;
    private volatile Object PrimitiveJCodecs$lzy1;
    public final JCodec<Document> smithy4s$json$internals$SchemaVisitorJCodec$$documentJCodec;
    private volatile Object UnionJCodec$lzy1;

    public SchemaVisitorJCodec(int maxArity, boolean infinitySupport, boolean flexibleCollectionsSupport, boolean preserveMapOrder, boolean lenientTaggedUnionDecoding, boolean lenientNumericDecoding, CompilationCache<JCodec> cache, FieldFilter fieldFilter) {
        this.smithy4s$json$internals$SchemaVisitorJCodec$$maxArity = maxArity;
        this.smithy4s$json$internals$SchemaVisitorJCodec$$infinitySupport = infinitySupport;
        this.flexibleCollectionsSupport = flexibleCollectionsSupport;
        this.smithy4s$json$internals$SchemaVisitorJCodec$$preserveMapOrder = preserveMapOrder;
        this.lenientTaggedUnionDecoding = lenientTaggedUnionDecoding;
        this.cache = cache;
        this.fieldFilter = fieldFilter;
        this.smithy4s$json$internals$SchemaVisitorJCodec$$emptyMetadata = (Map)Map$.MODULE$.empty();
        this.smithy4s$json$internals$SchemaVisitorJCodec$$allowJsonStringNumerics = lenientNumericDecoding || infinitySupport;
        this.smithy4s$json$internals$SchemaVisitorJCodec$$documentJCodec = this.PrimitiveJCodecs().document(maxArity);
    }

    public CompilationCache<JCodec> cache() {
        return this.cache;
    }

    public final SchemaVisitorJCodec$PrimitiveJCodecs$ PrimitiveJCodecs() {
        Object object = this.PrimitiveJCodecs$lzy1;
        if (object instanceof SchemaVisitorJCodec$PrimitiveJCodecs$) {
            return (SchemaVisitorJCodec$PrimitiveJCodecs$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (SchemaVisitorJCodec$PrimitiveJCodecs$)this.PrimitiveJCodecs$lzyINIT1();
    }

    private Object PrimitiveJCodecs$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.PrimitiveJCodecs$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    SchemaVisitorJCodec$PrimitiveJCodecs$ schemaVisitorJCodec$PrimitiveJCodecs$ = null;
                    try {
                        schemaVisitorJCodec$PrimitiveJCodecs$ = new SchemaVisitorJCodec$PrimitiveJCodecs$(this);
                        object2 = schemaVisitorJCodec$PrimitiveJCodecs$ == null ? LazyVals.NullValue$.MODULE$ : schemaVisitorJCodec$PrimitiveJCodecs$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.PrimitiveJCodecs$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return schemaVisitorJCodec$PrimitiveJCodecs$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public <P> JCodec<P> primitive(ShapeId shapeId, Hints hints, Primitive<P> tag) {
        Primitive<P> primitive = tag;
        if (Primitive.PBigDecimal$.MODULE$.equals(primitive)) {
            return this.PrimitiveJCodecs().bigdecimal();
        }
        if (Primitive.PBigInt$.MODULE$.equals(primitive)) {
            return this.PrimitiveJCodecs().bigint();
        }
        if (Primitive.PBlob$.MODULE$.equals(primitive)) {
            return this.PrimitiveJCodecs().bytes();
        }
        if (Primitive.PBoolean$.MODULE$.equals(primitive)) {
            return this.PrimitiveJCodecs().boolean();
        }
        if (Primitive.PByte$.MODULE$.equals(primitive)) {
            return this.PrimitiveJCodecs().byte();
        }
        if (Primitive.PDocument$.MODULE$.equals(primitive)) {
            return this.smithy4s$json$internals$SchemaVisitorJCodec$$documentJCodec;
        }
        if (Primitive.PDouble$.MODULE$.equals(primitive)) {
            return this.PrimitiveJCodecs().double();
        }
        if (Primitive.PFloat$.MODULE$.equals(primitive)) {
            return this.PrimitiveJCodecs().float();
        }
        if (Primitive.PInt$.MODULE$.equals(primitive)) {
            return this.PrimitiveJCodecs().int();
        }
        if (Primitive.PLong$.MODULE$.equals(primitive)) {
            return this.PrimitiveJCodecs().long();
        }
        if (Primitive.PShort$.MODULE$.equals(primitive)) {
            return this.PrimitiveJCodecs().short();
        }
        if (Primitive.PString$.MODULE$.equals(primitive)) {
            return this.PrimitiveJCodecs().string();
        }
        if (Primitive.PTimestamp$.MODULE$.equals(primitive)) {
            return this.timestampJCodec(hints, this.timestampJCodec$default$2());
        }
        if (Primitive.PUUID$.MODULE$.equals(primitive)) {
            return this.PrimitiveJCodecs().uuid();
        }
        throw new MatchError(primitive);
    }

    public JCodec<Timestamp> timestampJCodec(Hints hints, TimestampFormat defaultTimestamp) {
        TimestampFormat timestampFormat = (TimestampFormat)hints.get((ShapeTag)TimestampFormat$.MODULE$).getOrElse(() -> SchemaVisitorJCodec.timestampJCodec$$anonfun$1(defaultTimestamp));
        if (TimestampFormat.DATE_TIME$.MODULE$.equals(timestampFormat)) {
            return this.PrimitiveJCodecs().timestampDateTime();
        }
        if (TimestampFormat.EPOCH_SECONDS$.MODULE$.equals(timestampFormat)) {
            return this.PrimitiveJCodecs().timestampEpochSeconds();
        }
        if (TimestampFormat.HTTP_DATE$.MODULE$.equals(timestampFormat)) {
            return this.PrimitiveJCodecs().timestampHttpDate();
        }
        throw new MatchError((Object)timestampFormat);
    }

    public TimestampFormat timestampJCodec$default$2() {
        return TimestampFormat.EPOCH_SECONDS$.MODULE$;
    }

    private <A> JCodec<List<A>> listImpl(Schema<A> member) {
        return new JCodec<List<A>>(member, this){
            private final JCodec a;
            private final /* synthetic */ SchemaVisitorJCodec $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.a = (JCodec)$outer.apply(member$1);
            }

            public String expecting() {
                return "list";
            }

            public boolean canBeKey() {
                return false;
            }

            public List decodeValue(Cursor cursor, JsonReader in) {
                if (in.isNextToken((byte)91)) {
                    if (in.isNextToken((byte)93)) {
                        return package$.MODULE$.Nil();
                    }
                    in.rollbackToken();
                    ListBuffer builder = new ListBuffer();
                    int i = 0;
                    do {
                        if (i >= this.$outer.smithy4s$json$internals$SchemaVisitorJCodec$$maxArity) {
                            throw this.maxArityError(cursor);
                        }
                        cursor.push(i);
                        builder.$plus$eq(cursor.decode(this.a, in));
                        cursor.pop();
                        ++i;
                    } while (in.isNextToken((byte)44));
                    if (in.isCurrentToken((byte)93)) {
                        return builder.result();
                    }
                    throw in.arrayEndOrCommaError();
                }
                throw in.decodeError("Expected JSON array");
            }

            public void encodeValue(List xs, JsonWriter out) {
                out.writeArrayStart();
                for (List list = xs; list != package$.MODULE$.Nil(); list = (List)list.tail()) {
                    this.a.encodeValue(list.head(), out);
                }
                out.writeArrayEnd();
            }

            public List decodeKey(JsonReader in) {
                throw in.decodeError("Cannot use vectors as keys");
            }

            public void encodeKey(List xs, JsonWriter out) {
                throw out.encodeError("Cannot use vectors as keys");
            }

            private Nothing$ maxArityError(Cursor cursor) {
                throw cursor.payloadError(this, new StringBuilder(29).append("Input ").append(this.expecting()).append(" exceeded max arity of ").append(this.$outer.smithy4s$json$internals$SchemaVisitorJCodec$$maxArity).toString());
            }
        };
    }

    private <A> JCodec<Vector<A>> vector(Schema<A> member) {
        return new JCodec<Vector<A>>(member, this){
            private final JCodec a;
            private final /* synthetic */ SchemaVisitorJCodec $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.a = (JCodec)$outer.apply(member$2);
            }

            public String expecting() {
                return "list";
            }

            public boolean canBeKey() {
                return false;
            }

            public Vector decodeValue(Cursor cursor, JsonReader in) {
                if (in.isNextToken((byte)91)) {
                    if (in.isNextToken((byte)93)) {
                        return package$.MODULE$.Vector().empty();
                    }
                    in.rollbackToken();
                    ReusableBuilder builder = package$.MODULE$.Vector().newBuilder();
                    int i = 0;
                    do {
                        if (i >= this.$outer.smithy4s$json$internals$SchemaVisitorJCodec$$maxArity) {
                            throw this.maxArityError(cursor);
                        }
                        cursor.push(i);
                        builder.$plus$eq(cursor.decode(this.a, in));
                        cursor.pop();
                        ++i;
                    } while (in.isNextToken((byte)44));
                    if (in.isCurrentToken((byte)93)) {
                        return (Vector)builder.result();
                    }
                    throw in.arrayEndOrCommaError();
                }
                throw in.decodeError("Expected JSON array");
            }

            public void encodeValue(Vector xs, JsonWriter out) {
                out.writeArrayStart();
                xs.foreach((Function1)(JProcedure1 & Serializable)x -> this.a.encodeValue(x, out));
                out.writeArrayEnd();
            }

            public Vector decodeKey(JsonReader in) {
                throw in.decodeError("Cannot use vectors as keys");
            }

            public void encodeKey(Vector xs, JsonWriter out) {
                throw out.encodeError("Cannot use vectors as keys");
            }

            private Nothing$ maxArityError(Cursor cursor) {
                throw cursor.payloadError(this, new StringBuilder(29).append("Input ").append(this.expecting()).append(" exceeded max arity of ").append(this.$outer.smithy4s$json$internals$SchemaVisitorJCodec$$maxArity).toString());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{encodeValue$$anonfun$3(com.github.plokhotnyuk.jsoniter_scala.core.JsonWriter java.lang.Object )}, serializedLambda);
            }
        };
    }

    private <A> JCodec<IndexedSeq<A>> indexedSeq(Schema<A> member) {
        return new JCodec<IndexedSeq<A>>(member, this){
            private final JCodec a;
            private final Function1 withBuilder;
            private final /* synthetic */ SchemaVisitorJCodec $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.a = (JCodec)$outer.apply(member$3);
                this.withBuilder = CollectionTag.IndexedSeqTag$.MODULE$.compactBuilder(member$3);
            }

            public String expecting() {
                return "list";
            }

            public boolean canBeKey() {
                return false;
            }

            public Function1 withBuilder() {
                return this.withBuilder;
            }

            public IndexedSeq decodeValue(Cursor cursor, JsonReader in) {
                if (in.isNextToken((byte)91)) {
                    if (in.isNextToken((byte)93)) {
                        return package$.MODULE$.Vector().empty();
                    }
                    in.rollbackToken();
                    return (IndexedSeq)this.withBuilder().apply((JProcedure1 & Serializable)put -> {
                        int i = 0;
                        do {
                            if (i >= this.$outer.smithy4s$json$internals$SchemaVisitorJCodec$$maxArity) {
                                throw this.maxArityError(cursor);
                            }
                            cursor.push(i);
                            put.apply(cursor.decode(this.a, in));
                            cursor.pop();
                            ++i;
                        } while (in.isNextToken((byte)44));
                        if (!in.isCurrentToken((byte)93)) {
                            throw in.arrayEndOrCommaError();
                        }
                    });
                }
                throw in.decodeError("Expected JSON array");
            }

            public void encodeValue(IndexedSeq xs, JsonWriter out) {
                out.writeArrayStart();
                IndexedSeq indexedSeq = xs;
                if (indexedSeq instanceof ArraySeq) {
                    ArraySeq x2 = (ArraySeq)indexedSeq;
                    Object xs2 = x2.unsafeArray();
                    for (int i = 0; i < ScalaRunTime$.MODULE$.array_length(xs2); ++i) {
                        this.a.encodeValue(ScalaRunTime$.MODULE$.array_apply(xs2, i), out);
                    }
                } else {
                    xs.foreach((Function1)(JProcedure1 & Serializable)x -> this.a.encodeValue(x, out));
                }
                out.writeArrayEnd();
            }

            public IndexedSeq decodeKey(JsonReader in) {
                throw in.decodeError("Cannot use vectors as keys");
            }

            public void encodeKey(IndexedSeq xs, JsonWriter out) {
                throw out.encodeError("Cannot use vectors as keys");
            }

            private Nothing$ maxArityError(Cursor cursor) {
                throw cursor.payloadError(this, new StringBuilder(29).append("Input ").append(this.expecting()).append(" exceeded max arity of ").append(this.$outer.smithy4s$json$internals$SchemaVisitorJCodec$$maxArity).toString());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{decodeValue$$anonfun$1(smithy4s.json.internals.Cursor com.github.plokhotnyuk.jsoniter_scala.core.JsonReader scala.Function1 ), encodeValue$$anonfun$4(com.github.plokhotnyuk.jsoniter_scala.core.JsonWriter java.lang.Object )}, serializedLambda);
            }
        };
    }

    private <A> JCodec<Set<A>> set(Schema<A> member) {
        return new JCodec<Set<A>>(member, this){
            private final JCodec a;
            private final /* synthetic */ SchemaVisitorJCodec $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.a = (JCodec)$outer.apply(member$4);
            }

            public String expecting() {
                return "list";
            }

            public boolean canBeKey() {
                return false;
            }

            public Set decodeValue(Cursor cursor, JsonReader in) {
                if (in.isNextToken((byte)91)) {
                    if (in.isNextToken((byte)93)) {
                        return Predef$.MODULE$.Set().empty();
                    }
                    in.rollbackToken();
                    Builder builder = Predef$.MODULE$.Set().newBuilder();
                    int i = 0;
                    do {
                        if (i >= this.$outer.smithy4s$json$internals$SchemaVisitorJCodec$$maxArity) {
                            throw this.maxArityError(cursor);
                        }
                        cursor.push(i);
                        builder.$plus$eq(cursor.decode(this.a, in));
                        cursor.pop();
                        ++i;
                    } while (in.isNextToken((byte)44));
                    if (in.isCurrentToken((byte)93)) {
                        return (Set)builder.result();
                    }
                    throw in.arrayEndOrCommaError();
                }
                throw in.decodeError("Expected JSON array");
            }

            public void encodeValue(Set xs, JsonWriter out) {
                out.writeArrayStart();
                xs.foreach((Function1)(JProcedure1 & Serializable)x -> this.a.encodeValue(x, out));
                out.writeArrayEnd();
            }

            public Set decodeKey(JsonReader in) {
                throw in.decodeError("Cannot use vectors as keys");
            }

            public void encodeKey(Set xs, JsonWriter out) {
                throw out.encodeError("Cannot use vectors as keys");
            }

            private Nothing$ maxArityError(Cursor cursor) {
                throw cursor.payloadError(this, new StringBuilder(29).append("Input ").append(this.expecting()).append(" exceeded max arity of ").append(this.$outer.smithy4s$json$internals$SchemaVisitorJCodec$$maxArity).toString());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{encodeValue$$anonfun$5(com.github.plokhotnyuk.jsoniter_scala.core.JsonWriter java.lang.Object )}, serializedLambda);
            }
        };
    }

    private <K, V> JCodec<scala.collection.immutable.Map<K, V>> objectMap(JCodec<K> jk, JCodec<V> jv) {
        return new JCodec<scala.collection.immutable.Map<K, V>>(jk, jv, this){
            private final JCodec jk$1;
            private final JCodec jv$1;
            private final String expecting;
            private final /* synthetic */ SchemaVisitorJCodec $outer;
            {
                this.jk$1 = jk$3;
                this.jv$1 = jv$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.expecting = "map";
            }

            public String expecting() {
                return this.expecting;
            }

            public boolean canBeKey() {
                return false;
            }

            public scala.collection.immutable.Map decodeValue(Cursor cursor, JsonReader in) {
                if (in.isNextToken((byte)123)) {
                    if (in.isNextToken((byte)125)) {
                        return Predef$.MODULE$.Map().empty();
                    }
                    in.rollbackToken();
                    ReusableBuilder builder = this.$outer.smithy4s$json$internals$SchemaVisitorJCodec$$preserveMapOrder ? ListMap$.MODULE$.newBuilder() : Predef$.MODULE$.Map().newBuilder();
                    int i = 0;
                    do {
                        if (i >= this.$outer.smithy4s$json$internals$SchemaVisitorJCodec$$maxArity) {
                            throw this.maxArityError(cursor);
                        }
                        Object object = this.jk$1.decodeKey(in);
                        cursor.push(i);
                        A result = cursor.decode(this.jv$1, in);
                        cursor.pop();
                        builder.$plus$eq((Object)Tuple2$.MODULE$.apply(object, result));
                        ++i;
                    } while (in.isNextToken((byte)44));
                    if (in.isCurrentToken((byte)125)) {
                        return (scala.collection.immutable.Map)builder.result();
                    }
                    throw in.objectEndOrCommaError();
                }
                throw in.decodeError("Expected JSON object");
            }

            public void encodeValue(scala.collection.immutable.Map xs, JsonWriter out) {
                out.writeObjectStart();
                xs.foreach((Function1)(JProcedure1 & Serializable)kv -> {
                    this.jk$1.encodeKey(kv._1(), out);
                    this.jv$1.encodeValue(kv._2(), out);
                });
                out.writeObjectEnd();
            }

            public scala.collection.immutable.Map decodeKey(JsonReader in) {
                throw in.decodeError("Cannot use maps as keys");
            }

            public void encodeKey(scala.collection.immutable.Map xs, JsonWriter out) {
                throw out.encodeError("Cannot use maps as keys");
            }

            private Nothing$ maxArityError(Cursor cursor) {
                throw cursor.payloadError(this, new StringBuilder(29).append("Input ").append(this.expecting()).append(" exceeded max arity of ").append(this.$outer.smithy4s$json$internals$SchemaVisitorJCodec$$maxArity).toString());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{encodeValue$$anonfun$6(com.github.plokhotnyuk.jsoniter_scala.core.JsonWriter scala.Tuple2 )}, serializedLambda);
            }
        };
    }

    private <K, V> JCodec<scala.collection.immutable.Map<K, V>> arrayMap(Schema<K> k, Schema<V> v) {
        Field kField = Field$.MODULE$.required("key", k, (Function1 & Serializable)_$2 -> _$2._1());
        Field vField = Field$.MODULE$.required("value", v, (Function1 & Serializable)_$3 -> _$3._2());
        Schema kvCodec = Schema$.MODULE$.struct().apply((Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Field[]{kField, vField})), (Function1 & Serializable)fields -> Tuple2$.MODULE$.apply(fields.apply(0), fields.apply(1)));
        return this.listImpl(kvCodec).biject((Function1 & Serializable)_$4 -> _$4.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Function1 & Serializable)_$5 -> _$5.toList());
    }

    private <K, V> JCodec<scala.collection.immutable.Map<K, V>> flexibleNullParsingMap(JCodec<K> jk, JCodec<V> jv) {
        return new JCodec<scala.collection.immutable.Map<K, V>>(jk, jv, this){
            private final JCodec jk$2;
            private final JCodec jv$2;
            private final String expecting;
            private final /* synthetic */ SchemaVisitorJCodec $outer;
            {
                this.jk$2 = jk$4;
                this.jv$2 = jv$4;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.expecting = "map";
            }

            public String expecting() {
                return this.expecting;
            }

            public boolean canBeKey() {
                return false;
            }

            public scala.collection.immutable.Map decodeValue(Cursor cursor, JsonReader in) {
                if (in.isNextToken((byte)123)) {
                    if (in.isNextToken((byte)125)) {
                        return Predef$.MODULE$.Map().empty();
                    }
                    in.rollbackToken();
                    Builder builder = Predef$.MODULE$.Map().newBuilder();
                    int i = 0;
                    do {
                        Object object;
                        if (i >= this.$outer.smithy4s$json$internals$SchemaVisitorJCodec$$maxArity) {
                            throw this.maxArityError(cursor);
                        }
                        Object key = this.jk$2.decodeKey(in);
                        cursor.push(i);
                        if (in.isNextToken((byte)110)) {
                            object = in.readNullOrError((Object)BoxedUnit.UNIT, "Expected null");
                        } else {
                            in.rollbackToken();
                            A value = cursor.decode(this.jv$2, in);
                            Object object2 = Predef$.MODULE$.ArrowAssoc(key);
                            object = builder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object2, value));
                        }
                        cursor.pop();
                        ++i;
                    } while (in.isNextToken((byte)44));
                    if (in.isCurrentToken((byte)125)) {
                        return (scala.collection.immutable.Map)builder.result();
                    }
                    throw in.objectEndOrCommaError();
                }
                throw in.decodeError("Expected JSON object");
            }

            public void encodeValue(scala.collection.immutable.Map xs, JsonWriter out) {
                out.writeObjectStart();
                xs.foreach((Function1)(JProcedure1 & Serializable)kv -> {
                    this.jk$2.encodeKey(kv._1(), out);
                    this.jv$2.encodeValue(kv._2(), out);
                });
                out.writeObjectEnd();
            }

            public scala.collection.immutable.Map decodeKey(JsonReader in) {
                throw in.decodeError("Cannot use maps as keys");
            }

            public void encodeKey(scala.collection.immutable.Map xs, JsonWriter out) {
                throw out.encodeError("Cannot use maps as keys");
            }

            private Nothing$ maxArityError(Cursor cursor) {
                throw cursor.payloadError(this, new StringBuilder(29).append("Input ").append(this.expecting()).append(" exceeded max arity of ").append(this.$outer.smithy4s$json$internals$SchemaVisitorJCodec$$maxArity).toString());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{encodeValue$$anonfun$7(com.github.plokhotnyuk.jsoniter_scala.core.JsonWriter scala.Tuple2 )}, serializedLambda);
            }
        };
    }

    public <C, A> JCodec<Object> collection(ShapeId shapeId, Hints hints, CollectionTag<C> tag, Schema<A> member) {
        CollectionTag<C> collectionTag = tag;
        if (CollectionTag.ListTag$.MODULE$.equals(collectionTag)) {
            return this.listImpl(member);
        }
        if (CollectionTag.SetTag$.MODULE$.equals(collectionTag)) {
            return this.set(member);
        }
        if (CollectionTag.VectorTag$.MODULE$.equals(collectionTag)) {
            return this.vector(member);
        }
        if (CollectionTag.IndexedSeqTag$.MODULE$.equals(collectionTag)) {
            return this.indexedSeq(member);
        }
        throw new MatchError(collectionTag);
    }

    public <K, V> JCodec<scala.collection.immutable.Map<K, V>> map(ShapeId shapeId, Hints hints, Schema<K> key, Schema<V> value) {
        JCodec jk = (JCodec)this.apply(key);
        JCodec jv = (JCodec)this.apply(value);
        if (jk.canBeKey()) {
            if (this.flexibleCollectionsSupport && !value.isOption()) {
                return this.flexibleNullParsingMap(jk, jv);
            }
            return this.objectMap(jk, jv);
        }
        return this.arrayMap(key, value);
    }

    public <A, B> JCodec<B> biject(Schema<A> schema, Bijection<A, B> bijection) {
        return ((JCodec)this.apply(schema)).biject(bijection, (Function1 & Serializable)b -> bijection.from(b));
    }

    public <A, B> JCodec<B> refine(Schema<A> schema, Refinement<A, B> refinement) {
        return ((JCodec)this.apply(schema)).biject(refinement.asThrowingFunction(), (Function1 & Serializable)b -> refinement.from(b));
    }

    public <A> JCodec<A> lazily(Lazy<Schema<A>> suspend) {
        return new JCodec<A>(suspend, this){
            private final Lazy suspend$1;
            public static final long OFFSET$0;
            private volatile Object underlying$lzy1;
            private final /* synthetic */ SchemaVisitorJCodec $outer;
            {
                this.suspend$1 = suspend$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            static {
                OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic($anon$26.class.getDeclaredField("underlying$lzy1"));
            }

            public JCodec underlying() {
                Object object = this.underlying$lzy1;
                if (object instanceof JCodec) {
                    return (JCodec)object;
                }
                if (object == LazyVals.NullValue$.MODULE$) {
                    return null;
                }
                return (JCodec)this.underlying$lzyINIT1();
            }

            private Object underlying$lzyINIT1() {
                Object object;
                block8: {
                    while (true) {
                        if ((object = this.underlying$lzy1) == null) {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                            Object object2 = null;
                            JCodec jCodec = null;
                            try {
                                jCodec = (JCodec)this.$outer.apply((Schema)this.suspend$1.value());
                                object2 = jCodec == null ? LazyVals.NullValue$.MODULE$ : jCodec;
                            }
                            finally {
                                if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                    LazyVals.Waiting waiting = (LazyVals.Waiting)this.underlying$lzy1;
                                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                    waiting.countDown();
                                }
                            }
                            return jCodec;
                        }
                        if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                        if (object == LazyVals.Evaluating$.MODULE$) {
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                            continue;
                        }
                        if (!(object instanceof LazyVals.Waiting)) break;
                        ((LazyVals.Waiting)object).await();
                    }
                    return null;
                }
                return object;
            }

            public String expecting() {
                return this.underlying().expecting();
            }

            public Object decodeValue(Cursor cursor, JsonReader in) {
                return this.underlying().decodeValue(cursor, in);
            }

            public void encodeValue(Object x, JsonWriter out) {
                this.underlying().encodeValue(x, out);
            }

            public Object decodeKey(JsonReader in) {
                return this.underlying().decodeKey(in);
            }

            public void encodeKey(Object x, JsonWriter out) {
                this.underlying().encodeKey(x, out);
            }
        };
    }

    public final SchemaVisitorJCodec$UnionJCodec$ smithy4s$json$internals$SchemaVisitorJCodec$$UnionJCodec() {
        Object object = this.UnionJCodec$lzy1;
        if (object instanceof SchemaVisitorJCodec$UnionJCodec$) {
            return (SchemaVisitorJCodec$UnionJCodec$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (SchemaVisitorJCodec$UnionJCodec$)this.UnionJCodec$lzyINIT1();
    }

    private Object UnionJCodec$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.UnionJCodec$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    SchemaVisitorJCodec$UnionJCodec$ schemaVisitorJCodec$UnionJCodec$ = null;
                    try {
                        schemaVisitorJCodec$UnionJCodec$ = new SchemaVisitorJCodec$UnionJCodec$(this);
                        object2 = schemaVisitorJCodec$UnionJCodec$ == null ? LazyVals.NullValue$.MODULE$ : schemaVisitorJCodec$UnionJCodec$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.UnionJCodec$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return schemaVisitorJCodec$UnionJCodec$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private <U> JCodec<U> taggedUnion(Vector<Alt<U, ?>> alternatives, Alt.Dispatcher<U> dispatch) {
        return new TaggedUnionJCodec<U>(this, alternatives, dispatch, false);
    }

    private <U> JCodec<U> lenientTaggedUnion(Vector<Alt<U, ?>> alternatives, Alt.Dispatcher<U> dispatch) {
        return new TaggedUnionJCodec<U>(this, alternatives, dispatch, true);
    }

    private <U> JCodec<U> untaggedUnion(Vector<Alt<U, ?>> alternatives, Alt.Dispatcher<U> dispatch) {
        return new JCodec<U>(alternatives, dispatch, this){
            private final Function2[] handlerList;
            private final Alt.Precompiler precompiler;
            private final Function1 writer;
            private final /* synthetic */ SchemaVisitorJCodec $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                ArrayBuilder res = Array$.MODULE$.newBuilder(ClassTag$.MODULE$.apply(Function2.class));
                alternatives$1.foreach(arg_0 -> SchemaVisitorJCodec.smithy4s$json$internals$SchemaVisitorJCodec$$anon$29$$_$$lessinit$greater$$anonfun$3(res, $outer, arg_0));
                this.handlerList = (Function2[])res.result();
                this.precompiler = new Alt.Precompiler<Function1<Object, Function1<JsonWriter, BoxedUnit>>>(this){
                    private final /* synthetic */ $anon$29 $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public Function1 apply(String label, Schema instance) {
                        JCodec jcodecA = (JCodec)instance.compile((PolyFunction)this.$outer.smithy4s$json$internals$SchemaVisitorJCodec$_$$anon$$$outer());
                        return arg_0 -> SchemaVisitorJCodec.smithy4s$json$internals$SchemaVisitorJCodec$$anon$30$$_$apply$$anonfun$3(jcodecA, arg_0);
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{smithy4s$json$internals$SchemaVisitorJCodec$$anon$30$$_$apply$$anonfun$3(smithy4s.json.internals.JCodec java.lang.Object )}, serializedLambda);
                    }
                };
                this.writer = (Function1)dispatch$1.compile(this.precompiler(), EncoderK$.MODULE$.encoderKForFunction());
            }

            public String expecting() {
                return "untaggedUnion";
            }

            public boolean canBeKey() {
                return false;
            }

            public Object decodeValue(Cursor cursor, JsonReader in) {
                Object z = null;
                int len = this.handlerList.length;
                int i = 0;
                while (z == null && i < len) {
                    in.setMark();
                    Function2 handler = this.handlerList[i];
                    try {
                        z = handler.apply((Object)cursor, (Object)in);
                    }
                    catch (Throwable throwable) {
                        in.rollbackToMark();
                        ++i;
                    }
                }
                if (z != null) {
                    return z;
                }
                throw cursor.payloadError(this, "Could not decode untagged union");
            }

            public Alt.Precompiler precompiler() {
                return this.precompiler;
            }

            public Function1 writer() {
                return this.writer;
            }

            public void encodeValue(Object u, JsonWriter out) {
                ((Function1)this.writer().apply(u)).apply((Object)out);
            }

            public Object decodeKey(JsonReader in) {
                throw in.decodeError("Cannot use coproducts as keys");
            }

            public void encodeKey(Object u, JsonWriter out) {
                throw out.encodeError("Cannot use coproducts as keys");
            }

            public final /* synthetic */ SchemaVisitorJCodec smithy4s$json$internals$SchemaVisitorJCodec$_$$anon$$$outer() {
                return this.$outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{smithy4s$json$internals$SchemaVisitorJCodec$$anon$29$$_$$lessinit$greater$$anonfun$3(scala.collection.mutable.ArrayBuilder smithy4s.json.internals.SchemaVisitorJCodec smithy4s.schema.Alt )}, serializedLambda);
            }
        };
    }

    private <U> JCodec<U> discriminatedUnion(Vector<Alt<U, ?>> alternatives, String discriminated, Alt.Dispatcher<U> dispatch) {
        return new UnionJCodec<U>(alternatives, dispatch, discriminated, this){
            private final String discriminated$3;
            private final Alt.Precompiler precompiler;
            private final Function1 writer;
            private final /* synthetic */ SchemaVisitorJCodec $outer;
            {
                this.discriminated$3 = discriminated$1;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer, alternatives$2, true, dispatch$2);
                this.precompiler = new Alt.Precompiler<Function1<Object, Function1<JsonWriter, BoxedUnit>>>(discriminated$1, this){
                    private final String discriminated$2;
                    private final /* synthetic */ $anon$31 $outer;
                    {
                        this.discriminated$2 = discriminated$4;
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public Function1 apply(String label, Schema instance) {
                        String jsonLabel = (String)instance.hints().get((Newtype)JsonName$.MODULE$).map(SchemaVisitorJCodec::smithy4s$json$internals$SchemaVisitorJCodec$$anon$32$$_$_$$anonfun$6).getOrElse(() -> SchemaVisitorJCodec.smithy4s$json$internals$SchemaVisitorJCodec$$anon$32$$_$_$$anonfun$7(label));
                        JCodec jcodecA = (JCodec)instance.addHints(Hints$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Hints.Binding[]{Hints.Binding$.MODULE$.fromValue((Object)DiscriminatedUnionMember$.MODULE$.apply((String)Discriminated$.MODULE$.value((Object)this.discriminated$2), jsonLabel), DiscriminatedUnionMember$.MODULE$.tagInstance())}))).compile((PolyFunction)this.$outer.smithy4s$json$internals$SchemaVisitorJCodec$_$$anon$$$outer());
                        return arg_0 -> SchemaVisitorJCodec.smithy4s$json$internals$SchemaVisitorJCodec$$anon$32$$_$apply$$anonfun$4(jcodecA, arg_0);
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{smithy4s$json$internals$SchemaVisitorJCodec$$anon$32$$_$_$$anonfun$6(java.lang.String ), smithy4s$json$internals$SchemaVisitorJCodec$$anon$32$$_$_$$anonfun$7(java.lang.String ), smithy4s$json$internals$SchemaVisitorJCodec$$anon$32$$_$apply$$anonfun$4(smithy4s.json.internals.JCodec java.lang.Object )}, serializedLambda);
                    }
                };
                this.writer = (Function1)dispatch$2.compile(this.precompiler(), EncoderK$.MODULE$.encoderKForFunction());
            }

            public String expecting() {
                return "discriminated-union";
            }

            public boolean canBeKey() {
                return false;
            }

            public Object decodeValue(Cursor cursor, JsonReader in) {
                if (in.isNextToken((byte)123)) {
                    in.setMark();
                    if (in.skipToKey((String)Discriminated$.MODULE$.value((Object)this.discriminated$3))) {
                        String key = in.readString("");
                        in.rollbackToMark();
                        in.rollbackToken();
                        cursor.push(key);
                        Option<UnionJCodec.AltHandler<U, ?>> option = this.getHandler(key);
                        if (option instanceof Some) {
                            UnionJCodec.AltHandler handler = (UnionJCodec.AltHandler)((Some)option).value();
                            U result = handler.handle(cursor, in);
                            cursor.pop();
                            return result;
                        }
                        if (None$.MODULE$.equals(option)) {
                            throw in.discriminatorValueError(key);
                        }
                        throw new MatchError(option);
                    }
                    throw in.decodeError(new StringBuilder(29).append("Unable to find discriminator ").append(Discriminated$.MODULE$.value((Object)this.discriminated$3)).toString());
                }
                throw in.decodeError("Expected JSON object");
            }

            public Alt.Precompiler precompiler() {
                return this.precompiler;
            }

            public Function1 writer() {
                return this.writer;
            }

            public void encodeValue(Object u, JsonWriter out) {
                ((Function1)this.writer().apply(u)).apply((Object)out);
            }

            public Object decodeKey(JsonReader in) {
                throw in.decodeError("Cannot use coproducts as keys");
            }

            public void encodeKey(Object x, JsonWriter out) {
                throw out.encodeError("Cannot use coproducts as keys");
            }

            public final /* synthetic */ SchemaVisitorJCodec smithy4s$json$internals$SchemaVisitorJCodec$_$$anon$$$outer() {
                return this.$outer;
            }
        };
    }

    public <U> JCodec<U> union(ShapeId shapeId, Hints hints, Vector<Alt<U, ?>> alternatives, Alt.Dispatcher<U> dispatch) {
        Hints hints2 = hints;
        if (hints2 != null) {
            Option option = Untagged$.MODULE$.hint().unapply(hints2);
            if (!option.isEmpty()) {
                Untagged untagged = (Untagged)option.get();
                return this.untaggedUnion(alternatives, dispatch);
            }
            Option option2 = Discriminated$.MODULE$.hint().unapply(hints2);
            if (!option2.isEmpty()) {
                String string;
                String d = string = (String)option2.get();
                return this.discriminatedUnion(alternatives, d, dispatch);
            }
        }
        if (this.lenientTaggedUnionDecoding) {
            return this.lenientTaggedUnion(alternatives, dispatch);
        }
        return this.taggedUnion(alternatives, dispatch);
    }

    public <E> JCodec<E> enumeration(ShapeId shapeId, Hints hints, EnumTag<E> tag, List<EnumValue<E>> values, Function1<E, EnumValue<E>> total) {
        EnumTag<E> enumTag = tag;
        if (enumTag != null && EnumTag.IntEnum$.MODULE$.unapply(enumTag)) {
            return this.handleIntEnum(shapeId, hints, values, total, tag);
        }
        return this.handleEnum(shapeId, hints, values, total, tag);
    }

    private <E> JCodec<E> handleEnum(ShapeId shapeId, Hints hints, List<EnumValue<E>> values, Function1<E, EnumValue<E>> total, EnumTag<E> tag) {
        return new JCodec<E>(values, tag, total){
            private final Function1 total$2;
            private final scala.collection.immutable.Map nameMap;
            private final String expecting;
            private final Function2 decode;
            {
                Function2 & Serializable intersect;
                this.total$2 = total$1;
                this.nameMap = values$1.map(SchemaVisitorJCodec::smithy4s$json$internals$SchemaVisitorJCodec$$anon$33$$_$$lessinit$greater$$anonfun$4).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                this.expecting = new StringBuilder(15).append("enumeration: [").append(values$1.map(SchemaVisitorJCodec::smithy4s$json$internals$SchemaVisitorJCodec$$anon$33$$_$$lessinit$greater$$anonfun$5).mkString(", ")).append("]").toString();
                EnumTag enumTag = tag$1;
                if (enumTag instanceof EnumTag.OpenStringEnum) {
                    Function1 function1;
                    EnumTag.OpenStringEnum openStringEnum = EnumTag.OpenStringEnum$.MODULE$.unapply((EnumTag.OpenStringEnum)enumTag);
                    Function1 unknown = function1 = openStringEnum._1();
                    intersect = (Function2 & Serializable)(_$14, str) -> this.fromNameOpen((String)str, unknown);
                } else {
                    intersect = (Function2 & Serializable)(in, str) -> {
                        Option option = this.fromName((String)str);
                        if (option instanceof Some) {
                            Object value = ((Some)option).value();
                            return value;
                        }
                        if (None$.MODULE$.equals(option)) {
                            throw in.enumValueError(str);
                        }
                        throw new MatchError((Object)option);
                    };
                }
                this.decode = intersect;
            }

            private Option fromName(String v) {
                return this.nameMap.get((Object)v);
            }

            private Object fromNameOpen(String v, Function1 unknown) {
                return this.nameMap.getOrElse((Object)v, () -> SchemaVisitorJCodec.smithy4s$json$internals$SchemaVisitorJCodec$$anon$33$$_$fromNameOpen$$anonfun$1(unknown, v));
            }

            public String expecting() {
                return this.expecting;
            }

            public Object decodeValue(Cursor cursor, JsonReader in) {
                String str = in.readString(null);
                return this.decode.apply((Object)in, (Object)str);
            }

            public void encodeValue(Object x, JsonWriter out) {
                out.writeVal(((EnumValue)this.total$2.apply(x)).stringValue());
            }

            public Object decodeKey(JsonReader in) {
                String str = in.readKeyAsString();
                return this.decode.apply((Object)in, (Object)str);
            }

            public void encodeKey(Object x, JsonWriter out) {
                out.writeKey(((EnumValue)this.total$2.apply(x)).stringValue());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{smithy4s$json$internals$SchemaVisitorJCodec$$anon$33$$_$$lessinit$greater$$anonfun$4(smithy4s.schema.EnumValue ), smithy4s$json$internals$SchemaVisitorJCodec$$anon$33$$_$$lessinit$greater$$anonfun$5(smithy4s.schema.EnumValue ), $init$$$anonfun$6(scala.Function1 com.github.plokhotnyuk.jsoniter_scala.core.JsonReader java.lang.String ), $init$$$anonfun$7(com.github.plokhotnyuk.jsoniter_scala.core.JsonReader java.lang.String ), smithy4s$json$internals$SchemaVisitorJCodec$$anon$33$$_$fromNameOpen$$anonfun$1(scala.Function1 java.lang.String )}, serializedLambda);
            }
        };
    }

    private <E> JCodec<E> handleIntEnum(ShapeId shapeId, Hints hints, List<EnumValue<E>> values, Function1<E, EnumValue<E>> total, EnumTag<E> tag) {
        return new JCodec<E>(values, tag, total){
            private final Function1 total$4;
            private final scala.collection.immutable.Map ordinalMap;
            private final String expecting;
            private final Function2 decode;
            {
                Function2 & Serializable intersect;
                this.total$4 = total$3;
                this.ordinalMap = values$2.map(SchemaVisitorJCodec::smithy4s$json$internals$SchemaVisitorJCodec$$anon$34$$_$$lessinit$greater$$anonfun$8).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                this.expecting = new StringBuilder(15).append("enumeration: [").append(values$2.map(SchemaVisitorJCodec::smithy4s$json$internals$SchemaVisitorJCodec$$anon$34$$_$$lessinit$greater$$anonfun$9).mkString(", ")).append("]").toString();
                EnumTag enumTag = tag$2;
                if (enumTag instanceof EnumTag.OpenIntEnum) {
                    Function1 function1;
                    EnumTag.OpenIntEnum openIntEnum = EnumTag.OpenIntEnum$.MODULE$.unapply((EnumTag.OpenIntEnum)enumTag);
                    Function1 unknown = function1 = openIntEnum._1();
                    intersect = (Function2 & Serializable)(_$16, i) -> this.$init$$$anonfun$10(unknown, (JsonReader)_$16, BoxesRunTime.unboxToInt((Object)i));
                } else {
                    intersect = (Function2 & Serializable)(in, i) -> this.$init$$$anonfun$11((JsonReader)in, BoxesRunTime.unboxToInt((Object)i));
                }
                this.decode = intersect;
            }

            private Option fromOrdinal(int v) {
                return this.ordinalMap.get((Object)BoxesRunTime.boxToInteger((int)v));
            }

            private Object fromOrdinalOpen(int v, Function1 unknown) {
                return this.ordinalMap.getOrElse((Object)BoxesRunTime.boxToInteger((int)v), () -> SchemaVisitorJCodec.smithy4s$json$internals$SchemaVisitorJCodec$$anon$34$$_$fromOrdinalOpen$$anonfun$1(unknown, v));
            }

            public String expecting() {
                return this.expecting;
            }

            public Object decodeValue(Cursor cursor, JsonReader in) {
                int i = in.readInt();
                return this.decode.apply((Object)in, (Object)BoxesRunTime.boxToInteger((int)i));
            }

            public void encodeValue(Object x, JsonWriter out) {
                out.writeVal(((EnumValue)this.total$4.apply(x)).intValue());
            }

            public Object decodeKey(JsonReader in) {
                int i = in.readKeyAsInt();
                return this.decode.apply((Object)in, (Object)BoxesRunTime.boxToInteger((int)i));
            }

            public void encodeKey(Object x, JsonWriter out) {
                out.writeKey(((EnumValue)this.total$4.apply(x)).intValue());
            }

            private final /* synthetic */ Object $init$$$anonfun$10(Function1 unknown$3, JsonReader _$16, int i) {
                return this.fromOrdinalOpen(i, unknown$3);
            }

            private final /* synthetic */ Object $init$$$anonfun$11(JsonReader in, int i) {
                Option option = this.fromOrdinal(i);
                if (option instanceof Some) {
                    Object value = ((Some)option).value();
                    return value;
                }
                if (None$.MODULE$.equals(option)) {
                    throw in.enumValueError(i);
                }
                throw new MatchError((Object)option);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{smithy4s$json$internals$SchemaVisitorJCodec$$anon$34$$_$$lessinit$greater$$anonfun$8(smithy4s.schema.EnumValue ), smithy4s$json$internals$SchemaVisitorJCodec$$anon$34$$_$$lessinit$greater$$anonfun$9(smithy4s.schema.EnumValue ), $init$$$anonfun$adapted$1(scala.Function1 java.lang.Object java.lang.Object ), $init$$$anonfun$adapted$2(java.lang.Object java.lang.Object ), smithy4s$json$internals$SchemaVisitorJCodec$$anon$34$$_$fromOrdinalOpen$$anonfun$1(scala.Function1 int )}, serializedLambda);
            }
        };
    }

    public <A> JCodec<Option<A>> option(Schema<A> schema) {
        return new JCodec<Option<A>>(schema, this){
            private final JCodec underlying;
            private final boolean aIsNullable;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.underlying = (JCodec)$outer.apply(schema$1);
                this.aIsNullable = schema$1.hints().has((ShapeTag)Nullable$.MODULE$) && schema$1.isOption();
            }

            public JCodec underlying() {
                return this.underlying;
            }

            public boolean aIsNullable() {
                return this.aIsNullable;
            }

            public String expecting() {
                return new StringBuilder(10).append("JsNull or ").append(this.underlying().expecting()).toString();
            }

            public Option decodeKey(JsonReader in) {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public void encodeKey(Option x, JsonWriter out) {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public void encodeValue(Option x, JsonWriter out) {
                Option option = x;
                if (None$.MODULE$.equals(option)) {
                    out.writeNull();
                    return;
                }
                if (option instanceof Some) {
                    Object value = ((Some)option).value();
                    this.underlying().encodeValue(value, out);
                    return;
                }
                throw new MatchError((Object)option);
            }

            public Option decodeValue(Cursor cursor, JsonReader in) {
                if (in.isNextToken((byte)110) && !this.aIsNullable()) {
                    return (Option)in.readNullOrError((Object)None$.MODULE$, "Expected null");
                }
                in.rollbackToken();
                return Some$.MODULE$.apply(this.underlying().decodeValue(cursor, in));
            }
        };
    }

    private <A, Z> String jsonLabel(Field<Z, A> field) {
        Option option = field.hints().get((Newtype)JsonName$.MODULE$);
        if (None$.MODULE$.equals(option)) {
            return field.label();
        }
        if (option instanceof Some) {
            String x = (String)((Some)option).value();
            return (String)JsonName$.MODULE$.value((Object)x);
        }
        throw new MatchError((Object)option);
    }

    private <Z, A> boolean isForJsonUnknown(Field<Z, A> field) {
        return field.hints().has((ShapeTag)JsonUnknown$.MODULE$);
    }

    public <Z, A> Function3<Cursor, JsonReader, HashMap<String, Object>, BoxedUnit> smithy4s$json$internals$SchemaVisitorJCodec$$fieldHandler(Field<Z, A> field, Object object) {
        JCodec codec2 = (JCodec)this.apply(field.schema());
        String label = field.label();
        boolean allowExplicitNulls = !field.hints().has((ShapeTag)Required$.MODULE$) && object != null && !field.hints().has((ShapeTag)Nullable$.MODULE$);
        Function3 & Serializable decodeFn = allowExplicitNulls ? (Function3 & Serializable)(cursor, codec, in) -> {
            if (in.isNextToken((byte)110)) {
                return in.readNullOrError(object, new StringBuilder(24).append("Expected null for field ").append(label).toString());
            }
            in.rollbackToken();
            return cursor.decode(codec, (JsonReader)in);
        } : (Function3 & Serializable)(_$17, _$18, _$19) -> _$17.decode(_$18, (JsonReader)_$19);
        return (JProcedure3 & Serializable)(cursor, in, mmap) -> {
            cursor.push(label);
            Object result = decodeFn.apply(cursor, (Object)codec2, in);
            cursor.pop();
            Object object = mmap.put(label, result);
        };
    }

    private void writeLabel(String label, JsonWriter out) {
        if (StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(label), (Function1 & Serializable)ch -> JsonWriter$.MODULE$.isNonEscapedAscii(BoxesRunTime.unboxToChar((Object)ch)))) {
            out.writeNonEscapedAsciiKey(label);
            return;
        }
        out.writeKey(label);
    }

    private <Z, A> Function2<Z, JsonWriter, BoxedUnit> fieldEncoder(Field<Z, A> field) {
        JCodec codec = (JCodec)this.apply(field.schema());
        String jLabel = this.jsonLabel(field);
        Function1 shouldRender = this.fieldFilter.compile(field);
        return (JProcedure2 & Serializable)(z, out) -> {
            Object a = field.get().apply(z);
            if (BoxesRunTime.unboxToBoolean((Object)shouldRender.apply(a))) {
                this.writeLabel(jLabel, (JsonWriter)out);
                codec.encodeValue(a, (JsonWriter)out);
                return;
            }
        };
    }

    private <Z, A> Function2<Z, JsonWriter, BoxedUnit> jsonUnknownFieldEncoder(Field<Z, A> field) {
        Document.Encoder docEncoder = (Document.Encoder)Document.Encoder$.MODULE$.fromSchema(field.schema());
        return (JProcedure2 & Serializable)(z, out) -> field.foreachUnlessDefault(z, (Function1)(JProcedure1 & Serializable)a -> {
            Document document = docEncoder.encode(a);
            if (document instanceof Document.DObject) {
                scala.collection.immutable.Map map;
                Document.DObject dObject = Document.DObject$.MODULE$.unapply((Document.DObject)document);
                scala.collection.immutable.Map value = map = dObject._1();
                value.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        String string = (String)tuple2._1();
                        Document document = (Document)tuple2._2();
                        if (string != null) {
                            String label = string;
                            if (document != null) {
                                Document value = document;
                                this.writeLabel(label, (JsonWriter)out);
                                this.smithy4s$json$internals$SchemaVisitorJCodec$$documentJCodec.encodeValue(value, (JsonWriter)out);
                                return;
                            }
                        }
                    }
                    throw new MatchError((Object)tuple2);
                });
                return;
            }
            throw out.encodeError(new StringBuilder(70).append("Failed encoding field ").append(field.label()).append(" because it cannot be converted to a JSON object").toString());
        });
    }

    private <Z> Vector<Tuple3<Field<Z, ?>, String, Object>> labelledFields(Vector<Field<Z, ?>> fields) {
        return (Vector)fields.map((Function1 & Serializable)field -> {
            String jLabel = this.jsonLabel((Field)field);
            Option decoded = field.schema().getDefaultValue();
            Object object = decoded.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            return Tuple3$.MODULE$.apply(field, (Object)jLabel, object);
        });
    }

    private <Z> JCodec<Z> structRetainUnknownFields(Vector<Tuple3<Field<Z, ?>, String, Object>> allFields, Vector<Tuple3<Field<Z, ?>, String, Object>> knownFields, Vector<Tuple3<Field<Z, ?>, String, Object>> fieldsForUnknown, Hints structHints, Function1<Vector<Object>, Z> function1, Function3<Z, JsonWriter, Vector<Function2<Z, JsonWriter, BoxedUnit>>, BoxedUnit> encode) {
        return new JCodec<Z>(fieldsForUnknown, knownFields, allFields, function1, encode, this){
            private final Vector allFields$2;
            private final Function1 const$2;
            private final Function3 encode$2;
            private final scala.collection.immutable.Map fieldForUnknownDocumentDecoders;
            private final HashMap handlers;
            private final Vector documentEncoders;
            private final /* synthetic */ SchemaVisitorJCodec $outer;
            {
                this.allFields$2 = allFields$1;
                this.const$2 = const$1;
                this.encode$2 = encode$1;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.fieldForUnknownDocumentDecoders = ((IterableOnceOps)fieldsForUnknown$1.map(SchemaVisitorJCodec::smithy4s$json$internals$SchemaVisitorJCodec$$anon$36$$_$$lessinit$greater$$anonfun$12)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                this.handlers = new HashMap<String, Function3<Cursor, JsonReader, HashMap<String, Object>, BoxedUnit>>(knownFields$1, this){
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        super(knownFields$2.length() << 1, 0.5f);
                        knownFields$2.foreach((Function1 & Serializable)x$1 -> {
                            Tuple3 tuple3 = x$1;
                            if (tuple3 != null) {
                                Field field = (Field)tuple3._1();
                                String jLabel = (String)tuple3._2();
                                Object object = tuple3._3();
                                return this.put(jLabel, $outer.smithy4s$json$internals$SchemaVisitorJCodec$_$$anon$$$outer().smithy4s$json$internals$SchemaVisitorJCodec$$fieldHandler(field, object));
                            }
                            throw new MatchError((Object)tuple3);
                        });
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$init$$$anonfun$13(smithy4s.json.internals.SchemaVisitorJCodec$$anon$36 scala.Tuple3 )}, serializedLambda);
                    }
                };
                this.documentEncoders = (Vector)((IterableOps)knownFields$1.map(arg_0 -> SchemaVisitorJCodec.smithy4s$json$internals$SchemaVisitorJCodec$$anon$36$$_$$lessinit$greater$$anonfun$14($outer, arg_0))).$plus$plus((IterableOnce)fieldsForUnknown$1.map(arg_0 -> SchemaVisitorJCodec.smithy4s$json$internals$SchemaVisitorJCodec$$anon$36$$_$$lessinit$greater$$anonfun$15($outer, arg_0)));
            }

            public String expecting() {
                return "object";
            }

            public boolean canBeKey() {
                return false;
            }

            public Object decodeValue(Cursor cursor, JsonReader in) {
                return this.decodeValue_(cursor, in).apply(this.$outer.smithy4s$json$internals$SchemaVisitorJCodec$$emptyMetadata);
            }

            private Function1 decodeValue_(Cursor cursor, JsonReader in) {
                ListBuffer unknownValues = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                HashMap<K, V> buffer = new HashMap<K, V>(this.handlers.size() << 1, 0.5f);
                if (in.isNextToken((byte)123)) {
                    if (!in.isNextToken((byte)125)) {
                        in.rollbackToken();
                        do {
                            Object object;
                            String key;
                            Function3 handler;
                            if ((handler = (Function3)this.handlers.get(key = in.readKeyAsString())) == null) {
                                Document value = this.$outer.smithy4s$json$internals$SchemaVisitorJCodec$$documentJCodec.decodeValue(cursor, in);
                                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
                                object = unknownValues.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)value));
                                continue;
                            }
                            object = handler.apply((Object)cursor, (Object)in, buffer);
                        } while (in.isNextToken((byte)44));
                        if (!in.isCurrentToken((byte)125)) {
                            throw in.objectEndOrCommaError();
                        }
                    }
                } else {
                    throw in.decodeError("Expected JSON object");
                }
                return (Function1 & Serializable)meta -> {
                    meta.foreach(arg_0 -> SchemaVisitorJCodec.smithy4s$json$internals$SchemaVisitorJCodec$$anon$36$$_$decodeValue_$$anonfun$1$$anonfun$1(buffer, arg_0));
                    VectorBuilder stage2 = new VectorBuilder();
                    Document unknownValue = unknownValues.nonEmpty() ? Document$.MODULE$.obj((Iterable)unknownValues) : null;
                    this.allFields$2.foreach((Function1 & Serializable)x$1 -> {
                        Tuple3 tuple3 = x$1;
                        if (tuple3 != null) {
                            Object object;
                            Field f = (Field)tuple3._1();
                            String jsonLabel = (String)tuple3._2();
                            Object object2 = tuple3._3();
                            Option option = this.fieldForUnknownDocumentDecoders.get((Object)jsonLabel);
                            if (None$.MODULE$.equals(option)) {
                                V value = buffer.get(f.label());
                                if (value == null) {
                                    if (object2 == null) {
                                        throw cursor.requiredFieldError(jsonLabel, jsonLabel);
                                    }
                                    object = object2;
                                } else {
                                    object = value;
                                }
                            } else if (option instanceof Some) {
                                Decoder docDecoder = (Decoder)((Some)option).value();
                                object = unknownValue == null ? (object2 == null ? ((Either)docDecoder.decode((Object)Document$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])))).getOrElse(() -> SchemaVisitorJCodec.smithy4s$json$internals$SchemaVisitorJCodec$$anon$36$$_$decodeValue_$$anonfun$1$$anonfun$2$$anonfun$1(in, cursor, f)) : object2) : ((Either)docDecoder.decode((Object)unknownValue)).getOrElse(() -> SchemaVisitorJCodec.smithy4s$json$internals$SchemaVisitorJCodec$$anon$36$$_$decodeValue_$$anonfun$1$$anonfun$2$$anonfun$2(in, cursor, f));
                            } else {
                                throw new MatchError((Object)option);
                            }
                            return (VectorBuilder)stage2.$plus$eq(object);
                        }
                        throw new MatchError((Object)tuple3);
                    });
                    return this.const$2.apply((Object)stage2.result());
                };
            }

            public void encodeValue(Object z, JsonWriter out) {
                this.encode$2.apply(z, (Object)out, (Object)this.documentEncoders);
            }

            public Object decodeKey(JsonReader in) {
                throw in.decodeError("Cannot use products as keys");
            }

            public void encodeKey(Object x, JsonWriter out) {
                throw out.encodeError("Cannot use products as keys");
            }

            public final /* synthetic */ SchemaVisitorJCodec smithy4s$json$internals$SchemaVisitorJCodec$_$$anon$$$outer() {
                return this.$outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{smithy4s$json$internals$SchemaVisitorJCodec$$anon$36$$_$$lessinit$greater$$anonfun$12(scala.Tuple3 ), smithy4s$json$internals$SchemaVisitorJCodec$$anon$36$$_$$lessinit$greater$$anonfun$14(smithy4s.json.internals.SchemaVisitorJCodec scala.Tuple3 ), smithy4s$json$internals$SchemaVisitorJCodec$$anon$36$$_$$lessinit$greater$$anonfun$15(smithy4s.json.internals.SchemaVisitorJCodec scala.Tuple3 ), decodeValue_$$anonfun$1(java.util.HashMap scala.collection.mutable.ListBuffer smithy4s.json.internals.Cursor com.github.plokhotnyuk.jsoniter_scala.core.JsonReader scala.collection.Map ), smithy4s$json$internals$SchemaVisitorJCodec$$anon$36$$_$decodeValue_$$anonfun$1$$anonfun$2$$anonfun$1(com.github.plokhotnyuk.jsoniter_scala.core.JsonReader smithy4s.json.internals.Cursor smithy4s.schema.Field ), smithy4s$json$internals$SchemaVisitorJCodec$$anon$36$$_$decodeValue_$$anonfun$1$$anonfun$2$$anonfun$2(com.github.plokhotnyuk.jsoniter_scala.core.JsonReader smithy4s.json.internals.Cursor smithy4s.schema.Field ), smithy4s$json$internals$SchemaVisitorJCodec$$anon$36$$_$decodeValue_$$anonfun$1$$anonfun$1(java.util.HashMap scala.Tuple2 ), decodeValue_$$anonfun$1$$anonfun$2(scala.collection.immutable.VectorBuilder java.util.HashMap smithy4s.json.internals.Cursor smithy4s.Document com.github.plokhotnyuk.jsoniter_scala.core.JsonReader scala.Tuple3 )}, serializedLambda);
            }
        };
    }

    private <Z> JCodec<Z> structIgnoreUnknownFields(Vector<Tuple3<Field<Z, ?>, String, Object>> fields, Hints structHints, Function1<Vector<Object>, Z> function1, Function3<Z, JsonWriter, Vector<Function2<Z, JsonWriter, BoxedUnit>>, BoxedUnit> encode) {
        return new JCodec<Z>(fields, function1, encode, this){
            private final Vector fields$3;
            private final Function1 const$4;
            private final Function3 encode$4;
            private final HashMap handlers;
            private final Vector documentEncoders;
            private final /* synthetic */ SchemaVisitorJCodec $outer;
            {
                this.fields$3 = fields$1;
                this.const$4 = const$3;
                this.encode$4 = encode$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.handlers = new HashMap<String, Function3<Cursor, JsonReader, HashMap<String, Object>, BoxedUnit>>(fields$1, this){
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        super(fields$2.length() << 1, 0.5f);
                        fields$2.foreach((Function1 & Serializable)x$1 -> {
                            Tuple3 tuple3 = x$1;
                            if (tuple3 != null) {
                                Field field = (Field)tuple3._1();
                                String jLabel = (String)tuple3._2();
                                Object object = tuple3._3();
                                return this.put(jLabel, $outer.smithy4s$json$internals$SchemaVisitorJCodec$_$$anon$$$outer().smithy4s$json$internals$SchemaVisitorJCodec$$fieldHandler(field, object));
                            }
                            throw new MatchError((Object)tuple3);
                        });
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$init$$$anonfun$16(smithy4s.json.internals.SchemaVisitorJCodec$$anon$38 scala.Tuple3 )}, serializedLambda);
                    }
                };
                this.documentEncoders = (Vector)fields$1.map(arg_0 -> SchemaVisitorJCodec.smithy4s$json$internals$SchemaVisitorJCodec$$anon$38$$_$$lessinit$greater$$anonfun$17($outer, arg_0));
            }

            public String expecting() {
                return "object";
            }

            public boolean canBeKey() {
                return false;
            }

            public Object decodeValue(Cursor cursor, JsonReader in) {
                return this.decodeValue_(cursor, in).apply(this.$outer.smithy4s$json$internals$SchemaVisitorJCodec$$emptyMetadata);
            }

            private Function1 decodeValue_(Cursor cursor, JsonReader in) {
                HashMap<K, V> buffer = new HashMap<K, V>(this.handlers.size() << 1, 0.5f);
                if (in.isNextToken((byte)123)) {
                    if (!in.isNextToken((byte)125)) {
                        in.rollbackToken();
                        do {
                            Function3 handler;
                            if ((handler = (Function3)this.handlers.get(in.readKeyAsString())) == null) {
                                in.skip();
                                continue;
                            }
                            handler.apply((Object)cursor, (Object)in, buffer);
                        } while (in.isNextToken((byte)44));
                        if (!in.isCurrentToken((byte)125)) {
                            throw in.objectEndOrCommaError();
                        }
                    }
                } else {
                    throw in.decodeError("Expected JSON object");
                }
                return (Function1 & Serializable)meta -> {
                    meta.foreach(arg_0 -> SchemaVisitorJCodec.smithy4s$json$internals$SchemaVisitorJCodec$$anon$38$$_$decodeValue_$$anonfun$2$$anonfun$1(buffer, arg_0));
                    VectorBuilder stage2 = new VectorBuilder();
                    this.fields$3.foreach(arg_0 -> SchemaVisitorJCodec.smithy4s$json$internals$SchemaVisitorJCodec$$anon$38$$_$decodeValue_$$anonfun$2$$anonfun$2(stage2, buffer, cursor, arg_0));
                    return this.const$4.apply((Object)stage2.result());
                };
            }

            public void encodeValue(Object z, JsonWriter out) {
                this.encode$4.apply(z, (Object)out, (Object)this.documentEncoders);
            }

            public Object decodeKey(JsonReader in) {
                throw in.decodeError("Cannot use products as keys");
            }

            public void encodeKey(Object x, JsonWriter out) {
                throw out.encodeError("Cannot use products as keys");
            }

            public final /* synthetic */ SchemaVisitorJCodec smithy4s$json$internals$SchemaVisitorJCodec$_$$anon$$$outer() {
                return this.$outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{smithy4s$json$internals$SchemaVisitorJCodec$$anon$38$$_$$lessinit$greater$$anonfun$17(smithy4s.json.internals.SchemaVisitorJCodec scala.Tuple3 ), decodeValue_$$anonfun$2(java.util.HashMap smithy4s.json.internals.Cursor scala.collection.Map ), smithy4s$json$internals$SchemaVisitorJCodec$$anon$38$$_$decodeValue_$$anonfun$2$$anonfun$1(java.util.HashMap scala.Tuple2 ), smithy4s$json$internals$SchemaVisitorJCodec$$anon$38$$_$decodeValue_$$anonfun$2$$anonfun$2(scala.collection.immutable.VectorBuilder java.util.HashMap smithy4s.json.internals.Cursor scala.Tuple3 )}, serializedLambda);
            }
        };
    }

    private <Z> JCodec<Z> nonPayloadStruct(Vector<Tuple3<Field<Z, ?>, String, Object>> fields, Hints structHints, Function1<Vector<Object>, Z> function1, Function3<Z, JsonWriter, Vector<Function2<Z, JsonWriter, BoxedUnit>>, BoxedUnit> encode) {
        Tuple2 tuple2 = fields.partition((Function1 & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                Field field = (Field)tuple3._1();
                return this.isForJsonUnknown(field);
            }
            throw new MatchError((Object)tuple3);
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Vector fieldsForUnknown = (Vector)tuple2._1();
        Vector knownFields = (Vector)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)fieldsForUnknown, (Object)knownFields);
        Vector fieldsForUnknown2 = (Vector)tuple22._1();
        Vector knownFields2 = (Vector)tuple22._2();
        if (fieldsForUnknown2.isEmpty()) {
            return this.structIgnoreUnknownFields(fields, structHints, function1, encode);
        }
        return this.structRetainUnknownFields(fields, knownFields2, fieldsForUnknown2, structHints, function1, encode);
    }

    private <A, S> JCodec<S> basicStruct(Vector<Tuple3<Field<S, ?>, String, Object>> fields, Hints structHints, Function1<Vector<Object>, S> make) {
        JProcedure3 & Serializable encode = (JProcedure3 & Serializable)(z, out, documentEncoders) -> {
            out.writeObjectStart();
            documentEncoders.foreach((Function1)(JProcedure1 & Serializable)encoder -> encoder.apply(z, out));
            out.writeObjectEnd();
        };
        return this.nonPayloadStruct((Vector)fields, structHints, (Function1)make, (Function3)encode);
    }

    public <S> JCodec<S> struct(ShapeId shapeId, Hints hints, Vector<Field<S, ?>> fields, Function1<IndexedSeq<Object>, S> make) {
        Option option;
        Vector<Tuple3<Field<S, ?>, String, Object>> lFields = this.labelledFields(fields);
        Hints hints2 = hints;
        if (hints2 != null && !(option = DiscriminatedUnionMember$.MODULE$.hint().unapply(hints2)).isEmpty()) {
            DiscriminatedUnionMember discriminatedUnionMember = (DiscriminatedUnionMember)option.get();
            DiscriminatedUnionMember d = discriminatedUnionMember;
            JProcedure3 & Serializable encode = StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(d.propertyName()), (Function1 & Serializable)ch -> JsonWriter$.MODULE$.isNonEscapedAscii(BoxesRunTime.unboxToChar((Object)ch))) && StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(d.alternativeLabel()), (Function1 & Serializable)ch -> JsonWriter$.MODULE$.isNonEscapedAscii(BoxesRunTime.unboxToChar((Object)ch))) ? (JProcedure3 & Serializable)(z, out, documentEncoders) -> {
                out.writeObjectStart();
                out.writeNonEscapedAsciiKey(d.propertyName());
                out.writeNonEscapedAsciiVal(d.alternativeLabel());
                documentEncoders.foreach((Function1)(JProcedure1 & Serializable)encoder -> encoder.apply(z, out));
                out.writeObjectEnd();
            } : (JProcedure3 & Serializable)(z, out, documentEncoders) -> {
                out.writeObjectStart();
                out.writeKey(d.propertyName());
                out.writeVal(d.alternativeLabel());
                documentEncoders.foreach((Function1)(JProcedure1 & Serializable)encoder -> encoder.apply(z, out));
                out.writeObjectEnd();
            };
            return this.nonPayloadStruct((Vector)lFields, hints, (Function1)make, (Function3)encode);
        }
        return this.basicStruct(lFields, hints, make);
    }

    private static final TimestampFormat timestampJCodec$$anonfun$1(TimestampFormat defaultTimestamp$1) {
        return defaultTimestamp$1;
    }

    public static final /* synthetic */ boolean smithy4s$json$internals$SchemaVisitorJCodec$UnionJCodec$$_$$lessinit$greater$$anonfun$1(Alt _$7) {
        return _$7.hints().has((ShapeTag)JsonUnknown$.MODULE$);
    }

    public static final /* synthetic */ Function1 smithy4s$json$internals$SchemaVisitorJCodec$UnionJCodec$$_$$lessinit$greater$$anonfun$2(boolean isDiscriminated$1, SchemaVisitorJCodec $outer$1, Alt alt) {
        if (isDiscriminated$1) {
            UnionJCodec.AltHandler handler = $outer$1.smithy4s$json$internals$SchemaVisitorJCodec$$UnionJCodec().smithy4s$json$internals$SchemaVisitorJCodec$UnionJCodec$$$AltHandler().create(alt);
            return (Function1 & Serializable)_$8 -> handler;
        }
        return $outer$1.smithy4s$json$internals$SchemaVisitorJCodec$$UnionJCodec().smithy4s$json$internals$SchemaVisitorJCodec$UnionJCodec$$$AltHandler().openUnionTaggedUnknown(alt);
    }

    public static final /* synthetic */ UnionJCodec.AltHandler smithy4s$json$internals$SchemaVisitorJCodec$UnionJCodec$$_$getHandler$$anonfun$1$$anonfun$1(String key$2, Function1 _$9) {
        return (UnionJCodec.AltHandler)_$9.apply((Object)key$2);
    }

    public static final /* synthetic */ Object smithy4s$json$internals$SchemaVisitorJCodec$UnionJCodec$AltHandler$$$_$openUnionTaggedUnknown$$anonfun$1$$anonfun$1(Function2 documentTransformer$2, String key$3, Object a) {
        return documentTransformer$2.apply(a, (Function1 & Serializable)doc -> {
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key$3);
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, doc);
            return Document$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        });
    }

    public static final /* synthetic */ Object smithy4s$json$internals$SchemaVisitorJCodec$UnionJCodec$TransformDocumentCompiler$$$_$default$$anonfun$1(Object a, Function1 _$10) {
        return a;
    }

    public static final /* synthetic */ Object smithy4s$json$internals$SchemaVisitorJCodec$UnionJCodec$TransformDocumentCompiler$$$_$primitive$$anonfun$1(Object a, Function1 f) {
        return f.apply(a);
    }

    public static final /* synthetic */ Object smithy4s$json$internals$SchemaVisitorJCodec$UnionJCodec$TransformDocumentCompiler$$$_$biject$$anonfun$2(Bijection bijection$2, Function2 compiled$1, Object b, Function1 f) {
        return bijection$2.to(compiled$1.apply(bijection$2.from(b), (Object)f));
    }

    public static final /* synthetic */ String smithy4s$json$internals$SchemaVisitorJCodec$$anon$28$$_$_$$anonfun$4(String _$11) {
        return (String)JsonName$.MODULE$.value((Object)_$11);
    }

    public static final String smithy4s$json$internals$SchemaVisitorJCodec$$anon$28$$_$_$$anonfun$5(String label$1) {
        return label$1;
    }

    public static final /* synthetic */ Function1 smithy4s$json$internals$SchemaVisitorJCodec$$anon$28$$_$apply$$anonfun$1(String key$5, JCodec jcodecA$1, Object a) {
        return (JProcedure1 & Serializable)out -> {
            out.writeObjectStart();
            out.writeKey(key$5);
            jcodecA$1.encodeValue(a, (JsonWriter)out);
            out.writeObjectEnd();
        };
    }

    public static final /* synthetic */ Function1 smithy4s$json$internals$SchemaVisitorJCodec$$anon$28$$_$apply$$anonfun$2(JCodec jcodecA$3, Object a) {
        return (JProcedure1 & Serializable)out -> jcodecA$3.encodeValue(a, (JsonWriter)out);
    }

    private static final Function2 handler$2(SchemaVisitorJCodec $outer$2, Alt alt) {
        JCodec codec = (JCodec)$outer$2.apply(alt.schema());
        return (Function2 & Serializable)(cursor, reader) -> alt.inject().apply(cursor.decode(codec, (JsonReader)reader));
    }

    public static final /* synthetic */ ArrayBuilder smithy4s$json$internals$SchemaVisitorJCodec$$anon$29$$_$$lessinit$greater$$anonfun$3(ArrayBuilder res$1, SchemaVisitorJCodec $outer$3, Alt alt) {
        return (ArrayBuilder)res$1.$plus$eq((Object)SchemaVisitorJCodec.handler$2($outer$3, alt));
    }

    public static final /* synthetic */ Function1 smithy4s$json$internals$SchemaVisitorJCodec$$anon$30$$_$apply$$anonfun$3(JCodec jcodecA$5, Object a) {
        return (JProcedure1 & Serializable)out -> jcodecA$5.encodeValue(a, (JsonWriter)out);
    }

    public static final /* synthetic */ String smithy4s$json$internals$SchemaVisitorJCodec$$anon$32$$_$_$$anonfun$6(String _$12) {
        return (String)JsonName$.MODULE$.value((Object)_$12);
    }

    public static final String smithy4s$json$internals$SchemaVisitorJCodec$$anon$32$$_$_$$anonfun$7(String label$2) {
        return label$2;
    }

    public static final /* synthetic */ Function1 smithy4s$json$internals$SchemaVisitorJCodec$$anon$32$$_$apply$$anonfun$4(JCodec jcodecA$7, Object a) {
        return (JProcedure1 & Serializable)out -> jcodecA$7.encodeValue(a, (JsonWriter)out);
    }

    public static final /* synthetic */ Tuple2 smithy4s$json$internals$SchemaVisitorJCodec$$anon$33$$_$$lessinit$greater$$anonfun$4(EnumValue v) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)v.stringValue());
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, v.value());
    }

    public static final /* synthetic */ String smithy4s$json$internals$SchemaVisitorJCodec$$anon$33$$_$$lessinit$greater$$anonfun$5(EnumValue _$13) {
        return _$13.stringValue();
    }

    public static final Object smithy4s$json$internals$SchemaVisitorJCodec$$anon$33$$_$fromNameOpen$$anonfun$1(Function1 unknown$2, String v$1) {
        return unknown$2.apply((Object)v$1);
    }

    public static final /* synthetic */ Tuple2 smithy4s$json$internals$SchemaVisitorJCodec$$anon$34$$_$$lessinit$greater$$anonfun$8(EnumValue v) {
        Integer n = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)v.intValue()));
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n, v.value());
    }

    public static final /* synthetic */ String smithy4s$json$internals$SchemaVisitorJCodec$$anon$34$$_$$lessinit$greater$$anonfun$9(EnumValue _$15) {
        return _$15.stringValue();
    }

    public static final Object smithy4s$json$internals$SchemaVisitorJCodec$$anon$34$$_$fromOrdinalOpen$$anonfun$1(Function1 unknown$4, int v$2) {
        return unknown$4.apply((Object)BoxesRunTime.boxToInteger((int)v$2));
    }

    public static final /* synthetic */ Tuple2 smithy4s$json$internals$SchemaVisitorJCodec$$anon$36$$_$$lessinit$greater$$anonfun$12(Tuple3 x$1) {
        Tuple3 tuple3 = x$1;
        if (tuple3 != null) {
            Field field = (Field)tuple3._1();
            String label = (String)tuple3._2();
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)label);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)((Decoder)Document.Decoder$.MODULE$.fromSchema(field.schema())));
        }
        throw new MatchError((Object)tuple3);
    }

    public static final /* synthetic */ Function2 smithy4s$json$internals$SchemaVisitorJCodec$$anon$36$$_$$lessinit$greater$$anonfun$14(SchemaVisitorJCodec $outer$5, Tuple3 labelledField) {
        return $outer$5.fieldEncoder((Field)labelledField._1());
    }

    public static final /* synthetic */ Function2 smithy4s$json$internals$SchemaVisitorJCodec$$anon$36$$_$$lessinit$greater$$anonfun$15(SchemaVisitorJCodec $outer$6, Tuple3 f) {
        return $outer$6.jsonUnknownFieldEncoder((Field)f._1());
    }

    public static final /* synthetic */ Object smithy4s$json$internals$SchemaVisitorJCodec$$anon$36$$_$decodeValue_$$anonfun$1$$anonfun$1(HashMap buffer$2, Tuple2 kv) {
        return buffer$2.put(kv._1(), kv._2());
    }

    public static final Object smithy4s$json$internals$SchemaVisitorJCodec$$anon$36$$_$decodeValue_$$anonfun$1$$anonfun$2$$anonfun$1(JsonReader in$5, Cursor cursor$5, Field f$1) {
        throw in$5.decodeError(new StringBuilder(64).append(cursor$5.getPath((List<PayloadPath.Segment>)package$.MODULE$.Nil())).append(" Failed translating a Document.DObject to the type targeted by ").append(f$1.label()).append(".").toString());
    }

    public static final Object smithy4s$json$internals$SchemaVisitorJCodec$$anon$36$$_$decodeValue_$$anonfun$1$$anonfun$2$$anonfun$2(JsonReader in$6, Cursor cursor$6, Field f$2) {
        throw in$6.decodeError(new StringBuilder(64).append(cursor$6.getPath((List<PayloadPath.Segment>)package$.MODULE$.Nil())).append(" Failed translating a Document.DObject to the type targeted by ").append(f$2.label()).append(".").toString());
    }

    public static final /* synthetic */ Function2 smithy4s$json$internals$SchemaVisitorJCodec$$anon$38$$_$$lessinit$greater$$anonfun$17(SchemaVisitorJCodec $outer$8, Tuple3 labelledField) {
        return $outer$8.fieldEncoder((Field)labelledField._1());
    }

    public static final /* synthetic */ Object smithy4s$json$internals$SchemaVisitorJCodec$$anon$38$$_$decodeValue_$$anonfun$2$$anonfun$1(HashMap buffer$5, Tuple2 kv) {
        return buffer$5.put(kv._1(), kv._2());
    }

    public static final /* synthetic */ VectorBuilder smithy4s$json$internals$SchemaVisitorJCodec$$anon$38$$_$decodeValue_$$anonfun$2$$anonfun$2(VectorBuilder stage2$2, HashMap buffer$6, Cursor cursor$8, Tuple3 x$1) {
        Tuple3 tuple3 = x$1;
        if (tuple3 != null) {
            Object object;
            Field f = (Field)tuple3._1();
            String jsonLabel = (String)tuple3._2();
            Object object2 = tuple3._3();
            Object value = buffer$6.get(f.label());
            if (value == null) {
                if (object2 == null) {
                    throw cursor$8.requiredFieldError(jsonLabel, jsonLabel);
                }
                object = object2;
            } else {
                object = value;
            }
            return (VectorBuilder)stage2$2.$plus$eq(object);
        }
        throw new MatchError((Object)tuple3);
    }

    public final class TaggedUnionJCodec<U>
    extends UnionJCodec<U> {
        private final boolean isLenient;
        private final String expecting;
        private final Alt.Precompiler precompiler;
        private final Function1 writer;
        private final /* synthetic */ SchemaVisitorJCodec $outer;

        public TaggedUnionJCodec(SchemaVisitorJCodec $outer, Vector<Alt<U, ?>> alternatives, Alt.Dispatcher<U> dispatch, boolean isLenient) {
            this.isLenient = isLenient;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super($outer, alternatives, $outer.smithy4s$json$internals$SchemaVisitorJCodec$$UnionJCodec().$lessinit$greater$default$2(), dispatch);
            this.expecting = "tagged-union";
            this.precompiler = new Alt.Precompiler<Function1<Object, Function1<JsonWriter, BoxedUnit>>>(this){
                private final /* synthetic */ TaggedUnionJCodec $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public Function1 apply(String label, Schema instance) {
                    JCodec jcodecA = (JCodec)instance.compile((PolyFunction)this.$outer.smithy4s$json$internals$SchemaVisitorJCodec$TaggedUnionJCodec$$$outer());
                    if (!instance.hints().has((ShapeTag)JsonUnknown$.MODULE$)) {
                        String key = (String)instance.hints().get((Newtype)JsonName$.MODULE$).map(SchemaVisitorJCodec::smithy4s$json$internals$SchemaVisitorJCodec$$anon$28$$_$_$$anonfun$4).getOrElse(() -> SchemaVisitorJCodec.smithy4s$json$internals$SchemaVisitorJCodec$$anon$28$$_$_$$anonfun$5(label));
                        return arg_0 -> SchemaVisitorJCodec.smithy4s$json$internals$SchemaVisitorJCodec$$anon$28$$_$apply$$anonfun$1(key, jcodecA, arg_0);
                    }
                    return arg_0 -> SchemaVisitorJCodec.smithy4s$json$internals$SchemaVisitorJCodec$$anon$28$$_$apply$$anonfun$2(jcodecA, arg_0);
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{smithy4s$json$internals$SchemaVisitorJCodec$$anon$28$$_$_$$anonfun$4(java.lang.String ), smithy4s$json$internals$SchemaVisitorJCodec$$anon$28$$_$_$$anonfun$5(java.lang.String ), smithy4s$json$internals$SchemaVisitorJCodec$$anon$28$$_$apply$$anonfun$1(java.lang.String smithy4s.json.internals.JCodec java.lang.Object ), smithy4s$json$internals$SchemaVisitorJCodec$$anon$28$$_$apply$$anonfun$2(smithy4s.json.internals.JCodec java.lang.Object )}, serializedLambda);
                }
            };
            this.writer = (Function1)dispatch.compile(this.precompiler(), EncoderK$.MODULE$.encoderKForFunction());
        }

        @Override
        public String expecting() {
            return this.expecting;
        }

        @Override
        public boolean canBeKey() {
            return false;
        }

        public Alt.Precompiler<Function1<Object, Function1<JsonWriter, BoxedUnit>>> precompiler() {
            return this.precompiler;
        }

        public Function1<U, Function1<JsonWriter, BoxedUnit>> writer() {
            return this.writer;
        }

        public void encodeValue(U u, JsonWriter out) {
            ((Function1)this.writer().apply(u)).apply((Object)out);
        }

        public U decodeKey(JsonReader in) {
            throw in.decodeError("Cannot use coproducts as keys");
        }

        public void encodeKey(U u, JsonWriter out) {
            throw out.encodeError("Cannot use coproducts as keys");
        }

        @Override
        public U decodeValue(Cursor cursor, JsonReader in) {
            ObjectRef result = ObjectRef.create(null);
            ObjectRef lastKey = ObjectRef.create(null);
            if (in.isNextToken((byte)123)) {
                if (in.isNextToken((byte)125)) {
                    throw in.decodeError(this.emptyObjectErrorMessage());
                }
                in.rollbackToken();
                this.readKey$1(lastKey, in, cursor, result);
                if (this.isLenient) {
                    while (in.isNextToken((byte)44)) {
                        this.readKey$1(lastKey, in, cursor, result);
                    }
                    in.rollbackToken();
                }
                if (in.isNextToken((byte)125)) {
                    if (result.elem == null) {
                        throw in.decodeError("Expected a single non-null value");
                    }
                    return (U)result.elem;
                }
                if (this.isLenient) {
                    throw in.objectEndOrCommaError();
                }
                throw in.decodeError(new StringBuilder(32).append("Expected no other field after '").append((String)lastKey.elem).append("'").toString());
            }
            throw in.decodeError("Expected JSON object");
        }

        private String emptyObjectErrorMessage() {
            if (this.isLenient) {
                return "Expected a single non-null value";
            }
            return "Expected a single key/value pair";
        }

        private void onUnknownDiscriminator(JsonReader in, String key) {
            if (this.isLenient) {
                in.skip();
                return;
            }
            throw in.discriminatorValueError(key);
        }

        public final /* synthetic */ SchemaVisitorJCodec smithy4s$json$internals$SchemaVisitorJCodec$TaggedUnionJCodec$$$outer() {
            return this.$outer;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final void readKey$1(ObjectRef lastKey$1, JsonReader in$2, Cursor cursor$2, ObjectRef result$1) {
            lastKey$1.elem = in$2.readKeyAsString();
            cursor$2.push((String)lastKey$1.elem);
            if (this.isLenient && in$2.isNextToken((byte)110)) {
                in$2.readNullOrError((Object)BoxedUnit.UNIT, "expected null");
            } else {
                Option option;
                if (result$1.elem != null) throw in$2.decodeError(this.emptyObjectErrorMessage());
                if (this.isLenient) {
                    in$2.rollbackToken();
                }
                if ((option = this.getHandler((String)lastKey$1.elem)) instanceof Some) {
                    UnionJCodec.AltHandler handler = (UnionJCodec.AltHandler)((Some)option).value();
                    result$1.elem = handler.handle(cursor$2, in$2);
                } else {
                    if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                    this.onUnknownDiscriminator(in$2, (String)lastKey$1.elem);
                }
            }
            cursor$2.pop();
        }
    }

    public abstract class UnionJCodec<U>
    implements JCodec<U> {
        private final boolean isDiscriminated;
        private final scala.collection.immutable.Map<String, AltHandler<U, ?>> handlerMap;
        private final Option<Function1<String, AltHandler<U, ?>>> unknownAlt;
        private final /* synthetic */ SchemaVisitorJCodec $outer;
        public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(SchemaVisitorJCodec$UnionJCodec$.class.getDeclaredField("TransformDocumentCompiler$lzy1"));
        public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(SchemaVisitorJCodec$UnionJCodec$.class.getDeclaredField("AltHandler$lzy1"));

        public UnionJCodec(SchemaVisitorJCodec $outer, Vector<Alt<U, ?>> alternatives, boolean isDiscriminated, Alt.Dispatcher<U> dispatch) {
            this.isDiscriminated = isDiscriminated;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.handlerMap = ((IterableOnceOps)alternatives.collect((PartialFunction)new Serializable(this){
                private final /* synthetic */ UnionJCodec $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Alt x) {
                    Alt alt = x;
                    Alt alt2 = alt;
                    return !alt2.hints().has((ShapeTag)JsonUnknown$.MODULE$);
                }

                public final Object applyOrElse(Alt x, Function1 function1) {
                    Alt alt = x;
                    Alt alt2 = alt;
                    if (!alt2.hints().has((ShapeTag)JsonUnknown$.MODULE$)) {
                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)this.$outer.smithy4s$json$internals$SchemaVisitorJCodec$UnionJCodec$$jsonLabel(alt2));
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, this.$outer.smithy4s$json$internals$SchemaVisitorJCodec$UnionJCodec$$$outer().smithy4s$json$internals$SchemaVisitorJCodec$$UnionJCodec().smithy4s$json$internals$SchemaVisitorJCodec$UnionJCodec$$$AltHandler().create(alt2));
                    }
                    return function1.apply((Object)x);
                }
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            this.unknownAlt = alternatives.find(SchemaVisitorJCodec::smithy4s$json$internals$SchemaVisitorJCodec$UnionJCodec$$_$$lessinit$greater$$anonfun$1).map(arg_0 -> SchemaVisitorJCodec.smithy4s$json$internals$SchemaVisitorJCodec$UnionJCodec$$_$$lessinit$greater$$anonfun$2(isDiscriminated, $outer, arg_0));
        }

        public <A> String smithy4s$json$internals$SchemaVisitorJCodec$UnionJCodec$$jsonLabel(Alt<U, A> alt) {
            Option option = alt.hints().get((Newtype)JsonName$.MODULE$);
            if (None$.MODULE$.equals(option)) {
                return alt.label();
            }
            if (option instanceof Some) {
                String x = (String)((Some)option).value();
                return (String)JsonName$.MODULE$.value((Object)x);
            }
            throw new MatchError((Object)option);
        }

        public Option<AltHandler<U, ?>> getHandler(String key) {
            return this.handlerMap.get((Object)key).orElse(() -> this.getHandler$$anonfun$1(key));
        }

        public final /* synthetic */ SchemaVisitorJCodec smithy4s$json$internals$SchemaVisitorJCodec$UnionJCodec$$$outer() {
            return this.$outer;
        }

        private final Option getHandler$$anonfun$1(String key$1) {
            return this.unknownAlt.map(arg_0 -> SchemaVisitorJCodec.smithy4s$json$internals$SchemaVisitorJCodec$UnionJCodec$$_$getHandler$$anonfun$1$$anonfun$1(key$1, arg_0));
        }

        public static abstract class AltHandler<U, A> {
            private final /* synthetic */ SchemaVisitorJCodec$UnionJCodec$ $outer;

            public AltHandler(SchemaVisitorJCodec$UnionJCodec$ $outer) {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public U handle(Cursor cursor, JsonReader reader) {
                return this.inject(this.handleVariant(cursor, reader));
            }

            public abstract U inject(A var1);

            public abstract A handleVariant(Cursor var1, JsonReader var2);

            public final /* synthetic */ SchemaVisitorJCodec$UnionJCodec$ smithy4s$json$internals$SchemaVisitorJCodec$UnionJCodec$AltHandler$$$outer() {
                return this.$outer;
            }
        }
    }
}

