/**
 */

package smithy4s.meta;

import software.amazon.smithy.model.node.ExpectationNotMetException;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.SmithyGenerated;
import software.amazon.smithy.utils.ToSmithyBuilder;

/**
 * Marks the given shape to be generated in a way that allows binary-compatible evolution.
 * For example, classes generated from such structures will not have a public copy method, but will have .withXXX methods
 * instead.
 * Unions will be generated without direct access to member classes, and their visitor will require a default value.
 */
@SmithyGenerated
public final class BincompatFriendlyTrait extends AbstractTrait implements ToSmithyBuilder<BincompatFriendlyTrait> {
    public static final ShapeId ID = ShapeId.from("smithy4s.meta#bincompatFriendly");

    private BincompatFriendlyTrait(Builder builder) {
        super(ID, builder.getSourceLocation());
    }

    @Override
    protected Node createNode() {
        return Node.objectNodeBuilder()
            .sourceLocation(getSourceLocation())
            .build();
    }

    /**
     * Creates a {@link BincompatFriendlyTrait} from a {@link Node}.
     *
     * @param node Node to create the BincompatFriendlyTrait from.
     * @return Returns the created BincompatFriendlyTrait.
     * @throws ExpectationNotMetException if the given Node is invalid.
     */
    public static BincompatFriendlyTrait fromNode(Node node) {
        Builder builder = builder();
        node.expectObjectNode();
        return builder.build();
    }

    /**
     * Creates a builder used to build a {@link BincompatFriendlyTrait}.
     */
    public SmithyBuilder<BincompatFriendlyTrait> toBuilder() {
        return builder().sourceLocation(getSourceLocation());
    }

    public static Builder builder() {
        return new Builder();
    }

    /**
     * Builder for {@link BincompatFriendlyTrait}.
     */
    public static final class Builder extends AbstractTraitBuilder<BincompatFriendlyTrait, Builder> {

        private Builder() {}

        @Override
        public BincompatFriendlyTrait build() {
            return new BincompatFriendlyTrait(this);
        }
    }

    public static final class Provider extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        @Override
        public Trait createTrait(ShapeId target, Node value) {
            BincompatFriendlyTrait result = BincompatFriendlyTrait.fromNode(value);
            result.setNodeCache(value);
            return result;
        }
    }
}
