/**
 */

package smithy4s.meta;

import software.amazon.smithy.model.node.ExpectationNotMetException;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.SmithyGenerated;
import software.amazon.smithy.utils.ToSmithyBuilder;

/**
 * When present, references to this trait will be rendered
 * as Dynamic Hint Bindings rather than Static ones
 */
@SmithyGenerated
public final class RenderAsDynamicBindingTrait extends AbstractTrait implements ToSmithyBuilder<RenderAsDynamicBindingTrait> {
    public static final ShapeId ID = ShapeId.from("smithy4s.meta#renderAsDynamicBinding");

    private RenderAsDynamicBindingTrait(Builder builder) {
        super(ID, builder.getSourceLocation());
    }

    @Override
    protected Node createNode() {
        return Node.objectNodeBuilder()
            .sourceLocation(getSourceLocation())
            .build();
    }

    /**
     * Creates a {@link RenderAsDynamicBindingTrait} from a {@link Node}.
     *
     * @param node Node to create the RenderAsDynamicBindingTrait from.
     * @return Returns the created RenderAsDynamicBindingTrait.
     * @throws ExpectationNotMetException if the given Node is invalid.
     */
    public static RenderAsDynamicBindingTrait fromNode(Node node) {
        Builder builder = builder();
        node.expectObjectNode();
        return builder.build();
    }

    /**
     * Creates a builder used to build a {@link RenderAsDynamicBindingTrait}.
     */
    public SmithyBuilder<RenderAsDynamicBindingTrait> toBuilder() {
        return builder().sourceLocation(getSourceLocation());
    }

    public static Builder builder() {
        return new Builder();
    }

    /**
     * Builder for {@link RenderAsDynamicBindingTrait}.
     */
    public static final class Builder extends AbstractTraitBuilder<RenderAsDynamicBindingTrait, Builder> {

        private Builder() {}

        @Override
        public RenderAsDynamicBindingTrait build() {
            return new RenderAsDynamicBindingTrait(this);
        }
    }

    public static final class Provider extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        @Override
        public Trait createTrait(ShapeId target, Node value) {
            RenderAsDynamicBindingTrait result = RenderAsDynamicBindingTrait.fromNode(value);
            result.setNodeCache(value);
            return result;
        }
    }
}
