/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster.client;

import akka.actor.ActorSystem;
import akka.cluster.AkkaCuratorClient$;
import akka.cluster.ZookeeperClusterSeedSettings;
import akka.cluster.client.ClusterClientSettings;
import akka.cluster.client.ClusterClientSettings$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import java.io.Serializable;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.locks.LockInternals;
import org.apache.curator.framework.recipes.locks.LockInternalsSorter;
import org.apache.curator.framework.recipes.locks.StandardLockInternalsDriver;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.util.Try$;

public final class ZookeeperClusterClientSettings$ {
    public static ZookeeperClusterClientSettings$ MODULE$;
    private final LockInternalsSorter sorter;

    static {
        new ZookeeperClusterClientSettings$();
    }

    private LockInternalsSorter sorter() {
        return this.sorter;
    }

    public ClusterClientSettings apply(ActorSystem system, Option<Config> overwrittenActorSettings) {
        Config config = ((Config)overwrittenActorSettings.getOrElse((Function0 & Serializable & scala.Serializable)() -> system.settings().config())).getConfig("akka.cluster.client");
        String systemName = config.getString("zookeeper.name");
        String receptionistPath = (String)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> config.getString("zookeeper.receptionistName")).getOrElse((Function0 & Serializable & scala.Serializable)() -> "/system/receptionist");
        ZookeeperClusterSeedSettings settings = new ZookeeperClusterSeedSettings(system, "akka.cluster.client.zookeeper", overwrittenActorSettings);
        CuratorFramework client = AkkaCuratorClient$.MODULE$.apply(settings);
        Seq contacts = (Seq)this.getClusterParticipants(client, new StringBuilder(1).append(settings.ZKPath()).append("/").append(systemName).toString()).map((Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(0).append((String)x$1).append(receptionistPath).toString(), Seq$.MODULE$.canBuildFrom());
        system.log().info("component=zookeeper-cluster-client at=find-initial-contacts contacts={}", (Object)contacts);
        client.close();
        return ClusterClientSettings$.MODULE$.apply(config.withValue("initial-contacts", (ConfigValue)ConfigValueFactory.fromIterable((java.lang.Iterable)((java.lang.Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply(contacts)).asJava()))));
    }

    public Option<Config> apply$default$2() {
        return None$.MODULE$;
    }

    private Seq<String> getClusterParticipants(CuratorFramework client, String zkPath) {
        Iterable participants = (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(LockInternals.getParticipantNodes((CuratorFramework)client, (String)zkPath, (String)"latch-", (LockInternalsSorter)this.sorter())).asScala();
        return ((TraversableOnce)participants.map((Function1 & Serializable & scala.Serializable)path -> new String((byte[])client.getData().forPath(path)), Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    private ZookeeperClusterClientSettings$() {
        MODULE$ = this;
        this.sorter = new LockInternalsSorter(){

            public String fixForSorting(String str, String lockName) {
                return StandardLockInternalsDriver.standardFixForSorting((String)str, (String)lockName);
            }
        };
    }
}

