/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster.seed;

import akka.Done$;
import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.AddressFromURIString$;
import akka.actor.ClassicActorSystemProvider;
import akka.actor.CoordinatedShutdown;
import akka.actor.CoordinatedShutdown$;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.cluster.AkkaCuratorClient$;
import akka.cluster.AutoDownUnresolvedStrategies$;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import akka.cluster.ZookeeperClusterSeedSettings;
import akka.cluster.ZookeeperClusterSeedSettings$;
import akka.cluster.seed.ZookeeperClusterSeed$;
import java.io.Closeable;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.curator.framework.recipes.leader.LeaderLatchListener;
import org.apache.curator.framework.recipes.leader.Participant;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.zookeeper.KeeperException;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.Exception$;

@ScalaSignature(bytes="\u0006\u0001\u0005}t!\u0002\u0013&\u0011\u0003ac!\u0002\u0018&\u0011\u0003y\u0003BB#\u0002\t\u0003\t)\u0007C\u0004\u0002h\u0005!\t%!\u001b\t\u000f\u0005M\u0014\u0001\"\u0011\u0002v!9\u0011\u0011P\u0001\u0005B\u0005md\u0001\u0002\u0018&\u0001uB\u0001\"\u0011\u0004\u0003\u0002\u0003\u0006IA\u0011\u0005\u0006\u000b\u001a!\tA\u0012\u0005\b\u0011\u001a\u0011\r\u0011\"\u0001J\u0011\u0019qe\u0001)A\u0005\u0015\"AqJ\u0002b\u0001\n\u0003)\u0003\u000b\u0003\u0004U\r\u0001\u0006I!\u0015\u0005\b+\u001a\u0011\r\u0011\"\u0001W\u0011\u0019Qf\u0001)A\u0005/\"91L\u0002b\u0001\n\u00031\u0006B\u0002/\u0007A\u0003%q\u000bC\u0004^\r\t\u0007I\u0011\u00020\t\r-4\u0001\u0015!\u0003`\u0011\u001dagA1A\u0005\u00025Da!\u001f\u0004!\u0002\u0013q\u0007b\u0002>\u0007\u0005\u0004%\t!\u001c\u0005\u0007w\u001a\u0001\u000b\u0011\u00028\t\u000fq4!\u0019!C\u0005{\"9\u0011Q\u0002\u0004!\u0002\u0013q\b\"CA\b\r\u0001\u0007I\u0011BA\t\u0011%\tIB\u0002a\u0001\n\u0013\tY\u0002\u0003\u0005\u0002(\u0019\u0001\u000b\u0015BA\n\u0011%\tIC\u0002b\u0001\n\u0013\tY\u0003\u0003\u0005\u0002N\u0019\u0001\u000b\u0011BA\u0017\u0011\u001d\tyE\u0002C\u0001\u0003#Bq!a\u0015\u0007\t\u0003\t\t\u0006\u0003\u0005\u0002V\u0019!\t!JA,\u0011\u001d\tIF\u0002C\u0005\u0003/Bq!a\u0017\u0007\t\u0013\t\t\u0006C\u0004\u0002^\u0019!\t!!\u0015\u0002)i{wn[3fa\u0016\u00148\t\\;ti\u0016\u00148+Z3e\u0015\t1s%\u0001\u0003tK\u0016$'B\u0001\u0015*\u0003\u001d\u0019G.^:uKJT\u0011AK\u0001\u0005C.\\\u0017m\u0001\u0001\u0011\u00055\nQ\"A\u0013\u0003)i{wn[3fa\u0016\u00148\t\\;ti\u0016\u00148+Z3e'\u0015\t\u0001GNA0!\t\tD'D\u00013\u0015\u0005\u0019\u0014!B:dC2\f\u0017BA\u001b3\u0005\u0019\te.\u001f*fMB\u0019qG\u000f\u001f\u000e\u0003aR!!O\u0015\u0002\u000b\u0005\u001cGo\u001c:\n\u0005mB$aC#yi\u0016t7/[8o\u0013\u0012\u0004\"!\f\u0004\u0014\u0007\u0019\u0001d\b\u0005\u00028\u007f%\u0011\u0001\t\u000f\u0002\n\u000bb$XM\\:j_:\faa]=ti\u0016l\u0007CA\u001cD\u0013\t!\u0005HA\nFqR,g\u000eZ3e\u0003\u000e$xN]*zgR,W.\u0001\u0004=S:LGO\u0010\u000b\u0003y\u001dCQ!\u0011\u0005A\u0002\t\u000b\u0001b]3ui&twm]\u000b\u0002\u0015B\u00111\nT\u0007\u0002O%\u0011Qj\n\u0002\u001d5>|7.Z3qKJ\u001cE.^:uKJ\u001cV-\u001a3TKR$\u0018N\\4t\u0003%\u0019X\r\u001e;j]\u001e\u001c\b%A\u0007dYV\u001cH/\u001a:TsN$X-\\\u000b\u0002#B\u00111JU\u0005\u0003'\u001e\u0012qa\u00117vgR,'/\u0001\bdYV\u001cH/\u001a:TsN$X-\u001c\u0011\u0002\u0017M,GNZ!eIJ,7o]\u000b\u0002/B\u0011q\u0007W\u0005\u00033b\u0012q!\u00113ee\u0016\u001c8/\u0001\u0007tK24\u0017\t\u001a3sKN\u001c\b%A\u0004bI\u0012\u0014Xm]:\u0002\u0011\u0005$GM]3tg\u0002\naa\u00197jK:$X#A0\u0011\u0005\u0001LW\"A1\u000b\u0005\t\u001c\u0017!\u00034sC6,wo\u001c:l\u0015\t!W-A\u0004dkJ\fGo\u001c:\u000b\u0005\u0019<\u0017AB1qC\u000eDWMC\u0001i\u0003\ry'oZ\u0005\u0003U\u0006\u0014\u0001cQ;sCR|'O\u0012:b[\u0016<xN]6\u0002\u000f\rd\u0017.\u001a8uA\u0005!Q._%e+\u0005q\u0007CA8w\u001d\t\u0001H\u000f\u0005\u0002re5\t!O\u0003\u0002tW\u00051AH]8pizJ!!\u001e\u001a\u0002\rA\u0013X\rZ3g\u0013\t9\bP\u0001\u0004TiJLgn\u001a\u0006\u0003kJ\nQ!\\=JI\u0002\nA\u0001]1uQ\u0006)\u0001/\u0019;iA\u0005)A.\u0019;dQV\ta\u0010E\u0002\u0000\u0003\u0013i!!!\u0001\u000b\t\u0005\r\u0011QA\u0001\u0007Y\u0016\fG-\u001a:\u000b\u0007\u0005\u001d\u0011-A\u0004sK\u000eL\u0007/Z:\n\t\u0005-\u0011\u0011\u0001\u0002\f\u0019\u0016\fG-\u001a:MCR\u001c\u0007.\u0001\u0004mCR\u001c\u0007\u000eI\u0001\u000fg\u0016,G-\u00128uef\fE\rZ3e+\t\t\u0019\u0002E\u00022\u0003+I1!a\u00063\u0005\u001d\u0011un\u001c7fC:\f!c]3fI\u0016sGO]=BI\u0012,Gm\u0018\u0013fcR!\u0011QDA\u0012!\r\t\u0014qD\u0005\u0004\u0003C\u0011$\u0001B+oSRD\u0011\"!\n\u001b\u0003\u0003\u0005\r!a\u0005\u0002\u0007a$\u0013'A\btK\u0016$WI\u001c;ss\u0006#G-\u001a3!\u0003E\u0019Gn\\:fC\ndWmU3sm&\u001cWm]\u000b\u0003\u0003[\u0001b!a\f\u0002:\u0005uRBAA\u0019\u0015\u0011\t\u0019$!\u000e\u0002\u000f5,H/\u00192mK*\u0019\u0011q\u0007\u001a\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002<\u0005E\"aA*fiB!\u0011qHA%\u001b\t\t\tE\u0003\u0003\u0002D\u0005\u0015\u0013AA5p\u0015\t\t9%\u0001\u0003kCZ\f\u0017\u0002BA&\u0003\u0003\u0012\u0011b\u00117pg\u0016\f'\r\\3\u0002%\rdwn]3bE2,7+\u001a:wS\u000e,7\u000fI\u0001\u0005U>Lg\u000e\u0006\u0002\u0002\u001e\u0005y!/Z7pm\u0016\u001cV-\u001a3F]R\u0014\u00180\u0001\u0005jg2+\u0017\rZ3s)\t\t\u0019\"A\u0004uefTu.\u001b8\u0002%\r\u0014X-\u0019;f!\u0006$\b.\u00134OK\u0016$W\rZ\u0001\u0015e\u0016lwN^3Fa\",W.\u001a:bY:{G-Z:\u0011\u0007]\n\t'C\u0002\u0002da\u00121#\u0012=uK:\u001c\u0018n\u001c8JIB\u0013xN^5eKJ$\u0012\u0001L\u0001\u0004O\u0016$Hc\u0001\u001f\u0002l!1\u0011i\u0001a\u0001\u0003[\u00022aNA8\u0013\r\t\t\b\u000f\u0002\f\u0003\u000e$xN]*zgR,W.A\bde\u0016\fG/Z#yi\u0016t7/[8o)\ra\u0014q\u000f\u0005\u0006\u0003\u0012\u0001\rAQ\u0001\u0007Y>|7.\u001e9\u0015\u0005\u0005udBA\u0017\u0001\u0001")
public class ZookeeperClusterSeed
implements Extension {
    public final ExtendedActorSystem akka$cluster$seed$ZookeeperClusterSeed$$system;
    private final ZookeeperClusterSeedSettings settings;
    private final Cluster clusterSystem;
    private final Address selfAddress;
    private final Address address;
    private final CuratorFramework client;
    private final String myId;
    private final String path;
    private final LeaderLatch akka$cluster$seed$ZookeeperClusterSeed$$latch;
    private boolean seedEntryAdded;
    private final Set<Closeable> closeableServices;

    public static ZookeeperClusterSeed$ lookup() {
        return ZookeeperClusterSeed$.MODULE$.lookup();
    }

    public static ZookeeperClusterSeed createExtension(ExtendedActorSystem extendedActorSystem) {
        return ZookeeperClusterSeed$.MODULE$.createExtension(extendedActorSystem);
    }

    public static ZookeeperClusterSeed get(ActorSystem actorSystem) {
        return ZookeeperClusterSeed$.MODULE$.get(actorSystem);
    }

    public static Extension get(ClassicActorSystemProvider classicActorSystemProvider) {
        return ZookeeperClusterSeed$.MODULE$.get(classicActorSystemProvider);
    }

    public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return ZookeeperClusterSeed$.MODULE$.apply(classicActorSystemProvider);
    }

    public static Extension apply(ActorSystem actorSystem) {
        return ZookeeperClusterSeed$.MODULE$.apply(actorSystem);
    }

    public ZookeeperClusterSeedSettings settings() {
        return this.settings;
    }

    public Cluster clusterSystem() {
        return this.clusterSystem;
    }

    public Address selfAddress() {
        return this.selfAddress;
    }

    public Address address() {
        return this.address;
    }

    private CuratorFramework client() {
        return this.client;
    }

    public String myId() {
        return this.myId;
    }

    public String path() {
        return this.path;
    }

    public LeaderLatch akka$cluster$seed$ZookeeperClusterSeed$$latch() {
        return this.akka$cluster$seed$ZookeeperClusterSeed$$latch;
    }

    private boolean seedEntryAdded() {
        return this.seedEntryAdded;
    }

    private void seedEntryAdded_$eq(boolean x$1) {
        this.seedEntryAdded = x$1;
    }

    private Set<Closeable> closeableServices() {
        return this.closeableServices;
    }

    public synchronized void join() {
        this.createPathIfNeeded();
        this.akka$cluster$seed$ZookeeperClusterSeed$$latch().start();
        this.seedEntryAdded_$eq(true);
        while (!this.tryJoin()) {
            this.akka$cluster$seed$ZookeeperClusterSeed$$system.log().warning("component=zookeeper-cluster-seed at=try-join-failed id={}", (Object)this.myId());
            Thread.sleep(1000L);
        }
        this.clusterSystem().registerOnMemberRemoved((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.removeSeedEntry());
        ((CoordinatedShutdown)CoordinatedShutdown$.MODULE$.apply((ActorSystem)this.akka$cluster$seed$ZookeeperClusterSeed$$system)).addTask(CoordinatedShutdown$.MODULE$.PhaseBeforeActorSystemTerminate(), "terminate-zk", (Function0 & Serializable & scala.Serializable)() -> {
            $this.akka$cluster$seed$ZookeeperClusterSeed$$system.log().info("Shutting down Zookeeper Curator.");
            this.client().close();
            return Future$.MODULE$.successful((Object)Done$.MODULE$);
        });
    }

    public synchronized void removeSeedEntry() {
        block0: {
            if (!this.seedEntryAdded()) break block0;
            Exception$.MODULE$.ignoring((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{IllegalStateException.class})).apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.closeableServices().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    x$1.close();
                    return BoxedUnit.UNIT;
                });
                this.seedEntryAdded_$eq(false);
            });
        }
    }

    public boolean isLeader() {
        return this.akka$cluster$seed$ZookeeperClusterSeed$$latch().hasLeadership();
    }

    private boolean tryJoin() {
        boolean bl;
        Participant leadParticipant = this.akka$cluster$seed$ZookeeperClusterSeed$$latch().getLeader();
        if (!leadParticipant.isLeader()) {
            bl = false;
        } else {
            String string = leadParticipant.getId();
            String string2 = this.myId();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.akka$cluster$seed$ZookeeperClusterSeed$$system.log().info("component=zookeeper-cluster-seed at=this-node-is-leader-seed id={}", (Object)this.myId());
                ((Cluster)Cluster$.MODULE$.apply((ActorSystem)this.akka$cluster$seed$ZookeeperClusterSeed$$system)).join(this.address());
                bl = true;
            } else {
                List seeds = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(this.akka$cluster$seed$ZookeeperClusterSeed$$latch().getParticipants().iterator()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ZookeeperClusterSeed.$anonfun$tryJoin$1(this, x$2))).map((Function1 & Serializable & scala.Serializable)node -> AddressFromURIString$.MODULE$.apply(node.getId())).toList();
                this.akka$cluster$seed$ZookeeperClusterSeed$$system.log().info("component=zookeeper-cluster-seed at=join-cluster seeds={}", (Object)seeds);
                ((Cluster)Cluster$.MODULE$.apply((ActorSystem)this.akka$cluster$seed$ZookeeperClusterSeed$$system)).joinSeedNodes((scala.collection.immutable.Seq)Seq$.MODULE$.apply((Seq)seeds));
                Promise joined = Promise$.MODULE$.apply();
                ((Cluster)Cluster$.MODULE$.apply((ActorSystem)this.akka$cluster$seed$ZookeeperClusterSeed$$system)).registerOnMemberUp((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> joined.trySuccess((Object)BoxesRunTime.boxToBoolean((boolean)true)));
                try {
                    bl = BoxesRunTime.unboxToBoolean((Object)Await$.MODULE$.result((Awaitable)joined.future(), (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds()));
                }
                catch (TimeoutException timeoutException) {
                    bl = false;
                }
            }
        }
        return bl;
    }

    private void createPathIfNeeded() {
        Option$.MODULE$.apply(this.client().checkExists().forPath(this.path())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            try {
                object = this.client().create().creatingParentsIfNeeded().forPath(this.path());
            }
            catch (KeeperException.NodeExistsException e) {
                $this.akka$cluster$seed$ZookeeperClusterSeed$$system.log().info("component=zookeeper-cluster-seed at=path-create-race-detected");
                object = BoxedUnit.UNIT;
            }
            return object;
        });
    }

    public void removeEphemeralNodes() {
        Nil$ nil$;
        try {
            nil$ = (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)this.client().getChildren().forPath(this.path())).asScala();
        }
        catch (KeeperException.NoNodeException noNodeException) {
            nil$ = Nil$.MODULE$;
        }
        Nil$ ephemeralNodes = nil$;
        ((IterableLike)((TraversableLike)((TraversableLike)ephemeralNodes.map((Function1 & Serializable & scala.Serializable)p -> new StringBuilder(1).append(this.path()).append("/").append((String)p).toString(), scala.collection.Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)p -> {
            Tuple2 tuple2;
            try {
                tuple2 = new Tuple2(p, this.client().getData().forPath(p));
            }
            catch (KeeperException.NoNodeException noNodeException) {
                tuple2 = new Tuple2(p, Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()));
            }
            return tuple2;
        }, scala.collection.Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)pd -> BoxesRunTime.boxToBoolean((boolean)ZookeeperClusterSeed.$anonfun$removeEphemeralNodes$3(this, pd)))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String p = (String)tuple2._1();
                try {
                    object = this.client().delete().forPath(p);
                }
                catch (KeeperException.NoNodeException noNodeException) {
                    object = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Object object2 = object;
            return object2;
        });
    }

    public final Either akka$cluster$seed$ZookeeperClusterSeed$$waitForLeaderChange$1(int times, int delay, String removedAddress) {
        Left left;
        block2: {
            while (true) {
                boolean bl;
                if (!(bl = this.akka$cluster$seed$ZookeeperClusterSeed$$latch().getLeader().getId().equals(removedAddress))) {
                    left = package$.MODULE$.Left().apply((Object)BoxedUnit.UNIT);
                    break block2;
                }
                if (times <= 0) break;
                Thread.sleep(delay);
                --times;
            }
            left = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        }
        return left;
    }

    public static final /* synthetic */ boolean $anonfun$tryJoin$1(ZookeeperClusterSeed $this, Participant x$2) {
        String string = x$2.getId();
        String string2 = $this.myId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$removeEphemeralNodes$3(ZookeeperClusterSeed $this, Tuple2 pd) {
        String string = new String((byte[])pd._2());
        String string2 = $this.myId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public ZookeeperClusterSeed(ExtendedActorSystem system) {
        Object object;
        Address address;
        this.akka$cluster$seed$ZookeeperClusterSeed$$system = system;
        this.settings = new ZookeeperClusterSeedSettings((ActorSystem)system, ZookeeperClusterSeedSettings$.MODULE$.$lessinit$greater$default$2(), ZookeeperClusterSeedSettings$.MODULE$.$lessinit$greater$default$3());
        this.clusterSystem = (Cluster)Cluster$.MODULE$.apply((ActorSystem)system);
        this.selfAddress = this.clusterSystem().selfAddress();
        if (this.settings().host().nonEmpty() && this.settings().port().nonEmpty()) {
            system.log().info(new StringBuilder(43).append("host:port read from environment variables=").append(this.settings().host()).append(":").append(this.settings().port()).toString());
            Option<String> x$1 = this.settings().host();
            Option<Object> x$2 = this.settings().port();
            String x$3 = this.selfAddress().copy$default$1();
            String x$4 = this.selfAddress().copy$default$2();
            address = this.selfAddress().copy(x$3, x$4, x$1, x$2);
        } else {
            address = ((Cluster)Cluster$.MODULE$.apply((ActorSystem)system)).selfAddress();
        }
        this.address = address;
        this.client = AkkaCuratorClient$.MODULE$.apply(this.settings());
        this.myId = new StringBuilder(3).append(this.address().protocol()).append("://").append(this.address().hostPort()).toString();
        this.path = new StringBuilder(1).append(this.settings().ZKPath()).append("/").append(system.name()).toString();
        this.removeEphemeralNodes();
        this.akka$cluster$seed$ZookeeperClusterSeed$$latch = new LeaderLatch(this.client(), this.path(), this.myId());
        this.akka$cluster$seed$ZookeeperClusterSeed$$latch().addListener(new LeaderLatchListener(this){
            private final /* synthetic */ ZookeeperClusterSeed $outer;

            public void isLeader() {
                this.$outer.akka$cluster$seed$ZookeeperClusterSeed$$system.log().info("component=zookeeper-cluster-seed at=leader-change status=Became a leader");
            }

            public void notLeader() {
                this.$outer.akka$cluster$seed$ZookeeperClusterSeed$$system.log().info("component=zookeeper-cluster-seed at=leader-change status=Lost leadership");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        if (this.settings().autoShutdown()) {
            this.client().getConnectionStateListenable().addListener((Object)new ConnectionStateListener(this){
                private final /* synthetic */ ZookeeperClusterSeed $outer;

                public void stateChanged(CuratorFramework client, ConnectionState newState) {
                    ConnectionState connectionState = newState;
                    if (ConnectionState.LOST.equals(connectionState)) {
                        this.$outer.akka$cluster$seed$ZookeeperClusterSeed$$system.log().warning("Lost, leaving the actor system.");
                        this.$outer.clusterSystem().leave(this.$outer.clusterSystem().selfAddress());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    this.$outer.akka$cluster$seed$ZookeeperClusterSeed$$system.log().warning("component=zookeeper-cluser-seed at=conntection-state-changed state={}", (Object)newState);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        this.seedEntryAdded = false;
        this.closeableServices = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.closeableServices().add((Object)this.akka$cluster$seed$ZookeeperClusterSeed$$latch());
        if (this.settings().autoDown()) {
            PathChildrenCache pathCache = new PathChildrenCache(this.client(), this.path(), true);
            pathCache.getListenable().addListener((Object)new PathChildrenCacheListener(this){
                private final /* synthetic */ ZookeeperClusterSeed $outer;

                public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) {
                    PathChildrenCacheEvent.Type type = event.getType();
                    if (PathChildrenCacheEvent.Type.CHILD_REMOVED.equals(type)) {
                        String childAddress = new String(event.getData().getData());
                        Either either = this.$outer.akka$cluster$seed$ZookeeperClusterSeed$$waitForLeaderChange$1((int)this.$outer.settings().autoDownMaxWait().toMillis() / 100, 100, childAddress);
                        if (either instanceof Left) {
                            BoxedUnit boxedUnit;
                            if (this.$outer.akka$cluster$seed$ZookeeperClusterSeed$$latch().getLeader().getId().equals(this.$outer.akka$cluster$seed$ZookeeperClusterSeed$$latch().getId())) {
                                this.$outer.akka$cluster$seed$ZookeeperClusterSeed$$system.log().info("component=zookeeper-cluster-seed at=downing-cluster-node node-address={}", (Object)childAddress);
                                this.$outer.clusterSystem().down(AddressFromURIString$.MODULE$.apply(childAddress));
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                this.$outer.akka$cluster$seed$ZookeeperClusterSeed$$system.log().info("component=zookeeper-cluster-seed at=downing-cluster-node status=not a leader state={} leader={}", (Object)this.$outer.akka$cluster$seed$ZookeeperClusterSeed$$latch().getState(), (Object)this.$outer.akka$cluster$seed$ZookeeperClusterSeed$$latch().getLeader());
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit2 = boxedUnit;
                        } else if (either instanceof Right) {
                            String string = this.$outer.settings().autoDownUnresolvedStrategy();
                            String string2 = AutoDownUnresolvedStrategies$.MODULE$.Log();
                            String string3 = string;
                            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                                this.$outer.akka$cluster$seed$ZookeeperClusterSeed$$system.log().info("component=zookeeper-cluster-seed at=downing-cluster-node status=leader-change-timeout timed out while waiting for leader to change. Ignoring.");
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                String string4 = AutoDownUnresolvedStrategies$.MODULE$.ForceDown();
                                String string5 = string;
                                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                                    this.$outer.akka$cluster$seed$ZookeeperClusterSeed$$system.log().info("component=zookeeper-cluster-seed at=downing-cluster-node status=leader-change-timeout timed out while waiting for leader to change. Forcing down of {}.", (Object)childAddress);
                                    this.$outer.clusterSystem().down(AddressFromURIString$.MODULE$.apply(childAddress));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                }
                            }
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            throw new MatchError((Object)either);
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            pathCache.start();
            object = BoxesRunTime.boxToBoolean((boolean)this.closeableServices().add((Object)pathCache));
        } else {
            object = BoxedUnit.UNIT;
        }
    }
}

