/*
 * Decompiled with CFR 0.152.
 */
package com.distelli.persistence;

import com.distelli.cred.CredProvider;
import com.distelli.crypto.KeyProvider;
import com.distelli.persistence.ConvertMarker;
import com.distelli.persistence.ConvertValue;
import com.distelli.persistence.FilterCondFn;
import com.distelli.persistence.IndexKey;
import com.distelli.persistence.PageIterator;
import com.distelli.persistence.QueryItemsBuilder;
import com.distelli.persistence.UpdateItemBuilder;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityNotFoundException;
import javax.persistence.RollbackException;

public interface Index<T> {
    public String getHashKeyName();

    public String getRangeKeyName();

    public String getTableName();

    default public Object getDynamoDBUnsafe() {
        return null;
    }

    default public Object getMySQLDataSourceUnsafe() {
        return null;
    }

    public String toMarker(T var1, boolean var2);

    public <N> Builder<N> clone(Class<N> var1);

    public QueryItemsBuilder<T> queryItems(Object var1, PageIterator var2);

    public List<T> scanItems(PageIterator var1);

    public int countItems(PageIterator var1);

    public T getItem(Object var1, Object var2);

    default public T getItem(Object hk) {
        return this.getItem(hk, null);
    }

    public <V> V getItem(Object var1, Object var2, Collection<String> var3, Class<V> var4);

    default public <V> V getItem(Object hk, Object rk, Class<V> type) {
        return this.getItem(hk, rk, null, type);
    }

    default public T getItemOrThrow(Object hk, Object rk) throws EntityNotFoundException {
        T result = this.getItem(hk, rk);
        if (null == result) {
            StringBuilder sb = new StringBuilder().append("Item in '").append(this.getTableName()).append("' not found with ").append(this.getHashKeyName()).append("='").append(hk.toString()).append("'");
            if (null != this.getRangeKeyName()) {
                sb.append(" and ").append(this.getRangeKeyName()).append("='").append(rk.toString()).append("'");
            }
            throw new EntityNotFoundException(sb.toString());
        }
        return result;
    }

    public Map<IndexKey, T> getItems(IndexKey ... var1);

    public Set<IndexKey> itemsExist(IndexKey ... var1);

    public void putItem(T var1);

    public void putItemOrThrow(T var1) throws EntityExistsException;

    default public boolean putItemIfNotExists(T item) {
        try {
            this.putItemOrThrow(item);
            return true;
        }
        catch (EntityExistsException ex) {
            return false;
        }
    }

    public void putItems(T ... var1);

    public UpdateItemBuilder<T> updateItem(Object var1, Object var2);

    public void deleteItem(Object var1, Object var2, FilterCondFn var3) throws RollbackException;

    default public void deleteItem(Object hk, Object rk) {
        this.deleteItem(hk, rk, null);
    }

    public void deleteItems(IndexKey ... var1);

    public static interface Factory {
        public <T> Builder<T> create(Class<T> var1);
    }

    public static interface Builder<T> {
        public Builder<T> withEndpoint(URI var1);

        public Builder<T> withConvertMarker(ConvertMarker var1);

        public Builder<T> withHashKeyName(String var1);

        public Builder<T> withRangeKeyName(String var1);

        public Builder<T> withConvertValue(ConvertValue var1);

        public Builder<T> withInfiniteRetry();

        public Builder<T> withTableName(String var1);

        public Builder<T> withTableNameFormat(String var1);

        public Builder<T> withIndexName(String var1, String var2);

        public Builder<T> withCredProvider(CredProvider var1);

        public Builder<T> withProxy(URI var1);

        public Builder<T> withNoEncrypt(String ... var1);

        public Builder<T> withKeyProvider(KeyProvider var1);

        public Index<T> build();

        public String getHashKeyName();

        public String getRangeKeyName();

        public String getTableName();
    }
}

