/*
 * Decompiled with CFR 0.152.
 */
package com.distelli.persistence;

import java.util.Iterator;

public class PageIterator
implements Iterable<PageIterator>,
Iterator<PageIterator> {
    private boolean _isForward = true;
    private String _marker = null;
    private String _prevMarker = null;
    private int _pageSize = Integer.MAX_VALUE;
    private boolean _isFirstPage = true;

    public PageIterator() {
    }

    public PageIterator(PageIterator other) {
        this._isForward = other._isForward;
        this._marker = other._marker;
        this._prevMarker = other._prevMarker;
        this._pageSize = other._pageSize;
        this._isFirstPage = other._isFirstPage;
    }

    @Override
    public Iterator<PageIterator> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this._isFirstPage || null != this._marker;
    }

    @Override
    public PageIterator next() {
        return this;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public PageIterator marker(String marker) {
        this._marker = marker;
        return this;
    }

    public PageIterator pageSize(int pageSize) {
        this._pageSize = pageSize;
        return this;
    }

    public PageIterator forward() {
        this._isForward = true;
        return this;
    }

    public PageIterator backward() {
        this._isForward = false;
        return this;
    }

    public PageIterator setIsForward(boolean isForward) {
        this._isForward = isForward;
        return this;
    }

    public boolean isForward() {
        return this._isForward;
    }

    public String getMarker() {
        return this._marker;
    }

    public String getPrevMarker() {
        return this._prevMarker;
    }

    public void setMarker(String marker) {
        this._marker = marker;
        this._isFirstPage = false;
    }

    public void setPrevMarker(String prevMarker) {
        this._prevMarker = prevMarker;
    }

    public int getPageSize() {
        return this._pageSize;
    }
}

