/*
 * Decompiled with CFR 0.152.
 */
package com.ditto.internal.serialization;

import com.ditto.dittoffi.DittoCrdtType;
import com.ditto.internal.Base64Kt;
import com.ditto.internal.InternalDittoAttachment;
import com.ditto.internal.InternalDittoAttachmentToken;
import com.ditto.internal.InternalDittoDiff;
import com.ditto.internal.InternalDittoDiskUsageItem;
import com.ditto.internal.InternalDittoTransactionInfo;
import com.ditto.internal.error.InternalDittoErrorFactory;
import com.ditto.internal.error.InternalDittoErrorFactoryKt;
import com.ditto.internal.error.InternalDittoErrorReason;
import com.ditto.internal.serialization.InternalDittoCborSerializable;
import com.ditto.internal.serialization.InternalDittoJsonSerializable;
import com.ditto.internal.serialization.cbor.Cbor;
import com.ditto.internal.serialization.cbor.CborBuilder;
import com.ditto.internal.serialization.cbor.CborKt;
import com.ditto.internal.transports.InternalDittoTransportConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.UByteArray;
import kotlin.ULong;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.HexExtensionsKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u00fa\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0005\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0014\u0010\u0007\u001a\u00020\u0001*\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0002\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u000b\u001a\u000e\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0001\u001a\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0001\u001a\u0014\u0010\u000f\u001a\u00020\u0006*\u00020\b2\u0006\u0010\r\u001a\u00020\u0001H\u0002\u001a\n\u0010\u0010\u001a\u00020\u000b*\u00020\u0001\u001a\u0011\u0010\u0011\u001a\u00020\u0012*\u00020\u0013H\u0007\u00a2\u0006\u0002\b\u0014\u001a\n\u0010\u0011\u001a\u00020\u0015*\u00020\u0006\u001a\u001d\u0010\u0011\u001a\u00020\u0016*\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0017H\u0007\u00a2\u0006\u0002\b\u0018\u001a\u001d\u0010\u0011\u001a\u00020\u0016*\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00130\u0017H\u0007\u00a2\u0006\u0002\b\u0019\u001a\u001d\u0010\u0011\u001a\u00020\u0016*\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0017H\u0007\u00a2\u0006\u0002\b\u001a\u001a\u000e\u0010\u001b\u001a\u00020\u001c*\u0006\u0012\u0002\b\u00030\u001d\u001a\u000e\u0010\u001e\u001a\u00020\u001f*\u0006\u0012\u0002\b\u00030\u001d\u001a\n\u0010\u001b\u001a\u00020 *\u00020\u001f\u001a\u0016\u0010!\u001a\u00020\u001f*\u00020\u001c2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#\u001a\u0011\u0010$\u001a\u00020%*\u00020\u0006H\u0007\u00a2\u0006\u0002\b&\u001a\u0011\u0010$\u001a\u00020\u001c*\u00020\u0013H\u0007\u00a2\u0006\u0002\b'\u001a\u0011\u0010$\u001a\u00020\u001c*\u00020(H\u0007\u00a2\u0006\u0002\b)\u001a\u0013\u0010$\u001a\u00020**\u00020+H\u0007\u00a2\u0006\u0004\b,\u0010-\u001a\u0013\u0010$\u001a\u00020**\u00020.H\u0007\u00a2\u0006\u0004\b/\u00100\u001a\u0011\u0010$\u001a\u000201*\u000202H\u0007\u00a2\u0006\u0002\b3\u001a\u0011\u0010$\u001a\u000204*\u000205H\u0007\u00a2\u0006\u0002\b6\u001a\u0011\u0010$\u001a\u000207*\u000208H\u0007\u00a2\u0006\u0002\b9\u001a\u0011\u0010$\u001a\u00020:*\u00020\u0003H\u0007\u00a2\u0006\u0002\b;\u001a\u0013\u0010$\u001a\u00020:*\u00020<H\u0007\u00a2\u0006\u0004\b=\u0010>\u001a\u001d\u0010$\u001a\u00020 *\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0017H\u0007\u00a2\u0006\u0002\b?\u001a\u001d\u0010$\u001a\u00020 *\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001c0\u0017H\u0007\u00a2\u0006\u0002\b@\u001a\u001d\u0010$\u001a\u00020 *\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c0\u0017H\u0007\u00a2\u0006\u0002\bA\u001a\u0017\u0010$\u001a\u00020B*\b\u0012\u0004\u0012\u00020\u001c0CH\u0007\u00a2\u0006\u0002\bD\u001a\u0019\u0010$\u001a\u00020B*\b\u0012\u0004\u0012\u00020\u001c0EH\u0007\u00a2\u0006\u0004\bF\u0010G\u001a\u000e\u0010H\u001a\u00020\u001c2\u0006\u0010I\u001a\u00020\u0003\u001a\u0012\u0010J\u001a\u00020\u001c*\u00020K2\u0006\u0010L\u001a\u00020\u0003\u001a\u000e\u0010M\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u001c\u001a\u0012\u0010N\u001a\u00020\u0003*\u00020K2\u0006\u0010\r\u001a\u00020\u001c\u001a5\u0010U\u001a\u0002HV\"\u0004\b\u0000\u0010V2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#2\u0006\u0010L\u001a\u00020\u00032\f\u0010W\u001a\b\u0012\u0004\u0012\u0002HV0XH\u0000\u00a2\u0006\u0002\u0010Y\u001a5\u0010Z\u001a\u00020\u0003\"\u0004\b\u0000\u0010V2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#2\u0006\u0010[\u001a\u0002HV2\f\u0010\\\u001a\b\u0012\u0004\u0012\u0002HV0]H\u0000\u00a2\u0006\u0002\u0010^\u001a\u001c\u0010_\u001a\u00020\u00032\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#2\u0006\u0010`\u001a\u00020aH\u0000\u001a\u001c\u0010b\u001a\u00020a2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#2\u0006\u0010L\u001a\u00020\u0003H\u0000\u001a\u001c\u0010c\u001a\u00020d2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#2\u0006\u0010L\u001a\u00020\u0003H\u0000\u001a\u001c\u0010e\u001a\u00020f2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#2\u0006\u0010L\u001a\u00020\u0003H\u0000\u001a\"\u0010g\u001a\b\u0012\u0004\u0012\u00020f0C2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#2\u0006\u0010L\u001a\u00020\u0003H\u0000\u001a\u001c\u0010h\u001a\u00020i2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#2\u0006\u0010L\u001a\u00020\u0003H\u0000\u001a\u001c\u0010j\u001a\u00020\u00032\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#2\u0006\u0010k\u001a\u00020\u0016H\u0000\u001a\u001c\u0010l\u001a\u00020\u00162\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#2\u0006\u0010L\u001a\u00020\u0003H\u0000\u001a\u001c\u0010m\u001a\u00020\u00162\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#2\u0006\u0010L\u001a\u00020\u0003H\u0000\u001a9\u0010n\u001a\u0002HV\"\b\b\u0000\u0010V*\u00020o2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#2\u0006\u0010p\u001a\u00020\u00062\f\u0010W\u001a\b\u0012\u0004\u0012\u0002HV0XH\u0000\u00a2\u0006\u0002\u0010q\u001a9\u0010r\u001a\u00020\u0006\"\b\b\u0000\u0010V*\u00020o2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#2\u0006\u0010[\u001a\u0002HV2\f\u0010\\\u001a\b\u0012\u0004\u0012\u0002HV0]H\u0000\u00a2\u0006\u0002\u0010s\"\u0014\u0010O\u001a\u00020KX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bP\u0010Q\"\u0014\u0010R\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bS\u0010T\u00a8\u0006t"}, d2={"decodeSerializableFromJSONBytes", "Lcom/ditto/internal/serialization/InternalDittoJsonSerializable;", "jsonBytes", "", "decodeSerializableFromJSONString", "jsonString", "", "decodeSerializableFromString", "Lkotlinx/serialization/json/Json;", "string", "toInternalDittoJsonSerializable", "Lkotlinx/serialization/json/JsonElement;", "encodeSerializableToJSONBytes", "serializable", "encodeSerializableToJSONString", "encodeSerializableToString", "toJsonElement", "toJson", "Lcom/ditto/internal/serialization/InternalDittoJsonSerializable$PrimitiveValue;", "", "intToJson", "Lcom/ditto/internal/serialization/InternalDittoJsonSerializable$StringValue;", "Lcom/ditto/internal/serialization/InternalDittoJsonSerializable$ObjectValue;", "", "map_String_String_toJson", "map_String_Int_toJson", "map_String_Serializable_toJson", "toInternalDittoCborSerializable", "Lcom/ditto/internal/serialization/InternalDittoCborSerializable;", "Lcom/ditto/internal/InternalDittoAttachment;", "toAttachmentToken", "Lcom/ditto/internal/InternalDittoAttachmentToken;", "Lcom/ditto/internal/serialization/InternalDittoCborSerializable$Dictionary;", "attachment", "errorFactory", "Lcom/ditto/internal/error/InternalDittoErrorFactory;", "toCbor", "Lcom/ditto/internal/serialization/InternalDittoCborSerializable$Utf8String;", "stringToCbor", "intToCbor", "", "longToCbor", "Lcom/ditto/internal/serialization/InternalDittoCborSerializable$UnsignedInteger;", "Lkotlin/UInt;", "uintToCbor", "(I)Lcom/ditto/internal/serialization/InternalDittoCborSerializable$UnsignedInteger;", "Lkotlin/ULong;", "ulongToCbor", "(J)Lcom/ditto/internal/serialization/InternalDittoCborSerializable$UnsignedInteger;", "Lcom/ditto/internal/serialization/InternalDittoCborSerializable$FloatValue;", "", "floatToCbor", "Lcom/ditto/internal/serialization/InternalDittoCborSerializable$DoubleValue;", "", "doubleToCbor", "Lcom/ditto/internal/serialization/InternalDittoCborSerializable$BooleanValue;", "", "booleanToCbor", "Lcom/ditto/internal/serialization/InternalDittoCborSerializable$ByteString;", "byteArrayToCbor", "Lkotlin/UByteArray;", "ubyteArrayToCbor", "([B)Lcom/ditto/internal/serialization/InternalDittoCborSerializable$ByteString;", "map_String_String_toCbor", "map_String_Serializable_toCbor", "map_Serializable_Serializable_toCbor", "Lcom/ditto/internal/serialization/InternalDittoCborSerializable$ArrayValue;", "", "list_Serializable_toCbor", "", "array_Serializable_toCbor", "([Lcom/ditto/internal/serialization/InternalDittoCborSerializable;)Lcom/ditto/internal/serialization/InternalDittoCborSerializable$ArrayValue;", "decodeSerializableFromCBOR", "cbor", "decodeSerializableFromByteArray", "Lcom/ditto/internal/serialization/cbor/Cbor;", "bytes", "encodeSerializableToCBOR", "encodeSerializableToByteArray", "cborConfig", "getCborConfig", "()Lcom/ditto/internal/serialization/cbor/Cbor;", "jsonConfig", "getJsonConfig", "()Lkotlinx/serialization/json/Json;", "decodeValueFromCBOR", "T", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "(Lcom/ditto/internal/error/InternalDittoErrorFactory;[BLkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "encodeValueAsCBOR", "value", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "(Lcom/ditto/internal/error/InternalDittoErrorFactory;Ljava/lang/Object;Lkotlinx/serialization/SerializationStrategy;)[B", "encodeTransportConfigToCBOR", "config", "Lcom/ditto/internal/transports/InternalDittoTransportConfig;", "decodeTransportConfigFromCBOR", "decodeDittoDiskUsageItemFromCBOR", "Lcom/ditto/internal/InternalDittoDiskUsageItem;", "decodeDittoTransactionInfoFromCBOR", "Lcom/ditto/internal/InternalDittoTransactionInfo;", "decodeDittoTransactionInfoListFromCBOR", "decodeDittoDiffFromCBOR", "Lcom/ditto/internal/InternalDittoDiff;", "encodePeerMetadataToJSONBytes", "metadata", "decodePeerMetadataFromJSONBytes", "decodeIdentityServiceMetadataFromJSONBytes", "decodeValueFromJSON", "", "json", "(Lcom/ditto/internal/error/InternalDittoErrorFactory;Ljava/lang/String;Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "encodeValueToJSON", "(Lcom/ditto/internal/error/InternalDittoErrorFactory;Ljava/lang/Object;Lkotlinx/serialization/SerializationStrategy;)Ljava/lang/String;", "ditto-internal"})
@JvmName(name="SerializationHelpers")
@SourceDebugExtension(value={"SMAP\nserializationHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 serializationHelpers.kt\ncom/ditto/internal/serialization/SerializationHelpers\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,405:1\n1557#2:406\n1628#2,3:407\n1246#2,4:412\n1557#2:416\n1628#2,3:417\n1246#2,4:422\n1246#2,4:428\n1246#2,4:434\n1246#2,4:440\n1246#2,4:446\n1557#2:450\n1628#2,3:451\n1557#2:454\n1628#2,3:455\n1557#2:458\n1628#2,3:459\n1557#2:462\n1628#2,3:463\n462#3:410\n412#3:411\n462#3:420\n412#3:421\n462#3:426\n412#3:427\n462#3:432\n412#3:433\n462#3:438\n412#3:439\n477#3:444\n423#3:445\n*S KotlinDebug\n*F\n+ 1 serializationHelpers.kt\ncom/ditto/internal/serialization/SerializationHelpers\n*L\n49#1:406\n49#1:407,3\n52#1:412,4\n77#1:416\n77#1:417,3\n81#1:422,4\n93#1:428,4\n95#1:434,4\n170#1:440,4\n173#1:446,4\n324#1:450\n324#1:451,3\n325#1:454\n325#1:455,3\n326#1:458\n326#1:459,3\n327#1:462\n327#1:463,3\n52#1:410\n52#1:411\n81#1:420\n81#1:421\n93#1:426\n93#1:427\n95#1:432\n95#1:433\n170#1:438\n170#1:439\n173#1:444\n173#1:445\n*E\n"})
public final class SerializationHelpers {
    @NotNull
    private static final Cbor cborConfig = CborKt.Cbor$default(null, SerializationHelpers::cborConfig$lambda$8, 1, null);
    @NotNull
    private static final Json jsonConfig = JsonKt.Json$default(null, SerializationHelpers::jsonConfig$lambda$9, (int)1, null);

    @NotNull
    public static final InternalDittoJsonSerializable decodeSerializableFromJSONBytes(@NotNull byte[] jsonBytes) {
        Intrinsics.checkNotNullParameter((Object)jsonBytes, (String)"jsonBytes");
        return SerializationHelpers.decodeSerializableFromJSONString(StringsKt.decodeToString((byte[])jsonBytes));
    }

    @NotNull
    public static final InternalDittoJsonSerializable decodeSerializableFromJSONString(@NotNull String jsonString) {
        Intrinsics.checkNotNullParameter((Object)jsonString, (String)"jsonString");
        return SerializationHelpers.decodeSerializableFromString(jsonConfig, jsonString);
    }

    private static final InternalDittoJsonSerializable decodeSerializableFromString(Json $this$decodeSerializableFromString, String string) {
        JsonElement element = (JsonElement)$this$decodeSerializableFromString.decodeFromString((DeserializationStrategy)JsonElement.Companion.serializer(), string);
        return SerializationHelpers.toInternalDittoJsonSerializable(element);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final InternalDittoJsonSerializable toInternalDittoJsonSerializable(@NotNull JsonElement $this$toInternalDittoJsonSerializable) {
        InternalDittoJsonSerializable internalDittoJsonSerializable;
        Intrinsics.checkNotNullParameter((Object)$this$toInternalDittoJsonSerializable, (String)"<this>");
        JsonElement jsonElement = $this$toInternalDittoJsonSerializable;
        if (jsonElement instanceof JsonArray) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)$this$toInternalDittoJsonSerializable;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JsonElement jsonElement2 = (JsonElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(SerializationHelpers.toInternalDittoJsonSerializable((JsonElement)it));
            }
            List list = (List)destination$iv$iv;
            internalDittoJsonSerializable = new InternalDittoJsonSerializable.ArrayValue(list);
        } else if (jsonElement instanceof JsonObject) {
            void $this$mapValuesTo$iv$iv;
            Map $this$mapValues$iv = (Map)$this$toInternalDittoJsonSerializable;
            boolean $i$f$mapValues = false;
            Map $this$mapTo$iv$iv = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map3 = map2;
                boolean bl2 = false;
                JsonElement value = (JsonElement)entry2.getValue();
                InternalDittoJsonSerializable internalDittoJsonSerializable2 = SerializationHelpers.toInternalDittoJsonSerializable(value);
                map3.put(k, internalDittoJsonSerializable2);
            }
            Map map4 = destination$iv$iv;
            internalDittoJsonSerializable = new InternalDittoJsonSerializable.ObjectValue(map4);
        } else if (Intrinsics.areEqual((Object)jsonElement, (Object)JsonNull.INSTANCE)) {
            internalDittoJsonSerializable = InternalDittoJsonSerializable.NullValue.INSTANCE;
        } else if (jsonElement instanceof JsonPrimitive) {
            internalDittoJsonSerializable = ((JsonPrimitive)$this$toInternalDittoJsonSerializable).isString() ? (InternalDittoJsonSerializable)new InternalDittoJsonSerializable.StringValue(((JsonPrimitive)$this$toInternalDittoJsonSerializable).getContent()) : (InternalDittoJsonSerializable)new InternalDittoJsonSerializable.PrimitiveValue((JsonPrimitive)$this$toInternalDittoJsonSerializable);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return internalDittoJsonSerializable;
    }

    @NotNull
    public static final byte[] encodeSerializableToJSONBytes(@NotNull InternalDittoJsonSerializable serializable) {
        Intrinsics.checkNotNullParameter((Object)serializable, (String)"serializable");
        return StringsKt.encodeToByteArray((String)SerializationHelpers.encodeSerializableToJSONString(serializable));
    }

    @NotNull
    public static final String encodeSerializableToJSONString(@NotNull InternalDittoJsonSerializable serializable) {
        Intrinsics.checkNotNullParameter((Object)serializable, (String)"serializable");
        return SerializationHelpers.encodeSerializableToString(jsonConfig, serializable);
    }

    private static final String encodeSerializableToString(Json $this$encodeSerializableToString, InternalDittoJsonSerializable serializable) {
        JsonElement element = SerializationHelpers.toJsonElement(serializable);
        return $this$encodeSerializableToString.encodeToString((SerializationStrategy)JsonElement.Companion.serializer(), (Object)element);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JsonElement toJsonElement(@NotNull InternalDittoJsonSerializable $this$toJsonElement) {
        JsonElement jsonElement;
        Intrinsics.checkNotNullParameter((Object)$this$toJsonElement, (String)"<this>");
        InternalDittoJsonSerializable internalDittoJsonSerializable = $this$toJsonElement;
        if (internalDittoJsonSerializable instanceof InternalDittoJsonSerializable.ArrayValue) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ((InternalDittoJsonSerializable.ArrayValue)$this$toJsonElement).getValue$ditto_internal();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                InternalDittoJsonSerializable internalDittoJsonSerializable2 = (InternalDittoJsonSerializable)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(SerializationHelpers.toJsonElement((InternalDittoJsonSerializable)it));
            }
            List list = (List)destination$iv$iv;
            jsonElement = (JsonElement)new JsonArray(list);
        } else if (Intrinsics.areEqual((Object)internalDittoJsonSerializable, (Object)InternalDittoJsonSerializable.NullValue.INSTANCE)) {
            jsonElement = (JsonElement)JsonNull.INSTANCE;
        } else if (internalDittoJsonSerializable instanceof InternalDittoJsonSerializable.ObjectValue) {
            void $this$mapValuesTo$iv$iv;
            Map<String, InternalDittoJsonSerializable> $this$mapValues$iv = ((InternalDittoJsonSerializable.ObjectValue)$this$toJsonElement).getValue$ditto_internal();
            boolean $i$f$mapValues = false;
            Map<String, InternalDittoJsonSerializable> $this$mapTo$iv$iv = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map3 = map2;
                boolean bl2 = false;
                InternalDittoJsonSerializable value = (InternalDittoJsonSerializable)entry2.getValue();
                JsonElement jsonElement2 = SerializationHelpers.toJsonElement(value);
                map3.put(k, jsonElement2);
            }
            Map map4 = destination$iv$iv;
            jsonElement = (JsonElement)new JsonObject(map4);
        } else if (internalDittoJsonSerializable instanceof InternalDittoJsonSerializable.PrimitiveValue) {
            jsonElement = (JsonElement)((InternalDittoJsonSerializable.PrimitiveValue)$this$toJsonElement).getPrimitive$ditto_internal();
        } else if (internalDittoJsonSerializable instanceof InternalDittoJsonSerializable.StringValue) {
            jsonElement = (JsonElement)JsonElementKt.JsonPrimitive((String)((InternalDittoJsonSerializable.StringValue)$this$toJsonElement).getValue$ditto_internal());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return jsonElement;
    }

    @JvmName(name="intToJson")
    @NotNull
    public static final InternalDittoJsonSerializable.PrimitiveValue intToJson(int $this$toJson) {
        return new InternalDittoJsonSerializable.PrimitiveValue($this$toJson);
    }

    @NotNull
    public static final InternalDittoJsonSerializable.StringValue toJson(@NotNull String $this$toJson) {
        Intrinsics.checkNotNullParameter((Object)$this$toJson, (String)"<this>");
        return new InternalDittoJsonSerializable.StringValue($this$toJson);
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="map_String_String_toJson")
    @NotNull
    public static final InternalDittoJsonSerializable.ObjectValue map_String_String_toJson(@NotNull Map<String, String> $this$toJson) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toJson, (String)"<this>");
        Map<String, String> $this$mapValues$iv = $this$toJson;
        boolean $i$f$mapValues = false;
        Map<String, String> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            String value = (String)entry2.getValue();
            InternalDittoJsonSerializable.StringValue stringValue = SerializationHelpers.toJson(value);
            map4.put(k, stringValue);
        }
        return SerializationHelpers.map_String_Serializable_toJson(destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="map_String_Int_toJson")
    @NotNull
    public static final InternalDittoJsonSerializable.ObjectValue map_String_Int_toJson(@NotNull Map<String, Integer> $this$toJson) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toJson, (String)"<this>");
        Map<String, Integer> $this$mapValues$iv = $this$toJson;
        boolean $i$f$mapValues = false;
        Map<String, Integer> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            int value = ((Number)entry2.getValue()).intValue();
            InternalDittoJsonSerializable.PrimitiveValue primitiveValue = SerializationHelpers.intToJson(value);
            map4.put(k, primitiveValue);
        }
        return SerializationHelpers.map_String_Serializable_toJson(destination$iv$iv);
    }

    @JvmName(name="map_String_Serializable_toJson")
    @NotNull
    public static final InternalDittoJsonSerializable.ObjectValue map_String_Serializable_toJson(@NotNull Map<String, ? extends InternalDittoJsonSerializable> $this$toJson) {
        Intrinsics.checkNotNullParameter($this$toJson, (String)"<this>");
        return new InternalDittoJsonSerializable.ObjectValue($this$toJson);
    }

    @NotNull
    public static final InternalDittoCborSerializable toInternalDittoCborSerializable(@NotNull InternalDittoAttachment<?> $this$toInternalDittoCborSerializable) {
        Intrinsics.checkNotNullParameter($this$toInternalDittoCborSerializable, (String)"<this>");
        return SerializationHelpers.toInternalDittoCborSerializable(SerializationHelpers.toAttachmentToken($this$toInternalDittoCborSerializable));
    }

    @NotNull
    public static final InternalDittoAttachmentToken toAttachmentToken(@NotNull InternalDittoAttachment<?> $this$toAttachmentToken) {
        Intrinsics.checkNotNullParameter($this$toAttachmentToken, (String)"<this>");
        return new InternalDittoAttachmentToken($this$toAttachmentToken.getIdBytes-TcUX1vc$ditto_internal(), $this$toAttachmentToken.getLen-s-VKNKU(), $this$toAttachmentToken.getMetadata(), null);
    }

    @NotNull
    public static final InternalDittoCborSerializable.Dictionary toInternalDittoCborSerializable(@NotNull InternalDittoAttachmentToken $this$toInternalDittoCborSerializable) {
        Intrinsics.checkNotNullParameter((Object)$this$toInternalDittoCborSerializable, (String)"<this>");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)SerializationHelpers.stringToCbor("_ditto_internal_type_jkb12973t4b"), (Object)SerializationHelpers.uintToCbor(DittoCrdtType.Attachment.getValue-pVg5ArA())), TuplesKt.to((Object)SerializationHelpers.stringToCbor("_id"), (Object)SerializationHelpers.ubyteArrayToCbor($this$toInternalDittoCborSerializable.getIdBytes-TcUX1vc$ditto_internal())), TuplesKt.to((Object)SerializationHelpers.stringToCbor("_len"), (Object)SerializationHelpers.ulongToCbor($this$toInternalDittoCborSerializable.getLen-s-VKNKU())), TuplesKt.to((Object)SerializationHelpers.stringToCbor("_meta"), (Object)$this$toInternalDittoCborSerializable.getMetadata())};
        return new InternalDittoCborSerializable.Dictionary(MapsKt.mapOf((Pair[])pairArray));
    }

    @NotNull
    public static final InternalDittoAttachmentToken attachment(@NotNull InternalDittoCborSerializable $this$attachment, @NotNull InternalDittoErrorFactory<?> errorFactory) {
        Intrinsics.checkNotNullParameter((Object)$this$attachment, (String)"<this>");
        Intrinsics.checkNotNullParameter(errorFactory, (String)"errorFactory");
        if (!($this$attachment instanceof InternalDittoCborSerializable.Dictionary)) {
            throw InternalDittoErrorFactoryKt.createFatalError$default(errorFactory, $this$attachment + " is not a dictionary, therefore can't be converted to an attachment token!", null, 2, null);
        }
        return ((InternalDittoCborSerializable.Dictionary)$this$attachment).keySet().contains(SerializationHelpers.stringToCbor("id")) ? new InternalDittoAttachmentToken(Base64Kt.base64Decode(((InternalDittoCborSerializable)((InternalDittoCborSerializable.Dictionary)$this$attachment).get((Object)SerializationHelpers.stringToCbor("id"))).getString(errorFactory)), ((InternalDittoCborSerializable)((InternalDittoCborSerializable.Dictionary)$this$attachment).get((Object)SerializationHelpers.stringToCbor("len"))).getULong-I7RO_PI(errorFactory), ((InternalDittoCborSerializable)((InternalDittoCborSerializable.Dictionary)$this$attachment).get((Object)SerializationHelpers.stringToCbor("metadata"))).getDictionary(errorFactory), null) : new InternalDittoAttachmentToken(((InternalDittoCborSerializable)((InternalDittoCborSerializable.Dictionary)$this$attachment).get((Object)SerializationHelpers.stringToCbor("_id"))).getUByteArray-NTtOWj4(errorFactory), ((InternalDittoCborSerializable)((InternalDittoCborSerializable.Dictionary)$this$attachment).get((Object)SerializationHelpers.stringToCbor("_len"))).getULong-I7RO_PI(errorFactory), ((InternalDittoCborSerializable)((InternalDittoCborSerializable.Dictionary)$this$attachment).get((Object)SerializationHelpers.stringToCbor("_meta"))).getDictionary(errorFactory), null);
    }

    @JvmName(name="stringToCbor")
    @NotNull
    public static final InternalDittoCborSerializable.Utf8String stringToCbor(@NotNull String $this$toCbor) {
        Intrinsics.checkNotNullParameter((Object)$this$toCbor, (String)"<this>");
        return new InternalDittoCborSerializable.Utf8String($this$toCbor);
    }

    @JvmName(name="intToCbor")
    @NotNull
    public static final InternalDittoCborSerializable intToCbor(int $this$toCbor) {
        return $this$toCbor >= 0 ? (InternalDittoCborSerializable)new InternalDittoCborSerializable.UnsignedInteger(ULong.constructor-impl((long)$this$toCbor), null) : (InternalDittoCborSerializable)new InternalDittoCborSerializable.NegativeInteger(ULong.constructor-impl((long)(-1 * $this$toCbor)), null);
    }

    @JvmName(name="longToCbor")
    @NotNull
    public static final InternalDittoCborSerializable longToCbor(long $this$toCbor) {
        return $this$toCbor >= 0L ? (InternalDittoCborSerializable)new InternalDittoCborSerializable.UnsignedInteger(ULong.constructor-impl((long)$this$toCbor), null) : (InternalDittoCborSerializable)new InternalDittoCborSerializable.NegativeInteger(ULong.constructor-impl((long)((long)-1 * $this$toCbor)), null);
    }

    @JvmName(name="uintToCbor")
    @NotNull
    public static final InternalDittoCborSerializable.UnsignedInteger uintToCbor(int $this$toCbor_u2dWZ4Q5Ns) {
        return SerializationHelpers.ulongToCbor(ULong.constructor-impl((long)((long)$this$toCbor_u2dWZ4Q5Ns & 0xFFFFFFFFL)));
    }

    @JvmName(name="ulongToCbor")
    @NotNull
    public static final InternalDittoCborSerializable.UnsignedInteger ulongToCbor(long $this$toCbor_u2dVKZWuLQ) {
        return new InternalDittoCborSerializable.UnsignedInteger($this$toCbor_u2dVKZWuLQ, null);
    }

    @JvmName(name="floatToCbor")
    @NotNull
    public static final InternalDittoCborSerializable.FloatValue floatToCbor(float $this$toCbor) {
        return new InternalDittoCborSerializable.FloatValue($this$toCbor);
    }

    @JvmName(name="doubleToCbor")
    @NotNull
    public static final InternalDittoCborSerializable.DoubleValue doubleToCbor(double $this$toCbor) {
        return new InternalDittoCborSerializable.DoubleValue($this$toCbor);
    }

    @JvmName(name="booleanToCbor")
    @NotNull
    public static final InternalDittoCborSerializable.BooleanValue booleanToCbor(boolean $this$toCbor) {
        return new InternalDittoCborSerializable.BooleanValue($this$toCbor);
    }

    @JvmName(name="byteArrayToCbor")
    @NotNull
    public static final InternalDittoCborSerializable.ByteString byteArrayToCbor(@NotNull byte[] $this$toCbor) {
        Intrinsics.checkNotNullParameter((Object)$this$toCbor, (String)"<this>");
        return new InternalDittoCborSerializable.ByteString(UByteArray.constructor-impl((byte[])$this$toCbor), null);
    }

    @JvmName(name="ubyteArrayToCbor")
    @NotNull
    public static final InternalDittoCborSerializable.ByteString ubyteArrayToCbor(@NotNull byte[] $this$toCbor_u2dGBYM_sE) {
        Intrinsics.checkNotNullParameter((Object)$this$toCbor_u2dGBYM_sE, (String)"$this$toCbor");
        return new InternalDittoCborSerializable.ByteString($this$toCbor_u2dGBYM_sE, null);
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="map_String_String_toCbor")
    @NotNull
    public static final InternalDittoCborSerializable.Dictionary map_String_String_toCbor(@NotNull Map<String, String> $this$toCbor) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toCbor, (String)"<this>");
        Map<String, String> $this$mapValues$iv = $this$toCbor;
        boolean $i$f$mapValues = false;
        Map<String, String> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            String value = (String)entry2.getValue();
            InternalDittoCborSerializable.Utf8String utf8String = SerializationHelpers.stringToCbor(value);
            map4.put(k, utf8String);
        }
        return SerializationHelpers.map_String_Serializable_toCbor(destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="map_String_Serializable_toCbor")
    @NotNull
    public static final InternalDittoCborSerializable.Dictionary map_String_Serializable_toCbor(@NotNull Map<String, ? extends InternalDittoCborSerializable> $this$toCbor) {
        void $this$mapKeysTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toCbor, (String)"<this>");
        Map<String, ? extends InternalDittoCborSerializable> $this$mapKeys$iv = $this$toCbor;
        boolean $i$f$mapKeys = false;
        Map<String, ? extends InternalDittoCborSerializable> map2 = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            String key = (String)entry.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            InternalDittoCborSerializable internalDittoCborSerializable = SerializationHelpers.stringToCbor(key);
            Map map4 = map3;
            boolean bl2 = false;
            entry = it$iv$iv.getValue();
            map4.put(internalDittoCborSerializable, entry);
        }
        Map map5 = destination$iv$iv;
        return new InternalDittoCborSerializable.Dictionary(map5);
    }

    @JvmName(name="map_Serializable_Serializable_toCbor")
    @NotNull
    public static final InternalDittoCborSerializable.Dictionary map_Serializable_Serializable_toCbor(@NotNull Map<InternalDittoCborSerializable, ? extends InternalDittoCborSerializable> $this$toCbor) {
        Intrinsics.checkNotNullParameter($this$toCbor, (String)"<this>");
        return new InternalDittoCborSerializable.Dictionary($this$toCbor);
    }

    @JvmName(name="list_Serializable_toCbor")
    @NotNull
    public static final InternalDittoCborSerializable.ArrayValue list_Serializable_toCbor(@NotNull List<? extends InternalDittoCborSerializable> $this$toCbor) {
        Intrinsics.checkNotNullParameter($this$toCbor, (String)"<this>");
        return new InternalDittoCborSerializable.ArrayValue($this$toCbor);
    }

    @JvmName(name="array_Serializable_toCbor")
    @NotNull
    public static final InternalDittoCborSerializable.ArrayValue array_Serializable_toCbor(@NotNull InternalDittoCborSerializable[] $this$toCbor) {
        Intrinsics.checkNotNullParameter((Object)$this$toCbor, (String)"<this>");
        return new InternalDittoCborSerializable.ArrayValue(ArraysKt.toList((Object[])$this$toCbor));
    }

    @NotNull
    public static final InternalDittoCborSerializable decodeSerializableFromCBOR(@NotNull byte[] cbor) {
        Intrinsics.checkNotNullParameter((Object)cbor, (String)"cbor");
        return SerializationHelpers.decodeSerializableFromByteArray(cborConfig, cbor);
    }

    @NotNull
    public static final InternalDittoCborSerializable decodeSerializableFromByteArray(@NotNull Cbor $this$decodeSerializableFromByteArray, @NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeSerializableFromByteArray, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return (InternalDittoCborSerializable)$this$decodeSerializableFromByteArray.decodeFromByteArray((DeserializationStrategy)InternalDittoCborSerializable.Serializer.INSTANCE, bytes);
    }

    @NotNull
    public static final byte[] encodeSerializableToCBOR(@NotNull InternalDittoCborSerializable serializable) {
        Intrinsics.checkNotNullParameter((Object)serializable, (String)"serializable");
        return SerializationHelpers.encodeSerializableToByteArray(cborConfig, serializable);
    }

    @NotNull
    public static final byte[] encodeSerializableToByteArray(@NotNull Cbor $this$encodeSerializableToByteArray, @NotNull InternalDittoCborSerializable serializable) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeSerializableToByteArray, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)serializable, (String)"serializable");
        return $this$encodeSerializableToByteArray.encodeToByteArray((SerializationStrategy)InternalDittoCborSerializable.Serializer.INSTANCE, serializable);
    }

    @NotNull
    public static final Cbor getCborConfig() {
        return cborConfig;
    }

    @NotNull
    public static final Json getJsonConfig() {
        return jsonConfig;
    }

    public static final <T> T decodeValueFromCBOR(@NotNull InternalDittoErrorFactory<?> errorFactory, @NotNull byte[] bytes, @NotNull DeserializationStrategy<? extends T> deserializer) {
        T t;
        Intrinsics.checkNotNullParameter(errorFactory, (String)"errorFactory");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        try {
            t = cborConfig.decodeFromByteArray(deserializer, bytes);
        }
        catch (Throwable e) {
            throw errorFactory.createError(new InternalDittoErrorReason.StoreErrorReason.FailedToDecodeDocument(e));
        }
        return t;
    }

    @NotNull
    public static final <T> byte[] encodeValueAsCBOR(@NotNull InternalDittoErrorFactory<?> errorFactory, T value, @NotNull SerializationStrategy<? super T> serializer2) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter(errorFactory, (String)"errorFactory");
        Intrinsics.checkNotNullParameter(serializer2, (String)"serializer");
        try {
            byArray = cborConfig.encodeToByteArray(serializer2, value);
        }
        catch (Throwable e) {
            String string = e.getMessage();
            if (string == null) {
                string = "No message provided";
            }
            throw errorFactory.createError(new InternalDittoErrorReason.StoreErrorReason.FailedToEncodeValue(value, string, e));
        }
        return byArray;
    }

    @NotNull
    public static final byte[] encodeTransportConfigToCBOR(@NotNull InternalDittoErrorFactory<?> errorFactory, @NotNull InternalDittoTransportConfig config) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter(errorFactory, (String)"errorFactory");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        try {
            byArray = cborConfig.encodeToByteArray((SerializationStrategy)InternalDittoTransportConfig.Companion.serializer(), config);
        }
        catch (Throwable e) {
            throw InternalDittoErrorFactoryKt.createFatalError(errorFactory, "Could not serialize `DittoTransportConfig` (" + config + ") to bytes", e);
        }
        return byArray;
    }

    @NotNull
    public static final InternalDittoTransportConfig decodeTransportConfigFromCBOR(@NotNull InternalDittoErrorFactory<?> errorFactory, @NotNull byte[] bytes) {
        InternalDittoTransportConfig internalDittoTransportConfig;
        Intrinsics.checkNotNullParameter(errorFactory, (String)"errorFactory");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        try {
            internalDittoTransportConfig = (InternalDittoTransportConfig)cborConfig.decodeFromByteArray((DeserializationStrategy)InternalDittoTransportConfig.Companion.serializer(), bytes);
        }
        catch (Throwable e) {
            throw InternalDittoErrorFactoryKt.createFatalError(errorFactory, "Could not deserialize `DittoTransportConfig` from bytes " + HexExtensionsKt.toHexString$default((byte[])bytes, null, (int)1, null), e);
        }
        return internalDittoTransportConfig;
    }

    @NotNull
    public static final InternalDittoDiskUsageItem decodeDittoDiskUsageItemFromCBOR(@NotNull InternalDittoErrorFactory<?> errorFactory, @NotNull byte[] bytes) {
        InternalDittoDiskUsageItem internalDittoDiskUsageItem;
        Intrinsics.checkNotNullParameter(errorFactory, (String)"errorFactory");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        try {
            internalDittoDiskUsageItem = (InternalDittoDiskUsageItem)cborConfig.decodeFromByteArray((DeserializationStrategy)InternalDittoDiskUsageItem.Companion.serializer(), bytes);
        }
        catch (Throwable e) {
            throw InternalDittoErrorFactoryKt.createFatalError(errorFactory, "Could not deserialize `DittoDiskUsageItem` from bytes " + HexExtensionsKt.toHexString$default((byte[])bytes, null, (int)1, null), e);
        }
        return internalDittoDiskUsageItem;
    }

    @NotNull
    public static final InternalDittoTransactionInfo decodeDittoTransactionInfoFromCBOR(@NotNull InternalDittoErrorFactory<?> errorFactory, @NotNull byte[] bytes) {
        InternalDittoTransactionInfo internalDittoTransactionInfo;
        Intrinsics.checkNotNullParameter(errorFactory, (String)"errorFactory");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        try {
            internalDittoTransactionInfo = (InternalDittoTransactionInfo)cborConfig.decodeFromByteArray((DeserializationStrategy)InternalDittoTransactionInfo.Companion.serializer(), bytes);
        }
        catch (Throwable e) {
            throw InternalDittoErrorFactoryKt.createFatalError(errorFactory, "Could not deserialize `DittoTransactionInfo` from bytes " + HexExtensionsKt.toHexString$default((byte[])bytes, null, (int)1, null), e);
        }
        return internalDittoTransactionInfo;
    }

    @NotNull
    public static final List<InternalDittoTransactionInfo> decodeDittoTransactionInfoListFromCBOR(@NotNull InternalDittoErrorFactory<?> errorFactory, @NotNull byte[] bytes) {
        List list;
        Intrinsics.checkNotNullParameter(errorFactory, (String)"errorFactory");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        try {
            list = (List)cborConfig.decodeFromByteArray((DeserializationStrategy)BuiltinSerializersKt.ListSerializer(InternalDittoTransactionInfo.Companion.serializer()), bytes);
        }
        catch (Throwable e) {
            throw InternalDittoErrorFactoryKt.createFatalError(errorFactory, "Could not deserialize `List<DittoTransactionInfo>` from bytes " + HexExtensionsKt.toHexString$default((byte[])bytes, null, (int)1, null), e);
        }
        return list;
    }

    @NotNull
    public static final InternalDittoDiff decodeDittoDiffFromCBOR(@NotNull InternalDittoErrorFactory<?> errorFactory, @NotNull byte[] bytes) {
        InternalDittoDiff internalDittoDiff;
        Intrinsics.checkNotNullParameter(errorFactory, (String)"errorFactory");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        try {
            Collection<InternalDittoDiff.Move> collection;
            Collection<Integer> collection2;
            Collection collection3;
            InternalDittoCborSerializable it;
            Collection collection4;
            Iterable $this$mapTo$iv$iv;
            InternalDittoCborSerializable.Dictionary dictionary = SerializationHelpers.decodeSerializableFromByteArray(cborConfig, bytes).getDictionary(errorFactory);
            Iterable $this$map$iv = dictionary.get("insertions").getList(errorFactory);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                InternalDittoCborSerializable internalDittoCborSerializable = (InternalDittoCborSerializable)item$iv$iv;
                collection4 = destination$iv$iv;
                boolean bl = false;
                collection4.add(it.getInt(errorFactory));
            }
            $this$map$iv = dictionary.get("deletions").getList(errorFactory);
            collection4 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (InternalDittoCborSerializable)item$iv$iv;
                collection3 = destination$iv$iv;
                boolean bl = false;
                collection3.add(it.getInt(errorFactory));
            }
            $this$map$iv = dictionary.get("updates").getList(errorFactory);
            collection3 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (InternalDittoCborSerializable)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getInt(errorFactory));
            }
            collection2 = (List)destination$iv$iv;
            $this$map$iv = dictionary.get("moves").getList(errorFactory);
            collection2 = CollectionsKt.toSet((Iterable)collection2);
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (InternalDittoCborSerializable)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new InternalDittoDiff.Move(it.get(0).getInt(errorFactory), it.get(1).getInt(errorFactory)));
            }
            Collection<InternalDittoDiff.Move> collection5 = collection = (List)destination$iv$iv;
            Collection<Integer> collection6 = collection2;
            Collection collection7 = collection3;
            Collection collection8 = collection4;
            internalDittoDiff = new InternalDittoDiff((Set<Integer>)collection8, (Set<Integer>)collection7, (Set<Integer>)collection6, (List<InternalDittoDiff.Move>)collection5);
        }
        catch (Throwable e) {
            throw InternalDittoErrorFactoryKt.createFatalError(errorFactory, "Could not deserialize `DittoDiff` from bytes " + HexExtensionsKt.toHexString$default((byte[])bytes, null, (int)1, null), e);
        }
        return internalDittoDiff;
    }

    @NotNull
    public static final byte[] encodePeerMetadataToJSONBytes(@NotNull InternalDittoErrorFactory<?> errorFactory, @NotNull InternalDittoJsonSerializable.ObjectValue metadata) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter(errorFactory, (String)"errorFactory");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        try {
            byArray = SerializationHelpers.encodeSerializableToJSONBytes(metadata);
        }
        catch (Throwable e) {
            throw errorFactory.createError(new InternalDittoErrorReason.ValidationErrorReason.NotJsonCompatible("The given peer metadata failed to serialize to JSON.", e));
        }
        return byArray;
    }

    @NotNull
    public static final InternalDittoJsonSerializable.ObjectValue decodePeerMetadataFromJSONBytes(@NotNull InternalDittoErrorFactory<?> errorFactory, @NotNull byte[] bytes) {
        InternalDittoJsonSerializable internalDittoJsonSerializable;
        Intrinsics.checkNotNullParameter(errorFactory, (String)"errorFactory");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        try {
            internalDittoJsonSerializable = SerializationHelpers.decodeSerializableFromJSONBytes(bytes);
        }
        catch (Throwable e) {
            throw InternalDittoErrorFactoryKt.createFatalError(errorFactory, "Internal inconsistency, Rust Core returned peer metadata JSON that couldn't be decoded: " + HexExtensionsKt.toHexString$default((byte[])bytes, null, (int)1, null), e);
        }
        InternalDittoJsonSerializable decoded = internalDittoJsonSerializable;
        InternalDittoJsonSerializable.ObjectValue objectValue = decoded instanceof InternalDittoJsonSerializable.ObjectValue ? (InternalDittoJsonSerializable.ObjectValue)decoded : null;
        if (objectValue == null) {
            throw InternalDittoErrorFactoryKt.createFatalError$default(errorFactory, "Internal inconsistency, Rust Core returned peer metadata JSON that wasn't a JSON object", null, 2, null);
        }
        return objectValue;
    }

    @NotNull
    public static final InternalDittoJsonSerializable.ObjectValue decodeIdentityServiceMetadataFromJSONBytes(@NotNull InternalDittoErrorFactory<?> errorFactory, @NotNull byte[] bytes) {
        InternalDittoJsonSerializable internalDittoJsonSerializable;
        Intrinsics.checkNotNullParameter(errorFactory, (String)"errorFactory");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        try {
            internalDittoJsonSerializable = SerializationHelpers.decodeSerializableFromJSONBytes(bytes);
        }
        catch (Throwable e) {
            throw InternalDittoErrorFactoryKt.createFatalError(errorFactory, "Internal inconsistency, Rust Core returned identity service metadata JSON that couldn't be decoded: " + HexExtensionsKt.toHexString$default((byte[])bytes, null, (int)1, null), e);
        }
        InternalDittoJsonSerializable decoded = internalDittoJsonSerializable;
        InternalDittoJsonSerializable.ObjectValue objectValue = decoded instanceof InternalDittoJsonSerializable.ObjectValue ? (InternalDittoJsonSerializable.ObjectValue)decoded : null;
        if (objectValue == null) {
            throw InternalDittoErrorFactoryKt.createFatalError$default(errorFactory, "Internal inconsistency, Rust Core returned identity service metadata JSON that wasn't a JSON object", null, 2, null);
        }
        return objectValue;
    }

    @NotNull
    public static final <T> T decodeValueFromJSON(@NotNull InternalDittoErrorFactory<?> errorFactory, @NotNull String json, @NotNull DeserializationStrategy<? extends T> deserializer) {
        Object object;
        Intrinsics.checkNotNullParameter(errorFactory, (String)"errorFactory");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        try {
            object = jsonConfig.decodeFromString(deserializer, json);
        }
        catch (Throwable e) {
            throw errorFactory.createError(new InternalDittoErrorReason.PresenceErrorReason.FailedToDecodeJson(e));
        }
        return (T)object;
    }

    @NotNull
    public static final <T> String encodeValueToJSON(@NotNull InternalDittoErrorFactory<?> errorFactory, @NotNull T value, @NotNull SerializationStrategy<? super T> serializer2) {
        String string;
        Intrinsics.checkNotNullParameter(errorFactory, (String)"errorFactory");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Intrinsics.checkNotNullParameter(serializer2, (String)"serializer");
        try {
            string = jsonConfig.encodeToString(serializer2, value);
        }
        catch (Throwable e) {
            throw errorFactory.createError(new InternalDittoErrorReason.PresenceErrorReason.FailedToEncodeJson(e));
        }
        return string;
    }

    private static final Unit cborConfig$lambda$8(CborBuilder $this$Cbor) {
        Intrinsics.checkNotNullParameter((Object)$this$Cbor, (String)"$this$Cbor");
        $this$Cbor.setEncodeDefaults(true);
        $this$Cbor.setIgnoreUnknownKeys(true);
        $this$Cbor.setUseDefiniteLengthEncoding(true);
        $this$Cbor.setAlwaysUseByteString(true);
        return Unit.INSTANCE;
    }

    private static final Unit jsonConfig$lambda$9(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setEncodeDefaults(true);
        $this$Json.setIgnoreUnknownKeys(true);
        return Unit.INSTANCE;
    }
}

