/*
 * Decompiled with CFR 0.152.
 */
package com.ditto.internal.serialization.cbor.internal;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000b\u001a\u00020\u0007J\u001e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/ditto/internal/serialization/cbor/internal/ByteArrayInput;", "", "array", "", "<init>", "([B)V", "position", "", "availableBytes", "getAvailableBytes", "()I", "read", "b", "offset", "length", "skip", "", "ditto-internal"})
public final class ByteArrayInput {
    @NotNull
    private byte[] array;
    private int position;

    public ByteArrayInput(@NotNull byte[] array) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        this.array = array;
    }

    public final int getAvailableBytes() {
        return this.array.length - this.position;
    }

    public final int read() {
        int n;
        if (this.position < this.array.length) {
            int n2 = this.position;
            this.position = n2 + 1;
            n = this.array[n2] & 0xFF;
        } else {
            n = -1;
        }
        return n;
    }

    public final int read(@NotNull byte[] b, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (offset < 0 || offset > b.length || length < 0 || length > b.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (this.position >= this.array.length) {
            return -1;
        }
        if (length == 0) {
            return 0;
        }
        int copied = this.array.length - this.position < length ? this.array.length - this.position : length;
        ArraysKt.copyInto((byte[])this.array, (byte[])b, (int)offset, (int)this.position, (int)(this.position + copied));
        this.position += copied;
        return copied;
    }

    public final void skip(int length) {
        this.position += length;
    }
}

