/*
 * Decompiled with CFR 0.152.
 */
package com.ditto.internal.serialization.cbor.internal;

import com.ditto.internal.serialization.cbor.Cbor;
import com.ditto.internal.serialization.cbor.CborEncoder;
import com.ditto.internal.serialization.cbor.internal.ByteArrayOutput;
import com.ditto.internal.serialization.cbor.internal.EncoderKt;
import com.ditto.internal.serialization.cbor.internal.EncodingKt;
import kotlin.Metadata;
import kotlin.UByteArray;
import kotlin.ULong;
import kotlin.ULongArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractEncoder;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u00012\u00020\u0002:\u0001<B\u0019\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\u0015\u001a\u00020\u0006H \u00a2\u0006\u0002\b\u0016J)\u0010\u001b\u001a\u00020\u001c\"\u0004\b\u0000\u0010\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u001f2\u0006\u0010 \u001a\u0002H\u001dH\u0016\u00a2\u0006\u0002\u0010!J\u0018\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\u001cH$J\u0010\u0010(\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u001c2\u0006\u0010 \u001a\u000201H\u0016J\u0010\u00102\u001a\u00020\u001c2\u0006\u0010 \u001a\u000203H\u0016J\u0010\u00104\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020&H\u0016J\u0010\u00105\u001a\u00020\u001c2\u0006\u0010 \u001a\u000206H\u0016J\u0010\u00107\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u000eH\u0016J\b\u00108\u001a\u00020\u001cH\u0016J\u0018\u00109\u001a\u00020\u001c2\u0006\u0010:\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010;\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u000eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u0082\u0001\u0002=>\u00a8\u0006?"}, d2={"Lcom/ditto/internal/serialization/cbor/internal/CborWriter;", "Lkotlinx/serialization/encoding/AbstractEncoder;", "Lcom/ditto/internal/serialization/cbor/CborEncoder;", "cbor", "Lcom/ditto/internal/serialization/cbor/Cbor;", "output", "Lcom/ditto/internal/serialization/cbor/internal/ByteArrayOutput;", "<init>", "(Lcom/ditto/internal/serialization/cbor/Cbor;Lcom/ditto/internal/serialization/cbor/internal/ByteArrayOutput;)V", "getCbor", "()Lcom/ditto/internal/serialization/cbor/Cbor;", "getOutput", "()Lcom/ditto/internal/serialization/cbor/internal/ByteArrayOutput;", "isClass", "", "()Z", "setClass", "(Z)V", "encodeByteArrayAsByteString", "getEncodeByteArrayAsByteString", "setEncodeByteArrayAsByteString", "getDestination", "getDestination$ditto_internal", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "encodeSerializableValue", "", "T", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "value", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)V", "shouldEncodeElementDefault", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "index", "", "incrementChildren", "encodeString", "", "encodeFloat", "", "encodeDouble", "", "encodeChar", "", "encodeByte", "", "encodeShort", "", "encodeInt", "encodeLong", "", "encodeBoolean", "encodeNull", "encodeEnum", "enumDescriptor", "encodeElement", "Data", "Lcom/ditto/internal/serialization/cbor/internal/DefiniteLengthCborWriter;", "Lcom/ditto/internal/serialization/cbor/internal/IndefiniteLengthCborWriter;", "ditto-internal"})
@SourceDebugExtension(value={"SMAP\nEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Encoder.kt\ncom/ditto/internal/serialization/cbor/internal/CborWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,345:1\n1863#2,2:346\n1863#2,2:348\n*S KotlinDebug\n*F\n+ 1 Encoder.kt\ncom/ditto/internal/serialization/cbor/internal/CborWriter\n*L\n130#1:346,2\n144#1:348,2\n*E\n"})
public abstract class CborWriter
extends AbstractEncoder
implements CborEncoder {
    @NotNull
    private final Cbor cbor;
    @NotNull
    private final ByteArrayOutput output;
    private boolean isClass;
    private boolean encodeByteArrayAsByteString;

    private CborWriter(Cbor cbor, ByteArrayOutput output) {
        this.cbor = cbor;
        this.output = output;
    }

    @Override
    @NotNull
    public Cbor getCbor() {
        return this.cbor;
    }

    @NotNull
    protected final ByteArrayOutput getOutput() {
        return this.output;
    }

    protected final boolean isClass() {
        return this.isClass;
    }

    protected final void setClass(boolean bl) {
        this.isClass = bl;
    }

    protected final boolean getEncodeByteArrayAsByteString() {
        return this.encodeByteArrayAsByteString;
    }

    protected final void setEncodeByteArrayAsByteString(boolean bl) {
        this.encodeByteArrayAsByteString = bl;
    }

    @NotNull
    public abstract ByteArrayOutput getDestination$ditto_internal();

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.getCbor().getSerializersModule();
    }

    public <T> void encodeSerializableValue(@NotNull SerializationStrategy<? super T> serializer2, T value) {
        boolean shouldEncodeByteArrayAsByteString;
        Intrinsics.checkNotNullParameter(serializer2, (String)"serializer");
        boolean bl = shouldEncodeByteArrayAsByteString = this.encodeByteArrayAsByteString || this.getCbor().getConfiguration().getAlwaysUseByteString();
        if (shouldEncodeByteArrayAsByteString && Intrinsics.areEqual((Object)serializer2.getDescriptor(), (Object)BuiltinSerializersKt.ByteArraySerializer().getDescriptor())) {
            ByteArrayOutput byteArrayOutput = this.getDestination$ditto_internal();
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.ByteArray");
            EncoderKt.encodeByteString(byteArrayOutput, (byte[])value);
        } else if (shouldEncodeByteArrayAsByteString && Intrinsics.areEqual((Object)serializer2.getDescriptor(), (Object)BuiltinSerializersKt.UByteArraySerializer().getDescriptor())) {
            ByteArrayOutput byteArrayOutput = this.getDestination$ditto_internal();
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.UByteArray");
            EncoderKt.encodeByteString(byteArrayOutput, ((UByteArray)value).unbox-impl());
        } else {
            this.encodeByteArrayAsByteString = this.encodeByteArrayAsByteString || EncodingKt.isInlineByteString(serializer2.getDescriptor());
            super.encodeSerializableValue(serializer2, value);
        }
    }

    public boolean shouldEncodeElementDefault(@NotNull SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return this.getCbor().getConfiguration().getEncodeDefaults();
    }

    protected abstract void incrementChildren();

    public void encodeString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        EncoderKt.encodeString(this.getDestination$ditto_internal(), value);
    }

    public void encodeFloat(float value) {
        EncoderKt.encodeFloat(this.getDestination$ditto_internal(), value);
    }

    public void encodeDouble(double value) {
        EncoderKt.encodeDouble(this.getDestination$ditto_internal(), value);
    }

    public void encodeChar(char value) {
        EncoderKt.encodeNumber(this.getDestination$ditto_internal(), value);
    }

    public void encodeByte(byte value) {
        EncoderKt.encodeNumber(this.getDestination$ditto_internal(), value);
    }

    public void encodeShort(short value) {
        EncoderKt.encodeNumber(this.getDestination$ditto_internal(), value);
    }

    public void encodeInt(int value) {
        EncoderKt.encodeNumber(this.getDestination$ditto_internal(), value);
    }

    public void encodeLong(long value) {
        EncoderKt.encodeNumber(this.getDestination$ditto_internal(), value);
    }

    public void encodeBoolean(boolean value) {
        EncoderKt.encodeBoolean(this.getDestination$ditto_internal(), value);
    }

    public void encodeNull() {
        if (this.isClass) {
            EncoderKt.encodeEmptyMap(this.getDestination$ditto_internal());
        } else {
            EncoderKt.encodeNull(this.getDestination$ditto_internal());
        }
    }

    public void encodeEnum(@NotNull SerialDescriptor enumDescriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        EncoderKt.encodeString(this.getDestination$ditto_internal(), enumDescriptor.getElementName(index));
    }

    public boolean encodeElement(@NotNull SerialDescriptor descriptor, int index) {
        long it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        ByteArrayOutput destination = this.getDestination$ditto_internal();
        this.isClass = Intrinsics.areEqual((Object)descriptor.getElementDescriptor(index).getKind(), (Object)StructureKind.CLASS.INSTANCE);
        this.encodeByteArrayAsByteString = EncodingKt.isByteString(descriptor, index);
        String name = descriptor.getElementName(index);
        if (!EncodingKt.hasArrayTag(descriptor)) {
            if (this.getCbor().getConfiguration().getEncodeKeyTags()) {
                long[] lArray = EncodingKt.getKeyTags(descriptor, index);
                if (lArray != null) {
                    $this$forEach$iv = (Iterable)ULongArray.box-impl((long[])lArray);
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = ((ULong)element$iv).unbox-impl();
                        boolean bl = false;
                        EncoderKt.encodeTag-2TYgG_w(destination, it);
                    }
                }
            }
            if (!(descriptor.getKind() instanceof StructureKind.LIST || descriptor.getKind() instanceof StructureKind.MAP || descriptor.getKind() instanceof PolymorphicKind)) {
                Long cborLabel = EncodingKt.getCborLabel(descriptor, index);
                if (this.getCbor().getConfiguration().getPreferCborLabelsOverNames() && cborLabel != null) {
                    EncoderKt.encodeNumber(destination, cborLabel);
                } else {
                    EncoderKt.encodeString(destination, name);
                }
            }
        }
        if (this.getCbor().getConfiguration().getEncodeValueTags()) {
            long[] lArray = EncodingKt.getValueTags(descriptor, index);
            if (lArray != null) {
                $this$forEach$iv = (Iterable)ULongArray.box-impl((long[])lArray);
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = ((ULong)element$iv).unbox-impl();
                    boolean bl = false;
                    EncoderKt.encodeTag-2TYgG_w(destination, it);
                }
            }
        }
        this.incrementChildren();
        return true;
    }

    public /* synthetic */ CborWriter(Cbor cbor, ByteArrayOutput output, DefaultConstructorMarker $constructor_marker) {
        this(cbor, output);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/ditto/internal/serialization/cbor/internal/CborWriter$Data;", "", "bytes", "Lcom/ditto/internal/serialization/cbor/internal/ByteArrayOutput;", "elementCount", "", "<init>", "(Lcom/ditto/internal/serialization/cbor/internal/ByteArrayOutput;I)V", "getBytes", "()Lcom/ditto/internal/serialization/cbor/internal/ByteArrayOutput;", "getElementCount", "()I", "setElementCount", "(I)V", "ditto-internal"})
    public static final class Data {
        @NotNull
        private final ByteArrayOutput bytes;
        private int elementCount;

        public Data(@NotNull ByteArrayOutput bytes, int elementCount) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            this.bytes = bytes;
            this.elementCount = elementCount;
        }

        @NotNull
        public final ByteArrayOutput getBytes() {
            return this.bytes;
        }

        public final int getElementCount() {
            return this.elementCount;
        }

        public final void setElementCount(int n) {
            this.elementCount = n;
        }
    }
}

