/*
 * Decompiled with CFR 0.152.
 */
package com.ditto.internal.serialization.cbor.internal;

import com.ditto.internal.serialization.cbor.Cbor;
import com.ditto.internal.serialization.cbor.internal.ByteArrayOutput;
import com.ditto.internal.serialization.cbor.internal.CborWriter;
import com.ditto.internal.serialization.cbor.internal.EncoderKt;
import com.ditto.internal.serialization.cbor.internal.EncodingKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.ULong;
import kotlin.ULongArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.CompositeEncoder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\f\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0018\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/ditto/internal/serialization/cbor/internal/DefiniteLengthCborWriter;", "Lcom/ditto/internal/serialization/cbor/internal/CborWriter;", "cbor", "Lcom/ditto/internal/serialization/cbor/Cbor;", "output", "Lcom/ditto/internal/serialization/cbor/internal/ByteArrayOutput;", "<init>", "(Lcom/ditto/internal/serialization/cbor/Cbor;Lcom/ditto/internal/serialization/cbor/internal/ByteArrayOutput;)V", "structureStack", "", "Lcom/ditto/internal/serialization/cbor/internal/CborWriter$Data;", "Lcom/ditto/internal/serialization/cbor/internal/Stack;", "getDestination", "getDestination$ditto_internal", "incrementChildren", "", "beginStructure", "Lkotlinx/serialization/encoding/CompositeEncoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "endStructure", "ditto-internal"})
@SourceDebugExtension(value={"SMAP\nEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Encoder.kt\ncom/ditto/internal/serialization/cbor/internal/DefiniteLengthCborWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,345:1\n1863#2,2:346\n*S KotlinDebug\n*F\n+ 1 Encoder.kt\ncom/ditto/internal/serialization/cbor/internal/DefiniteLengthCborWriter\n*L\n210#1:346,2\n*E\n"})
public final class DefiniteLengthCborWriter
extends CborWriter {
    @NotNull
    private final List<CborWriter.Data> structureStack;

    public DefiniteLengthCborWriter(@NotNull Cbor cbor, @NotNull ByteArrayOutput output) {
        Intrinsics.checkNotNullParameter((Object)cbor, (String)"cbor");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        super(cbor, output, null);
        this.structureStack = EncoderKt.access$Stack(new CborWriter.Data(output, -1));
    }

    @Override
    @NotNull
    public ByteArrayOutput getDestination$ditto_internal() {
        return EncoderKt.access$peek(this.structureStack).getBytes();
    }

    @Override
    protected void incrementChildren() {
        CborWriter.Data data = EncoderKt.access$peek(this.structureStack);
        int n = data.getElementCount();
        data.setElementCount(n + 1);
    }

    @NotNull
    public CompositeEncoder beginStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        CborWriter.Data current = new CborWriter.Data(new ByteArrayOutput(), 0);
        EncoderKt.access$push(this.structureStack, current);
        return (CompositeEncoder)this;
    }

    public void endStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        CborWriter.Data completedCurrent = EncoderKt.access$pop(this.structureStack);
        ByteArrayOutput accumulator = this.getDestination$ditto_internal();
        int numChildren = completedCurrent.getElementCount();
        if (this.getCbor().getConfiguration().getEncodeObjectTags()) {
            long[] lArray = EncodingKt.getObjectTags(descriptor);
            if (lArray != null) {
                Iterable $this$forEach$iv = (Iterable)ULongArray.box-impl((long[])lArray);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    long it = ((ULong)element$iv).unbox-impl();
                    boolean bl = false;
                    EncoderKt.encodeTag-2TYgG_w(accumulator, it);
                }
            }
        }
        if (EncodingKt.hasArrayTag(descriptor)) {
            EncoderKt.access$startArray-2TYgG_w(accumulator, ULong.constructor-impl((long)numChildren));
        } else {
            SerialKind serialKind = descriptor.getKind();
            if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE) || serialKind instanceof PolymorphicKind) {
                EncoderKt.access$startArray-2TYgG_w(accumulator, ULong.constructor-impl((long)numChildren));
            } else if (serialKind instanceof StructureKind.MAP) {
                EncoderKt.access$startMap-2TYgG_w(accumulator, ULong.constructor-impl((long)(numChildren / 2)));
            } else {
                EncoderKt.access$startMap-2TYgG_w(accumulator, ULong.constructor-impl((long)numChildren));
            }
        }
        accumulator.copyFrom(completedCurrent.getBytes());
    }
}

