/*
 * Decompiled with CFR 0.152.
 */
package com.ditto.internal.util;

import com.ditto.internal.error.InternalDittoErrorFactory;
import com.ditto.internal.error.InternalDittoErrorReason;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FileAlreadyExistsException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\r\u001a\u001c\u0010\u0002\u001a\u00060\u0001j\u0002`\u0003*\u00060\u0001j\u0002`\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u0007*\u00060\u0001j\u0002`\u0003H\u0000\u001a\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t*\u00060\u0001j\u0002`\u0003H\u0000\u001a$\u0010\n\u001a\u00020\u000b*\u00060\u0001j\u0002`\u00032\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0000\u001a$\u0010\u000f\u001a\u00020\u000b*\u00060\u0001j\u0002`\u00032\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u0010\u001a\u00020\u0005H\u0000\u001a\u001c\u0010\u0011\u001a\u00020\u000b*\u00060\u0001j\u0002`\u00032\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u0014H\u0000\u001a\u0014\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017*\u00060\u0001j\u0002`\u0003H\u0000\u001a,\u0010\u0018\u001a\u00060\u0001j\u0002`\u0003*\u00060\u0001j\u0002`\u00032\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\n\u0010\u0019\u001a\u00060\u0001j\u0002`\u0003H\u0000\u001a\u0010\u0010&\u001a\u00020'*\u00060\u0001j\u0002`\u0003H\u0000\u001a\u0010\u0010(\u001a\u00020'*\u00060\u0001j\u0002`\u0003H\u0000\u001a\u0010\u0010)\u001a\u00020'*\u00060\u0001j\u0002`\u0003H\u0000\u001a\u0010\u0010*\u001a\u00020'*\u00060\u0001j\u0002`\u0003H\u0000\u001a\u0010\u0010+\u001a\u00020'*\u00060\u0001j\u0002`\u0003H\u0000\u001a\u001e\u0010/\u001a\u00060\u0001j\u0002`\u00032\u0006\u00100\u001a\u00020\u00052\b\u00101\u001a\u0004\u0018\u00010\u0005H\u0000\"$\u0010\u001a\u001a\n\u0018\u00010\u0001j\u0004\u0018\u0001`\u0003*\u00060\u0001j\u0002`\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\"\u0019\u0010\u001d\u001a\u00020\u0005*\u00060\u0001j\u0002`\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\"\u001c\u0010 \u001a\u00020\u0005*\u00060\u0001j\u0002`\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001f\"\u001c\u0010\"\u001a\u00020#*\u00060\u0001j\u0002`\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\"\u0014\u0010,\u001a\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.*\n\u0010\u0000\"\u00020\u00012\u00020\u0001*\n\u00102\"\u00020\u00162\u00020\u0016*\n\u00103\"\u00020\u00132\u00020\u0013\u00a8\u00064"}, d2={"File", "Ljava/io/File;", "resolve", "Lcom/ditto/internal/util/File;", "relative", "", "readBytes", "", "readLines", "", "writeBytes", "", "errorFactory", "Lcom/ditto/internal/error/InternalDittoErrorFactory;", "bytes", "writeText", "text", "writeConsumingStream", "stream", "Ljava/io/InputStream;", "Lcom/ditto/internal/util/InputStream;", "inputStream", "Ljava/io/FileInputStream;", "Lcom/ditto/internal/util/FileInputStream;", "copyToWithDittoError", "dest", "parentFile", "getParentFile", "(Ljava/io/File;)Ljava/io/File;", "path", "getPath", "(Ljava/io/File;)Ljava/lang/String;", "absolutePath", "getAbsolutePath", "length", "", "getLength", "(Ljava/io/File;)J", "exists", "", "mkdirs", "delete", "deleteRecursively", "createNewFile", "fileSeparator", "getFileSeparator", "()Ljava/lang/String;", "createTemporaryFile", "prefix", "suffix", "FileInputStream", "InputStream", "ditto-internal"})
public final class File_commonJvmKt {
    @NotNull
    public static final File resolve(@NotNull File $this$resolve, @NotNull String relative) {
        Intrinsics.checkNotNullParameter((Object)$this$resolve, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relative, (String)"relative");
        return FilesKt.resolve((File)$this$resolve, (String)relative);
    }

    @NotNull
    public static final byte[] readBytes(@NotNull File $this$readBytes) {
        Intrinsics.checkNotNullParameter((Object)$this$readBytes, (String)"<this>");
        return FilesKt.readBytes((File)$this$readBytes);
    }

    @NotNull
    public static final List<String> readLines(@NotNull File $this$readLines) {
        Intrinsics.checkNotNullParameter((Object)$this$readLines, (String)"<this>");
        return FilesKt.readLines$default((File)$this$readLines, null, (int)1, null);
    }

    public static final void writeBytes(@NotNull File $this$writeBytes, @NotNull InternalDittoErrorFactory<?> errorFactory, @NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)$this$writeBytes, (String)"<this>");
        Intrinsics.checkNotNullParameter(errorFactory, (String)"errorFactory");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        try {
            FilesKt.writeBytes((File)$this$writeBytes, (byte[])bytes);
        }
        catch (Throwable e) {
            throw errorFactory.createError(new InternalDittoErrorReason.IoErrorReason.IoOperationFailed("Failed to write bytes to file " + $this$writeBytes.getPath(), e));
        }
    }

    public static final void writeText(@NotNull File $this$writeText, @NotNull InternalDittoErrorFactory<?> errorFactory, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)$this$writeText, (String)"<this>");
        Intrinsics.checkNotNullParameter(errorFactory, (String)"errorFactory");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        try {
            FilesKt.writeText$default((File)$this$writeText, (String)text, null, (int)2, null);
        }
        catch (Throwable e) {
            throw errorFactory.createError(new InternalDittoErrorReason.IoErrorReason.IoOperationFailed("Failed to write text to file " + $this$writeText.getPath(), e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeConsumingStream(@NotNull File $this$writeConsumingStream, @NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)$this$writeConsumingStream, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Closeable closeable = stream;
        Throwable throwable = null;
        try {
            InputStream stream2 = (InputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new FileOutputStream($this$writeConsumingStream);
            Throwable throwable2 = null;
            try {
                FileOutputStream outputStream = (FileOutputStream)closeable2;
                boolean bl2 = false;
                ByteStreamsKt.copyTo$default((InputStream)stream2, (OutputStream)outputStream, (int)0, (int)2, null);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public static final FileInputStream inputStream(@NotNull File $this$inputStream) {
        Intrinsics.checkNotNullParameter((Object)$this$inputStream, (String)"<this>");
        return new FileInputStream($this$inputStream);
    }

    @NotNull
    public static final File copyToWithDittoError(@NotNull File $this$copyToWithDittoError, @NotNull InternalDittoErrorFactory<?> errorFactory, @NotNull File dest) {
        File file;
        Intrinsics.checkNotNullParameter((Object)$this$copyToWithDittoError, (String)"<this>");
        Intrinsics.checkNotNullParameter(errorFactory, (String)"errorFactory");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        try {
            file = FilesKt.copyTo$default((File)$this$copyToWithDittoError, (File)dest, (boolean)false, (int)0, (int)6, null);
        }
        catch (IOException e) {
            throw errorFactory.createError(new InternalDittoErrorReason.StoreErrorReason.FailedToCopyAttachment(e));
        }
        catch (FileAlreadyExistsException e) {
            throw errorFactory.createError(new InternalDittoErrorReason.StoreErrorReason.AttachmentCopyTargetAlreadyExists(e));
        }
        return file;
    }

    @Nullable
    public static final File getParentFile(@NotNull File $this$parentFile) {
        Intrinsics.checkNotNullParameter((Object)$this$parentFile, (String)"<this>");
        return $this$parentFile.getParentFile();
    }

    @NotNull
    public static final String getPath(@NotNull File $this$path) {
        Intrinsics.checkNotNullParameter((Object)$this$path, (String)"<this>");
        String string = $this$path.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }

    @NotNull
    public static final String getAbsolutePath(@NotNull File $this$absolutePath) {
        Intrinsics.checkNotNullParameter((Object)$this$absolutePath, (String)"<this>");
        String string = $this$absolutePath.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        return string;
    }

    public static final long getLength(@NotNull File $this$length) {
        Intrinsics.checkNotNullParameter((Object)$this$length, (String)"<this>");
        return $this$length.length();
    }

    public static final boolean exists(@NotNull File $this$exists) {
        Intrinsics.checkNotNullParameter((Object)$this$exists, (String)"<this>");
        return $this$exists.exists();
    }

    public static final boolean mkdirs(@NotNull File $this$mkdirs) {
        Intrinsics.checkNotNullParameter((Object)$this$mkdirs, (String)"<this>");
        return $this$mkdirs.mkdirs();
    }

    public static final boolean delete(@NotNull File $this$delete) {
        Intrinsics.checkNotNullParameter((Object)$this$delete, (String)"<this>");
        return $this$delete.delete();
    }

    public static final boolean deleteRecursively(@NotNull File $this$deleteRecursively) {
        Intrinsics.checkNotNullParameter((Object)$this$deleteRecursively, (String)"<this>");
        return FilesKt.deleteRecursively((File)$this$deleteRecursively);
    }

    public static final boolean createNewFile(@NotNull File $this$createNewFile) {
        Intrinsics.checkNotNullParameter((Object)$this$createNewFile, (String)"<this>");
        return $this$createNewFile.createNewFile();
    }

    @NotNull
    public static final String getFileSeparator() {
        String string = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
        return string;
    }

    @NotNull
    public static final File createTemporaryFile(@NotNull String prefix, @Nullable String suffix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        File file = File.createTempFile(prefix, suffix);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(...)");
        return file;
    }
}

