/*
 * Decompiled with CFR 0.152.
 */
package com.ditto.internal.util;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Properties;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u001b\u001a\u0004\u0018\u00010\u0017J\u0006\u0010\u001c\u001a\u00020\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\n\"\u0004\b\u000b\u0010\fR\u001b\u0010\u000f\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000f\u0010\nR\u001b\u0010\u0012\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0011\u001a\u0004\b\u0012\u0010\nR\u001b\u0010\u0014\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0011\u001a\u0004\b\u0014\u0010\nR\u0011\u0010\u0018\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001e"}, d2={"Lcom/ditto/internal/util/HostSystem;", "", "properties", "Ljava/util/Properties;", "<init>", "(Ljava/util/Properties;)V", "getProperties", "()Ljava/util/Properties;", "isTesting", "", "()Z", "setTesting", "(Z)V", "printProperties", "", "isMacOS", "isMacOS$delegate", "Lkotlin/Lazy;", "isLinux", "isLinux$delegate", "isAndroid", "isAndroid$delegate", "arch", "", "hostName", "getHostName", "()Ljava/lang/String;", "systemArchitectureTriple", "tempDirectory", "Ljava/io/File;", "ditto-internal"})
@SourceDebugExtension(value={"SMAP\nHostSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HostSystem.kt\ncom/ditto/internal/util/HostSystem\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,83:1\n1#2:84\n*E\n"})
public final class HostSystem {
    @NotNull
    private final Properties properties;
    private boolean isTesting;
    @NotNull
    private final Lazy isMacOS$delegate;
    @NotNull
    private final Lazy isLinux$delegate;
    @NotNull
    private final Lazy isAndroid$delegate;

    @JvmOverloads
    public HostSystem(@NotNull Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        this.properties = properties;
        Iterator iterator = ArrayIteratorKt.iterator((Object[])Thread.currentThread().getStackTrace());
        while (iterator.hasNext()) {
            StackTraceElement element = (StackTraceElement)iterator.next();
            String string = element.getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClassName(...)");
            if (!StringsKt.startsWith$default((String)string, (String)"org.junit.", (boolean)false, (int)2, null)) continue;
            this.isTesting = true;
            break;
        }
        this.isMacOS$delegate = LazyKt.lazy(() -> HostSystem.isMacOS_delegate$lambda$0(this));
        this.isLinux$delegate = LazyKt.lazy(() -> HostSystem.isLinux_delegate$lambda$1(this));
        this.isAndroid$delegate = LazyKt.lazy(() -> HostSystem.isAndroid_delegate$lambda$2(this));
    }

    public /* synthetic */ HostSystem(Properties properties, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            properties = System.getProperties();
        }
        this(properties);
    }

    @NotNull
    public final Properties getProperties() {
        return this.properties;
    }

    public final boolean isTesting() {
        return this.isTesting;
    }

    public final void setTesting(boolean bl) {
        this.isTesting = bl;
    }

    public final void printProperties() {
        this.properties.list(System.out);
    }

    public final boolean isMacOS() {
        Lazy lazy = this.isMacOS$delegate;
        return (Boolean)lazy.getValue();
    }

    public final boolean isLinux() {
        Lazy lazy = this.isLinux$delegate;
        return (Boolean)lazy.getValue();
    }

    public final boolean isAndroid() {
        Lazy lazy = this.isAndroid$delegate;
        return (Boolean)lazy.getValue();
    }

    @NotNull
    public final String arch() {
        String string = this.properties.getProperty("os.arch");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        return string;
    }

    @NotNull
    public final String getHostName() {
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            String string = localhost.getHostName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHostName(...)");
            return string;
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return "Unknown";
        }
    }

    @Nullable
    public final String systemArchitectureTriple() {
        if (this.isMacOS()) {
            return this.arch() + "-apple-darwin";
        }
        if (this.isLinux()) {
            return this.arch() + "-unknown-linux-gnu";
        }
        return null;
    }

    @NotNull
    public final File tempDirectory() {
        File file;
        String string = System.getProperty("java.io.tmpdir");
        if (string != null) {
            String it = string;
            boolean bl = false;
            file = new File(it);
        } else {
            file = null;
        }
        File tmpDir = file;
        tmpDir = new File(tmpDir, "dittoffiJNI");
        if (!tmpDir.exists()) {
            tmpDir.mkdirs();
        }
        return tmpDir;
    }

    @JvmOverloads
    public HostSystem() {
        this(null, 1, null);
    }

    private static final boolean isMacOS_delegate$lambda$0(HostSystem this$0) {
        String osName = this$0.properties.getProperty("os.name");
        Intrinsics.checkNotNull((Object)osName);
        return StringsKt.contains((CharSequence)osName, (CharSequence)"mac", (boolean)true);
    }

    private static final boolean isLinux_delegate$lambda$1(HostSystem this$0) {
        String osName = this$0.properties.getProperty("os.name");
        Intrinsics.checkNotNull((Object)osName);
        return StringsKt.contains((CharSequence)osName, (CharSequence)"linux", (boolean)true);
    }

    private static final boolean isAndroid_delegate$lambda$2(HostSystem this$0) {
        String javaVendor = this$0.properties.getProperty("java.vendor");
        Intrinsics.checkNotNull((Object)javaVendor);
        return StringsKt.contains((CharSequence)javaVendor, (CharSequence)"android", (boolean)true);
    }
}

