/*
 * Decompiled with CFR 0.152.
 */
package com.ditto.internal.util;

import com.ditto.internal.InternalDitto;
import com.ditto.internal.InternalDittoConfig;
import com.ditto.internal.error.InternalDittoErrorReason;
import com.ditto.internal.util.InternalDittoResource;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B)\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0010J\u0012\u0010\u0012\u001a\u00020\u00102\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lcom/ditto/internal/util/PlatformDependentDittoImplementation;", "BaseError", "", "Lcom/ditto/internal/util/InternalDittoResource$Node;", "initializer", "Lcom/ditto/internal/util/InternalDittoResource$Initializer;", "Lcom/ditto/internal/InternalDitto;", "config", "Lcom/ditto/internal/InternalDittoConfig;", "<init>", "(Lcom/ditto/internal/util/InternalDittoResource$Initializer;Lcom/ditto/internal/InternalDittoConfig;)V", "deviceName", "", "getDeviceName", "()Ljava/lang/String;", "beforeInit", "", "init", "ensureDirectoryExists", "dir", "Ljava/io/File;", "Lcom/ditto/internal/util/File;", "ditto-internal"})
public final class PlatformDependentDittoImplementation<BaseError extends Throwable>
extends InternalDittoResource.Node<BaseError> {
    @NotNull
    private final InternalDittoConfig<BaseError> config;

    public PlatformDependentDittoImplementation(@NotNull InternalDittoResource.Initializer<InternalDitto<BaseError>> initializer, @NotNull InternalDittoConfig<BaseError> config) {
        Intrinsics.checkNotNullParameter(initializer, (String)"initializer");
        Intrinsics.checkNotNullParameter(config, (String)"config");
        super(initializer);
        this.config = config;
    }

    @NotNull
    public final String getDeviceName() {
        String string;
        try {
            string = InetAddress.getLocalHost().getHostName();
            Intrinsics.checkNotNull((Object)string);
        }
        catch (UnknownHostException e) {
            string = "n/a";
        }
        return string;
    }

    public final void beforeInit() {
    }

    public final void init() {
    }

    public final void ensureDirectoryExists(@NotNull File dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        if (!dir.exists()) {
            try {
                dir.mkdirs();
            }
            catch (SecurityException e) {
                throw this.getErrorFactory().createError(new InternalDittoErrorReason.StoreErrorReason.FailedToInitializeDittoDirectory(e));
            }
        }
    }
}

