/*
 * Decompiled with CFR 0.152.
 */
package com.djdch.log4j;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.util.Cancellable;
import org.apache.logging.log4j.core.util.ShutdownCallbackRegistry;
import org.apache.logging.log4j.status.StatusLogger;

public class StaticShutdownCallbackRegistry
implements ShutdownCallbackRegistry,
LifeCycle,
Runnable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Logger LOGGER = StatusLogger.getLogger();
    private final AtomicReference<LifeCycle.State> state = new AtomicReference<LifeCycle.State>(LifeCycle.State.INITIALIZED);
    private final Collection<Cancellable> hooks = new CopyOnWriteArrayList<Cancellable>();
    private static final Collection<StaticShutdownCallbackRegistry> instances = new CopyOnWriteArrayList<StaticShutdownCallbackRegistry>();

    public StaticShutdownCallbackRegistry() {
        instances.add(this);
    }

    public static void invoke() {
        for (Runnable runnable : instances) {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                LOGGER.error(SHUTDOWN_HOOK_MARKER, "Caught exception executing shutdown hook {}", new Object[]{runnable, t});
            }
        }
    }

    @Override
    public void run() {
        if (this.state.compareAndSet(LifeCycle.State.STARTED, LifeCycle.State.STOPPING)) {
            for (Runnable runnable : this.hooks) {
                try {
                    runnable.run();
                }
                catch (Throwable t) {
                    LOGGER.error(SHUTDOWN_HOOK_MARKER, "Caught exception executing shutdown hook {}", new Object[]{runnable, t});
                }
            }
            this.state.set(LifeCycle.State.STOPPED);
        }
    }

    public Cancellable addShutdownCallback(final Runnable callback) {
        if (this.isStarted()) {
            Cancellable receipt = new Cancellable(){
                private final Reference<Runnable> hook;
                {
                    this.hook = new SoftReference<Runnable>(callback);
                }

                public void cancel() {
                    this.hook.clear();
                    StaticShutdownCallbackRegistry.this.hooks.remove(this);
                }

                public void run() {
                    Runnable hook = this.hook.get();
                    if (hook != null) {
                        hook.run();
                        this.hook.clear();
                    }
                }

                public String toString() {
                    return String.valueOf(this.hook.get());
                }
            };
            this.hooks.add(receipt);
            return receipt;
        }
        throw new IllegalStateException("Cannot add new shutdown hook as this is not started. Current state: " + this.state.get().name());
    }

    public void start() {
        this.state.set(LifeCycle.State.STARTED);
    }

    public void stop() {
        this.state.set(LifeCycle.State.STOPPED);
    }

    public LifeCycle.State getState() {
        return this.state.get();
    }

    public boolean isStarted() {
        return this.state.get() == LifeCycle.State.STARTED;
    }

    public boolean isStopped() {
        return this.state.get() == LifeCycle.State.STOPPED;
    }
}

