/*
 * Decompiled with CFR 0.152.
 */
package com.dji.mapkit.core.maps;

import android.view.View;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.dji.mapkit.core.callback.MapScreenShotListener;
import com.dji.mapkit.core.callback.OnCameraChangeListener;
import com.dji.mapkit.core.callback.OnMapTypeLoadedListener;
import com.dji.mapkit.core.camera.DJICameraUpdate;
import com.dji.mapkit.core.maps.DJIUiSettings;
import com.dji.mapkit.core.maps.koy;
import com.dji.mapkit.core.models.DJICameraPosition;
import com.dji.mapkit.core.models.DJILatLng;
import com.dji.mapkit.core.models.annotations.DJICircle;
import com.dji.mapkit.core.models.annotations.DJICircleOptions;
import com.dji.mapkit.core.models.annotations.DJIGroupCircle;
import com.dji.mapkit.core.models.annotations.DJIGroupCircleOptions;
import com.dji.mapkit.core.models.annotations.DJIMarker;
import com.dji.mapkit.core.models.annotations.DJIMarkerOptions;
import com.dji.mapkit.core.models.annotations.DJIPolygon;
import com.dji.mapkit.core.models.annotations.DJIPolygonOptions;
import com.dji.mapkit.core.models.annotations.DJIPolyline;
import com.dji.mapkit.core.models.annotations.DJIPolylineOptions;

public interface DJIMap {
    public static final int MAP_TYPE_NONE = 0;
    public static final int MAP_TYPE_NORMAL = 1;
    public static final int MAP_TYPE_SATELLITE = 2;
    public static final int MAP_TYPE_NIGHT = 3;
    public static final int MAP_TYPE_HYBRID = 4;

    @NonNull
    public DJIMarker addMarker(DJIMarkerOptions var1);

    public Object getMap();

    public void animateCamera(DJICameraUpdate var1);

    public void setOnCameraChangeListener(OnCameraChangeListener var1);

    public void removeAllOnCameraChangeListeners();

    public DJICameraPosition getCameraPosition();

    public void moveCamera(DJICameraUpdate var1);

    public void setInfoWindowAdapter(InfoWindowAdapter var1);

    public void setMapType(MapType var1);

    public void setMapType(MapType var1, OnMapTypeLoadedListener var2);

    public void setMapType(int var1);

    @NonNull
    public DJIPolyline addPolyline(DJIPolylineOptions var1);

    @Nullable
    public DJIPolygon addPolygon(DJIPolygonOptions var1);

    @Nullable
    public DJICircle addSingleCircle(DJICircleOptions var1);

    @Nullable
    public DJICircle addMarkerCircle(DJICircleOptions var1);

    @Nullable
    public DJIGroupCircle addGroupCircle(DJIGroupCircleOptions var1);

    public DJIUiSettings getUiSettings();

    public void removeOnCameraChangeListener(OnCameraChangeListener var1);

    public void removeOnMarkerClickListener(OnMarkerClickListener var1);

    public void removeAllOnMarkerClickListener();

    public void setOnInfoWindowClickListener(OnInfoWindowClickListener var1);

    public void setOnMarkerClickListener(OnMarkerClickListener var1);

    public void setOnMapClickListener(OnMapClickListener var1);

    public void removeOnMapClickListener(OnMapClickListener var1);

    public void setOnMapLongClickListener(OnMapLongClickListener var1);

    public void removeAllOnMapClickListener();

    public void removeOnMapLongClickListener(OnMapLongClickListener var1);

    public void removeAllOnMapLongClickListener();

    public void setOnMarkerDragListener(OnMarkerDragListener var1);

    public void removeOnMarkerDragListener(OnMarkerDragListener var1);

    public void removeAllOnMarkerDragListener();

    public void snapshot(MapScreenShotListener var1);

    public koy getProjection();

    public void clear();

    public static interface OnMarkerDragListener {
        public void onMarkerDragStart(DJIMarker var1);

        public void onMarkerDrag(DJIMarker var1);

        public void onMarkerDragEnd(DJIMarker var1);
    }

    public static interface OnMapLongClickListener {
        public void onMapLongClick(DJILatLng var1);
    }

    public static interface OnInfoWindowClickListener {
        public void onInfoWindowClick(DJIMarker var1);
    }

    public static interface OnMapClickListener {
        public void onMapClick(DJILatLng var1);
    }

    public static interface OnMarkerClickListener {
        public boolean onMarkerClick(DJIMarker var1);
    }

    public static interface InfoWindowAdapter {
        public View getInfoWindow(DJIMarker var1);

        public View getInfoContents(DJIMarker var1);
    }

    public static final class MapType
    extends Enum<MapType> {
        public static final /* enum */ MapType NORMAL;
        public static final /* enum */ MapType SATELLITE;
        public static final /* enum */ MapType HYBRID;
        private static MapType[] mValues;
        private static final /* synthetic */ MapType[] $VALUES;
        int value;

        public static MapType[] values() {
            return null;
        }

        public static MapType valueOf(String string2) {
            return null;
        }

        private MapType(int n4) {
        }

        public static MapType[] getValues() {
            return null;
        }

        @NonNull
        public static MapType find(@IntRange(from=1L, to=4L) int n3) {
            return null;
        }

        static {
            MapType mapType;
            MapType mapType2;
            MapType mapType3;
            MapType mapType4 = mapType3;
            NORMAL = new MapType(1);
            MapType mapType5 = mapType2;
            SATELLITE = new MapType(2);
            MapType mapType6 = mapType;
            HYBRID = new MapType(4);
            $VALUES = new MapType[]{mapType4, mapType5, mapType6};
        }

        public int getValue() {
            return 0;
        }
    }
}

