/*
 * Decompiled with CFR 0.152.
 */
package dji.common.error;

import com.dji.megatronking.stringfog.lib.gfd;
import dji.common.error.DJIError;
import dji.fieldAnnotation.fdd;
import dji.midware.data.config.P3.Ccode;

@fdd
public class DJIMissionError
extends DJIError {
    public static final DJIMissionError MAX_FLIGHT_SPEED_NOT_VALID = new DJIMissionError(gfd.fdd("FEsxYiEyMAMxXmkxFzs8AHlcKC4SO3kUK0U/KwM7PUQwWWkrCSg4CDBO"));
    public static final DJIMissionError AUTO_FLIGHT_SPEED_NOT_VALID = new DJIMissionError(gfd.fdd("GF89LUc4NQ0+Qj1iFC48AT0KPyMLKzxEKVgmNA46PAB5QzpiDjAvBTVDLQ=="));
    public static final DJIMissionError REPEAT_TIME_NOT_VALID = new DJIMissionError(gfd.fdd("C085JwYqeRAwRyxiET81ETwKOTAIKDAAPE5pKxR+MAovSyUrAw=="));
    public static final DJIMissionError WAYPOINT_COUNT_NOT_VALID = new DJIMissionError(gfd.fdd("DkswMgg3NxB5SSY3CSp5DSoKICwRPzUNPQ=="));
    public static final DJIMissionError WAYPOINT_LIST_SIZE_NOT_VALID = new DJIMissionError(gfd.fdd("DkswMgg3NxB5RiAxE34qDSNPaSsUfjAKL0slKwM="));
    public static final DJIMissionError WAYPOINT_COORDINATE_NOT_VALID = new DJIMissionError(gfd.fdd("DkswMgg3NxB5SSYtFTowCjheLGIXLDYSME4sJkc3KkQwRD8jCzc9"));
    public static final DJIMissionError ALTITUDE_NOT_VALID = new DJIMissionError(gfd.fdd("DkswMgg3NxB5SyU2DiosADwKOTAIKDAAPE5pKxR+MAovSyUrAw=="));
    public static final DJIMissionError HEADING_NOT_VALID = new DJIMissionError(gfd.fdd("DkswMgg3NxB5QiwjAzc3A3laOy0RNz0BPQogMUc3NxI4RiAm"));
    public static final DJIMissionError ACTION_REPEAT_TIME_NOT_VALID = new DJIMissionError(gfd.fdd("DkswMgg3NxB5WCwyAj8tRC1DJCdHLisLL0MtJwN+MBd5Qyc0BjIwAA=="));
    public static final DJIMissionError ACTION_TIMEOUT_NOT_VALID = new DJIMissionError(gfd.fdd("DkswMgg3NxB5Syo2DjE3RC1DJCcIKy1EKVgmNA46PAB5QzpiDjAvBTVDLQ=="));
    public static final DJIMissionError CORNER_RADIUS_NOT_VALID = new DJIMissionError(gfd.fdd("DkswMgg3NxB5SSYwCTsrRCtLLSsSLXkUK0U/KwM7PUQwWWkrCSg4CDBO"));
    public static final DJIMissionError GIMBAL_PITCH_NOT_VALID = new DJIMissionError(gfd.fdd("DkswMgg3NxB5TSAvBT81RClDPSEPfikWNlwgJgI6eQ0qCiAsET81DT0="));
    public static final DJIMissionError WAYPOINT_SPEED_NOT_VALID = new DJIMissionError(gfd.fdd("DkswMgg3NxB5WTknAjp5FCtFPysDOz1EMFlpKwkoOAgwTg=="));
    public static final DJIMissionError SHOOT_PHOTO_NOT_VALID = new DJIMissionError(gfd.fdd("DkswMgg3NxB5WSEtCCp5FDFFPS1HOjAXLUsnIQJ+KRY2XCAmAjp5DSoKICwRPzUNPQ=="));
    public static final DJIMissionError STAY_ACTION_NOT_VALID = new DJIMissionError(gfd.fdd("DkswMgg3NxB5WT0jHn44By1DJixHLjgWOEdpMhUxLw09Ty1iDi15DTdcKC4OOg=="));
    public static final DJIMissionError ROTATE_GIMBAL_ACTION_NOT_VALID = new DJIMissionError(gfd.fdd("DkswMgg3NxB5WCY2Bio8RD5DJCAGMnkFOl4gLQl+KQUrSyRiFyw2EjBOLCZHNypEMEQ/Iws3PQ=="));
    public static final DJIMissionError ROTATE_AIRCRAFT_ACTION_NOT_VALID = new DJIMissionError(gfd.fdd("DkswMgg3NxB5WCY2Bio8RDhDOyEVPz8QeUsqNg4xN0QpSzsjCn4pFjZcICYCOnkNKgogLBE/NQ09"));
    public static final DJIMissionError INDICES_ARE_DISCONTINUOUS = new DJIMissionError(gfd.fdd("DkswMgg3NxB5QycmDj08F3lLOydHOjAXOkUnNg4wLAssWQ=="), 172);
    public static final DJIMissionError INDEX_OUT_OF_RANGE = new DJIMissionError(gfd.fdd("DkswMgg3NxB5QycmAiZ5CyxeaS0BfisFN00sbA=="), 173);
    public static final DJIMissionError INVALID_DATA_SIZE = new DJIMissionError(gfd.fdd("DkswMgg3NxB5Tig2Bn4qDSNPaSsUfjAKL0slKwNweS0tCiAxRzg2FnlDJzYCLDcFNQo8MQY5PEo="), 175);
    public static final DJIMissionError TAKE_OFF_FAILURE_CAUSED_BY_ATTITUDE = new DJIMissionError(gfd.fdd("DUIsYgY3KwcrSy82Rz04CjdFPWITPzIBeUUvJEc8PAc4XzonRzE/RDBHOTAILjwWeUsgMAQsOAItDTpiBiotDS1fLSdJ"), 179);
    public static final DJIMissionError INVALID_INTERVAL_SHOOT_PARAM = new DJIMissionError(gfd.fdd("DUIsYhM3NAF5Qyc2AiwvBTUKJjBHKjEBeU4gMRM/Nwc8CiAsEzsrEjhGaSsUfjAKL0slKwNw"), 180);
    public static final DJIMissionError MULTI_MODE_DISABLED = new DJIMissionError(gfd.fdd("DUIsYgo3KhcwRSdiBD83CjZeaTETPysQeV0hJwl+NBE1XiBvCjE9AXlDOmIDNyoFO0YsJkk="), 203);
    public static final DJIMissionError NULL_MISSION = new DJIMissionError(gfd.fdd("F18lLkcTMBcqQyYs"));
    public static final DJIMissionError INCOMPLETE_MISSION = new DJIMissionError(gfd.fdd("EEQqLQouNQEtT2kPDi0qDTZE"));
    public static final DJIMissionError COMMON_UNSUPPORTED = new DJIMissionError(gfd.fdd("F0U9YhQrKRQ2WD0nAw=="));
    public static final DJIMissionError COMMON_DISCONNECTED = new DJIMissionError(gfd.fdd("HUM6IQgwNwE6Xiwm"));
    public static final DJIMissionError BEGAN = new DJIMissionError(gfd.fdd("O08uIwk="), 1);
    public static final DJIMissionError CANCELED = new DJIMissionError(gfd.fdd("OksnIQIyPAA="), 2);
    public static final DJIMissionError FAILED = new DJIMissionError(gfd.fdd("P0sgLgI6"), 3);
    public static final DJIMissionError NO_MISSION_RUNNING = new DJIMissionError(gfd.fdd("FEM6MQ4xN0Q3RT1iAiYwFy1PLQ=="));
    public static final DJIMissionError TIMEOUT = new DJIMissionError(gfd.fdd("HFIsIRIqMAs3CiYkRyoxDSoKOTAIPTwXKgohIxR+LQ00Ty1iCCst"), 4);
    public static final DJIMissionError MODE_ERROR = new DJIMissionError(gfd.fdd("DUIsYgQxNxArRSViCjE9AXlFL2ITNjxEOEM7IRU/PxB5QzpiCTEtRDBEaTYPO3kHNlg7JwQqeRctSz0n"), 5);
    public static final DJIMissionError GPS_NOT_READY = new DJIMissionError(gfd.fdd("HnoaYgg4eQUwWCowBjgtRDBZaSwIKnkWPEstOw=="), 6);
    public static final DJIMissionError MOTORS_DID_NOT_START = new DJIMissionError(gfd.fdd("DUIsYgY3KwcrSy82QC15CTZeJjBHNjgXeUQmNkctLQUrXiwm"), 7);
    public static final DJIMissionError TAKE_OFF = new DJIMissionError(gfd.fdd("GEM7IRU/PxB5QzpiEz8yDTdNaS0BOA=="), 8);
    public static final DJIMissionError IS_FLYING = new DJIMissionError(gfd.fdd("GEM7IRU/PxB5QzpiATIgDTdN"), 9);
    public static final DJIMissionError NOT_AUTO_MODE = new DJIMissionError(gfd.fdd("GEM7IRU/PxB5QzpiCTEtRDBEaSMSKjZENEUtJw=="), 10);
    public static final DJIMissionError MAX_NUMBER_OF_WAYPOINTS_UPLOAD_LIMIT_REACHED = new DJIMissionError(gfd.fdd("DkswMgg3NxB5RyAxFDc2CnlCKDFHLDwFOkIsJkcqMQF5Ryg6DjMsCXlaJisJKipENUMkKxM="), 11);
    public static final DJIMissionError UPLOADING_WAYPOINT = new DJIMissionError(gfd.fdd("DkswMgg3NxB5RyAxFDc2CnlDOmISLjULOE4gLAA="), 233);
    public static final DJIMissionError KEY_LEVEL_LOW = new DJIMissionError(gfd.fdd("DUIsYiYOEEQyTzBiFyw2EjBOLCZHKjZEIEU8Yg4teQo2XmkjE34tDDwKKi0VLDwHLQo5JxUzMBcqQyYsRzI8EjxG"), 13);
    public static final DJIMissionError NAVIGATION_MODE_DISABLED = new DJIMissionError(gfd.fdd("F0s/KwA/LQ02RGkrFH43Cy0KJjICMA=="), 209);
    public static final DJIMissionError TOO_CLOSE_TO_HOME_POINT = new DJIMissionError(gfd.fdd("GEM7IRU/PxB5QzpiEzE2RDpGJjECfi0LeUImLwJ+KQswRD0="), 160);
    public static final DJIMissionError IOC_TYPE_UNKNOWN = new DJIMissionError(gfd.fdd("DUIsYhMnKQF5RS9iLhEaRDBZaTcJNTcLLkQ="), 161);
    public static final DJIMissionError HOME_POINT_VALUE_INVALID = new DJIMissionError(gfd.fdd("DUIsYg8xNAF5WiYrCSp5DSoKJy0TfjhEL0slKwN+Pwg2Sz1iET81ETw="), 162);
    public static final DJIMissionError HOME_POINT_LOCATION_INVALID = new DJIMissionError(gfd.fdd("DUIsYgs/LQ0tXy0nRz83AHlGJiwANy0RPU9pLQF+MQs0TzktDjAtRDhYLGIOMC8FNUMt"), 163);
    public static final DJIMissionError HOME_POINT_DIRECTION_UNKNOWN = new DJIMissionError(gfd.fdd("DUIsYgM3KwE6XiAtCX42AnlCJi8CLjYNN15pKxR+LAoyRCY1CQ=="), 166);
    public static final DJIMissionError HOME_POINT_MISSION_PAUSED = new DJIMissionError(gfd.fdd("DUIsYg8xNAF0WiYrCSp5CTBZOisIMHkNKgo5IxItPAA="), 169);
    public static final DJIMissionError HOME_POINT_MISSION_NOT_PAUSED = new DJIMissionError(gfd.fdd("DUIsYg8xNAF0WiYrCSp5RDRDOjEOMTdEMFlpLAgqeRQ4XzonAw=="), 170);
    public static final DJIMissionError FOLLOW_ME_DISTANCE_TOO_LARGE = new DJIMissionError(gfd.fdd("HUM6NgYwOgF5SCw2EDs8CnleISdHPzAWOlgoJBN+OAo9CiQtBTc1AXlaIS0JO3kNKgorJx4xNwB5SyohAi4tBTtGLGILNzQNLQIkNxQqeQY8CiUtEDsrRC1CKCxHbGlUaRokaw=="), 176);
    public static final DJIMissionError FOLLOW_ME_DISCONNECT_TIME_TOO_LONG = new DJIMissionError(gfd.fdd("DUIsYgM3Kgc2RCcnBCp5EDBHLGIIOHkCNkYlLRB+NAF5RyAxFDc2CnlDOmITMTZENUUnJQ=="), 177);
    public static final DJIMissionError FOLLOW_ME_GIMBAL_PITCH_ERROR = new DJIMissionError(gfd.fdd("DUIsYg4wMBAwSyViFzctBzEKKCwAMjxENkxpJQ4zOwU1CiAxRyo2C3lGKDAAOw=="), 178);
    public static final DJIMissionError ALTITUDE_TOO_HIGH = new DJIMissionError(gfd.fdd("DUIsYgYyLQ0tXy0nRzcqRC1FJmIPNz4M"), 192);
    public static final DJIMissionError ALTITUDE_TOO_LOW = new DJIMissionError(gfd.fdd("DUIsYgYyLQ0tXy0nRzcqRC1FJmILMS4="), 193);
    public static final DJIMissionError MISSION_RADIUS_INVALID = new DJIMissionError(gfd.fdd("DUIsYhU/PQ0sWWktAX40DSpZIC0JfjAXeUMnNAYyMAA="), 194);
    public static final DJIMissionError MISSION_SPEED_TOO_HIGH = new DJIMissionError(gfd.fdd("DUIsYhQuPAE9CiYkRzMwFypDJixHNypELUUmYgs/KwM8"), 195);
    public static final DJIMissionError MISSION_ENTRY_POINT_INVALID = new DJIMissionError(gfd.fdd("DUIsYgIwLRYgCjktDjAtRDZMaS8OLSoNNkRpKxR+MAovSyUrAw=="), 196);
    public static final DJIMissionError MISSION_HEADING_MODE_INVALID = new DJIMissionError(gfd.fdd("DUIsYg87OAAwRC5iCjE9AXlFL2IKNyoXMEUnYg4teQ03XCguDjo="), 197);
    public static final DJIMissionError MISSION_RESUME_FAILED = new DJIMissionError(gfd.fdd("H0sgLgI6eRA2CjsnFCs0AXleISdHMzAXKkMmLA=="), 198);
    public static final DJIMissionError MISSION_RADIUS_OVER_LIMIT = new DJIMissionError(gfd.fdd("DUIsYhU/PQ0sWWktAX40DSpZIC0JfjAXeUU/JxV+LQw8CighBDspEDhIJSdHMjAJMF5lYhcyKkQtWDBiEzF5CDZNICxHPzcAeUkhJwQ1eRY4TiA3FH42AnldKDsXMTAKLQ=="), 199);
    public static final DJIMissionError NAVIGATION_MODE_NOT_SUPPORTED = new DJIMissionError(gfd.fdd("F0s/KwA/LQ02RGkvCDo8RDBZaSwIKnkXLFo5LRUqPAA="), 200);
    public static final DJIMissionError DISTANCE_FROM_MISSION_TARGET_TOO_LONG = new DJIMissionError(gfd.fdd("DUIsYgM3KhA4RConRzgrCzQKJCsULTALNwo9IxU5PBB5WiYxDiowCzcKIDFHKjYLeUYmLAA="), 201);
    public static final DJIMissionError RC_MODE_ERROR = new DJIMissionError(gfd.fdd("FEUtJ0c7KxY2WGViFzI8BSpPaS8GNTxEKl87J0cqMQF5WCwvCCo8RDpFJzYVMTUIPFhuMUczNgA8Cjo1Dio6DHlDOmIOMHlDHw1pLwg6PEo="), 208);
    public static final DJIMissionError IOC_WORKING = new DJIMissionError(gfd.fdd("DUIsYi4RGkQ0RS0nRzcqRC5FOykOMD4="), 210);
    public static final DJIMissionError MISSION_NOT_INITIALIZED = new DJIMissionError(gfd.fdd("DUIsYgo3KhcwRSdiDi15CjZeaSsJNy0NOEYgOAI6"), 211);
    public static final DJIMissionError MISSION_NOT_EXIST = new DJIMissionError(gfd.fdd("DUIsYgo3KhcwRSdiAzE8F3lEJjZHOyENKl4="), 212);
    public static final DJIMissionError MISSION_CONFLICT = new DJIMissionError(gfd.fdd("DUIsMAJ+MBd5S2khCDA/CDBJPSsJOXkXPF49Kwk5eQ03Cj0qAn40DSpZIC0J"), 213);
    public static final DJIMissionError MISSION_ESTIMATE_TIME_TOO_LONG = new DJIMissionError(gfd.fdd("DUIsYgItLQ00Sz0nA34tDTRPaSQILHkQMU9pLw4tKg02RGkrFH4tCzYKJS0JOQ=="), 214);
    public static final DJIMissionError RTK_IS_NOT_READY = new DJIMissionError(gfd.fdd("C34CYg4teQo2XmkwAj89HQ=="), 205);
    public static final DJIMissionError MULTI_MODE_IS_OFF = new DJIMissionError(gfd.fdd("FF8lNg5zNAs9T2kxEDctBzEKIDFHMDYQeV48MAk7PUQ2RA=="), 203);
    public static final DJIMissionError IN_NOVICE_MODE = new DJIMissionError(gfd.fdd("DUIsYgY3KwcrSy82RzcqRDBEaSwIKDAHPAokLQM7eQo2XQ=="), 202);
    public static final DJIMissionError HIGH_PRIORITY_MISSION_EXECUTING = new DJIMissionError(gfd.fdd("GAohKwA2PBZ5WjsrCCwwECAKJCsULTALNwogMUc7IQE6Xz0rCTk="), 215);
    public static final DJIMissionError GPS_SIGNAL_WEAK = new DJIMissionError(gfd.fdd("DUIsYiAOCkQqQy4sBjJ5Cz8KPSoCfjgNK0k7IwEqeQ0qCj4nBjU="), 216);
    public static final DJIMissionError LOW_BATTERY = new DJIMissionError(gfd.fdd("FUU+YgU/LRA8WDBiCzsvATUKPiMVMDAKPg=="), 217);
    public static final DJIMissionError AIRCRAFT_NOT_IN_THE_AIR = new DJIMissionError(gfd.fdd("DUIsYgY3KwcrSy82RzcqRDdFPWIOMHkQMU9pIw4s"), 218);
    public static final DJIMissionError MISSION_PARAMETERS_INVALID = new DJIMissionError(gfd.fdd("DUIsYhc/KwU0Tz0nFS15Cz8KPSoCfjQNKlkgLQl+OBY8CiAsET81DT0="), 219);
    public static final DJIMissionError MISSION_CONDITION_NOT_SATISFIED = new DJIMissionError(gfd.fdd("DUIsYgQxNwAwXiAtCX42AnlHIDEUNzYKeUM6YgkxLUQqSz0rFDgwAT0="), 220);
    public static final DJIMissionError MISSION_ACROSS_NO_FLY_ZONE = new DJIMissionError(gfd.fdd("DUIsYgo3KhcwRSdiDi15BTpYJjEUfi0MPAonLUc4NR15UCYsAg=="), 221);
    public static final DJIMissionError HOME_POINT_NOT_RECORDED = new DJIMissionError(gfd.fdd("DUIsYg8xNAF5WiYrCSp5Cz8KKCsVPSsFP15pKxR+NwstCjsnBDErADxO"), 222);
    public static final DJIMissionError AIRCRAFT_IN_NO_FLY_ZONE = new DJIMissionError(gfd.fdd("DUIsYgY3KwcrSy82RzcqRDBEaTYPO3kKNgovLh5+Iws3Tw=="), 223);
    public static final DJIMissionError MISSION_INFO_INVALID = new DJIMissionError(gfd.fdd("DUIsYg4wPwsrRyg2DjE3RDZMaS8OLSoNNkRpKxR+MAovSyUrAw=="), 224);
    public static final DJIMissionError WAYPOINT_INFO_INVALID = new DJIMissionError(gfd.fdd("DUIsYg4wPwsrRyg2DjE3RDZMaTUGJykLMEQ9Yg4teQ03XCguDjo="), 225);
    public static final DJIMissionError WAYPOINT_TRACE_TOO_LONG = new DJIMissionError(gfd.fdd("DUIsYhMsOAc8CiYkRyk4HSlFICwTfjAXeV4mLUcyNgo+"), 226);
    public static final DJIMissionError WAYPOINT_TOTAL_TRACE_TOO_LONG = new DJIMissionError(gfd.fdd("DUIsYhMxLQU1Cj0wBj08RDZMaTUGJykLMEQ9Yg4teRA2RWkuCDA+"), 227);
    public static final DJIMissionError WAYPOINT_INDEX_OVER_RANGE = new DJIMissionError(gfd.fdd("DUIsYg4wPQEhCiYkRyk4HSlFICwTfjAXeUU/JxV+KwU3TSw="), 228);
    public static final DJIMissionError WAYPOINT_DISTANCE_TOO_CLOSE = new DJIMissionError(gfd.fdd("DUIsYhA/IBQ2Qyc2RzowFy1LJyECfjAXeV4mLUc9NQsqTw=="), 229);
    public static final DJIMissionError WAYPOINT_DISTANCE_TOO_LONG = new DJIMissionError(gfd.fdd("DUIsYhA/IBQ2Qyc2RzowFy1LJyECfjAXeV4mLUcyNgo+"), 230);
    public static final DJIMissionError WAYPOINT_DAMPING_CHECK_FAILED = new DJIMissionError(gfd.fdd("DUIsYgM/NBQwRC5iBDY8BzIKIDFHODgNNU8t"), 231);
    public static final DJIMissionError WAYPOINT_ACTION_PARAMETER_INVALID = new DJIMissionError(gfd.fdd("DUIsYhc/KwU0Tz0nFX42AnldKDsXMTAKLQooIRM3Ngp5QzpiDjAvBTVDLQ=="), 232);
    public static final DJIMissionError WAYPOINT_MISSION_INFO_NOT_UPLOADED = new DJIMissionError(gfd.fdd("DUIsYg4wPwt5RS9iED8gFDZDJzZHMzAXKkMmLEc3KkQ3RT1iBDE0FDVPPScLJ3kRKUYmIwM7PQ=="), 234);
    public static final DJIMissionError WAYPOINT_UPLOAD_NOT_COMPLETE = new DJIMissionError(gfd.fdd("DUIsYhA/IBQ2Qyc2RyspCDZLLSsJOXkNKgonLRN+Ogs0WiUnEzs="), 235);
    public static final DJIMissionError WAYPOINT_REQUEST_IS_RUNNING = new DJIMissionError(gfd.fdd("DUIsYhA/IBQ2Qyc2Ryw8FSxPOjZHNypEK18nLA4wPg=="), 236);
    public static final DJIMissionError WAYPOINT_NOT_RUNNING = new DJIMissionError(gfd.fdd("DUIsYhA/IBQ2Qyc2RzMwFypDJixHNypEN0U9YhUrNwowRC4="), 237);
    public static final DJIMissionError WAYPOINT_IDLE_VELOCITY_INVALID = new DJIMissionError(gfd.fdd("DUIsYg46NQF5XCwuCD0wECAKIDFHNzcSOEYgJg=="), 238);
    public static final DJIMissionError AIRCRAFT_TAKING_OFF = new DJIMissionError(gfd.fdd("DUIsYgY3KwcrSy82RzcqRC1LIisJOXkLP0w="), 240);
    public static final DJIMissionError AIRCRAFT_LANDING = new DJIMissionError(gfd.fdd("DUIsYgY3KwcrSy82RzcqRDVLJyYOMD4="), 241);
    public static final DJIMissionError AIRCRAFT_GOING_HOME = new DJIMissionError(gfd.fdd("DUIsYgY3KwcrSy82RzcqRD5FICwAfjELNE8="), 242);
    public static final DJIMissionError AIRCRAFT_STARTING_MOTOR = new DJIMissionError(gfd.fdd("DUIsYgY3KwcrSy82RzcqRCpeKDATNzcDeV4hJ0czNhA2WA=="), 243);
    public static final DJIMissionError WRONG_CMD = new DJIMissionError(gfd.fdd("DUIsYgQxNAk4RC1iDi15EytFJyU="), 244);
    public static final DJIMissionError RUNNING_MISSION = new DJIMissionError(gfd.fdd("DUIsYgY3KwcrSy82RzcqRCtfJywOMD5EOAokKxQtMAs3"));
    public static final DJIMissionError WAYPOINT_GET_INTERRUPTION_FAILURE_FOR_COMPLETE_MISSION = new DJIMissionError(gfd.fdd("DUIsYhA/IBQ2Qyc2RzMwFypDJixHNzcQPFg7NxcqMAs3CiAxRzA2EHlLPyMOMjgGNU9pIAI9OBEqT2kvDi0qDTZEaSoGLXkHNkc5LgIqPAB3"));
    public static final DJIMissionError WAYPOINT_GET_INTERRUPTION_FAILURE_WITHOUT_REACHING_FIRST_WAYPOINT = new DJIMissionError(gfd.fdd("DUIsYhA/IBQ2Qyc2RzMwFypDJixHNzcQPFg7NxcqMAs3CiAxRzA2EHlLPyMOMjgGNU9pIAI9OBEqT2k2Dzt5BTBYKjAGOC1EPUMtLEAqeRY8SyoqRyoxAXlMIDAUKnkTOFM5LQ4wLUQwRGk2Dzt5CDhZPWIKNyoXMEUnbA=="));
    public static final DJIMissionError TRACKING_TARGET_LOW_CONFIDENCE = new DJIMissionError(gfd.fdd("DUIsYiY9LQ0vTx0wBj0yRDRDOjEOMTdEMFlpNggxeRE3WTwwAn4tDDwKPTAGPTINN01pLQU0PActCigsA346CzdMIDAKPy0NNkRpKxR+KwEoXyAwAjp3"));
    public static final DJIMissionError TRACKING_PAUSED_BY_USER = new DJIMissionError(gfd.fdd("FEM6MQ4xN0QwWWkyBisqAT0KKztHKyoBKwQ="));
    public static final DJIMissionError TRACKING_TARGET_TOO_HIGH = new DJIMissionError(gfd.fdd("DUIsYhMsOAcyQyclRyo4Fj5PPWIOLXkQNkVpKg45MUo="));
    public static final DJIMissionError TRACKING_OBSTACLE_DETECTED = new DJIMissionError(gfd.fdd("Fkg6NgY9NQEqCigwAn49AS1PKjYCOnc="));
    public static final DJIMissionError TRACKING_GIMBAL_PITCH_TOO_LOW = new DJIMissionError(gfd.fdd("DUIsYgA3NAY4RmkyDio6DHlDOmITMTZENUU+bA=="));
    public static final DJIMissionError TRACKING_TARGET_TOO_FAR = new DJIMissionError(gfd.fdd("DUIsYhMsOAcyQyclRyo4Fj5PPWIOLXkQNkVpJAYseQUuSzBiASw2CXleISdHPzAWOlgoJBNw"));
    public static final DJIMissionError TRACKING_TARGET_TOO_CLOSE = new DJIMissionError(gfd.fdd("DUIsYhMsOAcyQyclRyo4Fj5PPWIOLXkQNkVpIQsxKgF5XiZiEzY8RDhDOyEVPz8Qdw=="));
    public static final DJIMissionError AIRCRAFT_ALTITUDE_TOO_HIGH = new DJIMissionError(gfd.fdd("DUIsYgY3KwcrSy82QC15BTVeIDYSOjxEMFlpNggxeQwwTSFs"));
    public static final DJIMissionError AIRCRAFT_ALTITUDE_TOO_LOW = new DJIMissionError(gfd.fdd("DUIsYgY3KwcrSy82QC15BTVeIDYSOjxEMFlpNggxeQg2XWc="));
    public static final DJIMissionError TRACKING_RECT_TOO_SMALL = new DJIMissionError(gfd.fdd("DUIsYhMsOAcyQyclRyw8By1LJyULO3kNKgo9LQh+Kgk4RiVs"));
    public static final DJIMissionError TRACKING_RECT_TOO_LARGE = new DJIMissionError(gfd.fdd("DUIsYhMsOAcyQyclRyw8By1LJyULO3kNKgo9LQh+NQUrTSxs"));
    public static final DJIMissionError TRACKING_TARGET_NOT_ENOUGH_FEATURES = new DJIMissionError(gfd.fdd("DUIsYhMsOAcyQyclRyo4Fj5PPWIDMTwXNw09Yg8/LwF5TyctEjkxRD9PKDYSLDwXeV4mYgsxOg95RSc2CHA="));
    public static final DJIMissionError TRACKING_TARGET_LOST = new DJIMissionError(gfd.fdd("DUIsYhMsOAcyQyclRyo4Fj5PPWIOLXkINlk9bA=="));
    public static final DJIMissionError VISION_DATA_ABNORMAL = new DJIMissionError(gfd.fdd("DUIsYgM/LQV5TDstCn4tDDwKPysUNzYKeVkwMRM7NEQwWWkjBTA2FjRLJWw="));
    public static final DJIMissionError NO_VIDEO_FEED = new DJIMissionError(gfd.fdd("F0VpLg4oPEQvQy0nCH4/ATxOaSsUfjoFKV48MAI6eQI2WGk2Dzt5JTpeIDQCCisFOkFpDw4tKg02RGdi"));
    public static final DJIMissionError VIDEO_FRAME_RATE_TOO_LOW = new DJIMissionError(gfd.fdd("DUIsYgEsOAk8CjsjEzt5Cz8KPSoCfjUNL09pNA46PAt5TCwnA34wF3leJi1HMjYTdw=="));
    public static final DJIMissionError REACH_FLIGHT_LIMITATION = new DJIMissionError(gfd.fdd("DUIsYgY3KwcrSy82RzY4F3lYLCMENjwAeV4hJ0c4NQ0+Qj1iCzc0DS1LPSsIMHc="));
    public static final DJIMissionError VISION_SYSTEM_NOT_AUTHORIZED = new DJIMissionError(gfd.fdd("DUIsYhE3Kg02RGkxHi0tATQKKiMJMDYQeU0sNkcqMQF5Szw2DzErDSNLPSsIMHkQNgoqLQkqKws1Cj0qAn44DStJOyMBKndE"));
    public static final DJIMissionError TRACKING_TARGET_SHAKING = new DJIMissionError(gfd.fdd("DUIsYhMsOAcyQyclRyo4Fj5PPWIOLXkXMUsiKwk5eRA2RWkvEj0xSg=="));
    public static final DJIMissionError POINTING_AIRCRAFT_NOT_IN_THE_AIR = new DJIMissionError(gfd.fdd("DUIsYgY3KwcrSy82RzcqRDdFPWIOMHkQMU9pIw4sd0QJRiwjFDt5EDhBLGIIOD9EP0M7MRNw"));
    public static final DJIMissionError VISION_SYSTEM_NEEDS_CALIBRATION = new DJIMissionError(gfd.fdd("DUIsYhE3Kg02RGkxHi0tATQKOycWKzAWPFlpIQYyMAYrSz0rCDB3"));
    public static final DJIMissionError FEATURE_POINT_CANNOT_MATCH = new DJIMissionError(gfd.fdd("DUIsYgE7OBAsWCxiFzEwCi1ZaSQIKzcAeUgwYgUxLQx5XCAxDjE3RCpPJzEILCpEOksnLAgqeQk4XioqSQ=="));
    public static final DJIMissionError VISION_SENSOR_OVEREXPOSED = new DJIMissionError(gfd.fdd("DUIsYhE3Kg02RGkxAjAqCytZaSMVO3kLL087Jx8uNhc8Tmc="));
    public static final DJIMissionError VISION_SENSOR_UNDEREXPOSED = new DJIMissionError(gfd.fdd("DUIsYhE3Kg02RGkxAjAqCytZaSMVO3kRN04sMAImKQsqTy1s"));
    public static final DJIMissionError VISION_SENSOR_LOW_QUALITY = new DJIMissionError(gfd.fdd("DUIsYhYrOAgwXjBiCDh5EjBZIC0JfioBN1kmMEc3KkQ1RT5s"));
    public static final DJIMissionError VISION_SYSTEM_ERROR = new DJIMissionError(gfd.fdd("DUIsYhE3Kg02RGkxHi0tATQKLCwEMSwKLU87MUctIBctTyRiAiwrCysE"));
    public static final DJIMissionError REACH_ALTITUDE_LOWER_BOUND = new DJIMissionError(gfd.fdd("DUIsYgY3KwcrSy82Ryw8BTpCLDFHKjEBeUslNg4qLAA8CiUtEDsrRDtFPCwDfjYCeV4hJ0cKOBQfRjBiKjcqFzBFJ2w="));
    public static final DJIMissionError CANNOT_BYPASS_OBSTACLE = new DJIMissionError(gfd.fdd("DUIsYgY3KwcrSy82Rz04CjdFPWIFJykFKllpNg87eQs7WT0jBDI8Sg=="));
    public static final DJIMissionError STOPPED_BY_USER = new DJIMissionError(gfd.fdd("FEM6MQ4xN0QuSzpiFCo2FClPLWIFJ3kQMU9pNxQ7K0o="));
    public static final DJIMissionError MISSION_NOT_STARTED = new DJIMissionError(gfd.fdd("FEM6MQ4xN0QwWWksCCp5Fy1LOzYCOnkdPF4="));
    public static final DJIMissionError COMMON_STATE_ERROR = new DJIMissionError(gfd.fdd("DUIsYgQxNAk4RC1iDi15CjZeaTESLikLK14sJkc3N0Q6XzswAjAtRCpeKDYCcA=="));
    public static final DJIMissionError SYSTEM_ABNORMAL = new DJIMissionError(gfd.fdd("ClM6NgIzeQErWCYwS34pCDxLOidHKisdeUsuIw4wd0QQTGk2Dzt5AStYJjBHPTYKLUMnNwItdUQrTzo2BiwtRC1CLGIGNysHK0svNkk="), 5301);
    public static final DJIMissionError TARGET_AREA_IS_TOO_SMALL = new DJIMissionError(gfd.fdd("H1goLwJ+KgE1Tyo2DjE3RCpfKygCPS1ELUUmYhQzOAg1BA=="), 5302);
    public static final DJIMissionError INSUFFICIENT_FEATURES_IN_TARGET_AREA = new DJIMissionError(gfd.fdd("H1goLwJ+KgE1Tyo2DjE3RCpfKygCPS1ELU8xNhIsPEQ3RT1iCDwvDTZfOmw="), 5303);
    public static final DJIMissionError LOST_TARGET_WHILE_WATCHING = new DJIMissionError(gfd.fdd("DVgoIQw3NwN5WTwgDTs6EHlGJjETfi4MMEYsYhA/LQcxQyclSQ=="), 5304);
    public static final DJIMissionError LOST_TARGET_WHILE_EXECUTING = new DJIMissionError(gfd.fdd("DVgoIQw3NwN5WTwgDTs6EHlGJjETfi4MMEYsYgImPAcsXiAsAHA="), 5305);
    public static final DJIMissionError REPROJECTION_FAILED_WHILE_EXECUTING = new DJIMissionError(gfd.fdd("H0sgLgI6eRA2CiQnBi0sFjwGaTILOzgXPAo9MB5+OAM4Qyds"), 5306);
    public static final DJIMissionError TARGET_TOO_CLOSE = new DJIMissionError(gfd.fdd("H1goLwJ+KhE7QCwhE34tCzYKKi4ILTxK"), 5307);
    public static final DJIMissionError TARGET_SIZE_CHANGED = new DJIMissionError(gfd.fdd("DUs7JQIqeRcwUCxiBDY4Cj5PLW5HLjUBOFksYhMsIEQ4TSgrCXB5LT8KPSoCfjwWK0U7Yhc7KxcwWT0xS34rASpeKDATfi0MPAooKxU9KwU/Xmc="), 5308);
    public static final DJIMissionError GPS_ABNORMAL = new DJIMissionError(gfd.fdd("HnoaYhQ3Pgo4Rmk1Aj8ySnl6JScGLTxELVgwYgY5OA03CiAsRz83RDZaLCxHPysBOAQ="), 5309);
    public static final DJIMissionError HOT_POINT_INVALID = new DJIMissionError(gfd.fdd("EUU9Mgg3NxB5WigwBjM8EDxYaSYIfjcLLQokJwIqeRY8WzwrFTs0ATdeOmw="), 5310);
    public static final DJIMissionError WATCH_TARGET_FAILED = new DJIMissionError(gfd.fdd("HkMkIAYyeRY8SyoqAjp5CTZcLC8CMC1ENUMkKxNyeRcsSCMnBCowCj4KLyMOMjwAdwoZLgI/KgF5Xjs7Rz8+BTBEZw=="), 5311);
    public static final DJIMissionError ESTIMATE_TIMEOUT = new DJIMissionError(gfd.fdd("HFk9Kwo/LQF5XiAvAjEsEHUKJCsULTALNwosOg4qdw=="), 5312);
    public static final DJIMissionError ESTIMATE_RESULT_INVALID = new DJIMissionError(gfd.fdd("H0sgLgI6eRA2CiwxEzc0BS1PaTESPDMBOl5pLgg9OBAwRSds"), 5313);
    public static final DJIMissionError EXIT_BY_USER_BUTTON = new DJIMissionError(gfd.fdd("Gl87MAIwLUQ0QzoxDjE3RDxSIDZHPCBELFksMEc8LBAtRSds"), 5314);
    public static final DJIMissionError RADIUS_LIMIT = new DJIMissionError(gfd.fdd("DUIsYgY3KwcrSy82Ryw8BTpCaTYPO3kAMFk9Iwk9PEQ1QyQrE3AJCDxLOidHMSkBK0s9J0cqMQF5SyAwBCw4Ai0KPisTNjAKeV4hJ0c6MBctSychAn41DTRDPWw="), 5315);
    public static final DJIMissionError ALTITUDE_LIMIT = new DJIMissionError(gfd.fdd("DUIsYgY3KwcrSy82Ryw8BTpCaTYPO3kFNV4gNhI6PEQ1QyQrE3B5NDVPKDECfjYUPFgoNgJ+LQw8CigrFT0rBT9eaTUOKjENNwo9KgJ+OAgtQz03Azt5CDBHIDZJ"), 5316);
    public static final DJIMissionError CONTROL_FAILED = new DJIMissionError(gfd.fdd("EEQ9JwsyMAM8RD1iLzEtFDZDJzZHMzAXKkMmLEc7IQE6Xz0nRzg4DTVPLW5HKjEBeU4sMQQsMBQtQyYsRzcqRC1CLGIBPzAIeVgsIxQxNw=="), 5317);
    public static final DJIMissionError LOST_CONNECTION_WITH_REMOTE_CONTROLLER = new DJIMissionError(gfd.fdd("FUU6Nkc9Ngo3Tyo2DjE3RC5DPSpHDDwJNl4sYiQxNxArRSUuAiw="), 5318);
    public static final DJIMissionError OBSTACLE_ENCOUNTERED_WHILE_ESTIMATING = new DJIMissionError(gfd.fdd("Fkg6NgY9NQEqCiwsBDEsCi1POycDfi4MMEYsYgItLQ00Sz0rCTl1RDpfOzACMC1ENEM6MQ4xN0QoXyA2Ezs9Sg=="), 5319);
    public static final DJIMissionError OBSTACLE_ENCOUNTERED_WHILE_SURROUNDING = new DJIMissionError(gfd.fdd("Fkg6NgY9NQEqCiwsBDEsCi1POycDfi4MMEYsYhQrKxY2XycmDjA+SHlJPDAVOzcQeUcgMRQ3Ngp5WTwxFzs3ADxOZw=="), 5320);
    public static final DJIMissionError TARGET_IS_TOO_FAR_AWAY = new DJIMissionError(gfd.fdd("DUs7JQIqeQ0qCj0tCH4/BSsKKDUGJ3VELUIsYgY3KwcrSy82RzA8AT1ZaTYIfjoLN14gLBI7eRA2CiQnBi0sFjwKLSsUKjgKOk8="), 5321);
    public static final DJIMissionError HOTPOINT_ALTITUDE_TOO_LOW = new DJIMissionError(gfd.fdd("GEM7IRU/PxB+WWkjCyowECxOLGIOLXkQNkVpLggpeRA2Ciw6Aj0sEDwKIS0TLjYNN15pLw4tKg02RGc="), 5322);
    public static final DJIMissionError UNKNOWN = new DJIMissionError(gfd.fdd("DEQiLAgpN0QrTzo3Cyo="));
    public static final DJIMissionError Z30_ONLY_SUPPORT_SPOTLIGHT_PRO = new DJIMissionError(gfd.fdd("Gl87MAIwLUQaSyQnFT95CzdGMGIUKykUNlg9YhQuNhA1Qy4qE34pFjYKJC0DO3g="));
    public static final DJIMissionError USER_CANCEL_UPLOADING_MISSION = new DJIMissionError(gfd.fdd("DFolLQY6MAo+CiQrFC0wCzcKISMUfjsBPERpIQYwOgE1Ty1j"));
    public static final DJIMissionError ALREADY_IN_OTHER_NAVIGATION_MODE = new DJIMissionError(gfd.fdd("GEY7JwY6IEQwRGktEzY8FnlEKDQOOTgQMEUnYgoxPQF1CjkuAj8qAXlJJS0UO3kCMFg6Nkk="));
    public static final DJIMissionError UNKNOWN_OBJECT_TARGET = new DJIMissionError(gfd.fdd("DEQiLAgpN0Q2SCMnBCp5EDhYLicTfj0LeUQmNkctLBQpRTs2RyorBTpBICwA"));
    public static final DJIMissionError AIRCRAFT_AUTO_LANDING = new DJIMissionError(gfd.fdd("GEM7IRU/PxB5RigsAzc3A3lLPDYIMzgQMEkoLgsnd0QMRCggCzt5EDYKPDECfhgHLUM/JzMsOAcy"));
    public static final DJIMissionError IN_SMART_PHOTO_MODE = new DJIMissionError(gfd.fdd("ClomNgs3PgwtCjwsBig4DTVLKy4CfjAKeXkkIxUqCQw2XiZiCjE9AQ=="));
    public static final DJIMissionError IN_BURST_MODE = new DJIMissionError(gfd.fdd("ClomNgs3PgwtCjwsBig4DTVLKy4CfjAKeWg8MBQqeQk2Tiw="));
    public static final DJIMissionError IN_TIMED_SHOT_MODE = new DJIMissionError(gfd.fdd("ClomNgs3PgwtCjwsBig4DTVLKy4CfjAKeX4gLwI6eTcxRT1iCjE9AQ=="));
    public static final DJIMissionError IN_AEB_SHOT_MODE = new DJIMissionError(gfd.fdd("ClomNgs3PgwtCjwsBig4DTVLKy4CfjAKeWsMAEctMQs2XiAsAH40Cz1P"));
    public static final DJIMissionError IN_48MP_SHOT_MODE = new DJIMissionError(gfd.fdd("ClomNgs3PgwtCjwsBig4DTVLKy4CfjAKeR5xYioOeRcxRSY2DjA+RDRFLSc="));
    public static final DJIMissionError IN_SLOW_MOTION_MODE = new DJIMissionError(gfd.fdd("ClomNgs3PgwtCjwsBig4DTVLKy4CfjAKeXklLRB+FAstQyYsRzM2ADw="));
    public static final DJIMissionError CAMERA_IS_SHOOTING = new DJIMissionError(gfd.fdd("GkskJxU/eQ0qCjoqCDEtDTdNZWISMDgGNU9pNgh+LBc8CgghEzcvAQ1YKCEM"));
    public static final DJIMissionError AUTOSENSING_MUST_ENABLE = new DJIMissionError(gfd.fdd("GF89LTQ7NxcwRC5iCisqEHlPJyMFMjwA"));
    public static final DJIMissionError ACTIVETRACK_MUST_ENABLE = new DJIMissionError(gfd.fdd("GEk9KxE7eTArSyopRzMsFy0KLCwGPDUBPQ=="));
    public static final DJIMissionError NOT_IN_SMART_EYE_MODE = new DJIMissionError(gfd.fdd("DUIsYgk/Lw0+Sz0rCDB5DSoKJy0TfjAKeVkkIxUqeQEgT2kvCDo8SHlaJScGLTxEPEQ9JxV+Kgk4WD1iAic8RDRFLSdHODAWKl5o"));
    public static final DJIMissionError SMART_EYE_STARTED = new DJIMissionError(gfd.fdd("DUIsYjQzOBYtCgw7An44CCtPKCYefgoQOFg9JwNyeQU3TmknHzs6ES1DJyVLfikIPEs6J0ctLQspCiw6Aj0sEDBELmIBNysXLQs="));
    public static final DJIMissionError SMART_EYE_MODE_NOT_RECOGNISED = new DJIMissionError(gfd.fdd("DUIsYhQzOBYtCiw7An40Cz1PaSsUfjcLLQo7JwQxPgowWSwmS34pCDxLOidHLS4NLUkhYhMxeQV5WSQjFSp5ASBPaTESPHkJNk4sYw=="));
    private int mErrorCode;

    protected DJIMissionError(String string2) {
    }

    private DJIMissionError(String string2, int n3) {
    }

    public static DJIError getDJIError(Ccode ccode) {
        return null;
    }

    public static DJIError getDJIErrorByCode(int n3) {
        return null;
    }
}

