/*
 * Decompiled with CFR 0.152.
 */
package dji.common.mission.waypoint;

import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import dji.common.error.DJIError;
import dji.common.mission.waypoint.Waypoint;
import dji.common.mission.waypoint.WaypointMissionFinishedAction;
import dji.common.mission.waypoint.WaypointMissionFlightPathMode;
import dji.common.mission.waypoint.WaypointMissionGotoWaypointMode;
import dji.common.mission.waypoint.WaypointMissionHeadingMode;
import dji.common.model.LocationCoordinate2D;
import dji.fieldAnnotation.fdd;
import java.util.List;

@fdd
public final class WaypointMission {
    public static final float ALMOST_ZERO_SPEED = 1.0E-7f;
    public static final float MAX_FLIGHT_SPEED = 15.0f;
    public static final float MIN_FLIGHT_SPEED = 2.0f;
    public static final float MAX_AUTO_FLIGHT_SPEED = 15.0f;
    public static final float MIN_AUTO_FLIGHT_SPEED = -15.0f;
    public static final int MAX_WAYPOINT_COUNT = 99;
    public static final int MIN_WAYPOINT_COUNT = 2;
    public static final int MIN_REPEAT_TIME = 1;
    public static final int MAX_REPEAT_TIME = 255;
    private static final double HORIZONTAL_ACCELERATION = 2.0;
    public static final int TIME_MILLISECOND_TO_SECOND = 1000;
    private int missionID;
    private int waypointCount;
    private final float maxFlightSpeed;
    @FloatRange(from=-15.0, to=15.0)
    private final float autoFlightSpeed;
    private final WaypointMissionFinishedAction finishedAction;
    private final WaypointMissionHeadingMode headingMode;
    private final WaypointMissionFlightPathMode flightPathMode;
    private final WaypointMissionGotoWaypointMode gotoFirstWaypointMode;
    private final boolean isExitMissionOnRCSignalLostEnabled;
    private final LocationCoordinate2D pointOfInterest;
    private final boolean isGimbalPitchRotationEnabled;
    private final boolean isGimbalElevationOptimizeEnabled;
    private final int repeatTimes;
    @Size(max=99L, min=2L)
    private final List<Waypoint> waypointList;

    public WaypointMission(Builder builder) {
    }

    static /* synthetic */ int access$000(WaypointMission waypointMission) {
        return 0;
    }

    static /* synthetic */ int access$100(WaypointMission waypointMission) {
        return 0;
    }

    static /* synthetic */ float access$200(WaypointMission waypointMission) {
        return 0.0f;
    }

    static /* synthetic */ float access$300(WaypointMission waypointMission) {
        return 0.0f;
    }

    static /* synthetic */ WaypointMissionFinishedAction access$400(WaypointMission waypointMission) {
        return null;
    }

    static /* synthetic */ WaypointMissionHeadingMode access$500(WaypointMission waypointMission) {
        return null;
    }

    static /* synthetic */ WaypointMissionFlightPathMode access$600(WaypointMission waypointMission) {
        return null;
    }

    static /* synthetic */ WaypointMissionGotoWaypointMode access$700(WaypointMission waypointMission) {
        return null;
    }

    static /* synthetic */ boolean access$800(WaypointMission waypointMission) {
        return false;
    }

    static /* synthetic */ LocationCoordinate2D access$900(WaypointMission waypointMission) {
        return null;
    }

    static /* synthetic */ boolean access$1000(WaypointMission waypointMission) {
        return false;
    }

    static /* synthetic */ boolean access$1100(WaypointMission waypointMission) {
        return false;
    }

    static /* synthetic */ int access$1200(WaypointMission waypointMission) {
        return 0;
    }

    static /* synthetic */ List access$1300(WaypointMission waypointMission) {
        return null;
    }

    public int getWaypointCount() {
        return 0;
    }

    public int getMissionID() {
        return 0;
    }

    public float getMaxFlightSpeed() {
        return 0.0f;
    }

    public float getAutoFlightSpeed() {
        return 0.0f;
    }

    public WaypointMissionFinishedAction getFinishedAction() {
        return null;
    }

    public WaypointMissionHeadingMode getHeadingMode() {
        return null;
    }

    public WaypointMissionFlightPathMode getFlightPathMode() {
        return null;
    }

    public WaypointMissionGotoWaypointMode getGotoFirstWaypointMode() {
        return null;
    }

    public boolean isExitMissionOnRCSignalLostEnabled() {
        return false;
    }

    public LocationCoordinate2D getPointOfInterest() {
        return null;
    }

    public boolean isGimbalPitchRotationEnabled() {
        return false;
    }

    public boolean isGimbalElevationOptimizeEnabled() {
        return false;
    }

    public int getRepeatTimes() {
        return 0;
    }

    @Size(max=99L, min=2L)
    public List<Waypoint> getWaypointList() {
        return null;
    }

    @Nullable
    public DJIError checkParameters() {
        return null;
    }

    public static class Builder {
        protected boolean isMultiInterestPointMission;
        protected int waypointCount;
        protected int missionID;
        protected float lastCalculatedTotalDistance;
        protected Float lastCalculatedTotalTime;
        @FloatRange(from=2.0, to=15.0)
        protected float maxFlightSpeed;
        @FloatRange(from=-15.0, to=15.0)
        protected float autoFlightSpeed;
        protected WaypointMissionFinishedAction finishedAction;
        protected WaypointMissionHeadingMode headingMode;
        protected WaypointMissionFlightPathMode flightPathMode;
        protected WaypointMissionGotoWaypointMode gotoFirstWaypointMode;
        protected boolean isExitMissionOnRCSignalLostEnabled;
        protected LocationCoordinate2D pointOfInterest;
        protected boolean isGimbalPitchRotationEnabled;
        protected boolean isGimbalElevationOptimizeEnabled;
        @IntRange(from=1L)
        protected int repeatTimes;
        @Size(max=99L, min=2L)
        protected List<Waypoint> waypointList;

        public Builder() {
        }

        public Builder(WaypointMission waypointMission) {
        }

        public Builder maxFlightSpeed(@FloatRange(from=2.0, to=15.0) float f4) {
            return null;
        }

        public Builder autoFlightSpeed(@FloatRange(from=-15.0, to=15.0) float f4) {
            return null;
        }

        public Builder finishedAction(@NonNull WaypointMissionFinishedAction waypointMissionFinishedAction) {
            return null;
        }

        public Builder headingMode(@NonNull WaypointMissionHeadingMode waypointMissionHeadingMode) {
            return null;
        }

        public Builder flightPathMode(@NonNull WaypointMissionFlightPathMode waypointMissionFlightPathMode) {
            return null;
        }

        public Builder gotoFirstWaypointMode(@NonNull WaypointMissionGotoWaypointMode waypointMissionGotoWaypointMode) {
            return null;
        }

        public Builder setExitMissionOnRCSignalLostEnabled(boolean bl) {
            return null;
        }

        public Builder setPointOfInterest(@NonNull LocationCoordinate2D locationCoordinate2D) {
            return null;
        }

        public Builder setGimbalPitchRotationEnabled(boolean bl) {
            return null;
        }

        public Builder setGimbalElevationOptimizeEnabled(boolean bl) {
            return null;
        }

        public Builder repeatTimes(@IntRange(from=1L, to=255L) int n3) {
            return null;
        }

        @Deprecated
        public Builder waypointList(@NonNull @Size(max=99L, min=2L) List<Waypoint> list) {
            return null;
        }

        public Builder addWaypoint(@NonNull Waypoint waypoint) {
            return null;
        }

        public Builder removeWaypoint(@NonNull Waypoint waypoint) {
            return null;
        }

        public Builder removeWaypoint(@NonNull int n3) {
            return null;
        }

        public Builder insertWaypoint(@NonNull Waypoint waypoint, int n3) {
            return null;
        }

        public Builder waypointCount(int n3) {
            return null;
        }

        public WaypointMission build() {
            return null;
        }

        public boolean isMissionComplete() {
            return false;
        }

        public int getWaypointCount() {
            return 0;
        }

        public float getMaxFlightSpeed() {
            return 0.0f;
        }

        public float getAutoFlightSpeed() {
            return 0.0f;
        }

        public WaypointMissionFinishedAction getFinishedAction() {
            return null;
        }

        public WaypointMissionHeadingMode getHeadingMode() {
            return null;
        }

        public WaypointMissionFlightPathMode getFlightPathMode() {
            return null;
        }

        public WaypointMissionGotoWaypointMode getGotoFirstWaypointMode() {
            return null;
        }

        public boolean isExitMissionOnRCSignalLostEnabled() {
            return false;
        }

        public LocationCoordinate2D getPointOfInterest() {
            return null;
        }

        public boolean isGimbalPitchRotationEnabled() {
            return false;
        }

        public boolean isGimbalElevationOptimizeEnabled() {
            return false;
        }

        public int getRepeatTimes() {
            return 0;
        }

        @Nullable
        public DJIError checkParameters() {
            return null;
        }

        public List<Waypoint> getWaypointList() {
            return null;
        }

        public int getMissionID() {
            return 0;
        }

        public Builder setMissionID(@IntRange(from=0L, to=65535L) int n3) {
            return null;
        }

        public float calculateTotalDistance() {
            return 0.0f;
        }

        public Float calculateTotalTime() {
            return null;
        }

        public float getLastCalculatedTotalDistance() {
            return 0.0f;
        }

        public Float getLastCalculatedTotalTime() {
            return null;
        }
    }
}

