/*
 * Decompiled with CFR 0.152.
 */
package dji.keysdk;

import androidx.annotation.CheckResult;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import com.dji.megatronking.stringfog.lib.gfd;
import dji.keysdk.DJIKey;
import dji.sdksharedlib.keycatalog.DJISDKCacheKey;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class FlightControllerKey
extends DJIKey {
    public static final String TAKEOFF_LOCATION_ALTITUDE = gfd.fdd("DUsiJwg4Pyg2SSg2DjE3JTVeIDYSOjw=");
    public static final String SUBCOMPONENT_IMU_KEY = gfd.fdd("EEc8");
    public static final String SERIAL_NUMBER = gfd.fdd("Ck87KwYyFxE0SCww");
    public static final String EID_NUMBER = gfd.fdd("HGMNDBIzOwEr");
    public static final String AREA_CODE = gfd.fdd("GFgsIyQxPQE=");
    public static final String GO_HOME_ASSESSMENT = gfd.fdd("HkUBLQo7GBcqTzoxCjs3EA==");
    public static final String IMU_COUNT = gfd.fdd("EEc8AQgrNxA=");
    public static final String COMPASS_COUNT = gfd.fdd("GkUkMgYtKic2Xyc2");
    public static final String IS_LANDING_GEAR_MOVABLE = gfd.fdd("EFkFIwk6MAo+bSwjFRM2EjhIJSc=");
    public static final String IS_ON_BOARD_SDK_AVAILABLE = gfd.fdd("EFkGLCUxOBY9eQ0JJig4DTVLKy4C");
    public static final String REDUNDANCY_SENSOR_USED_STATE = gfd.fdd("C08tNwk6OAo6UxonCS02FgxZLCY0KjgQPA==");
    public static final String REDUNDANCY_IMU_STATUS = gfd.fdd("K08tNwk6OAo6UwAvEg0tBS1fOg==");
    public static final String REDUNDANCY_COMPASS_STATUS = gfd.fdd("K08tNwk6NwU6UwotCi44Fyp5PSMTKyo=");
    public static final String IS_FLIGHT_ASSISTANT_SUPPORTED = gfd.fdd("EEQ9JwsyMAM8RD0ECzc+DC1rOjEOLS0FN14aNxcuNhYtTy0=");
    public static final String ACCESS_LOCKER_SUPPORTED = gfd.fdd("GEkqJxQtFQs6QSwwNCspFDZYPScD");
    public static final String FLY_ZONE_LIMITATION_ENABLED = gfd.fdd("Hk8mBAI/LRErTwAsNDc0ETVLPS0VGzcFO0YsJg==");
    public static final String HOME_LOCATION = gfd.fdd("EUUkJysxOgUtQyYs");
    public static final String SET_HOME_LOCATION_WITHOUT_LIMITATION = gfd.fdd("Ck89CggzPCg2SSg2DjE3MzBeIS0SKhUNNEM9IxM3Ngo=");
    public static final String GO_HOME_HEIGHT_IN_METERS = gfd.fdd("HkUBLQo7GAgtQz03Azs=");
    public static final String LOW_BATTERY_WARNING_THRESHOLD = gfd.fdd("FUU+AAYqLQErUx4jFTAwCj5+ITACLTELNU4=");
    public static final String SERIOUS_LOW_BATTERY_WARNING_THRESHOLD = gfd.fdd("Ck87KwgrKig2XQsjEyo8FiB9KDAJNzcDDUI7JxQ2Ngg9");
    public static final String AIRCRAFT_NAME = gfd.fdd("GEM7IRU/PxAXSyQn");
    public static final String LEDS_ENABLED_SETTINGS = gfd.fdd("FW8NMSIwOAY1Ty0RAiotDTdNOg==");
    public static final String HAS_INTERNAL_BEACON_LEDS = gfd.fdd("EUs6CwkqPBY3SyUAAj86CzdmLCYU");
    public static final String HOTPOINT_MAX_ACCELERATION = gfd.fdd("H0YgJQ8qGgs3XjstCzI8FhpFJyQOORELLVomKwkqFAUhayohAjI8FjheIC0J");
    public static final String HOTPOINT_MIN_RADIUS = gfd.fdd("H0YgJQ8qGgs3XjstCzI8FhpFJyQOORELLVomKwkqFA03eCgmDisq");
    public static final String MAX_FLIGHT_HEIGHT = gfd.fdd("FEsxBAs3PgwtYiwrADYt");
    public static final String MAX_FLIGHT_HEIGHT_RANGE = gfd.fdd("FEsxBAs3PgwtYiwrADYtNjhELic=");
    public static final String MAX_FLIGHT_RADIUS = gfd.fdd("FEsxBAs3PgwteCgmDisq");
    public static final String MAX_FLIGHT_RADIUS_ENABLED = gfd.fdd("FEsxBAs3PgwteCgmDisqITdLKy4COg==");
    public static final String MAX_FLIGHT_RADIUS_RANGE = gfd.fdd("FEsxBAs3PgwteCgmDisqNjhELic=");
    public static final String MAX_FLIGHT_HEIGHT_IN_NFZ = gfd.fdd("FEsxBAs3PgwtYiwrADYtLTdkDxg=");
    public static final String COMPASS_HEADING = gfd.fdd("GkUkMgYtKiw8Sy0rCTk=");
    public static final String COMPASS_HAS_ERROR = gfd.fdd("GkUkMgYtKiw4WQwwFTEr");
    public static final String COMPASS_IS_CALIBRATING = gfd.fdd("GkUkMgYtKi0qaSguDjwrBS1DJyU=");
    public static final String COMPASS_CALIBRATION_STATUS = gfd.fdd("GkUkMgYtKic4RiAgFT8tDTZEGjYGKiwX");
    public static final String COMPASS_STATE = gfd.fdd("GkUkMgYtKjctSz0n");
    public static final String SATELLITE_COUNT = gfd.fdd("Cks9JwsyMBA8aSY3CSo=");
    public static final String AIRCRAFT_LOCATION_LATITUDE = gfd.fdd("GEM7IRU/PxAVRSojEzc2ChVLPSsTKz0B");
    public static final String AIRCRAFT_LOCATION_LONGITUDE = gfd.fdd("GEM7IRU/PxAVRSojEzc2ChVFJyUOKiwAPA==");
    public static final String AIRCRAFT_LOCATION = gfd.fdd("GEM7IRU/PxAVRSojEzc2Cg==");
    public static final String VELOCITY_X = gfd.fdd("D08lLQQ3LR0B");
    public static final String VELOCITY_Y = gfd.fdd("D08lLQQ3LR0A");
    public static final String VELOCITY_Z = gfd.fdd("D08lLQQ3LR0D");
    public static final String ALTITUDE = gfd.fdd("GEY9KxMrPQE=");
    public static final String ATTITUDE_PITCH = gfd.fdd("GF49KxMrPQEJQz0hDw==");
    public static final String ATTITUDE_ROLL = gfd.fdd("GF49KxMrPQELRSUu");
    public static final String ATTITUDE_YAW = gfd.fdd("GF49KxMrPQEASz4=");
    public static final String ABSOLUTE_GPS_ALTITUDE = gfd.fdd("HnoaAwUtNggsXiwDCyowECxOLA==");
    public static final String IS_ABSOLUTE_GPS_ALTITUDE_SUPPORT = gfd.fdd("EFkOEjQfOxc2Rjw2Ah81EDBePCYCDSwUKUU7Ng==");
    public static final String BATTERY_THRESHOLD_BEHAVIOR = gfd.fdd("C08kIw4wMAo+aCg2EzsrHQ==");
    public static final String IS_FLYING = gfd.fdd("EFkPLh43NwM=");
    public static final String IS_LANDING = gfd.fdd("EFkINxMxFQU3TiAsAA==");
    public static final String FLIGHT_MODE_STRING = gfd.fdd("H0YgJQ8qFAs9Txo2FTc3Aw==");
    public static final String GPS_SIGNAL_LEVEL = gfd.fdd("HnoaEQ45NwU1Ziw0AjI=");
    public static final String IS_FAIL_SAFE = gfd.fdd("EFkPIw4yCgU/Tw==");
    public static final String IS_IMU_PREHEATING = gfd.fdd("EFkADzIOKwExTyg2DjA+");
    public static final String IS_ULTRASONIC_BEING_USED = gfd.fdd("EFkcLhMsOBc2RCAhJTswCj5/OicD");
    public static final String ULTRASONIC_HEIGHT_IN_METERS = gfd.fdd("DEY9MAYtNgowSQEnDjkxEBBEBCcTOysX");
    public static final String IS_VISION_POSITIONING_SENSOR_BEING_USED = gfd.fdd("EFkfKxQ3NgoJRTorEzc2CjBELhECMCoLK2gsKwk5DBc8Tg==");
    public static final String ARE_MOTOR_ON = gfd.fdd("GFgsDwgqNhYqZSc=");
    public static final String HOME_LOCATION_LATITUDE = gfd.fdd("EUUkJysxOgUtQyYsKz8tDS1fLSc=");
    public static final String HOME_LOCATION_LONGITUDE = gfd.fdd("EUUkJysxOgUtQyYsKzE3AzBePCYC");
    public static final String REMAINING_FLIGHT_TIME = gfd.fdd("C08kIw4wMAo+bCUrADYtMDBHLA==");
    public static final String TIME_NEEDED_TO_GO_HOME = gfd.fdd("DUMkJyk7PAA8Th0tIDERCzRP");
    public static final String TIME_NEEDED_TO_LAND_FROM_CURRENT_HEIGHT = gfd.fdd("DUMkJyk7PAA8Th0tKz83AB9YJi8kKysWPEQ9CgI3Pgwt");
    public static final String BATTERY_PERCENTAGE_NEEDED_TO_GO_HOME = gfd.fdd("G0s9NgIsIDQ8WConCSo4AzxkLCcDOz0wNm0mCggzPA==");
    public static final String MAX_RADIUS_AIRCRAFT_CAN_FLY_AND_GO_HOME = gfd.fdd("FEsxEAY6MBEqayAwBCw4Ai1pKCwhMiAlN04OLS8xNAE=");
    public static final String AIRCRAFT_SHOULD_GO_HOME = gfd.fdd("GEM7IRU/PxAKQiY3CzoeCxFFJCc=");
    public static final String AIRCRAFT_GO_HOME_COUNT_DOWN = gfd.fdd("GEM7IRU/PxAeRQEtCjsaCyxEPQYIKTc=");
    public static final String ULTRASONIC_ERROR = gfd.fdd("DEY9MAYtNgowSQwwFTEr");
    public static final String FLY_TIME_IN_SECONDS = gfd.fdd("H0YwFg4zPA==");
    public static final String GO_HOME_STATUS = gfd.fdd("HkUBLQo7ChA4Xjwx");
    public static final String IS_GOING_HOME = gfd.fdd("EFkOLQ4wPiw2Ryw=");
    public static final String IS_HOME_LOCATION_SET = gfd.fdd("EFkBLQo7FQs6Sz0rCDAKAS0=");
    public static final String HOME_POINT_ALTITUDE = gfd.fdd("EUUkJzcxMAotayU2DiosADw=");
    public static final String ORIENTATION_MODE = gfd.fdd("EEUqDwg6PA==");
    public static final String FLIGHT_WIND_WARNING = gfd.fdd("H0YgJQ8qDg03Th4jFTAwCj4=");
    public static final String MULTI_MODE_OPEN = gfd.fdd("FF8lNg4TNgA8ZTknCQ==");
    public static final String IS_RTK_SUPPORTED = gfd.fdd("C14iERIuKQsrXiwm");
    public static final String WIND_SPEED = gfd.fdd("DkMnJjQuPAE9");
    public static final String WIND_DIRECTION = gfd.fdd("DkMnJiM3KwE6XiAtCQ==");
    public static final String FLIGHT_MODE = gfd.fdd("H0YgJQ8qFAs9Tw==");
    public static final String FLIGHT_ACTION = gfd.fdd("H0YgJQ8qGActQyYs");
    public static final String IS_CANCEL_AUTO_LANDING_DISABLED = gfd.fdd("EFkKIwk9PAgYXz0tKz83ADBELgYOLTgGNU8t");
    public static final String IS_CANCEL_RETURN_TO_HOME_DISABLED = gfd.fdd("EFkKIwk9PAgLTz03FTANCxFFJCcjNyoFO0YsJg==");
    public static final String CONTROL_MODE = gfd.fdd("GkUnNhUxNSk2Tiw=");
    public static final String IS_SIMULATOR_ACTIVE = gfd.fdd("EFkaKworNQUtRTsREz8rEDxO");
    public static final String SIMULATOR_STATE = gfd.fdd("CkMkNws/LQsreT0jEzs=");
    public static final String HAS_REACHED_MAX_FLIGHT_HEIGHT = gfd.fdd("EUs6EAI/Ogw8TgQjHxg1DT5CPQoCNz4MLQ==");
    public static final String HAS_REACHED_MAX_FLIGHT_RADIUS = gfd.fdd("EUs6EAI/Ogw8TgQjHxg1DT5CPRAGOjARKg==");
    public static final String MAX_FLIGHT_HEIGHT_LIMIT_REASON = gfd.fdd("FEsxBAs3PgwtYiwrADYtKDBHIDY1OzgXNkQ=");
    public static final String NOVICE_MODE_ENABLED = gfd.fdd("F0U/KwQ7FAs9TwwsBjw1AT0=");
    public static final String LANDING_GEAR_STATUS = gfd.fdd("FUsnJg4wPiM8SzsREz8tESo=");
    public static final String LANDING_GEAR_MODE = gfd.fdd("FUsnJg4wPiM8SzsPCDo8");
    public static final String HOME_LOCATION_USING_CURRENT_AIRCRAFT_LOCATION = gfd.fdd("EUUkJysxOgUtQyYsMi0wCj5pPDAVOzcQGEM7IRU/PxAVRSojEzc2Cg==");
    public static final String TAKE_OFF = gfd.fdd("DUsiJyg4Pw==");
    public static final String PRECISION_TAKE_OFF = gfd.fdd("CVgsIQ4tMAs3figpAhE/Ag==");
    public static final String IS_PRECISION_TAKE_OFF_SUPPORTED = gfd.fdd("EFkZMAI9MBcwRScWBjU8Cz9MGjcXLjYWLU8t");
    public static final String CANCEL_TAKE_OFF = gfd.fdd("GksnIQIyDQUyTwYkAQ==");
    public static final String START_LANDING = gfd.fdd("GF89LSs/NwAwRC4=");
    public static final String CANCEL_LANDING = gfd.fdd("GksnIQIyGBEtRQUjCTowCj4=");
    public static final String TURN_ON_MOTORS = gfd.fdd("DV87LCgwFAstRTsx");
    public static final String TURN_OFF_MOTORS = gfd.fdd("DV87LCg4Pyk2XiYwFA==");
    public static final String START_GO_HOME = gfd.fdd("HkUBLQo7");
    public static final String CANCEL_GO_HOME = gfd.fdd("GksnIQIyHgsRRSQn");
    public static final String LOCK_COURSE_USING_CURRENT_HEADING = gfd.fdd("FUUqKSQxLBYqTxwxDjA+JyxYOycJKh0NK08qNg4xNw==");
    public static final String START_IMU_CALIBRATION = gfd.fdd("Cl4oMBMXFDEaSyUrBSw4EDBFJw==");
    public static final String START_IMU_CALIBRATION_WITH_ID = gfd.fdd("Cl4oMBMXFDEaSyUrBSw4EDBFJxUOKjEtHQ==");
    public static final String SEND_DATA_TO_ON_BOARD_SDK_DEVICE = gfd.fdd("Ck8nJiM/LQUNRQYsBTE4Fj15DQkjOy8NOk8=");
    public static final String IS_VIRTUAL_STICK_CONTROL_MODE_AVAILABLE = gfd.fdd("MFkfKxUqLAU1eT0rBDUaCzdeOy0LEzYAPGs/Iw4yOAY1Tw==");
    public static final String SEND_VIRTUAL_STICK_FLIGHT_CONTROL_DATA = gfd.fdd("Ck8nJjE3KxAsSyUREzc6Dx9GICUPKhoLN147LQsaOBA4");
    public static final String LANDING_GEAR_AUTOMATIC_MOVEMENT_ENABLED = gfd.fdd("FUsnJg4wPiM8SzsDEio2CTheICEqMS8BNE8nNiIwOAY1Ty0=");
    public static final String LANDING_GEAR_HIDE_ENABLED = gfd.fdd("FUsnJg4wPiM8SzsKDjo8ITdLKy4COg==");
    public static final String EXIT_TRANSPORT_MODE = gfd.fdd("HFIgNjMsOAoqWiYwExM2ADw=");
    public static final String ENTER_TRANSPORT_MODE = gfd.fdd("HEQ9JxUKKwU3WTktFSoUCz1P");
    public static final String RETRACT_LANDING_GEAR = gfd.fdd("C089MAY9LSg4RC0rCTkeAThY");
    public static final String DEPLOY_LANDING_GEAR = gfd.fdd("HU85LggnFQU3TiAsABk8BSs=");
    public static final String START_SIMULATOR = gfd.fdd("Cl4oMBMNMAksRig2CCw=");
    public static final String STOP_SIMULATOR = gfd.fdd("Cl4mMjQ3NBE1Sz0tFQ==");
    public static final String SIMULATOR_WIND_DATA = gfd.fdd("CkMkNws/LQsrfSAsAxo4EDg=");
    public static final String VIRTUAL_STICK_CONTROL_MODE_ENABLED = gfd.fdd("D0M7NhI/NTctQyopJDE3ECtFJQ8IOjwhN0srLgI6");
    public static final String COMPASS_START_CALIBRATION = gfd.fdd("GkUkMgYtKjctSzs2JD81DTtYKDYOMTc=");
    public static final String COMPASS_STOP_CALIBRATION = gfd.fdd("GkUkMgYtKjctRTkBBjIwBitLPSsIMA==");
    public static final String CONFIRM_LANDING = gfd.fdd("OkUnJA4sNCg4RC0rCTk=");
    public static final String IS_LANDING_CONFIRMATION_NEEDED = gfd.fdd("MFkFIwk6MAo+aSYsATcrCTheIC0JEDwBPU8t");
    public static final String IS_IN_LANDING_MODE = gfd.fdd("MFkALCs/NwAwRC4PCDo8");
    public static final String FORCE_LANDING_HEIGHT = gfd.fdd("H0U7IQISOAo9QyclLzswAzFe");
    public static final String IMU_STATE = gfd.fdd("EGccERM/LQE=");
    public static final String TERRAIN_FOLLOW_MODE_ENABLED = gfd.fdd("DU87MAY3NyI2RiUtEBM2ADxvJyMFMjwA");
    public static final String CURRENT_LAND_IMMEDIATELY_BATTERY = gfd.fdd("Gl87MAIwLSg4RC0LCjM8ADBLPScLJxsFLV4sMB4=");
    public static final String QUICK_SPIN_ENABLED = gfd.fdd("CF8gIQwNKQ03");
    public static final String TRIPOD_MODE_ENABLED = gfd.fdd("DVggMgg6FAs9TwwsBjw1AT0=");
    public static final String CINEMATIC_MODE_ENABLED = gfd.fdd("GkMnJwo/LQ06ZyYmAhs3BTtGLCY=");
    public static final String CONNECTION_FAIL_SAFE_BEHAVIOR = gfd.fdd("H0YgJQ8qHwUwRhojATsWFDxYKDYOMTc=");
    @Deprecated
    public static final String CONTROL_GIMBAL_BEHAVIOR = gfd.fdd("OkUnNhUxNTs+QyQgBjIGBjxCKDQOMSs=");
    public static final String BOTH_CONTROL_MULTI_GIMBALS = gfd.fdd("O0U9Kjg9NgotWCYuODMsCC1DFiUOMzsFNVk=");
    public static final String OUT_OF_BOTH_CONTROL_GIMBALS_REASON = gfd.fdd("Nl89DQEcNhAxaSYsEyw2CB5DJCAGMio2PEs6LQk=");
    public static final String ENABLE_1860 = gfd.fdd("HEQoIAs7aFxvGg==");
    public static final String URGENT_STOP_MOTOR_MODE = gfd.fdd("DFguJwkqChA2WgQtEzErKTZOLA==");
    public static final String BINDING_STATE = gfd.fdd("G0MnJg4wPjctSz0n");
    public static final String RESET_MOTOR = gfd.fdd("C086JxMTNhA2WA==");
    public static final String AIR_SENSE_SYSTEM_CONNECTED = gfd.fdd("GEM7EQIwKgEKUzo2AjMaCzdELCETOz0=");
    public static final String AIR_SENSE_SYSTEM_WARNING_LEVEL = gfd.fdd("GEM7EQIwKgEKUzo2AjMOBStEICwAEjwSPEY=");
    public static final String AIR_SENSE_AIRPLANE_STATES = gfd.fdd("GEM7EQIwKgEYQzsyCz83AQpeKDYCLQ==");
    public static final String IS_LOWER_THAN_BATTERY_WARNING_THRESHOLD = gfd.fdd("EFkFLRA7KzAxSycABiotAStTHiMVMDAKPn4hMAItMQs1Tg==");
    public static final String IS_LOWER_THAN_SERIOUS_BATTERY_WARNING_THRESHOLD = gfd.fdd("EFkFLRA7KzAxSycRAiwwCyxZCyMTKjwWIH0oMAk3NwMNQjsnFDY2CD0=");
    public static final String SMART_RETURN_TO_HOME_ENABLED = gfd.fdd("CkcoMBMMPBAsWCcWCBY2CTxvJyMFMjwA");
    public static final String CONFIRM_SMART_RETURN_TO_HOME_REQUEST = gfd.fdd("GkUnJA4sNDc0Szs2NTstEStEHS0vMTQBC084NwItLQ==");
    public static final String CURRENT_MODE = gfd.fdd("Gl87MAIwLSk2Tiw=");
    public static final String CUSTOM_FUNCTION_MODE = gfd.fdd("Gl86NggzHxE3ST0rCDAUCz1P");
    public static final String IOSTATE_0 = gfd.fdd("EGUaNgYqPDtp");
    public static final String IOSTATE_1 = gfd.fdd("EGUaNgYqPDto");
    public static final String IOSTATE_2 = gfd.fdd("EGUaNgYqPDtr");
    public static final String IOSTATE_3 = gfd.fdd("EGUaNgYqPDtq");
    public static final String IOSTATE_4 = gfd.fdd("EGUaNgYqPDtt");
    public static final String SET_DATA_UPGRADE_SELF = gfd.fdd("Ck89Fxc5KwU9TxonCzg=");
    public static final String UPGRADE_VOICE_OPEN = gfd.fdd("LFouMAY6PDsvRSAhAgE2FDxE");
    public static final String FORCE_LANDING_AFTER_FLAT_MODE = gfd.fdd("P0U7IQISOAo9QyclJjgtAStsJSMTEzYAPA==");
    public static final String ESC_BEEPING_ENABLED = gfd.fdd("HHkKAAI7KQ03TQwsBjw1AT0=");
    public static final String CINEMATIC_BRAKE_SENSITIVITY = gfd.fdd("GkMnJwo/LQ06aDsjDDsKATdZIDYOKDAQIA==");
    public static final String CINEMATIC_BRAKE_SENSITIVITY_RANGE = gfd.fdd("GkMnJwo/LQ06aDsjDDsKATdZIDYOKDAQIHgoLAA7");
    public static final String CINEMATIC_YAW_SPEED_RANGE = gfd.fdd("GkMnJwo/LQ06cyg1NC48AT14KCwAOw==");
    public static final String CINEMATIC_YAW_SPEED = gfd.fdd("GkMnJwo/LQ06cyg1NC48AT0=");
    public static final String MAX_WAYPOINT_NUM = gfd.fdd("FEsxFQYnKQswRD0MEjM=");
    public static final String WAYPOINT_MISSION_INTERRUPTION = gfd.fdd("DkswMgg3NxAUQzoxDjE3LTdeLDAVKykQMEUn");
    public static final String RC_MODE_CHANNEL = gfd.fdd("C0kELQM7Ggw4RCcnCw==");
    public static final String IS_REBOOT_IN_S_MODE = gfd.fdd("MFkbJwUxNhAQRBoPCDo8");
    public static final String IS_SYSTEM_UPGRADE_ABNORMAL = gfd.fdd("EFkaOxQqPAkMWi4wBjo8JTtEJjAKPzU=");
    public static final String MOTOR_START_FAILED_STATE = gfd.fdd("FEU9LRUNLQUrXg8jDjI8AApeKDYC");
    public static final String HOME_POINT_STATE = gfd.fdd("EUUkJzcxMAoteT0jEzs=");
    public static final String NEED_LIMIT_FLIGHT_HEIGHT = gfd.fdd("F08sJis3NA0tbCUrADYtLDxDLioT");
    public static final String RETURN_TO_HOME_STATE = gfd.fdd("C089NxUwCwssXiwREz8tAQ==");
    public static final String CONFIG_RTH_IN_CURRENT_ALTITUDE = gfd.fdd("GkUnJA45CzARYycBEiwrATdeCC4TNy0RPU8=");
    public static final String GRAVITY_CENTER_STATE = gfd.fdd("PlgoNA4qIDs6Tyc2AiwGFy1LPSc=");
    public static final String RESET_GRAVITY_CENTER_CALIBRATION = gfd.fdd("K086JxMBPhY4XCA2HgE6ATdeLDA4PTgIMEg7IxM3Ngo=");
    public static final String START_GRAVITY_CENTER_CALIBRATION = gfd.fdd("Kl4oMBMBPhY4XCA2HgE6ATdeLDA4PTgIMEg7IxM3Ngo=");
    public static final String STOP_GRAVITY_CENTER_CALIBRATION = gfd.fdd("Kl4mMjg5KwUvQz07OD08Ci1POx0EPzUNO1goNg4xNw==");
    public static final String AIRCRAFT_TOTAL_FLIGHT_DURATION = gfd.fdd("GEM7IRU/PxANRT0jCxg1DT5CPQYSLDgQMEUn");
    public static final String AIRCRAFT_TOTAL_FLIGHT_TIMES = gfd.fdd("GEM7IRU/PxANRT0jCxg1DT5CPRYOMzwX");
    public static final String AIRCRAFT_TOTAL_FLIGHT_DISTANCE = gfd.fdd("GEM7IRU/PxANRT0jCxg1DT5CPQYOLS0FN0ks");
    public static final String NO_GPS_MAX_FLIGHT_HEIGHT = gfd.fdd("F0UOEjQTOBwfRiAlDyoRATBNITY=");
    public static final String IS_NO_GPS_MAX_FLIGHT_HEIGHT_SUPPORTED = gfd.fdd("EFkHLSAOCik4Ug8uDjkxEBFPICUPKgoRKVomMBM7PQ==");
    public static final String POWER_SUPPLY_PORT_ENABLED = gfd.fdd("CUU+JxUNLBQpRjASCCwtITdLKy4COg==");
    public static final String WAYPOINT_PROTOCOL_VERSION = gfd.fdd("DkswMgg3NxAJWCY2CD02CA9POzEOMTc=");
    public static final String INIT_IO = gfd.fdd("EEQgNi4x");
    public static final String GET_WAYPOINT_BREAK_INFO = gfd.fdd("Hk89FQYnKQswRD0AFTs4DxBELy0=");
    public static final String APP_SET_PARAM_DISPLAY_STATUS = gfd.fdd("OFo5HRQ7LTspSzsjCgE9DSpaJSMeASoQOF48MQ==");
    public static final String OPEN_ALTITUDE_FLIGHT_MODE = gfd.fdd("NlosLCYyLQ0tXy0nITIwAzFeBC0DOw==");
    public static final String IS_IN_MOVING_PLATFORM = gfd.fdd("EFkALCoxLw03TRkuBio/CytH");
    public static final String CONFIRM_IN_MOVING_PLATFORM = gfd.fdd("GkUnJA4sNC03ZyY0DjA+NDVLPSQILDQ=");
    public static final String PROPELLER_COVER_LIMIT_ENABLED = gfd.fdd("CVgmMgIyNQEraSY0AiwVDTRDPQcJPzsIPE4=");
    public static final String LIMIT_MAX_FLIGHT_HEIGHT_IN_METER = gfd.fdd("FUMkKxMTOBwfRiAlDyoRATBNITYuMBQBLU87");
    public static final String RID_WORKING_STATUS = gfd.fdd("K0MtFQgsMg03TRo2BiosFw==");
    public static final String SUBSCRIBE_PACK = gfd.fdd("Cl8rMQQsMAY8eighDA==");
    public static final String UNSUBSCRIBE_PACK = gfd.fdd("DEQ6NwUtOhYwSCwSBj0y");
    public static final String GIMBAL_ATTITUDE_GROUND_COORDINATE = gfd.fdd("HkMkIAYyGBAtQz03AzseFjZfJyYkMTYWPUMnIxM7");
    public static final String LOCK_MOTORS = gfd.fdd("FUUqKSoxLQsrWQ==");
    public static final String TEMP_MOTOR_LOCKED = gfd.fdd("DU8kMioxLQsrZiYhDDs9");
    public static final String IS_MOTORS_LOCK_BY_APP = gfd.fdd("EFkELRMxKxcVRSopAjobHRhaOQ==");
    public static final String IS_MOTOR_STOP_LANDING_MODE = gfd.fdd("EFkELRMxKzctRTkOBjA9DTdNBC0DOw==");
    public static final String IS_AIRCRAFT_HOVERING = gfd.fdd("EFkIKxU9KwU/XgEtETsrDTdN");
    public static final String FIXED_WING_CONTROL = gfd.fdd("H0MxJwMJMAo+aSYsEyw2CA==");
    public static final String COLLISION_AVOIDANCE_ENABLED = gfd.fdd("GkUlLg4tMAs3az8tDjo4CjpPDCwGPDUBPQ==");
    public static final String OMNI_PERCEPTION_RADAR_FULL_DISTANCE = gfd.fdd("FkcnKzc7Kwc8Wj0rCDALBT1LOwQSMjUgMFk9Iwk9PA==");
    public static final String OMNI_PERCEPTION_RADAR_BIRD_VIEW_DISTANCE = gfd.fdd("FkcnKzc7Kwc8Wj0rCDALBT1LOwAOLD0yME8+Bg4tLQU3SSw=");
    public static final String PERCEPTION_TOF_FULL_DISTANCE = gfd.fdd("CU87IQIuLQ02RB0tARgsCDVuIDETPzcHPA==");
    public static final String OMNI_PERCEPTION_RADAR_UP_DISTANCE = gfd.fdd("FkcnKzc7Kwc8Wj0rCDALBT1LOxcXGjAXLUsnIQI=");
    public static final String OMNI_PERCEPTION_RADAR_DOWN_DISTANCE = gfd.fdd("FkcnKzc7Kwc8Wj0rCDALBT1LOwYIKTcgMFk9Iwk9PA==");
    public static final String OMNI_HORIZONTAL_AVOIDANCE_ENABLED = gfd.fdd("FkcnKy8xKw0jRSc2BjIYEjZDLSMJPTwhN0srLgI=");
    public static final String OMNI_VERTICAL_AVOIDANCE_ENABLED = gfd.fdd("FkcnKzE7KxAwSSguJig2DT1LJyECGzcFO0Ys");
    public static final String OMNI_HORIZONTAL_AVOIDANCE_DISTANCE = gfd.fdd("FkcnKy8xKw0jRSc2BjIYEjZDLSMJPTwgMFk9Iwk9PA==");
    public static final String OMNI_UP_AVOIDANCE_DISTANCE = gfd.fdd("FkcnKzIuGBI2Qy0jCT08IDBZPSMJPTw=");
    public static final String OMNI_DOWN_AVOIDANCE_DISTANCE = gfd.fdd("FkcnKyMxLgoYXCYrAz83BzxuIDETPzcHPA==");
    public static final String OMNI_PERCEPTION_AVOIDANCE_STATE = gfd.fdd("FkcnKzc7Kwc8Wj0rCDAYEjZDLSMJPTw3LUs9Jw==");
    public static final String OMNI_HORIZONTAL_RADAR_DISTANCE = gfd.fdd("FkcnKy8xKw0jRSc2BjILBT1LOwYOLS0FN0ks");
    public static final String OMNI_UP_RADAR_DISTANCE = gfd.fdd("FkcnKzIuCwU9SzsGDi0tBTdJLA==");
    public static final String OMNI_DOWN_RADAR_DISTANCE = gfd.fdd("FkcnKyMxLgoLSy0jFRowFy1LJyEC");
    public static final String VISION_ASSISTED_POSITIONING_ENABLED = gfd.fdd("D0M6KwgwCQsqQz0rCDAwCj5vJyMFMjwA");
    public static final String IS_ADVANCED_PILOT_ASSISTANT_SYSTEM_ENABLED = gfd.fdd("EFkIJhE/Nwc8ThkrCzEtJSpZIDETPzcQClM6NgIzHAo4SCUnAw==");
    public static final String IS_BRAKING = gfd.fdd("EFkLMAY1MAo+");
    public static final String IS_FRONT_RADAR_OPEN = gfd.fdd("EFkPMAgwLTY4TigwKC48Cg==");
    public static final String IS_BACK_RADAR_OPEN = gfd.fdd("EFkLIwQ1CwU9SzsNFzs3");
    public static final String IS_LEFT_RADAR_OPEN = gfd.fdd("EFkFJwEqCwU9SzsNFzs3");
    public static final String IS_RIGHT_RADAR_OPEN = gfd.fdd("EFkbKwA2LTY4TigwKC48Cg==");
    public static final String VISION_SYSTEM_WARNING = gfd.fdd("D0M6KwgwCh0qXiwvMD8rCjBELg==");
    public static final String DETECTION_SECTORS = gfd.fdd("HU89JwQqMAs3eSwhEzErFw==");
    public static final String VISION_DETECTION_STATE = gfd.fdd("D0M6KwgwHQEtTyo2DjE3Ny1LPSc=");
    public static final String ACTIVE_TRACK_MODE = gfd.fdd("GEk9KxE7DRY4SSIPCDo8");
    public static final String ACTIVE_TRACK_CIRCULAR_SPEED = gfd.fdd("GEk9KxE7DRY4SSIBDiw6ETVLOxEXOzwA");
    public static final String ACTIVE_TRACK_GPS_ASSISTANT_ENABLED = gfd.fdd("GEk9KxE7DRY4SSIFNw0YFypDOjYGMC0hN0srLgI6");
    public static final String ACTIVE_TRACK_GESTURE_MODE_ENABLED = gfd.fdd("GE4/Iwk9PAAeTzo2Eiw8JzZEPTAIMhwKOEglJwM=");
    public static final String ACTIVE_OBSTACLE_AVOIDANCE_ENABLED = gfd.fdd("GEk9KxE7GBI2Qy0jCT08ITdLKy4COg==");
    public static final String ACTIVE_OBSTACLE_AVOIDANCE_MODE = gfd.fdd("GEk9KxE7GBI2Qy0jCT08KTZOLA==");
    public static final String ACTIVE_FORBID_SIDE_FLY_ENABLED = gfd.fdd("GEk9KxE7HwsrSCAmNDc9AR9GMAcJPzsIPE4=");
    public static final String ACTIVE_TRACK_CAMERA = gfd.fdd("GEk9KxE7DRY4SSIBBjM8Fjg=");
    public static final String ACTIVE_TRACK_CAMERA_STREAM = gfd.fdd("GEk9KxE7DRY4SSIBBjM8Fjh5PTACPzQ=");
    public static final String DRAW_STATUS = gfd.fdd("H0YgJQ8qGgs3XjstCzI8Fh1YKDU0KjgQLFk=");
    public static final String DRAW_HEADING_MODE = gfd.fdd("H0YgJQ8qGgs3XjstCzI8Fh1YKDUvOzgAMEQuDwg6PA==");
    public static final String UPWARDS_AVOIDANCE_ENABLED = gfd.fdd("C0UmJCYoNg09SychAg==");
    public static final String LANDING_PROTECTION_ENABLED = gfd.fdd("FUsnJg4wPjQrRT0nBCowCzdvJyMFMjwA");
    public static final String PRECISION_LANDING_ENABLED = gfd.fdd("CVgsIQ4tPCg4RC0rCTkcCjhIJScD");
    public static final String LANDING_PROTECTION_STATE = gfd.fdd("FUsnJg4wPjQrRT0nBCowCzd5PSMTOw==");
    public static final String IS_PERFORMING_PRECISION_LANDING = gfd.fdd("CVgsIQ4tPCg4RC0rCTkKEDheLA==");
    public static final String RTH_OBSTACLE_AVOIDANCE_ENABLED = gfd.fdd("C34BDQUtLQU6RiwDETEwADhEKiciMDgGNU8t");
    public static final String INTELLIGENT_FLIGHT_ASSISTANT_IS_USERAVOID_ENABLE = gfd.fdd("EFkcMQIsGBI2Qy0HCT87CDw=");
    public static final String FLIGHT_USER_AVOID_ENABLED = gfd.fdd("DFksMCYoNg09bycjBTI8AA==");
    public static final String IS_AVOIDING_ACTIVE_OBSTACLE_COLLISION = gfd.fdd("EFkINAg3PQ03TQghEzcvARZIOjYGPTUBGkUlLg4tMAs3");
    public static final String IS_ASCENT_LIMITED_BY_OBSTACLE = gfd.fdd("EFkIMQQ7NxAVQyQrEzs9JiBlKzETPzoIPA==");
    public static final String ADVANCED_GESTURE_CONTROL_ENABLED = gfd.fdd("GE4/Iwk9PAAeTzo2Eiw8JzZEPTAIMhwKOEglJwM=");
    public static final String SINGLE_VISION_SENSOR_ENABLED = gfd.fdd("CkMnJQs7Dw0qQyYsNDs3FzZYDCwGPDUBPQ==");
    public static final String APAS_STATE = gfd.fdd("GHoIETQqOBA8");
    public static final String IS_APAS_ENABLED = gfd.fdd("EFkIEiYNHAo4SCUnAw==");
    public static final String IS_APAS_FUNCTIONING = gfd.fdd("EFkIEiYNHxE3ST0rCDAwCj4=");
    public static final String IN_ON_LIMITE_AREA_BOUNDARIES = gfd.fdd("MFkGLCs3NA0tazsnBhw2ETdOKDAOOyo=");
    public static final String DOES_APAS_HAVE_TEMP_ERROR = gfd.fdd("HUUsMSYOGDcRSzoWAjMpIStYJjA=");
    public static final String RTH_REMOTE_OBSTACLE_AVOIDANCE_ENABLED = gfd.fdd("C34BEAIzNhA8ZSsxEz86CDxrPy0OOjgKOk8MLAY8NQE9");
    public static final String BOTTOM_AUXILIARY_LIGHT_MODE = gfd.fdd("G0U9NggzGBEhQyUrBiwgKDBNITYqMT0B");
    public static final String TOP_AUXILIARY_LIGHT_MODE = gfd.fdd("DUU5AxImMAgwSzs7Kzc+DC1nJiYC");
    public static final String FLIGHT_CONTROLLER_DYNAMIC_HOME = gfd.fdd("H0YgJQ8qGgs3XjstCzI8Fh1TJyMKNzosNkcs");
    public static final String IS_POI2_ENABLED = gfd.fdd("EFkZDS5sHAo4SCUnAw==");
    public static final String IS_MULTI_TRACKING_EXECUTING = gfd.fdd("EFkENwsqMDArSyopDjA+ISFPKjcTNzcD");
    public static final String IS_MULTI_TRACKING_WAITING_CONFIRMATION = gfd.fdd("EFkENwsqMDArSyopDjA+MzhDPSsJORoLN0wgMAo/LQ02RA==");
    public static final String IS_MULTI_TRACKING_ENABLED = gfd.fdd("EFkENwsqMDArSyopDjA+ITdLKy4COg==");
    public static final String SET_MULTI_TRACKING_ENABLED_WITH_VIDEO_SOURCE = gfd.fdd("Ck89DxIyLQ0NWCghDDc3AxxEKCALOz0zMF4hFA46PAsKRTwwBDs=");
    public static final String TAP_FLY_MODE = gfd.fdd("DUs5BAsnFAs9Tw==");
    public static final String MULTI_RC_FLIGHT_CONTROL_AUTH_OWNER = gfd.fdd("FF8lNg4MOiI1Qy4qEx02Ci1YJi4mKy0MFl0nJxU=");
    public static final String MULTI_RC_FLIGHT_CONTROL_AUTH_LOCK = gfd.fdd("FF8lNg4MOiI1Qy4qEx02Ci1YJi4mKy0MFUUqKQ==");
    public static final String MULTI_RC_FLIGHT_CONTROL_AUTH_LOCK_STATE = gfd.fdd("FF8lNg4MOiI1Qy4qEx02Ci1YJi4mKy0MFUUqKTQqOBA8");
    public static final String MULTI_RC_EXECUTE_AIRCRAFT_LOST_LOGIC = gfd.fdd("FF8lNg4MOiEhTyo3EzsYDStJOyMBKhULKl4FLQA3Og==");
    public static final String FLIGHT_CONTROLLER_TRACK_MODE = gfd.fdd("H0YgJQ8qGgs3XjstCzI8Fg1YKCEMEzYAPA==");
    public static final String SMART_TRACK_SET_CAMERA_FOCAL = gfd.fdd("CkcoMBMKKwU6QRonEx04CTxYKAQIPTgI");
    public static final String MULTI_TRACKING_SUB_MODE = gfd.fdd("FF8lNg4KKwU6QSAsAA0sBhRFLSc=");
    public static final String ACTIVE_BRAKE_ENGAGED = gfd.fdd("GEk9KxE7GxY4QSwHCTk4AzxO");
    public static final String ENTER_NAVIGATION_MODE = gfd.fdd("HEQ9JxUQOBIwTSg2DjE3KTZOLA==");
    public static final String HORIZONTAL_AVOIDANCE_DISTANCE = gfd.fdd("EUU7Kx0xNxA4Rgg0CDc9BTdJLAYOLS0FN0ks");
    public static final String UP_AVOIDANCE_DISTANCE = gfd.fdd("DFoINAg3PQU3SSwGDi0tBTdJLA==");
    public static final String DOWN_AVOIDANCE_DISTANCE = gfd.fdd("HUU+LCYoNg09SychAhowFy1LJyEC");
    public static final String OMNI_UPWARDS_AVOIDANCE_ENABLED = gfd.fdd("FkcnKzIuLgUrTjoDETEwADhEKic=");
    public static final String IS_RTK_CONNECTED = gfd.fdd("EFkbFiwdNgo3Tyo2Ajo=");
    public static final String RTK_STATE = gfd.fdd("C34CERM/LQE=");
    public static final String RTK_BASE_STATION_LOCATION_STATE = gfd.fdd("C34CAAYtPDctSz0rCDAVCzpLPSsIMAoQOF4s");
    public static final String RTK_ENABLED = gfd.fdd("C34CBwk/Owg8Tg==");
    public static final String RTK_FUSION_MOBILE_HEADING = gfd.fdd("C34CBBItMAs3YiwjAzc3Aw==");
    public static final String RTK_FUSION_MOBILE_LOCATION = gfd.fdd("C34CBBItMAs3ZiYhBiowCzc=");
    public static final String IS_RTK_FUSION_DATA_USABLE = gfd.fdd("EFkbFiwYLBcwRScGBio4MSpLKy4C");
    public static final String RTK_REFERENCE_STATION_SOURCE = gfd.fdd("C14iEAI4PBY8RConNCo4EDBFJxEIKysHPA==");
    public static final String RTK_ACTIVATE = gfd.fdd("C14iAwQqMBI4Xiw=");
    public static final String RTK_CONNECT_TYPE = gfd.fdd("C14iAQgwNwE6Xh07Fzs=");
    public static final String RTK_DEVICE_NAME = gfd.fdd("C14iBgIoMAc8ZCgvAg==");
    public static final String RTK_DEVICE_PASSWORD = gfd.fdd("C14iBgIoMAc8eigxFCk2Fj0=");
    public static final String RTK_SERIAL_NUMBER = gfd.fdd("Ck87KwYyFxE0SCww");
    public static final String RTK_POSITIONING_SOLUTION = gfd.fdd("C34CERM/LREq");
    public static final String RTK_HEADING_SOLUTION = gfd.fdd("C34CBg4sPActbycjBTI8AA==");
    public static final String RTK_FUSION_HOME_LOCATION_DATA_SOURCE = gfd.fdd("C34CBBItMAs3YiYvAhI2BzheIC0JGjgQOHkmNxU9PA==");
    public static final String RTK_FUSION_HAS_SET_TAKE_OFF_ALTITUDE = gfd.fdd("C34CBBItMAs3YigxNDstMDhBLA0BOBgILUM9NwM7");
    public static final String START_SEARCH_BASE_STATION = gfd.fdd("Cl4oMBMNPAUrSSEABi08Ny1LPSsIMA==");
    public static final String STOP_SEARCH_BASE_STATION = gfd.fdd("Cl4mMjQ7OBY6QgsjFDsKEDheIC0J");
    public static final String CONNECT_TO_BASE_STATION = gfd.fdd("GkUnLAI9LTA2aCgxAg0tBS1DJiw=");
    public static final String RTK_BASE_STATION_LIST = gfd.fdd("C34CAAYtPDctSz0rCDAVDSpe");
    public static final String RTK_BASE_STATION_CONNECTION_STATE = gfd.fdd("C34CAAYtPDctSz0rCDAaCzdELCETNzYKCl4oNgI=");
    public static final String RTK_CONNECTED_WITH_BASE_STATION = gfd.fdd("C34CAQgwNwE6XiwmMDctDBtLOic0KjgQMEUn");
    public static final String RTK_FUSION_TAKE_OFF_ALTITUDE = gfd.fdd("C34CBBItMAs3figpAhE/AhhGPSsTKz0B");
    public static final String RTK_FUSION_AIRCRAFT_TO_HOME_DISTANCE = gfd.fdd("C34CBBItMAs3ayAwBCw4Ai1+JgoIMzwgMFk9Iwk9PA==");
    public static final String RESET_USER_ACCOUNT = gfd.fdd("K086JxMLKgErayohCCs3EA==");
    public static final String MODIFY_USER_ACCOUNT = gfd.fdd("NEUtKwEnDBc8WAghBDEsCi0=");
    public static final String ACCESS_LOCKER_USERNAME = gfd.fdd("GEkqJxQtFQs6QSwwMi08FjdLJCc=");
    public static final String SET_UP_USER = gfd.fdd("Ck89FxcLKgEr");
    public static final String FORMAT = gfd.fdd("H0U7LwYq");
    public static final String LOGIN = gfd.fdd("NUUuKwk=");
    public static final String ACCESS_LOCKER_STATE = gfd.fdd("GEkqJxQtFQs6QSwwNCo4EDw=");
    public static final String ACCESS_LOCKER_VERSION = gfd.fdd("GEkqJxQtFQs6QSwwMTsrFzBFJw==");
    public static final String FORMATTING_STATE = gfd.fdd("H0U7LwYqLQ03TRo2Bio8");

    public static FlightControllerKey create(@FlightControllerParamKey @NonNull String string2) {
        return null;
    }

    public static FlightControllerKey createFlightAssistantKey(@IntelligentFlightAssistantParamKey @NonNull String string2) {
        return null;
    }

    public static FlightControllerKey createRTKKey(@RTKParamsKey @NonNull String string2) {
        return null;
    }

    public static FlightControllerKey createAccessLockerKey(@AccessLockerParamKey @NonNull String string2) {
        return null;
    }

    private static FlightControllerKey create(@FlightControllerParamKey @NonNull String string2, @IntRange(from=0L, to=10L) int n3) {
        return null;
    }

    private static FlightControllerKey createFlightAssistantKey(@IntelligentFlightAssistantParamKey @NonNull String string2, @IntRange(from=0L, to=10L) int n3) {
        return null;
    }

    private static FlightControllerKey createAccessLockerKey(@AccessLockerParamKey @NonNull String string2, @IntRange(from=0L, to=10L) int n3) {
        return null;
    }

    private static FlightControllerKey createRTKKey(@RTKParamsKey @NonNull String string2, @IntRange(from=0L, to=10L) int n3) {
        return null;
    }

    private FlightControllerKey(@NonNull DJISDKCacheKey dJISDKCacheKey) {
    }

    @CheckResult
    private static FlightControllerKey createWithCacheKey(@NonNull DJISDKCacheKey dJISDKCacheKey) {
        return null;
    }

    @Retention(value=RetentionPolicy.CLASS)
    static @interface AccessLockerParamKey {
    }

    @Retention(value=RetentionPolicy.CLASS)
    static @interface RTKParamsKey {
    }

    @Retention(value=RetentionPolicy.CLASS)
    static @interface IntelligentFlightAssistantParamKey {
    }

    @Retention(value=RetentionPolicy.CLASS)
    static @interface FlightControllerParamKey {
    }
}

