/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin;

import com.djrapitops.plugin.APFPlugin;
import com.djrapitops.plugin.IPlugin;
import com.djrapitops.plugin.PluginCommon;
import com.djrapitops.plugin.benchmarking.Timings;
import com.djrapitops.plugin.command.CommandNode;
import com.djrapitops.plugin.command.velocity.VelocityCommand;
import com.djrapitops.plugin.logging.console.PluginLogger;
import com.djrapitops.plugin.logging.console.Slf4jPluginLogger;
import com.djrapitops.plugin.logging.debug.CombineDebugLogger;
import com.djrapitops.plugin.logging.debug.DebugLogger;
import com.djrapitops.plugin.logging.debug.MemoryDebugLogger;
import com.djrapitops.plugin.logging.error.DefaultErrorHandler;
import com.djrapitops.plugin.logging.error.ErrorHandler;
import com.djrapitops.plugin.task.RunnableFactory;
import com.djrapitops.plugin.task.velocity.VelocityRunnableFactory;
import com.djrapitops.plugin.utilities.Verify;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.proxy.ProxyServer;
import java.io.File;
import java.nio.file.Path;
import org.slf4j.Logger;

public abstract class VelocityPlugin
implements APFPlugin {
    protected final ProxyServer proxy;
    protected final PluginLogger logger;
    protected final CombineDebugLogger debugLogger;
    protected final DefaultErrorHandler errorHandler;
    protected final Timings timings;
    protected final RunnableFactory runnableFactory;
    private final Logger slf4jLogger;
    private final Path dataFolderPath;
    protected boolean reloading;

    public VelocityPlugin(ProxyServer proxy, Logger slf4jLogger, Path dataFolderPath) {
        this(proxy, slf4jLogger, dataFolderPath, new CombineDebugLogger(new DebugLogger[]{new MemoryDebugLogger()}));
    }

    public VelocityPlugin(ProxyServer proxy, Logger slf4jLogger, Path dataFolderPath, CombineDebugLogger debugLogger) {
        this.proxy = proxy;
        this.slf4jLogger = slf4jLogger;
        this.dataFolderPath = dataFolderPath;
        this.debugLogger = debugLogger;
        this.runnableFactory = new VelocityRunnableFactory(this, proxy.getScheduler());
        this.timings = new Timings((DebugLogger)debugLogger);
        this.logger = new Slf4jPluginLogger(slf4jLogger, this::getDebugLogger);
        this.errorHandler = new DefaultErrorHandler((IPlugin)this, this.logger, new File(this.getDataFolder(), "logs"));
    }

    public File getDataFolder() {
        return this.dataFolderPath.toFile();
    }

    public ProxyServer getProxy() {
        return this.proxy;
    }

    protected Logger getLogger() {
        return this.slf4jLogger;
    }

    public void onDisable() {
        this.runnableFactory.cancelAllKnownTasks();
    }

    public void onReload() {
    }

    public void reloadPlugin(boolean full) {
        PluginCommon.reload((APFPlugin)this, (boolean)full);
    }

    public void registerListener(Object ... listeners) {
        for (Object listener : listeners) {
            this.getProxy().getEventManager().register((Object)this, listener);
        }
    }

    public void registerCommand(String name, CommandNode command) {
        this.getProxy().getCommandManager().register((Command)new VelocityCommand(command), new String[]{name});
    }

    public String getVersion() {
        Plugin annotation = this.getClass().getAnnotation(Plugin.class);
        return ((Plugin)Verify.nullCheck((Object)annotation, () -> new IllegalStateException(this.getClass().getName() + " does not have required @Plugin annotation."))).version();
    }

    public DebugLogger getDebugLogger() {
        return this.debugLogger;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public Timings getTimings() {
        return this.timings;
    }

    public RunnableFactory getRunnableFactory() {
        return this.runnableFactory;
    }

    public PluginLogger getPluginLogger() {
        return this.logger;
    }

    public boolean isReloading() {
        return this.reloading;
    }

    public void setReloading(boolean reloading) {
        this.reloading = reloading;
    }

    public void setDebugLoggers(DebugLogger ... loggers) {
        this.debugLogger.setDebugLoggers(loggers);
    }

    public void setErrorHandlers(ErrorHandler ... errorHandlers) {
        this.errorHandler.setErrorHandlers(errorHandlers);
    }
}

