/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.logging.console;

import com.djrapitops.plugin.logging.L;
import com.djrapitops.plugin.logging.console.PluginLogger;
import com.djrapitops.plugin.logging.debug.DebugLogger;
import java.util.function.Supplier;
import org.slf4j.Logger;

public class Slf4jPluginLogger
implements PluginLogger {
    private final Supplier<DebugLogger> debugLogger;
    private final Supplier<Logger> loggerSupplier;

    public Slf4jPluginLogger(Logger loggerSupplier, Supplier<DebugLogger> debugLogger) {
        this(() -> loggerSupplier, debugLogger);
    }

    public Slf4jPluginLogger(Supplier<Logger> loggerSupplier, Supplier<DebugLogger> debugLogger) {
        this.debugLogger = debugLogger;
        this.loggerSupplier = loggerSupplier;
    }

    public void log(L level, String ... message) {
        if (level == L.DEBUG) {
            this.debugLogger.get().log(message);
            return;
        }
        if (level != L.DEBUG_INFO) {
            this.log(L.DEBUG, message);
        }
        Logger logger = this.loggerSupplier.get();
        switch (level) {
            case CRITICAL: 
            case ERROR: {
                for (String line : message) {
                    logger.error(line);
                }
                break;
            }
            case WARN: {
                for (String line : message) {
                    logger.warn(line);
                }
                break;
            }
            case DEBUG_INFO: {
                for (String line : message) {
                    logger.info("[DEBUG] {}", (Object)line);
                }
                break;
            }
            default: {
                for (String line : message) {
                    logger.info(line);
                }
            }
        }
    }

    public void log(L level, String message, Throwable throwable) {
        Logger logger = this.loggerSupplier.get();
        switch (level) {
            case CRITICAL: 
            case ERROR: {
                logger.error(message, throwable);
                break;
            }
            default: {
                logger.warn(message, throwable);
            }
        }
    }

    public DebugLogger getDebugLogger() {
        return this.debugLogger.get();
    }
}

