/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.task.velocity;

import com.djrapitops.plugin.VelocityPlugin;
import com.djrapitops.plugin.api.TimeAmount;
import com.djrapitops.plugin.task.PluginRunnable;
import com.djrapitops.plugin.task.PluginTask;
import com.djrapitops.plugin.task.velocity.AbsVelocityTask;
import com.velocitypowered.api.scheduler.Scheduler;
import java.util.concurrent.TimeUnit;

abstract class AbsVelocityRunnable
implements PluginRunnable,
Runnable {
    private final String name;
    private final long time;
    private VelocityPlugin plugin;
    private Scheduler scheduler;
    private AbsVelocityTask task;

    AbsVelocityRunnable(String name, VelocityPlugin plugin, Scheduler scheduler, long time) {
        this.time = time;
        this.scheduler = scheduler;
        this.plugin = plugin;
        this.name = name;
    }

    AbsVelocityTask getTask() {
        return this.task;
    }

    public String getTaskName() {
        return this.name;
    }

    public void cancel() {
        if (this.scheduler == null) {
            return;
        }
        try {
            if (this.task != null) {
                this.task.cancel();
            }
        }
        finally {
            this.scheduler = null;
        }
    }

    public int getTaskId() {
        return -1;
    }

    public PluginTask runTask() {
        return this.runTaskAsynchronously();
    }

    public PluginTask runTaskAsynchronously() {
        this.task = new AbsVelocityTask(this.scheduler.buildTask((Object)this.plugin, (Runnable)this).schedule());
        return this.task;
    }

    public PluginTask runTaskLater(long delay) {
        return this.runTaskLaterAsynchronously(delay);
    }

    public PluginTask runTaskLaterAsynchronously(long delay) {
        this.task = new AbsVelocityTask(this.scheduler.buildTask((Object)this.plugin, (Runnable)this).delay(TimeAmount.ticksToMillis((long)delay), TimeUnit.MILLISECONDS).schedule());
        return this.task;
    }

    public PluginTask runTaskTimer(long delay, long period) {
        return this.runTaskTimerAsynchronously(delay, period);
    }

    public PluginTask runTaskTimerAsynchronously(long delay, long period) {
        this.task = new AbsVelocityTask(this.scheduler.buildTask((Object)this.plugin, (Runnable)this).delay(TimeAmount.ticksToMillis((long)delay), TimeUnit.MILLISECONDS).repeat(TimeAmount.ticksToMillis((long)delay), TimeUnit.MILLISECONDS).schedule());
        return this.task;
    }

    public long getTime() {
        return this.time;
    }
}

