/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.task.velocity;

import com.djrapitops.plugin.VelocityPlugin;
import com.djrapitops.plugin.task.AbsRunnable;
import com.djrapitops.plugin.task.PluginRunnable;
import com.djrapitops.plugin.task.RunnableFactory;
import com.djrapitops.plugin.task.velocity.AbsVelocityRunnable;
import com.velocitypowered.api.scheduler.Scheduler;
import java.util.HashSet;
import java.util.Set;

public class VelocityRunnableFactory
extends RunnableFactory {
    private final VelocityPlugin plugin;
    private final Scheduler scheduler;
    private volatile Set<AbsVelocityRunnable> tasks;

    public VelocityRunnableFactory(VelocityPlugin plugin, Scheduler scheduler) {
        this.plugin = plugin;
        this.scheduler = scheduler;
        this.tasks = new HashSet<AbsVelocityRunnable>();
    }

    protected PluginRunnable createNewRunnable(String name, final AbsRunnable runnable, long time) {
        this.cleanUp();
        return new AbsVelocityRunnable(name, this.plugin, this.scheduler, time){

            @Override
            public void run() {
                VelocityRunnableFactory.this.setCancellable(runnable, this);
                runnable.run();
            }
        };
    }

    private void cleanUp() {
        this.tasks.removeIf(runnable -> runnable.getTask().isFinished());
    }

    public void cancelAllKnownTasks() {
        this.tasks.forEach(PluginRunnable::cancel);
        this.tasks.clear();
    }
}

