/*!
 * Angular Material Design
 * https://github.com/angular/material
 * @license MIT
 * v1.1.0-rc4-master-c26842a
 */
function MdNavBar(t){return{restrict:"E",transclude:!0,controller:MdNavBarController,controllerAs:"ctrl",bindToController:!0,scope:{mdSelectedNavItem:"=?",navBarAriaLabel:"@?"},template:'<div class="md-nav-bar"><nav role="navigation"><ul class="_md-nav-bar-list" layout="row" ng-transclude role="listbox"tabindex="0"ng-focus="ctrl.onFocus()"ng-blur="ctrl.onBlur()"ng-keydown="ctrl.onKeydown($event)"aria-label="{{ctrl.navBarAriaLabel}}"></ul></nav><md-nav-ink-bar></md-nav-ink-bar></div>',link:function(e,n,a,r){r.navBarAriaLabel||t.expectAsync(n,"aria-label",angular.noop)}}}function MdNavBarController(t,e,n,a){this._$timeout=n,this._$scope=e,this._$mdConstant=a,this.mdSelectedNavItem,this.navBarAriaLabel,this._navBarEl=t[0],this._inkbar;var r=this,o=this._$scope.$watch(function(){return r._navBarEl.querySelectorAll("._md-nav-button").length},function(t){t>0&&(r._initTabs(),o())})}function MdNavItem(t){return{restrict:"E",require:["mdNavItem","^mdNavBar"],controller:MdNavItemController,bindToController:!0,controllerAs:"ctrl",replace:!0,transclude:!0,template:'<li class="md-nav-item" role="option" aria-selected="{{ctrl.isSelected()}}"><md-button ng-if="ctrl.mdNavSref" class="_md-nav-button md-accent"ng-class="ctrl.getNgClassMap()"tabindex="-1"ui-sref="{{ctrl.mdNavSref}}"><span ng-transclude class="_md-nav-button-text"></span></md-button><md-button ng-if="ctrl.mdNavHref" class="_md-nav-button md-accent"ng-class="ctrl.getNgClassMap()"tabindex="-1"ng-href="{{ctrl.mdNavHref}}"><span ng-transclude class="_md-nav-button-text"></span></md-button><md-button ng-if="ctrl.mdNavClick" class="_md-nav-button md-accent"ng-class="ctrl.getNgClassMap()"tabindex="-1"ng-click="ctrl.mdNavClick()"><span ng-transclude class="_md-nav-button-text"></span></md-button></li>',scope:{mdNavClick:"&?",mdNavHref:"@?",mdNavSref:"@?",name:"@"},link:function(e,n,a,r){var o=r[0],l=r[1];t(function(){o.name||(o.name=angular.element(n[0].querySelector("._md-nav-button-text")).text().trim());var t=angular.element(n[0].querySelector("._md-nav-button"));t.on("click",function(){l.mdSelectedNavItem=o.name,e.$apply()})})}}}function MdNavItemController(t){this._$element=t,this.mdNavClick,this.mdNavHref,this.name,this._selected=!1,this._focused=!1;var e=!!t.attr("md-nav-click"),n=!!t.attr("md-nav-href"),a=!!t.attr("md-nav-sref");if((e?1:0)+(n?1:0)+(a?1:0)>1)throw Error("Must specify exactly one of md-nav-click, md-nav-href, md-nav-sref for nav-item directive")}goog.provide("ng.material.components.navBar"),goog.require("ng.material.core"),angular.module("material.components.navBar",["material.core"]).controller("MdNavBarController",MdNavBarController).directive("mdNavBar",MdNavBar).controller("MdNavItemController",MdNavItemController).directive("mdNavItem",MdNavItem),MdNavBar.$inject=["$mdAria"],MdNavBarController.$inject=["$element","$scope","$timeout","$mdConstant"],MdNavBarController.prototype._initTabs=function(){this._inkbar=angular.element(this._navBarEl.getElementsByTagName("md-nav-ink-bar")[0]);var t=this;this._$timeout(function(){t._updateTabs(t.mdSelectedNavItem,void 0)}),this._$scope.$watch("ctrl.mdSelectedNavItem",function(e,n){t._$timeout(function(){t._updateTabs(e,n)})})},MdNavBarController.prototype._updateTabs=function(t,e){var n,a=this._getTabs();if(e){var r=this._getTabByName(e);r&&(r.setSelected(!1),n=a.indexOf(r))}if(t){var o=this._getTabByName(t);if(o){o.setSelected(!0);var l=a.indexOf(o),i=this;this._$timeout(function(){i._updateInkBarStyles(o,l,n)})}}},MdNavBarController.prototype._updateInkBarStyles=function(t,e,n){var a=t.getButtonEl(),r=a.offsetLeft;this._inkbar.toggleClass("_md-left",n>e).toggleClass("_md-right",e>n),this._inkbar.css({left:r+"px",width:a.offsetWidth+"px"})},MdNavBarController.prototype._getTabs=function(){var t=Array.prototype.slice.call(this._navBarEl.querySelectorAll(".md-nav-item"));return t.map(function(t){return angular.element(t).controller("mdNavItem")})},MdNavBarController.prototype._getTabByName=function(t){return this._findTab(function(e){return e.getName()==t})},MdNavBarController.prototype._getSelectedTab=function(){return this._findTab(function(t){return t.isSelected()})},MdNavBarController.prototype.getFocusedTab=function(){return this._findTab(function(t){return t.hasFocus()})},MdNavBarController.prototype._findTab=function(t){for(var e=this._getTabs(),n=0;n<e.length;n++)if(t(e[n]))return e[n];return null},MdNavBarController.prototype.onFocus=function(){var t=this._getSelectedTab();t&&t.setFocused(!0)},MdNavBarController.prototype.onBlur=function(){var t=this.getFocusedTab();t&&t.setFocused(!1)},MdNavBarController.prototype._moveFocus=function(t,e){t.setFocused(!1),e.setFocused(!0)},MdNavBarController.prototype.onKeydown=function(t){var e=this._$mdConstant.KEY_CODE,n=this._getTabs(),a=this.getFocusedTab();if(a){var r=n.indexOf(a);switch(t.keyCode){case e.UP_ARROW:case e.LEFT_ARROW:r>0&&this._moveFocus(a,n[r-1]);break;case e.DOWN_ARROW:case e.RIGHT_ARROW:r<n.length-1&&this._moveFocus(a,n[r+1]);break;case e.SPACE:case e.ENTER:this._$timeout(function(){a.getButtonEl().click()})}}},MdNavItem.$inject=["$$rAF"],MdNavItemController.$inject=["$element"],MdNavItemController.prototype.getNgClassMap=function(){return{"md-active":this._selected,"md-primary":this._selected,"md-unselected":!this._selected,"md-focused":this._focused}},MdNavItemController.prototype.getName=function(){return this.name},MdNavItemController.prototype.getButtonEl=function(){return this._$element[0].querySelector("._md-nav-button")},MdNavItemController.prototype.setSelected=function(t){this._selected=t},MdNavItemController.prototype.isSelected=function(){return this._selected},MdNavItemController.prototype.setFocused=function(t){this._focused=t},MdNavItemController.prototype.hasFocus=function(){return this._focused},ng.material.components.navBar=angular.module("material.components.navBar");