/*
 * Decompiled with CFR 0.152.
 */
package com.dlmorais.livelog;

import com.dlmorais.livelog.AnalyticDataDTO;
import com.dlmorais.livelog.LiveLogConfig;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/analytics")
@Produces(value={"application/json"})
@RolesAllowed(value={""})
public class AnalyticTableAPI {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    public Response get(@QueryParam(value="f") String file) {
        HashMap analysis = new HashMap();
        try (Stream<String> lines = null;){
            Pattern pattern = Pattern.compile(LiveLogConfig.getContentRegex());
            lines = Files.lines(Paths.get(LiveLogConfig.getLogFilePath(file), new String[0]));
            lines.forEach(l -> {
                Matcher matcher = pattern.matcher((CharSequence)l);
                if (matcher.find()) {
                    StringBuilder group = new StringBuilder();
                    for (int i = 1; i <= matcher.groupCount(); ++i) {
                        group.append(matcher.group(i)).append(" ");
                    }
                    String groupStr = group.toString();
                    analysis.merge(groupStr, new AnalyticDataDTO(groupStr, 1L), (v1, v2) -> {
                        v1.increment();
                        return v1;
                    });
                }
            });
            Response response = Response.ok(analysis.values()).build();
            return response;
        }
    }
}

