/*
 * Decompiled with CFR 0.152.
 */
package com.dlmorais.livelog;

import com.dlmorais.livelog.LiveLogConfig;
import java.io.File;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/list-files")
@Produces(value={"application/json"})
@RolesAllowed(value={""})
public class FileListAPI {
    @GET
    public Response get() {
        File logDir = new File(LiveLogConfig.getLogDir());
        File[] files = logDir.listFiles();
        return Response.ok(Arrays.stream(files).map(f -> f.getName()).collect(Collectors.toList())).build();
    }

    @GET
    @Path(value="/default-filter")
    public Response getDefaultFilter() {
        return Response.ok((Object)LiveLogConfig.getDefaultFileFilter(), (String)"text/plain").build();
    }
}

