/*
 * Decompiled with CFR 0.152.
 */
package com.dlmorais.livelog;

import com.dlmorais.livelog.CustomGroupDTO;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public final class LiveLogConfig {
    public static Optional<String> LOG_DIR = null;
    public static Optional<String> CONTENT_REGEX = null;
    public static Optional<String> DEFAULT_FILE_FILTER = null;

    private static String getValueFromWebXml(String name, boolean ignoreName) {
        try {
            Context env = (Context)new InitialContext().lookup("java:comp/env");
            return (String)env.lookup(name);
        }
        catch (NamingException e) {
            if (!ignoreName) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            return null;
        }
    }

    public static String getSecureToken() {
        return LiveLogConfig.getValueFromWebXml("livelog-secure-token", true);
    }

    public static String getLogDir() {
        if (LOG_DIR == null) {
            LOG_DIR = Optional.ofNullable(LiveLogConfig.getValueFromWebXml("livelog-logdir", false));
        }
        return LOG_DIR.orElse(null);
    }

    public static String getLogFilePath(String fileName) {
        String logDir = LiveLogConfig.getLogDir();
        StringBuilder sb = new StringBuilder(logDir);
        if (!logDir.endsWith("/") && !logDir.endsWith(File.separator)) {
            sb.append(File.separator);
        }
        sb.append(fileName);
        return sb.toString();
    }

    public static String getDefaultFileFilter() {
        if (DEFAULT_FILE_FILTER == null) {
            DEFAULT_FILE_FILTER = Optional.ofNullable(LiveLogConfig.getValueFromWebXml("livelog-defaultfilefilter", true));
        }
        return DEFAULT_FILE_FILTER.orElse(null);
    }

    public static String getContentRegex() {
        if (CONTENT_REGEX == null) {
            CONTENT_REGEX = Optional.ofNullable(LiveLogConfig.getValueFromWebXml("livelog-contentregex", true));
        }
        return CONTENT_REGEX.orElse(null);
    }

    public static List<CustomGroupDTO> getCustomGroupings() {
        ArrayList<CustomGroupDTO> groupings = new ArrayList<CustomGroupDTO>();
        int counter = 1;
        String name = null;
        while ((name = LiveLogConfig.getValueFromWebXml("livelog-customgroup-" + counter + "-name", true)) != null) {
            String color = LiveLogConfig.getValueFromWebXml("livelog-customgroup-" + counter + "-color", false);
            String regex = LiveLogConfig.getValueFromWebXml("livelog-customgroup-" + counter + "-regex", false);
            if (regex != null) {
                CustomGroupDTO customGroupDTO = new CustomGroupDTO(name, regex);
                customGroupDTO.setColor(Optional.ofNullable(color).orElse("gray"));
                groupings.add(customGroupDTO);
            } else {
                System.err.println("LiveLog - Custom grouping defined without regular expression :: " + name);
            }
            ++counter;
        }
        return groupings;
    }
}

