/*
 * Decompiled with CFR 0.152.
 */
package com.dlmorais.livelog;

import com.dlmorais.livelog.LiveLogConfig;
import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;

@PreMatching
public class SimpleAuthenticationFilter
implements ContainerRequestFilter {
    @Context
    private HttpServletRequest request;

    public void filter(final ContainerRequestContext requestContext) throws IOException {
        requestContext.setSecurityContext(new SecurityContext(){

            public boolean isUserInRole(String role) {
                return this.getUserPrincipal() != null;
            }

            public Principal getUserPrincipal() {
                String secureToken = LiveLogConfig.getSecureToken();
                if (secureToken == null || "".equals(secureToken)) {
                    return () -> "User";
                }
                Cookie[] cookies = SimpleAuthenticationFilter.this.request.getCookies();
                if (cookies != null) {
                    String llstCookie = (String)SimpleAuthenticationFilter.this.request.getSession().getAttribute("llst");
                    Cookie cookie = Arrays.stream(cookies).filter(c -> c.getName().equals("llst")).findFirst().orElse(null);
                    if (cookie != null && cookie.getValue().equals(llstCookie)) {
                        return () -> "User";
                    }
                }
                return null;
            }

            public boolean isSecure() {
                return requestContext.getSecurityContext().isSecure();
            }

            public String getAuthenticationScheme() {
                return requestContext.getSecurityContext().getAuthenticationScheme();
            }
        });
    }
}

