/*
 * Decompiled with CFR 0.152.
 */
package com.dlmorais.livelog;

import com.dlmorais.livelog.CustomGroupDTO;
import com.dlmorais.livelog.LiveLogConfig;
import com.dlmorais.livelog.LogLineDTO;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.LongAdder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/tail")
@Produces(value={"application/json"})
@RolesAllowed(value={""})
public class TailerAPI {
    @Context
    private HttpServletRequest request;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    public Response get(@QueryParam(value="f") String file, @QueryParam(value="l") Integer fromLine, @QueryParam(value="n") Integer numberOfLines) throws IOException {
        this.defineCurrentFile(file);
        try (Stream<String> lines = null;){
            lines = Files.lines(Paths.get(LiveLogConfig.getLogFilePath(file), new String[0]));
            long startLine = 0L;
            if (fromLine != null) {
                startLine = fromLine - 1;
            }
            ArrayList content = new ArrayList();
            Integer numLines = Optional.ofNullable(numberOfLines).orElse(100);
            List<CustomGroupDTO> customGroupings = this.getGroupings();
            LongAdder adder = new LongAdder();
            adder.add(startLine);
            lines.skip(startLine).forEach(l -> {
                for (CustomGroupDTO customGroupDTO : customGroupings) {
                    Matcher matcher = Pattern.compile(customGroupDTO.getRegex()).matcher((CharSequence)l);
                    if (!matcher.find()) continue;
                    customGroupDTO.increment();
                }
                adder.increment();
                LogLineDTO dto = new LogLineDTO();
                dto.setLine(adder.sum());
                dto.setContent((String)l);
                content.add(dto);
                if (fromLine == null && content.size() > numLines) {
                    content.remove(0);
                }
            });
            Response response = Response.ok(content).build();
            return response;
        }
    }

    private List<CustomGroupDTO> getGroupings() {
        HttpSession session = this.request.getSession();
        List<CustomGroupDTO> customGroupings = (List<CustomGroupDTO>)session.getAttribute("customGroupings");
        if (customGroupings == null) {
            customGroupings = LiveLogConfig.getCustomGroupings();
            session.setAttribute("customGroupings", customGroupings);
        }
        return customGroupings;
    }

    private void defineCurrentFile(String file) {
        HttpSession session = this.request.getSession();
        String currentFile = (String)session.getAttribute("livelog-currentfile");
        if (currentFile == null || !currentFile.equals(file)) {
            currentFile = file;
            session.setAttribute("livelog-currentfile", (Object)currentFile);
            session.removeAttribute("customGroupings");
        }
    }
}

