/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gmapsfx.javascript;

import com.dlsc.gmapsfx.javascript.JavascriptFunctionLine;
import com.dlsc.gmapsfx.javascript.JavascriptObject;
import java.util.List;

public class JavascriptFunction
extends JavascriptObject {
    protected String functionName;
    protected List<String> args;
    protected List<JavascriptFunctionLine> functionLines;

    public JavascriptFunction(String functionName, List<String> args, List<JavascriptFunctionLine> functionLines) {
        this.functionName = functionName;
        this.args = args;
        this.functionLines = functionLines;
    }

    public String getFunctionAsString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.functionName).append("(");
        if (this.args.isEmpty()) {
            sb.append(")");
        } else {
            for (String arg : this.args) {
                sb.append(arg).append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(")");
        }
        sb.append("{\n");
        for (JavascriptFunctionLine line : this.functionLines) {
            sb.append(line.getFunctionLine());
        }
        sb.append("}");
        return sb.toString();
    }
}

