/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gmapsfx.service.geocoding;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import netscape.javascript.JSObject;

public class GeocoderUtils {
    public static List<JSObject> getJSObjectsFromArray(JSObject jsArray) {
        ArrayList<JSObject> result = new ArrayList<JSObject>();
        boolean keepLooking = true;
        int index = 0;
        while (keepLooking) {
            try {
                JSObject jsGeocoderResult = (JSObject)jsArray.getSlot(index++);
                if (jsGeocoderResult != null) {
                    result.add(jsGeocoderResult);
                    continue;
                }
                keepLooking = false;
            }
            catch (Exception e) {
                keepLooking = false;
            }
        }
        return result;
    }

    public static <T extends Enum> List<T> convertJSObjectToListOfEnum(JSObject jsObject, Class<T> enumClass) {
        ArrayList<Enum> result = new ArrayList<Enum>();
        if (jsObject != null) {
            try {
                String jsTypesString = jsObject.toString();
                for (Enum value : (Enum[])enumClass.getEnumConstants()) {
                    if (!jsTypesString.toLowerCase().contains(value.name().toLowerCase())) continue;
                    result.add(value);
                }
            }
            catch (Exception e) {
                Logger.getLogger(GeocoderUtils.class.getName()).log(Level.SEVERE, "", e);
            }
        }
        return result;
    }
}

