/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gmapsfx.shapes;

import com.dlsc.gmapsfx.javascript.object.LatLong;
import com.dlsc.gmapsfx.javascript.object.MVCArray;
import com.dlsc.gmapsfx.shapes.PolygonOptions;
import com.dlsc.gmapsfx.shapes.PolylineOptions;
import javafx.scene.shape.ArcType;

public class ArcBuilder {
    private static final int DEFAULT_ARC_POINTS = 32;

    public static final PolygonOptions buildClosedArc(LatLong center, LatLong start, LatLong end, ArcType arcType) {
        MVCArray res = ArcBuilder.buildArcPoints(center, start, end);
        if (ArcType.ROUND.equals((Object)arcType)) {
            res.push(center);
        }
        return new PolygonOptions().paths(res);
    }

    public static final PolylineOptions buildOpenArc(LatLong center, LatLong start, LatLong end) {
        MVCArray res = ArcBuilder.buildArcPoints(center, start, end);
        return new PolylineOptions().path(res);
    }

    public static final MVCArray buildArcPoints(LatLong center, LatLong start, LatLong end) {
        return ArcBuilder.buildArcPoints(center, center.getBearing(start), center.getBearing(end), center.distanceFrom(start));
    }

    public static final MVCArray buildArcPoints(LatLong center, double startBearing, double endBearing, double radius) {
        int points = 32;
        MVCArray res = new MVCArray();
        if (startBearing > endBearing) {
            endBearing += 360.0;
        }
        double deltaBearing = endBearing - startBearing;
        deltaBearing /= (double)points;
        for (int i = 0; i < points + 1; ++i) {
            res.push(center.getDestinationPoint(startBearing + (double)i * deltaBearing, radius));
        }
        return res;
    }
}

