/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gmapsfx;

import com.dlsc.gmapsfx.javascript.JavaFxWebEngine;
import com.dlsc.gmapsfx.javascript.JavascriptArray;
import com.dlsc.gmapsfx.javascript.JavascriptObject;
import com.dlsc.gmapsfx.javascript.JavascriptRuntime;
import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.BorderPane;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import netscape.javascript.JSObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayTester
extends Application {
    private static final Logger LOG = LoggerFactory.getLogger(ArrayTester.class);
    protected WebView webview;
    protected JavaFxWebEngine webengine;

    public void start(Stage stage) throws Exception {
        this.webview = new WebView();
        this.webengine = new JavaFxWebEngine(this.webview.getEngine());
        JavascriptRuntime.setDefaultWebEngine(this.webengine);
        BorderPane bp = new BorderPane();
        bp.setCenter((Node)this.webview);
        this.webengine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

            public void changed(ObservableValue ov, Worker.State oldState, Worker.State newState) {
                if (newState == Worker.State.SUCCEEDED) {
                    ArrayTester.this.runTests();
                }
            }
        });
        this.webengine.load(((Object)((Object)this)).getClass().getResource("/com/dlsc/gmapsfx/html/arrays.html").toExternalForm());
        Scene scene = new Scene((Parent)bp, 600.0, 600.0);
        stage.setScene(scene);
        stage.show();
    }

    private void runTests() {
        JSObject jsWin = (JSObject)this.webengine.executeScript("window");
        jsWin.call("displayTest", new Object[]{null});
        JavascriptArray ary = new JavascriptArray();
        int len = 0;
        for (int i = 0; i < 6; ++i) {
            len = ary.push("String " + i);
            LOG.debug("testArrays push " + i + " gives len: " + len);
        }
        LOG.debug("testArrays toString: " + ary.toString());
        ary.reverse();
        LOG.debug("testArrays reverse toString: " + ary.toString());
        ary.reverse();
        Object obj = ary.pop();
        LOG.debug("testArrays popped: " + obj);
        LOG.debug("testArrays popped toString: " + ary.toString());
        TestJSO jso = new TestJSO();
        jso.setTestName("Test 1");
        ary.unshift(jso);
        LOG.debug("testArrays unshift JsO toString: " + ary.toString());
        Object jso1 = ary.shift();
        LOG.debug("testArrays shift JsO: " + jso1);
        LOG.debug("testArrays shift JsO reference equality: " + (jso == jso1));
        LOG.debug("testArrays shift JsO toString: " + ary.toString());
        ary.push(jso);
        LOG.debug("testArrays push JsO toString: " + ary.toString());
        jsWin.call("displayArray", ary);
        jso.setTestName("Altered Test 1");
        jsWin.call("displayArray", ary);
        LOG.debug("testArrays alter JsO toString: " + ary.toString());
        Object jso2 = ary.get(ary.length() - 1);
        LOG.debug("testArrays get JsO2: " + jso2);
        jsWin.call("iterateArray", ary);
        jsWin.call("displayTestEnd", new Object[]{null});
    }

    public static void main(String[] args) {
        System.setProperty("java.net.useSystemProxies", "true");
        ArrayTester.launch((String[])args);
    }

    class TestJSO
    extends JavascriptObject {
        public TestJSO() {
            super("Object");
        }

        public void setTestName(String testName) {
            this.setProperty("testName", testName);
        }

        public String getTestName() {
            return this.getProperty("testName", String.class);
        }

        public String toString() {
            return this.getTestName();
        }
    }
}

