/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gmapsfx.service.directions;

import com.dlsc.gmapsfx.javascript.JavascriptObject;
import com.dlsc.gmapsfx.service.directions.DirectionStatus;
import com.dlsc.gmapsfx.service.directions.DirectionsRenderer;
import com.dlsc.gmapsfx.service.directions.DirectionsRequest;
import com.dlsc.gmapsfx.service.directions.DirectionsResult;
import com.dlsc.gmapsfx.service.directions.DirectionsServiceCallback;
import netscape.javascript.JSObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectionsService
extends JavascriptObject {
    private static final Logger LOG = LoggerFactory.getLogger(DirectionsService.class);
    public DirectionsServiceCallback callback;
    public DirectionsRenderer renderer;

    public DirectionsService() {
        super("google.maps.DirectionsService");
    }

    public void getRoute(DirectionsRequest req, DirectionsServiceCallback callback, DirectionsRenderer renderer) {
        this.callback = callback;
        this.renderer = renderer;
        JSObject doc = (JSObject)this.getJSObject().eval("document");
        doc.setMember(this.getVariableName(), this);
        StringBuilder r = new StringBuilder(this.getVariableName()).append(".").append("route(").append(req.getVariableName()).append(", ").append("function(results, status) {\n").append("if(status === 'OK'){\n").append(renderer.getVariableName()).append(".setDirections(results);\ndocument.").append(this.getVariableName()).append(".processResponse(results, status);\n}").append("});");
        LOG.trace("Directions direct call: " + r.toString());
        try {
            this.getJSObject().eval(r.toString());
        }
        catch (Throwable t) {
            LOG.error(t.getMessage());
        }
    }

    public void processResponse(Object results, Object status) {
        LOG.trace("STATUS: {}", status);
        DirectionStatus pStatus = DirectionStatus.UNKNOWN_ERROR;
        if (status instanceof String && results instanceof JSObject && DirectionStatus.OK.equals((Object)(pStatus = DirectionStatus.valueOf((String)status)))) {
            LOG.trace("\n\nResults: " + results);
            DirectionsResult ers = new DirectionsResult((JSObject)results);
            this.callback.directionsReceived(ers, pStatus);
            return;
        }
        this.callback.directionsReceived(new DirectionsResult(), pStatus);
    }
}

