/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gmapsfx.service.geocoding;

import com.dlsc.gmapsfx.javascript.JavascriptObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeocoderComponentRestrictions
extends JavascriptObject {
    private static final Logger LOG = LoggerFactory.getLogger(GeocoderComponentRestrictions.class);

    public GeocoderComponentRestrictions(String administrativeArea, String country, String locality, String postalCode, String route) {
        super("google.maps.GeocoderComponentRestrictions", GeocoderComponentRestrictions.buildJavascriptString(administrativeArea, country, locality, postalCode, route));
    }

    public static String buildJavascriptString(String administrativeArea, String country, String locality, String postalCode, String route) {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        if (administrativeArea != null) {
            builder.append("administrativeArea: '").append(administrativeArea).append("'");
        }
        builder.append(",");
        if (country != null) {
            builder.append("country: '").append(country).append("'");
        }
        builder.append(",");
        if (locality != null) {
            builder.append("locality: '").append(locality).append("'");
        }
        builder.append(",");
        if (postalCode != null) {
            builder.append("postalCode: '").append(postalCode).append("'");
        }
        builder.append(",");
        if (route != null) {
            builder.append("route: '").append(route).append("'");
        }
        builder.append("}");
        LOG.trace("COMPONENT " + builder.toString());
        return builder.toString();
    }
}

