/*
 * Copyright 2014 Lynden, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.dlsc.gmapsfx.javascript;

import netscape.javascript.JSObject;

/**
 *
 * @author Rob Terpilowski
 */
public class JavascriptEnum  {

    protected IJavascriptRuntime runtime;
    protected String type;
    protected String name;
    protected Object value;

    
    protected JavascriptEnum(String type, String name) {
        this.type = type;
        this.name = name;
        runtime = JavascriptRuntime.getInstance();

    }

    public Object getEnumValue() {
        if (value == null) {
            JSObject jsObject = runtime.execute(type);
            value = jsObject.getMember(name);
        }
        return value;
    }

    public String getType() {
        return type;
    }

    public String getName() {
        return name;
    }
    
}
