/*
 * Copyright 2014 Geoff Capper.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.dlsc.gmapsfx.shapes;

import com.dlsc.gmapsfx.javascript.object.GMapObjectType;
import com.dlsc.gmapsfx.javascript.object.MVCArray;
import com.dlsc.gmapsfx.javascript.object.MapShape;
import netscape.javascript.JSObject;

/**
 *
 * @author Geoff Capper
 */
public class Polygon extends MapShape {
    
    public Polygon() {
        super(GMapObjectType.POLYGON);
    }
    
    public Polygon(PolygonOptions opts) {
        super(GMapObjectType.POLYGON, opts);
    }
    
    public MVCArray getPath() {
        return new MVCArray((JSObject) invokeJavascript("getPath"));
    }
    
    public MVCArray getPaths() {
        return new MVCArray((JSObject) invokeJavascript("getPaths"));
    }
    
    public void setPath(MVCArray path) {
        invokeJavascript("setPath", path);
    }
    
    public void setPaths(MVCArray paths) {
        invokeJavascript("setPaths", paths);
    }
    
}
