/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gmapsfx.service.directions;

import com.dlsc.gmapsfx.javascript.JavascriptObject;
import com.dlsc.gmapsfx.javascript.object.DirectionsPane;
import com.dlsc.gmapsfx.javascript.object.GoogleMap;
import netscape.javascript.JSObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectionsRenderer
extends JavascriptObject {
    private static final Logger LOG = LoggerFactory.getLogger(DirectionsRenderer.class);

    public DirectionsRenderer() {
        super("google.maps.DirectionsRenderer");
    }

    public DirectionsRenderer(JSObject type) {
        super("google.maps.DirectionsRenderer", type);
        LOG.trace("map: " + this.getJSObject().getMember("map").toString() + "\ndraggable: " + this.getJSObject().getMember("draggable").toString());
    }

    public DirectionsRenderer(boolean drag, GoogleMap map, DirectionsPane panel) {
        super("google.maps.DirectionsRenderer");
        this.getJSObject().eval(this.getVariableName() + ".setOptions({draggable:" + drag + "});");
        this.getJSObject().eval(this.getVariableName() + ".setMap(" + map.getVariableName() + ");");
        this.getJSObject().eval(this.getVariableName() + ".setPanel(" + panel.getVariableName() + ");");
    }

    public DirectionsRenderer(boolean drag, GoogleMap map, DirectionsPane panel, String strokeColor) {
        super("google.maps.DirectionsRenderer");
        this.getJSObject().eval(this.getVariableName() + ".setOptions({draggable:" + drag + ", polylineOptions: { strokeColor: '" + strokeColor + "'}});");
        this.getJSObject().eval(this.getVariableName() + ".setMap(" + map.getVariableName() + ");");
        this.getJSObject().eval(this.getVariableName() + ".setPanel(" + panel.getVariableName() + ");");
    }

    public void setMap(GoogleMap map) {
        if (map == null) {
            this.getJSObject().eval(this.getVariableName() + ".setMap(null);");
        } else {
            this.getJSObject().eval(this.getVariableName() + ".setMap(" + map.getVariableName() + ");");
        }
    }

    public void clearDirections() {
        this.setMap(null);
    }

    public void setOptions(String options) {
        this.getJSObject().eval(this.getVariableName() + ".setOptions({draggable:" + options + "});");
    }

    public void setPanel(DirectionsPane panel) {
        this.getJSObject().eval(this.getVariableName() + ".setPanel(" + panel.getVariableName() + ");");
    }

    public int getRoutesCount() {
        return Integer.valueOf(this.getJSObject().eval(this.getVariableName() + ".directions.routes.length").toString());
    }

    public void setRouteIndex(int index) {
        this.getJSObject().eval(this.getVariableName() + ".setRouteIndex(" + index + ");");
    }

    public String toString() {
        return "map: " + this.getJSObject().getMember("map").toString() + "\ndraggable: " + this.getJSObject().getMember("draggable").toString() + "\npanel: " + this.getJSObject().getMember("panel").toString() + "\ndirections: " + this.getJSObject().getMember("directions").toString();
    }
}

