/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.jfxcentral.data;

import com.dlsc.jfxcentral.data.model.Blog;
import com.dlsc.jfxcentral.data.model.Book;
import com.dlsc.jfxcentral.data.model.Company;
import com.dlsc.jfxcentral.data.model.Coordinates;
import com.dlsc.jfxcentral.data.model.Documentation;
import com.dlsc.jfxcentral.data.model.Download;
import com.dlsc.jfxcentral.data.model.IkonliPack;
import com.dlsc.jfxcentral.data.model.LearnJavaFX;
import com.dlsc.jfxcentral.data.model.LearnMobile;
import com.dlsc.jfxcentral.data.model.LearnRaspberryPi;
import com.dlsc.jfxcentral.data.model.Library;
import com.dlsc.jfxcentral.data.model.LibraryInfo;
import com.dlsc.jfxcentral.data.model.LinksOfTheWeek;
import com.dlsc.jfxcentral.data.model.Member;
import com.dlsc.jfxcentral.data.model.ModelObject;
import com.dlsc.jfxcentral.data.model.News;
import com.dlsc.jfxcentral.data.model.Person;
import com.dlsc.jfxcentral.data.model.Post;
import com.dlsc.jfxcentral.data.model.RealWorldApp;
import com.dlsc.jfxcentral.data.model.Tip;
import com.dlsc.jfxcentral.data.model.Tool;
import com.dlsc.jfxcentral.data.model.Tutorial;
import com.dlsc.jfxcentral.data.model.Utility;
import com.dlsc.jfxcentral.data.model.Video;
import com.dlsc.jfxcentral.data.pull.PullRequest;
import com.dlsc.jfxcentral.data.util.QueryResult;
import com.fatboyindustrial.gsonjavatime.Converters;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.rometools.rome.feed.synd.SyndEntry;
import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.io.SyndFeedInput;
import com.rometools.rome.io.XmlReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.apache.commons.lang3.StringUtils;

public class DataRepository {
    private static final Logger LOG = Logger.getLogger(DataRepository.class.getName());
    public static File REPO_DIRECTORY = new File(System.getProperty("jfxcentral.repo", new File(System.getProperty("user.home"), ".jfxcentralrepo").getAbsolutePath())).getAbsoluteFile();
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static DataRepository instance;
    private final Gson gson = Converters.registerLocalDate((GsonBuilder)new GsonBuilder()).setPrettyPrinting().create();
    private final Map<Library, ObjectProperty<LibraryInfo>> libraryInfoMap = new HashMap<Library, ObjectProperty<LibraryInfo>>();
    private final Map<News, StringProperty> newsTextMap = new HashMap<News, StringProperty>();
    private final Map<Tutorial, StringProperty> tutorialTextMap = new HashMap<Tutorial, StringProperty>();
    private final Map<Download, StringProperty> downloadTextMap = new HashMap<Download, StringProperty>();
    private final Map<Book, StringProperty> bookTextMap = new HashMap<Book, StringProperty>();
    private final Map<Person, StringProperty> personDescriptionMap = new HashMap<Person, StringProperty>();
    private final Map<Tool, StringProperty> toolDescriptionMap = new HashMap<Tool, StringProperty>();
    private final Map<Utility, StringProperty> utilityDescriptionMap = new HashMap<Utility, StringProperty>();
    private final Map<Tip, StringProperty> tipDescriptionMap = new HashMap<Tip, StringProperty>();
    private final Map<RealWorldApp, StringProperty> realWorldAppDescriptionMap = new HashMap<RealWorldApp, StringProperty>();
    private final Map<Company, StringProperty> companyDescriptionMap = new HashMap<Company, StringProperty>();
    private final Map<Library, StringProperty> libraryReadMeMap = new HashMap<Library, StringProperty>();
    private final Map<LinksOfTheWeek, StringProperty> linksOfTheWeekReadMeMap = new HashMap<LinksOfTheWeek, StringProperty>();
    private final Map<Member, StringProperty> memberDescriptionMap = new HashMap<Member, StringProperty>();
    private final Map<LearnJavaFX, StringProperty> learnJavaFXDescriptionMap = new HashMap<LearnJavaFX, StringProperty>();
    private final Map<LearnMobile, StringProperty> learnMobileDescriptionMap = new HashMap<LearnMobile, StringProperty>();
    private final Map<LearnRaspberryPi, StringProperty> learnRaspberryPiDescriptionMap = new HashMap<LearnRaspberryPi, StringProperty>();
    private boolean loaded;
    public static boolean testing;
    private final ObservableList<ModelObject> recentItems = FXCollections.observableArrayList();
    private final StringProperty homeText = new SimpleStringProperty((Object)this, "homeText");
    private final StringProperty openJFXText = new SimpleStringProperty((Object)this, "openJFXText");
    private final ObservableList<Library> libraries = FXCollections.observableArrayList();
    private final ObservableList<Blog> blogs = FXCollections.observableArrayList();
    private final ObservableList<News> news = FXCollections.observableArrayList();
    private final ObservableList<Book> books = FXCollections.observableArrayList();
    private final ObservableList<LinksOfTheWeek> linksOfTheWeek = FXCollections.observableArrayList();
    private final ObservableList<Tip> tips = FXCollections.observableArrayList();
    private final ObservableList<Tutorial> tutorials = FXCollections.observableArrayList();
    private final ObservableList<Video> videos = FXCollections.observableArrayList();
    private final ObservableList<Download> downloads = FXCollections.observableArrayList();
    private final ObservableList<RealWorldApp> realWorldApps = FXCollections.observableArrayList();
    private final ObservableList<Tool> tools = FXCollections.observableArrayList();
    private final ObservableList<Utility> utilities = FXCollections.observableArrayList();
    private final ObservableList<Company> companies = FXCollections.observableArrayList();
    private final ObservableList<Person> people = FXCollections.observableArrayList();
    private final ObservableList<IkonliPack> ikonliPacks = FXCollections.observableArrayList();
    private final ObservableList<Member> members = FXCollections.observableArrayList();
    private final ObservableList<Documentation> documentation = FXCollections.observableArrayList();
    private final ObservableList<LearnJavaFX> learnJavaFX = FXCollections.observableArrayList();
    private final ObservableList<LearnMobile> learnMobile = FXCollections.observableArrayList();
    private final ObservableList<LearnRaspberryPi> learnRaspberryPi = FXCollections.observableArrayList();
    private long cachedPullrequestsTime;
    private final long timeToReloadSeconds = 600L;
    private List<PullRequest> cachedPullRequests;

    public static synchronized DataRepository getInstance() {
        if (instance == null) {
            instance = new DataRepository();
        }
        return instance;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    private DataRepository() {
    }

    public void loadData() {
        this.doLoadData("explicit call to refresh method");
    }

    public void clearData() {
        this.loaded = false;
        this.setHomeText("");
        this.setOpenJFXText("");
        this.libraryInfoMap.clear();
        this.libraryReadMeMap.clear();
        this.newsTextMap.clear();
        this.personDescriptionMap.clear();
        this.companyDescriptionMap.clear();
        this.toolDescriptionMap.clear();
        this.utilityDescriptionMap.clear();
        this.tipDescriptionMap.clear();
        this.realWorldAppDescriptionMap.clear();
        this.downloadTextMap.clear();
        this.bookTextMap.clear();
        this.tutorialTextMap.clear();
        this.linksOfTheWeekReadMeMap.clear();
        this.memberDescriptionMap.clear();
        this.learnJavaFXDescriptionMap.clear();
        this.learnMobileDescriptionMap.clear();
        this.learnRaspberryPiDescriptionMap.clear();
        this.getPeople().clear();
        this.getLibraries().clear();
        this.getBooks().clear();
        this.getNews().clear();
        this.getVideos().clear();
        this.getBlogs().clear();
        this.getCompanies().clear();
        this.getTools().clear();
        this.getUtilities().clear();
        this.getRealWorldApps().clear();
        this.getDownloads().clear();
        this.getTutorials().clear();
        this.getTips().clear();
        this.getLinksOfTheWeek().clear();
        this.getIkonliPacks().clear();
        this.getMembers().clear();
        this.getDocumentation().clear();
        this.getLearnJavaFX().clear();
        this.getLearnMobile().clear();
        this.getLearnRaspberryPi().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLoadData(String reason) {
        LOG.fine("loading data, reason = " + reason);
        try {
            String homeText = this.loadString(new File(this.getRepositoryDirectory(), "intro.md"));
            String openJFXText = this.loadString(new File(this.getRepositoryDirectory(), "openjfx/intro.md"));
            List<Person> people = this.loadModel("people/people.json", new TypeToken<List<Person>>(){});
            List<Book> books = this.loadModel("books/books.json", new TypeToken<List<Book>>(){});
            List<Video> videos = this.loadModel("videos/videos.json", new TypeToken<List<Video>>(){});
            List<Library> libraries = this.loadModel("libraries/libraries.json", new TypeToken<List<Library>>(){});
            List<News> news = this.loadModel("news/news.json", new TypeToken<List<News>>(){});
            List<Blog> blogs = this.loadModel("blogs/blogs.json", new TypeToken<List<Blog>>(){});
            List<Company> companies = this.loadModel("companies/companies.json", new TypeToken<List<Company>>(){});
            List<Tool> tools = this.loadModel("tools/tools.json", new TypeToken<List<Tool>>(){});
            List<Utility> utilities = this.loadModel("utilities/utilities.json", new TypeToken<List<Utility>>(){});
            List<RealWorldApp> realWorldApps = this.loadModel("realworld/realworld.json", new TypeToken<List<RealWorldApp>>(){});
            List<Download> downloads = this.loadModel("downloads/downloads.json", new TypeToken<List<Download>>(){});
            List<Tutorial> tutorials = this.loadModel("tutorials/tutorials.json", new TypeToken<List<Tutorial>>(){});
            List<Tip> tips = this.loadModel("tips/tips.json", new TypeToken<List<Tip>>(){});
            List<LinksOfTheWeek> links = this.loadModel("links/links.json", new TypeToken<List<LinksOfTheWeek>>(){});
            List<IkonliPack> ikonliPacks = this.loadModel("ikonlipacks/ikonlipacks.json", new TypeToken<List<IkonliPack>>(){});
            List<Member> members = this.loadModel("members/members.json", new TypeToken<List<Member>>(){});
            List<Documentation> documentation = this.loadModel("documentation/documentation.json", new TypeToken<List<Documentation>>(){});
            List<LearnJavaFX> learnJavaFX = this.loadModel("learn/javafx/learn.json", new TypeToken<List<LearnJavaFX>>(){});
            List<LearnMobile> learnMobile = this.loadModel("learn/mobile/learn.json", new TypeToken<List<LearnMobile>>(){});
            List<LearnRaspberryPi> learnRaspberryPi = this.loadModel("learn/raspberrypi/learn.json", new TypeToken<List<LearnRaspberryPi>>(){});
            this.setData(homeText, openJFXText, people, books, videos, libraries, news, blogs, companies, tools, utilities, realWorldApps, downloads, tutorials, tips, links, ikonliPacks, members, documentation, learnJavaFX, learnMobile, learnRaspberryPi);
            LOG.fine("data loading finished");
        }
        catch (Exception e) {
            LOG.severe("data loading failed: " + e.getMessage());
        }
        finally {
            this.loaded = true;
        }
    }

    private <T> List<T> loadModel(String path, TypeToken<List<T>> typeToken) {
        List list;
        File file = new File(this.getRepositoryDirectory(), path);
        FileReader fileReader = new FileReader(file, StandardCharsets.UTF_8);
        try {
            list = (List)this.gson.fromJson((Reader)fileReader, typeToken.getType());
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.severe("failed to load model from file " + path + ": " + e.getMessage());
                return Collections.emptyList();
            }
        }
        fileReader.close();
        return list;
    }

    private void setData(String homeText, String openJFXText, List<Person> people, List<Book> books, List<Video> videos, List<Library> libraries, List<News> news, List<Blog> blogs, List<Company> companies, List<Tool> tools, List<Utility> utilities, List<RealWorldApp> realWorldApps, List<Download> downloads, List<Tutorial> tutorials, List<Tip> tips, List<LinksOfTheWeek> links, List<IkonliPack> ikonliPacks, List<Member> members, List<Documentation> documentation, List<LearnJavaFX> learnJavaFX, List<LearnMobile> learnMobile, List<LearnRaspberryPi> learnRaspberryPi) {
        this.clearData();
        this.setOpenJFXText(openJFXText);
        this.setHomeText(homeText);
        this.getPeople().setAll(people);
        this.getBooks().setAll(books);
        this.getVideos().setAll(videos);
        this.getLibraries().setAll(libraries);
        this.getNews().setAll(news);
        this.getBlogs().setAll(blogs);
        this.getCompanies().setAll(companies);
        this.getTools().setAll(tools);
        this.getUtilities().setAll(utilities);
        this.getRealWorldApps().setAll(realWorldApps);
        this.getDownloads().setAll(downloads);
        this.getTutorials().setAll(tutorials);
        this.getTips().setAll(tips);
        this.getLinksOfTheWeek().setAll(links);
        this.getIkonliPacks().setAll(ikonliPacks);
        this.getMembers().setAll(members);
        this.getDocumentation().setAll(documentation);
        this.getLearnJavaFX().setAll(learnJavaFX);
        this.getLearnMobile().setAll(learnMobile);
        this.getLearnRaspberryPi().setAll(learnRaspberryPi);
        List<ModelObject> recentItems = this.findRecentItems();
        this.getRecentItems().setAll(recentItems);
    }

    private List<ModelObject> findRecentItems() {
        ArrayList<ModelObject> result = new ArrayList<ModelObject>();
        result.addAll(this.findRecentItems((List<? extends ModelObject>)this.getPeople()));
        result.addAll(this.findRecentItems((List<? extends ModelObject>)this.getBooks()));
        result.addAll(this.findRecentItems((List<? extends ModelObject>)this.getLibraries()));
        result.addAll(this.findRecentItems((List<? extends ModelObject>)this.getVideos()));
        result.addAll(this.findRecentItems((List<? extends ModelObject>)this.getBlogs()));
        result.addAll(this.findRecentItems((List<? extends ModelObject>)this.getCompanies()));
        result.addAll(this.findRecentItems((List<? extends ModelObject>)this.getTools()));
        result.addAll(this.findRecentItems((List<? extends ModelObject>)this.getUtilities()));
        result.addAll(this.findRecentItems((List<? extends ModelObject>)this.getTutorials()));
        result.addAll(this.findRecentItems((List<? extends ModelObject>)this.getRealWorldApps()));
        result.addAll(this.findRecentItems((List<? extends ModelObject>)this.getDownloads()));
        result.addAll(this.findRecentItems((List<? extends ModelObject>)this.getTips()));
        result.addAll(this.findRecentItems((List<? extends ModelObject>)this.getIkonliPacks()));
        result.addAll(this.findRecentItems((List<? extends ModelObject>)this.getMembers()));
        result.addAll(this.findRecentItems((List<? extends ModelObject>)this.getDocumentation()));
        result.addAll(this.findRecentItems((List<? extends ModelObject>)this.getLearnJavaFX()));
        result.addAll(this.findRecentItems((List<? extends ModelObject>)this.getLearnMobile()));
        result.addAll(this.findRecentItems((List<? extends ModelObject>)this.getLearnRaspberryPi()));
        Collections.sort(result, Comparator.comparing(ModelObject::getCreationOrUpdateDate).reversed());
        return result;
    }

    private List<ModelObject> findRecentItems(List<? extends ModelObject> items) {
        ArrayList<ModelObject> result = new ArrayList<ModelObject>();
        LocalDate today = LocalDate.now();
        items.forEach(item -> {
            LocalDate date = item.getModifiedOn();
            if (date == null) {
                date = item.getCreatedOn();
            }
            if (date != null && date.isAfter(today.minusWeeks(8L))) {
                result.add((ModelObject)item);
            }
        });
        return result;
    }

    public ObservableList<ModelObject> getRecentItems() {
        return this.recentItems;
    }

    public Optional<Person> getPersonById(String id) {
        return this.people.stream().filter(item -> item.getId().equals(id)).findFirst();
    }

    public Optional<Company> getCompanyById(String id) {
        return this.companies.stream().filter(item -> item.getId().equals(id)).findFirst();
    }

    public Optional<Library> getLibraryById(String id) {
        return this.libraries.stream().filter(item -> item.getId().equals(id)).findFirst();
    }

    public Optional<Book> getBookById(String id) {
        return this.books.stream().filter(item -> item.getId().equals(id)).findFirst();
    }

    public Optional<Blog> getBlogById(String id) {
        return this.blogs.stream().filter(item -> item.getId().equals(id)).findFirst();
    }

    public Optional<RealWorldApp> getRealWorldAppById(String id) {
        return this.realWorldApps.stream().filter(item -> item.getId().equals(id)).findFirst();
    }

    public Optional<Tool> getToolById(String id) {
        return this.tools.stream().filter(item -> item.getId().equals(id)).findFirst();
    }

    public Optional<Utility> getUtilityById(String id) {
        return this.utilities.stream().filter(item -> item.getId().equals(id)).findFirst();
    }

    public Optional<Download> getDownloadById(String id) {
        return this.downloads.stream().filter(item -> item.getId().equals(id)).findFirst();
    }

    public Optional<News> getNewsById(String id) {
        return this.news.stream().filter(item -> item.getId().equals(id)).findFirst();
    }

    public Optional<Video> getVideoById(String id) {
        return this.videos.stream().filter(item -> item.getId().equals(id)).findFirst();
    }

    public Optional<Tutorial> getTutorialById(String id) {
        return this.tutorials.stream().filter(item -> item.getId().equals(id)).findFirst();
    }

    public Optional<Tip> getTipById(String id) {
        return this.tips.stream().filter(item -> item.getId().equals(id)).findFirst();
    }

    public Optional<LinksOfTheWeek> getLinksOfTheWeekById(String id) {
        return this.linksOfTheWeek.stream().filter(item -> item.getId().equals(id)).findFirst();
    }

    public Optional<IkonliPack> getIkonliPackById(String id) {
        return this.ikonliPacks.stream().filter(item -> item.getId().equals(id)).findFirst();
    }

    public Optional<Member> getMemberById(String id) {
        return this.members.stream().filter(item -> item.getId().equals(id)).findFirst();
    }

    public Optional<Documentation> getDocumentationById(String id) {
        return this.documentation.stream().filter(item -> item.getId().equals(id)).findFirst();
    }

    public Optional<LearnJavaFX> getLearnJavaFXById(String id) {
        return this.learnJavaFX.stream().filter(item -> item.getId().equals(id)).findFirst();
    }

    public Optional<LearnMobile> getLearnMobileById(String id) {
        return this.learnMobile.stream().filter(item -> item.getId().equals(id)).findFirst();
    }

    public Optional<LearnRaspberryPi> getLearnRaspberryPiById(String id) {
        return this.learnRaspberryPi.stream().filter(item -> item.getId().equals(id)).findFirst();
    }

    public <T extends ModelObject> ObservableList<T> getLinkedObjects(ModelObject modelObject, Class<T> clazz) {
        List<T> itemList = this.getList(clazz);
        List<String> idsList = this.getIdList(modelObject, clazz);
        ObservableList list = FXCollections.observableArrayList();
        list.setAll((Collection)itemList.stream().filter(item -> idsList.contains(item.getId()) || this.getIdList((ModelObject)item, modelObject.getClass()).contains(modelObject.getId())).collect(Collectors.toList()));
        return list;
    }

    private <T extends ModelObject> List<String> getIdList(ModelObject modelObject, Class<T> clazz) {
        if (clazz.equals(Video.class)) {
            return modelObject.getVideoIds();
        }
        if (clazz.equals(Book.class)) {
            return modelObject.getBookIds();
        }
        if (clazz.equals(Library.class)) {
            return modelObject.getLibraryIds();
        }
        if (clazz.equals(Tutorial.class)) {
            return modelObject.getTutorialIds();
        }
        if (clazz.equals(Download.class)) {
            return modelObject.getDownloadIds();
        }
        if (clazz.equals(Person.class)) {
            return modelObject.getPersonIds();
        }
        if (clazz.equals(Tool.class)) {
            return modelObject.getToolIds();
        }
        if (clazz.equals(Utility.class)) {
            return modelObject.getUtilityIds();
        }
        if (clazz.equals(RealWorldApp.class)) {
            return modelObject.getAppIds();
        }
        if (clazz.equals(News.class)) {
            return modelObject.getNewsIds();
        }
        if (clazz.equals(Blog.class)) {
            return modelObject.getBlogIds();
        }
        if (clazz.equals(Company.class)) {
            return modelObject.getCompanyIds();
        }
        if (clazz.equals(Tip.class)) {
            return modelObject.getTipIds();
        }
        if (clazz.equals(LinksOfTheWeek.class)) {
            return modelObject.getLinksOfTheWeekIds();
        }
        if (clazz.equals(IkonliPack.class)) {
            return modelObject.getIkonliPackIds();
        }
        if (clazz.equals(Member.class)) {
            return modelObject.getMemberIds();
        }
        if (clazz.equals(Documentation.class)) {
            return modelObject.getDocumentationIds();
        }
        if (clazz.equals(LearnJavaFX.class)) {
            return modelObject.getLearnJavaFXIds();
        }
        if (clazz.equals(LearnMobile.class)) {
            return modelObject.getLearnMobileIds();
        }
        if (clazz.equals(LearnRaspberryPi.class)) {
            return modelObject.getLearnRaspberryPiIds();
        }
        throw new IllegalArgumentException("unsupported class type: " + clazz.getSimpleName());
    }

    public <T extends ModelObject> List<T> getList(Class<T> clazz) {
        if (clazz.equals(Video.class)) {
            return this.videos;
        }
        if (clazz.equals(Book.class)) {
            return this.books;
        }
        if (clazz.equals(Library.class)) {
            return this.libraries;
        }
        if (clazz.equals(Tutorial.class)) {
            return this.tutorials;
        }
        if (clazz.equals(Download.class)) {
            return this.downloads;
        }
        if (clazz.equals(Person.class)) {
            return this.people;
        }
        if (clazz.equals(Tool.class)) {
            return this.tools;
        }
        if (clazz.equals(Utility.class)) {
            return this.utilities;
        }
        if (clazz.equals(RealWorldApp.class)) {
            return this.realWorldApps;
        }
        if (clazz.equals(News.class)) {
            return this.news;
        }
        if (clazz.equals(Blog.class)) {
            return this.blogs;
        }
        if (clazz.equals(Company.class)) {
            return this.companies;
        }
        if (clazz.equals(Tip.class)) {
            return this.tips;
        }
        if (clazz.equals(LinksOfTheWeek.class)) {
            return this.linksOfTheWeek;
        }
        if (clazz.equals(IkonliPack.class)) {
            return this.ikonliPacks;
        }
        if (clazz.equals(Member.class)) {
            return this.members;
        }
        if (clazz.equals(Documentation.class)) {
            return this.documentation;
        }
        if (clazz.equals(LearnJavaFX.class)) {
            return this.learnJavaFX;
        }
        if (clazz.equals(LearnMobile.class)) {
            return this.learnMobile;
        }
        if (clazz.equals(LearnRaspberryPi.class)) {
            return this.learnRaspberryPi;
        }
        throw new IllegalArgumentException("unsupported class type: " + clazz.getSimpleName());
    }

    public ModelObject getByID(Class<? extends ModelObject> clz, String id) {
        return this.getList(clz).stream().filter(item -> item.getId().equals(id)).findFirst().get();
    }

    public ObservableList<Video> getVideosByModelObject(ModelObject modelObject) {
        return this.getLinkedObjects(modelObject, Video.class);
    }

    public ObservableList<Download> getDownloadsByModelObject(ModelObject modelObject) {
        return this.getLinkedObjects(modelObject, Download.class);
    }

    public ObservableList<LearnJavaFX> getLearnJavaFXByModelObject(ModelObject modelObject) {
        return this.getLinkedObjects(modelObject, LearnJavaFX.class);
    }

    public ObservableList<LearnMobile> getLearnMobileByModelObject(ModelObject modelObject) {
        return this.getLinkedObjects(modelObject, LearnMobile.class);
    }

    public ObservableList<LearnRaspberryPi> getLearnRaspberryPiByModelObject(ModelObject modelObject) {
        return this.getLinkedObjects(modelObject, LearnRaspberryPi.class);
    }

    public ObservableList<Book> getBooksByModelObject(ModelObject modelObject) {
        return this.getLinkedObjects(modelObject, Book.class);
    }

    public ObservableList<Tutorial> getTutorialsByModelObject(ModelObject modelObject) {
        return this.getLinkedObjects(modelObject, Tutorial.class);
    }

    public ObservableList<Blog> getBlogsByModelObject(ModelObject modelObject) {
        return this.getLinkedObjects(modelObject, Blog.class);
    }

    public ObservableList<Library> getLibrariesByModelObject(ModelObject modelObject) {
        return this.getLinkedObjects(modelObject, Library.class);
    }

    public ObservableList<Tool> getToolsByModelObject(ModelObject modelObject) {
        return this.getLinkedObjects(modelObject, Tool.class);
    }

    public ObservableList<News> getNewsByModelObject(ModelObject modelObject) {
        return this.getLinkedObjects(modelObject, News.class);
    }

    public ObservableList<Company> getCompaniesByModelObject(ModelObject modelObject) {
        return this.getLinkedObjects(modelObject, Company.class);
    }

    public ObservableList<RealWorldApp> getRealWorldAppsByModelObject(ModelObject modelObject) {
        return this.getLinkedObjects(modelObject, RealWorldApp.class);
    }

    public ObservableList<Person> getPeopleByModelObject(ModelObject modelObject) {
        return this.getLinkedObjects(modelObject, Person.class);
    }

    public ObservableList<Tip> getTipsByModelObject(ModelObject modelObject) {
        return this.getLinkedObjects(modelObject, Tip.class);
    }

    public ObservableList<LinksOfTheWeek> getLinksOfTheWeekByModelObject(ModelObject modelObject) {
        return this.getLinkedObjects(modelObject, LinksOfTheWeek.class);
    }

    public ObjectProperty<LibraryInfo> libraryInfoProperty(Library library) {
        return this.libraryInfoMap.computeIfAbsent(library, key -> {
            SimpleObjectProperty infoProperty = new SimpleObjectProperty();
            this.loadLibraryInfo(library, (ObjectProperty<LibraryInfo>)infoProperty);
            return infoProperty;
        });
    }

    private void loadLibraryInfo(Library library, ObjectProperty<LibraryInfo> infoProperty) {
        try {
            String libraryId = library.getId();
            File file = new File(this.getRepositoryDirectory(), "libraries/" + libraryId + "/info.json");
            try (FileReader reader = new FileReader(file, StandardCharsets.UTF_8);){
                LibraryInfo result = (LibraryInfo)this.gson.fromJson((Reader)reader, LibraryInfo.class);
                infoProperty.set((Object)result);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public StringProperty newsTextProperty(News news) {
        return this.newsTextMap.computeIfAbsent(news, key -> {
            SimpleStringProperty textProperty = new SimpleStringProperty();
            this.loadNewsText(news, (StringProperty)textProperty);
            return textProperty;
        });
    }

    private void loadNewsText(News news, StringProperty textProperty) {
        String text = this.loadString(new File(this.getNewsDirectory(news), "/text.md"));
        textProperty.set((Object)text);
    }

    public StringProperty linksOfTheWeekTextProperty(LinksOfTheWeek links) {
        return this.linksOfTheWeekReadMeMap.computeIfAbsent(links, key -> {
            SimpleStringProperty textProperty = new SimpleStringProperty();
            this.loadLinksOfTheWeekText(links, (StringProperty)textProperty);
            return textProperty;
        });
    }

    public void loadLinksOfTheWeekText(LinksOfTheWeek links, StringProperty textProperty) {
        String text = this.loadString(new File(this.getRepositoryDirectory(), "links/" + links.getId() + "/readme.md"));
        textProperty.set((Object)text);
    }

    public StringProperty tutorialTextProperty(Tutorial tutorial) {
        return this.tutorialTextMap.computeIfAbsent(tutorial, key -> {
            SimpleStringProperty textProperty = new SimpleStringProperty();
            this.loadTutorialText(tutorial, (StringProperty)textProperty);
            return textProperty;
        });
    }

    private void loadTutorialText(Tutorial tutorial, StringProperty textProperty) {
        String text = this.loadString(new File(this.getRepositoryDirectory(), "tutorials/" + tutorial.getId() + "/readme.md"));
        textProperty.set((Object)text);
    }

    public StringProperty downloadTextProperty(Download download) {
        return this.downloadTextMap.computeIfAbsent(download, key -> {
            SimpleStringProperty textProperty = new SimpleStringProperty();
            this.loadDownloadText(download, (StringProperty)textProperty);
            return textProperty;
        });
    }

    private void loadDownloadText(Download download, StringProperty textProperty) {
        String text = this.loadString(new File(this.getRepositoryDirectory(), "downloads/" + download.getId() + "/readme.md"));
        textProperty.set((Object)text);
    }

    public StringProperty bookTextProperty(Book book) {
        return this.bookTextMap.computeIfAbsent(book, key -> {
            SimpleStringProperty textProperty = new SimpleStringProperty();
            this.loadBookText(book, (StringProperty)textProperty);
            return textProperty;
        });
    }

    private void loadBookText(Book book, StringProperty textProperty) {
        String text = this.loadString(new File(this.getRepositoryDirectory(), "books/" + book.getId() + "/readme.md"));
        textProperty.set((Object)text);
    }

    public StringProperty personDescriptionProperty(Person person) {
        return this.personDescriptionMap.computeIfAbsent(person, key -> {
            SimpleStringProperty readmeProperty = new SimpleStringProperty();
            this.loadPersonDescription(person, (StringProperty)readmeProperty);
            return readmeProperty;
        });
    }

    private void loadPersonDescription(Person person, StringProperty readmeProperty) {
        String readmeText = this.loadString(new File(this.getRepositoryDirectory(), "people/" + person.getId() + "/readme.md"));
        readmeProperty.set((Object)readmeText);
    }

    public StringProperty memberDescriptionProperty(Member member) {
        return this.memberDescriptionMap.computeIfAbsent(member, key -> {
            SimpleStringProperty readmeProperty = new SimpleStringProperty();
            this.loadMemberDescription(member, (StringProperty)readmeProperty);
            return readmeProperty;
        });
    }

    private void loadMemberDescription(Member member, StringProperty readmeProperty) {
        String readmeText = this.loadString(new File(this.getRepositoryDirectory(), "members/" + member.getId() + "/readme.md"));
        readmeProperty.set((Object)readmeText);
    }

    public StringProperty toolDescriptionProperty(Tool tool) {
        return this.toolDescriptionMap.computeIfAbsent(tool, key -> {
            SimpleStringProperty readmeProperty = new SimpleStringProperty();
            this.loadToolDescription(tool, (StringProperty)readmeProperty);
            return readmeProperty;
        });
    }

    private void loadToolDescription(Tool tool, StringProperty readmeProperty) {
        String readmeText = this.loadString(new File(this.getRepositoryDirectory(), "tools/" + tool.getId() + "/readme.md"));
        readmeProperty.set((Object)readmeText);
    }

    public StringProperty utilityDescriptionProperty(Utility utility) {
        return this.utilityDescriptionMap.computeIfAbsent(utility, key -> {
            SimpleStringProperty readmeProperty = new SimpleStringProperty();
            this.loadUtilityDescription(utility, (StringProperty)readmeProperty);
            return readmeProperty;
        });
    }

    private void loadUtilityDescription(Utility utility, StringProperty readmeProperty) {
        String readmeText = this.loadString(new File(this.getRepositoryDirectory(), "utilities/" + utility.getId() + "/readme.md"));
        readmeProperty.set((Object)readmeText);
    }

    public StringProperty tipDescriptionProperty(Tip tip) {
        return this.tipDescriptionMap.computeIfAbsent(tip, key -> {
            SimpleStringProperty readmeProperty = new SimpleStringProperty();
            this.loadTipDescription(tip, (StringProperty)readmeProperty);
            return readmeProperty;
        });
    }

    private void loadTipDescription(Tip tip, StringProperty readmeProperty) {
        String readmeText = this.loadString(new File(this.getRepositoryDirectory(), "tips/" + tip.getId() + "/readme.md"));
        readmeProperty.set((Object)readmeText);
    }

    public StringProperty realWorldAppDescriptionProperty(RealWorldApp app) {
        return this.realWorldAppDescriptionMap.computeIfAbsent(app, key -> {
            SimpleStringProperty readmeProperty = new SimpleStringProperty();
            this.loadRealWorldDescription(app, (StringProperty)readmeProperty);
            return readmeProperty;
        });
    }

    private void loadRealWorldDescription(RealWorldApp app, StringProperty readmeProperty) {
        String readmeText = this.loadString(new File(this.getRepositoryDirectory(), "realworld/" + app.getId() + "/readme.md"));
        readmeProperty.set((Object)readmeText);
    }

    public StringProperty companyDescriptionProperty(Company company) {
        return this.companyDescriptionMap.computeIfAbsent(company, key -> {
            SimpleStringProperty readmeProperty = new SimpleStringProperty();
            this.loadCompanyDescription(company, (StringProperty)readmeProperty);
            return readmeProperty;
        });
    }

    private void loadCompanyDescription(Company company, StringProperty readmeProperty) {
        String readmeText = this.loadString(new File(this.getRepositoryDirectory(), "companies/" + company.getId() + "/readme.md"));
        readmeProperty.set((Object)readmeText);
    }

    private void loadLearnJavaFXReadMe(LearnJavaFX learnJavaFX, StringProperty readmeProperty) {
        String readmeText = this.loadString(new File(this.getRepositoryDirectory(), "learn/javafx/" + learnJavaFX.getId() + "/readme.md"));
        readmeProperty.set((Object)readmeText);
    }

    public StringProperty learnJavaFXReadMeProperty(LearnJavaFX learnJavaFX) {
        return this.learnJavaFXDescriptionMap.computeIfAbsent(learnJavaFX, key -> {
            SimpleStringProperty readmeProperty = new SimpleStringProperty();
            this.loadLearnJavaFXReadMe(learnJavaFX, (StringProperty)readmeProperty);
            return readmeProperty;
        });
    }

    private void loadLearnMobileReadMe(LearnMobile learnMobile, StringProperty readmeProperty) {
        String readmeText = this.loadString(new File(this.getRepositoryDirectory(), "learn/mobile/" + learnMobile.getId() + "/readme.md"));
        readmeProperty.set((Object)readmeText);
    }

    public StringProperty learnMobileReadMeProperty(LearnMobile learnMobile) {
        return this.learnMobileDescriptionMap.computeIfAbsent(learnMobile, key -> {
            SimpleStringProperty readmeProperty = new SimpleStringProperty();
            this.loadLearnMobileReadMe(learnMobile, (StringProperty)readmeProperty);
            return readmeProperty;
        });
    }

    private void loadLearnRaspberryPiReadMe(LearnRaspberryPi learnRaspberryPi, StringProperty readmeProperty) {
        String readmeText = this.loadString(new File(this.getRepositoryDirectory(), "learn/raspberrypi/" + learnRaspberryPi.getId() + "/readme.md"));
        readmeProperty.set((Object)readmeText);
    }

    public StringProperty learnRaspberryPiReadMeProperty(LearnRaspberryPi learnRaspberryPi) {
        return this.learnRaspberryPiDescriptionMap.computeIfAbsent(learnRaspberryPi, key -> {
            SimpleStringProperty readmeProperty = new SimpleStringProperty();
            this.loadLearnRaspberryPiReadMe(learnRaspberryPi, (StringProperty)readmeProperty);
            return readmeProperty;
        });
    }

    public static void setTesting(boolean testing) {
        DataRepository.testing = testing;
    }

    public File getRepositoryDirectory() {
        if (testing) {
            return new File(System.getProperty("user.dir"));
        }
        return REPO_DIRECTORY;
    }

    public String getRepositoryDirectoryURL() {
        return this.getRepositoryDirectory().toURI().toString();
    }

    public File getNewsDirectory(News news) {
        return new File(this.getRepositoryDirectory(), "news/" + DATE_FORMATTER.format(news.getCreatedOn()) + "-" + news.getId());
    }

    public StringProperty libraryReadMeProperty(Library library) {
        return this.libraryReadMeMap.computeIfAbsent(library, key -> {
            SimpleStringProperty readmeProperty = new SimpleStringProperty();
            this.loadLibraryDescription(library, (StringProperty)readmeProperty);
            return readmeProperty;
        });
    }

    private void loadLibraryDescription(Library library, StringProperty readmeProperty) {
        String readmeText = this.loadString(new File(this.getRepositoryDirectory(), "libraries/" + library.getId() + "/readme.md"));
        readmeProperty.set((Object)readmeText);
    }

    public String getHomeText() {
        return (String)this.homeText.get();
    }

    public StringProperty homeTextProperty() {
        return this.homeText;
    }

    public void setHomeText(String homeText) {
        this.homeText.set((Object)homeText);
    }

    public String getOpenJFXText() {
        return (String)this.openJFXText.get();
    }

    public StringProperty openJFXTextProperty() {
        return this.openJFXText;
    }

    public void setOpenJFXText(String openJFXText) {
        this.openJFXText.set((Object)openJFXText);
    }

    public ObservableList<Library> getLibraries() {
        return this.libraries;
    }

    public ObservableList<Blog> getBlogs() {
        return this.blogs;
    }

    public ObservableList<News> getNews() {
        return this.news;
    }

    public ObservableList<Book> getBooks() {
        return this.books;
    }

    public ObservableList<LinksOfTheWeek> getLinksOfTheWeek() {
        return this.linksOfTheWeek;
    }

    public ObservableList<Tip> getTips() {
        return this.tips;
    }

    public ObservableList<Tutorial> getTutorials() {
        return this.tutorials;
    }

    public ObservableList<Video> getVideos() {
        return this.videos;
    }

    public ObservableList<Download> getDownloads() {
        return this.downloads;
    }

    public ObservableList<RealWorldApp> getRealWorldApps() {
        return this.realWorldApps;
    }

    public ObservableList<Tool> getTools() {
        return this.tools;
    }

    public ObservableList<Utility> getUtilities() {
        return this.utilities;
    }

    public ObservableList<Company> getCompanies() {
        return this.companies;
    }

    public ObservableList<Person> getPeople() {
        return this.people;
    }

    public ObservableList<IkonliPack> getIkonliPacks() {
        return this.ikonliPacks;
    }

    public ObservableList<Member> getMembers() {
        return this.members;
    }

    public ObservableList<Documentation> getDocumentation() {
        return this.documentation;
    }

    public ObservableList<LearnJavaFX> getLearnJavaFX() {
        return this.learnJavaFX;
    }

    public ObservableList<LearnMobile> getLearnMobile() {
        return this.learnMobile;
    }

    public ObservableList<LearnRaspberryPi> getLearnRaspberryPi() {
        return this.learnRaspberryPi;
    }

    private String loadString(File file) {
        LOG.fine("loading string from: " + file);
        StringBuilder sb = new StringBuilder();
        try (BufferedReader in = new BufferedReader(new FileReader(file, StandardCharsets.UTF_8));){
            String line;
            while ((line = in.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
        }
        catch (MalformedURLException e) {
            LOG.fine("Malformed URL: " + e.getMessage());
        }
        catch (IOException e) {
            LOG.fine("I/O Error: " + e.getMessage());
        }
        return sb.toString();
    }

    public StringProperty getArtifactVersion(Coordinates coordinates) {
        String groupId = coordinates.getGroupId();
        String artifactId = coordinates.getArtifactId();
        SimpleStringProperty result = new SimpleStringProperty("");
        if (StringUtils.isNotBlank((CharSequence)groupId) && StringUtils.isNotBlank((CharSequence)artifactId)) {
            this.loadArtifactVersion(groupId, artifactId, (StringProperty)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadArtifactVersion(String groupId, String artifactId, StringProperty result) {
        block17: {
            HttpURLConnection con = null;
            try {
                URL url = new URL(MessageFormat.format("https://search.maven.org/solrsearch/select?q=g:{0}+AND+a:{1}", groupId, artifactId));
                con = (HttpURLConnection)url.openConnection();
                con.setRequestMethod("GET");
                con.setUseCaches(false);
                int status = con.getResponseCode();
                if (status == 200) {
                    try (BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));){
                        String inputLine;
                        StringBuffer content = new StringBuffer();
                        while ((inputLine = in.readLine()) != null) {
                            content.append(inputLine);
                        }
                        in.close();
                        QueryResult queryResult = (QueryResult)this.gson.fromJson(content.toString(), QueryResult.class);
                        result.set((Object)queryResult.getResponse().getDocs().get(0).getLatestVersion());
                        break block17;
                    }
                }
                result.set((Object)"unknown");
            }
            catch (ProtocolException e) {
                e.printStackTrace();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (con != null) {
                    con.disconnect();
                }
            }
        }
    }

    public List<Post> loadPosts(Blog blog) {
        block9: {
            LOG.fine("loading posts for blog " + blog.getName());
            try {
                String url = blog.getFeed();
                if (!StringUtils.isNotBlank((CharSequence)url)) break block9;
                ArrayList<Post> posts = new ArrayList<Post>();
                URL urlObject = new URL(url);
                URLConnection urlConnection = urlObject.openConnection();
                try (XmlReader reader = new XmlReader(urlConnection.getInputStream());){
                    SyndFeed feed = new SyndFeedInput().build((Reader)reader);
                    List entries = feed.getEntries();
                    entries.forEach(entry -> posts.add(new Post(blog, feed, (SyndEntry)entry)));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return posts;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return Collections.emptyList();
    }

    public List<PullRequest> loadPullRequests() {
        long time = System.currentTimeMillis() / 1000L;
        if (this.cachedPullrequestsTime + 600L > time) {
            return this.cachedPullRequests;
        }
        this.cachedPullrequestsTime = time;
        this.cachedPullRequests = this.loadPullRequestsImpl();
        return this.cachedPullRequests;
    }

    /*
     * Exception decompiling
     */
    private List<PullRequest> loadPullRequestsImpl() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<ModelObject> search(String pattern) {
        ArrayList<ModelObject> result = new ArrayList<ModelObject>();
        this.search((List<? extends ModelObject>)this.getBooks(), pattern, (List<ModelObject>)result);
        this.search((List<? extends ModelObject>)this.getBlogs(), pattern, (List<ModelObject>)result);
        this.search((List<? extends ModelObject>)this.getCompanies(), pattern, (List<ModelObject>)result);
        this.search((List<? extends ModelObject>)this.getPeople(), pattern, (List<ModelObject>)result);
        this.search((List<? extends ModelObject>)this.getLibraries(), pattern, (List<ModelObject>)result);
        this.search((List<? extends ModelObject>)this.getRealWorldApps(), pattern, (List<ModelObject>)result);
        this.search((List<? extends ModelObject>)this.getTools(), pattern, (List<ModelObject>)result);
        this.search((List<? extends ModelObject>)this.getVideos(), pattern, (List<ModelObject>)result);
        this.search((List<? extends ModelObject>)this.getNews(), pattern, (List<ModelObject>)result);
        this.search((List<? extends ModelObject>)this.getDownloads(), pattern, (List<ModelObject>)result);
        this.search((List<? extends ModelObject>)this.getTutorials(), pattern, (List<ModelObject>)result);
        this.search((List<? extends ModelObject>)this.getTips(), pattern, (List<ModelObject>)result);
        this.search((List<? extends ModelObject>)this.getIkonliPacks(), pattern, (List<ModelObject>)result);
        this.search((List<? extends ModelObject>)this.getMembers(), pattern, (List<ModelObject>)result);
        this.search((List<? extends ModelObject>)this.getDocumentation(), pattern, (List<ModelObject>)result);
        this.search((List<? extends ModelObject>)this.getLearnJavaFX(), pattern, (List<ModelObject>)result);
        this.search((List<? extends ModelObject>)this.getLearnMobile(), pattern, (List<ModelObject>)result);
        this.search((List<? extends ModelObject>)this.getLearnRaspberryPi(), pattern, (List<ModelObject>)result);
        return result;
    }

    private void search(List<? extends ModelObject> modelObjects, String pattern, List<ModelObject> result) {
        modelObjects.forEach(mo -> {
            if (mo.matches(pattern)) {
                result.add((ModelObject)mo);
            }
        });
    }

    static {
        testing = false;
    }
}

