/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.jfxcentral.data;

import com.dlsc.jfxcentral.data.model.Blog;
import com.dlsc.jfxcentral.data.model.Book;
import com.dlsc.jfxcentral.data.model.Company;
import com.dlsc.jfxcentral.data.model.Coordinates;
import com.dlsc.jfxcentral.data.model.Documentation;
import com.dlsc.jfxcentral.data.model.Download;
import com.dlsc.jfxcentral.data.model.IkonliPack;
import com.dlsc.jfxcentral.data.model.LearnJavaFX;
import com.dlsc.jfxcentral.data.model.LearnMobile;
import com.dlsc.jfxcentral.data.model.LearnRaspberryPi;
import com.dlsc.jfxcentral.data.model.Library;
import com.dlsc.jfxcentral.data.model.LibraryInfo;
import com.dlsc.jfxcentral.data.model.LinksOfTheWeek;
import com.dlsc.jfxcentral.data.model.Member;
import com.dlsc.jfxcentral.data.model.ModelObject;
import com.dlsc.jfxcentral.data.model.News;
import com.dlsc.jfxcentral.data.model.Person;
import com.dlsc.jfxcentral.data.model.Post;
import com.dlsc.jfxcentral.data.model.RealWorldApp;
import com.dlsc.jfxcentral.data.model.Tip;
import com.dlsc.jfxcentral.data.model.Tool;
import com.dlsc.jfxcentral.data.model.Tutorial;
import com.dlsc.jfxcentral.data.model.Utility;
import com.dlsc.jfxcentral.data.model.Video;
import com.dlsc.jfxcentral.data.pull.PullRequest;
import com.dlsc.jfxcentral.data.util.QueryResult;
import com.fatboyindustrial.gsonjavatime.Converters;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.rometools.rome.feed.synd.SyndEntry;
import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.io.SyndFeedInput;
import com.rometools.rome.io.XmlReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.apache.commons.lang3.StringUtils;

public class DataRepository2 {
    private static final File REPO_DIRECTORY = new File(System.getProperty("jfxcentral.repo", new File(System.getProperty("user.home"), ".jfxcentralrepo").getAbsolutePath())).getAbsoluteFile();
    private static final Logger LOG = Logger.getLogger(DataRepository2.class.getName());
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static boolean testing;
    private static DataRepository2 instance;
    private final Gson gson = Converters.registerLocalDate((GsonBuilder)new GsonBuilder()).setPrettyPrinting().create();
    private final List<Library> libraries = new ArrayList<Library>();
    private final List<Blog> blogs = new ArrayList<Blog>();
    private final List<News> news = new ArrayList<News>();
    private final List<Book> books = new ArrayList<Book>();
    private final List<LinksOfTheWeek> linksOfTheWeek = new ArrayList<LinksOfTheWeek>();
    private final List<Tip> tips = new ArrayList<Tip>();
    private final List<Tutorial> tutorials = new ArrayList<Tutorial>();
    private final List<Video> videos = new ArrayList<Video>();
    private final List<Download> downloads = new ArrayList<Download>();
    private final List<RealWorldApp> realWorldApps = new ArrayList<RealWorldApp>();
    private final List<Tool> tools = new ArrayList<Tool>();
    private final List<Utility> utilities = new ArrayList<Utility>();
    private final List<Company> companies = new ArrayList<Company>();
    private final List<Person> people = new ArrayList<Person>();
    private final List<IkonliPack> ikonliPacks = new ArrayList<IkonliPack>();
    private final List<Member> members = new ArrayList<Member>();
    private final List<Documentation> documentation = new ArrayList<Documentation>();
    private final List<LearnJavaFX> learnJavaFX = new ArrayList<LearnJavaFX>();
    private final List<LearnMobile> learnMobile = new ArrayList<LearnMobile>();
    private final List<LearnRaspberryPi> learnRaspberryPi = new ArrayList<LearnRaspberryPi>();
    private String homeText;
    private String openJFXText;
    private long cachedPullRequestsTime;
    private List<PullRequest> cachedPullRequests;

    private DataRepository2() {
        this.doLoadData("initial loading of data upon creation of data repository instance");
    }

    public static synchronized DataRepository2 getInstance() {
        if (instance == null) {
            instance = new DataRepository2();
        }
        return instance;
    }

    public static void setTesting(boolean testing) {
        DataRepository2.testing = testing;
    }

    public static File getRepositoryDirectory() {
        if (testing) {
            return new File(System.getProperty("user.dir"));
        }
        return REPO_DIRECTORY;
    }

    public void reload() {
        this.doLoadData("explicit call to refresh method");
    }

    public void clearData() {
        LOG.fine("clearing data");
        this.homeText = "";
        this.openJFXText = "";
        this.getPeople().clear();
        this.getLibraries().clear();
        this.getBooks().clear();
        this.getNews().clear();
        this.getVideos().clear();
        this.getBlogs().clear();
        this.getCompanies().clear();
        this.getTools().clear();
        this.getUtilities().clear();
        this.getRealWorldApps().clear();
        this.getDownloads().clear();
        this.getTutorials().clear();
        this.getTips().clear();
        this.getLinksOfTheWeek().clear();
        this.getIkonliPacks().clear();
        this.getMembers().clear();
        this.getDocumentation().clear();
        this.getLearnJavaFX().clear();
        this.getLearnMobile().clear();
        this.getLearnRaspberryPi().clear();
    }

    private void doLoadData(String reason) {
        this.clearData();
        LOG.fine("loading data, reason = " + reason);
        try {
            this.homeText = this.loadString(new File(DataRepository2.getRepositoryDirectory(), "intro.md"));
            this.openJFXText = this.loadString(new File(DataRepository2.getRepositoryDirectory(), "openjfx/intro.md"));
            this.people.addAll(this.load(this.getFile("people/people.json"), new TypeToken<List<Person>>(){}.getType()));
            this.books.addAll(this.load(this.getFile("books/books.json"), new TypeToken<List<Book>>(){}.getType()));
            this.videos.addAll(this.load(this.getFile("videos/videos.json"), new TypeToken<List<Video>>(){}.getType()));
            this.libraries.addAll(this.load(this.getFile("libraries/libraries.json"), new TypeToken<List<Library>>(){}.getType()));
            this.news.addAll(this.load(this.getFile("news/news.json"), new TypeToken<List<News>>(){}.getType()));
            this.tutorials.addAll(this.load(this.getFile("tutorials/tutorials.json"), new TypeToken<List<Tutorial>>(){}.getType()));
            this.blogs.addAll(this.load(this.getFile("blogs/blogs.json"), new TypeToken<List<Blog>>(){}.getType()));
            this.companies.addAll(this.load(this.getFile("companies/companies.json"), new TypeToken<List<Company>>(){}.getType()));
            this.tools.addAll(this.load(this.getFile("tools/tools.json"), new TypeToken<List<Tool>>(){}.getType()));
            this.utilities.addAll(this.load(this.getFile("utilities/utilities.json"), new TypeToken<List<Utility>>(){}.getType()));
            this.realWorldApps.addAll(this.load(this.getFile("realworld/realworld.json"), new TypeToken<List<RealWorldApp>>(){}.getType()));
            this.downloads.addAll(this.load(this.getFile("downloads/downloads.json"), new TypeToken<List<Download>>(){}.getType()));
            this.tips.addAll(this.load(this.getFile("tips/tips.json"), new TypeToken<List<Tip>>(){}.getType()));
            this.linksOfTheWeek.addAll(this.load(this.getFile("links/links.json"), new TypeToken<List<LinksOfTheWeek>>(){}.getType()));
            this.ikonliPacks.addAll(this.load(this.getFile("ikonlipacks/ikonlipacks.json"), new TypeToken<List<IkonliPack>>(){}.getType()));
            this.members.addAll(this.load(this.getFile("members/members.json"), new TypeToken<List<Member>>(){}.getType()));
            this.documentation.addAll(this.load(this.getFile("documentation/documentation.json"), new TypeToken<List<Documentation>>(){}.getType()));
            this.learnJavaFX.addAll(this.load(this.getFile("learn/javafx/learn.json"), new TypeToken<List<LearnJavaFX>>(){}.getType()));
            this.learnMobile.addAll(this.load(this.getFile("learn/mobile/learn.json"), new TypeToken<List<LearnMobile>>(){}.getType()));
            this.learnRaspberryPi.addAll(this.load(this.getFile("learn/raspberrypi/learn.json"), new TypeToken<List<LearnRaspberryPi>>(){}.getType()));
        }
        catch (Exception e) {
            LOG.severe("error loading data: " + e.getMessage());
        }
        LOG.fine("data loading finished");
    }

    private <T> Collection<T> load(File file, Type type) {
        Collection collection;
        FileReader fr = new FileReader(file, StandardCharsets.UTF_8);
        try {
            collection = (Collection)this.gson.fromJson((Reader)fr, type);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        fr.close();
        return collection;
    }

    private File getFile(String path) {
        return new File(DataRepository2.getRepositoryDirectory(), path);
    }

    public Optional<Person> getPersonById(String id) {
        return this.people.stream().filter(item -> item.getId().equals(id)).findFirst();
    }

    public Optional<Company> getCompanyById(String id) {
        return this.companies.stream().filter(item -> item.getId().equals(id)).findFirst();
    }

    public Optional<Library> getLibraryById(String id) {
        return this.libraries.stream().filter(item -> item.getId().equals(id)).findFirst();
    }

    public Optional<Book> getBookById(String id) {
        return this.books.stream().filter(item -> item.getId().equals(id)).findFirst();
    }

    public Optional<LearnJavaFX> getLearnJavaFXById(String id) {
        return this.learnJavaFX.stream().filter(item -> item.getId().equals(id)).findFirst();
    }

    public Optional<LearnMobile> getLearnMobileById(String id) {
        return this.learnMobile.stream().filter(item -> item.getId().equals(id)).findFirst();
    }

    public Optional<LearnRaspberryPi> getLearnRaspberryPiById(String id) {
        return this.learnRaspberryPi.stream().filter(item -> item.getId().equals(id)).findFirst();
    }

    public Optional<Blog> getBlogById(String id) {
        return this.blogs.stream().filter(item -> item.getId().equals(id)).findFirst();
    }

    public Optional<RealWorldApp> getRealWorldAppById(String id) {
        return this.realWorldApps.stream().filter(item -> item.getId().equals(id)).findFirst();
    }

    public Optional<Tool> getToolById(String id) {
        return this.tools.stream().filter(item -> item.getId().equals(id)).findFirst();
    }

    public Optional<Utility> getUtilityById(String id) {
        return this.utilities.stream().filter(item -> item.getId().equals(id)).findFirst();
    }

    public Optional<Download> getDownloadById(String id) {
        return this.downloads.stream().filter(item -> item.getId().equals(id)).findFirst();
    }

    public Optional<News> getNewsById(String id) {
        return this.news.stream().filter(item -> item.getId().equals(id)).findFirst();
    }

    public Optional<Video> getVideoById(String id) {
        return this.videos.stream().filter(item -> item.getId().equals(id)).findFirst();
    }

    public Optional<Tutorial> getTutorialById(String id) {
        return this.tutorials.stream().filter(item -> item.getId().equals(id)).findFirst();
    }

    public Optional<Tip> getTipById(String id) {
        return this.tips.stream().filter(item -> item.getId().equals(id)).findFirst();
    }

    public Optional<LinksOfTheWeek> getLinksOfTheWeekById(String id) {
        return this.linksOfTheWeek.stream().filter(item -> item.getId().equals(id)).findFirst();
    }

    public Optional<IkonliPack> getIkonliPackById(String id) {
        return this.ikonliPacks.stream().filter(item -> item.getId().equals(id)).findFirst();
    }

    public Optional<Member> getMemberById(String id) {
        return this.members.stream().filter(item -> item.getId().equals(id)).findFirst();
    }

    public Optional<Documentation> getDocumentationById(String id) {
        return this.documentation.stream().filter(item -> item.getId().equals(id)).findFirst();
    }

    public <T extends ModelObject> List<T> getLinkedObjects(ModelObject modelObject, Class<T> clazz) {
        List<T> itemList = this.getList(clazz);
        List<String> idsList = this.getIdList(modelObject, clazz);
        return itemList.stream().filter(item -> idsList.contains(item.getId()) || this.getIdList((ModelObject)item, modelObject.getClass()).contains(modelObject.getId())).collect(Collectors.toList());
    }

    private <T extends ModelObject> List<String> getIdList(ModelObject modelObject, Class<T> clazz) {
        if (clazz.equals(Video.class)) {
            return modelObject.getVideoIds();
        }
        if (clazz.equals(Book.class)) {
            return modelObject.getBookIds();
        }
        if (clazz.equals(Library.class)) {
            return modelObject.getLibraryIds();
        }
        if (clazz.equals(Tutorial.class)) {
            return modelObject.getTutorialIds();
        }
        if (clazz.equals(Download.class)) {
            return modelObject.getDownloadIds();
        }
        if (clazz.equals(Person.class)) {
            return modelObject.getPersonIds();
        }
        if (clazz.equals(Tool.class)) {
            return modelObject.getToolIds();
        }
        if (clazz.equals(Utility.class)) {
            return modelObject.getUtilityIds();
        }
        if (clazz.equals(RealWorldApp.class)) {
            return modelObject.getAppIds();
        }
        if (clazz.equals(News.class)) {
            return modelObject.getNewsIds();
        }
        if (clazz.equals(Blog.class)) {
            return modelObject.getBlogIds();
        }
        if (clazz.equals(Company.class)) {
            return modelObject.getCompanyIds();
        }
        if (clazz.equals(Tip.class)) {
            return modelObject.getTipIds();
        }
        if (clazz.equals(LinksOfTheWeek.class)) {
            return modelObject.getLinksOfTheWeekIds();
        }
        if (clazz.equals(IkonliPack.class)) {
            return modelObject.getIkonliPackIds();
        }
        if (clazz.equals(Member.class)) {
            return modelObject.getMemberIds();
        }
        if (clazz.equals(Documentation.class)) {
            return modelObject.getDocumentationIds();
        }
        if (clazz.equals(LearnJavaFX.class)) {
            return modelObject.getLearnJavaFXIds();
        }
        if (clazz.equals(LearnMobile.class)) {
            return modelObject.getLearnMobileIds();
        }
        if (clazz.equals(LearnRaspberryPi.class)) {
            return modelObject.getLearnRaspberryPiIds();
        }
        throw new IllegalArgumentException("unsupported class type: " + clazz.getSimpleName());
    }

    public <T extends ModelObject> List<T> getList(Class<T> clazz) {
        if (clazz.equals(Video.class)) {
            return this.videos;
        }
        if (clazz.equals(Book.class)) {
            return this.books;
        }
        if (clazz.equals(Library.class)) {
            return this.libraries;
        }
        if (clazz.equals(Tutorial.class)) {
            return this.tutorials;
        }
        if (clazz.equals(Download.class)) {
            return this.downloads;
        }
        if (clazz.equals(Person.class)) {
            return this.people;
        }
        if (clazz.equals(Tool.class)) {
            return this.tools;
        }
        if (clazz.equals(Utility.class)) {
            return this.utilities;
        }
        if (clazz.equals(RealWorldApp.class)) {
            return this.realWorldApps;
        }
        if (clazz.equals(News.class)) {
            return this.news;
        }
        if (clazz.equals(Blog.class)) {
            return this.blogs;
        }
        if (clazz.equals(Company.class)) {
            return this.companies;
        }
        if (clazz.equals(Tip.class)) {
            return this.tips;
        }
        if (clazz.equals(LinksOfTheWeek.class)) {
            return this.linksOfTheWeek;
        }
        if (clazz.equals(IkonliPack.class)) {
            return this.ikonliPacks;
        }
        if (clazz.equals(Member.class)) {
            return this.members;
        }
        if (clazz.equals(Documentation.class)) {
            return this.documentation;
        }
        if (clazz.equals(LearnJavaFX.class)) {
            return this.learnJavaFX;
        }
        if (clazz.equals(LearnMobile.class)) {
            return this.learnMobile;
        }
        if (clazz.equals(LearnRaspberryPi.class)) {
            return this.learnRaspberryPi;
        }
        throw new IllegalArgumentException("unsupported class type: " + clazz.getSimpleName());
    }

    public <T extends ModelObject> T getByID(Class<T> clz, String id) {
        return (T)((ModelObject)this.getList(clz).stream().filter(item -> item.getId().equals(id)).findFirst().orElse(null));
    }

    public boolean isValidId(Class<? extends ModelObject> clz, String id) {
        return this.getList(clz).stream().anyMatch(item -> item.getId().equals(id));
    }

    public List<Video> getVideosByModelObject(ModelObject modelObject) {
        return this.getLinkedObjects(modelObject, Video.class);
    }

    public List<Download> getDownloadsByModelObject(ModelObject modelObject) {
        return this.getLinkedObjects(modelObject, Download.class);
    }

    public List<Book> getBooksByModelObject(ModelObject modelObject) {
        return this.getLinkedObjects(modelObject, Book.class);
    }

    public List<Tutorial> getTutorialsByModelObject(ModelObject modelObject) {
        return this.getLinkedObjects(modelObject, Tutorial.class);
    }

    public List<Blog> getBlogsByModelObject(ModelObject modelObject) {
        return this.getLinkedObjects(modelObject, Blog.class);
    }

    public List<Library> getLibrariesByModelObject(ModelObject modelObject) {
        return this.getLinkedObjects(modelObject, Library.class);
    }

    public List<Tool> getToolsByModelObject(ModelObject modelObject) {
        return this.getLinkedObjects(modelObject, Tool.class);
    }

    public List<Utility> getUtilitiesByModelObject(ModelObject modelObject) {
        return this.getLinkedObjects(modelObject, Utility.class);
    }

    public List<News> getNewsByModelObject(ModelObject modelObject) {
        return this.getLinkedObjects(modelObject, News.class);
    }

    public List<Company> getCompaniesByModelObject(ModelObject modelObject) {
        return this.getLinkedObjects(modelObject, Company.class);
    }

    public List<RealWorldApp> getRealWorldAppsByModelObject(ModelObject modelObject) {
        return this.getLinkedObjects(modelObject, RealWorldApp.class);
    }

    public List<Person> getPeopleByModelObject(ModelObject modelObject) {
        return this.getLinkedObjects(modelObject, Person.class);
    }

    public List<Tip> getTipsByModelObject(ModelObject modelObject) {
        return this.getLinkedObjects(modelObject, Tip.class);
    }

    public List<LearnJavaFX> getLearnJavaFXByModelObject(ModelObject modelObject) {
        return this.getLinkedObjects(modelObject, LearnJavaFX.class);
    }

    public List<LearnMobile> getLearnMobileByModelObject(ModelObject modelObject) {
        return this.getLinkedObjects(modelObject, LearnMobile.class);
    }

    public List<LearnRaspberryPi> getLearnRaspberryPiByModelObject(ModelObject modelObject) {
        return this.getLinkedObjects(modelObject, LearnRaspberryPi.class);
    }

    public List<LinksOfTheWeek> getLinksOfTheWeekByModelObject(ModelObject modelObject) {
        return this.getLinkedObjects(modelObject, LinksOfTheWeek.class);
    }

    public LibraryInfo getLibraryInfo(Library library) {
        LibraryInfo libraryInfo;
        String libraryId = library.getId();
        File file = new File(DataRepository2.getRepositoryDirectory(), "libraries/" + libraryId + "/info.json");
        FileReader reader = new FileReader(file, StandardCharsets.UTF_8);
        try {
            libraryInfo = (LibraryInfo)this.gson.fromJson((Reader)reader, LibraryInfo.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return null;
            }
        }
        reader.close();
        return libraryInfo;
    }

    public File getNewsDirectory(News news) {
        return new File(DataRepository2.getRepositoryDirectory(), "news/" + DATE_FORMATTER.format(news.getCreatedOn()) + "-" + news.getId());
    }

    public String getNewsText(News news) {
        return this.loadString(new File(this.getNewsDirectory(news), "/text.md"));
    }

    public String getLinksOfTheWeekReadMe(LinksOfTheWeek links) {
        return this.loadString(new File(DataRepository2.getRepositoryDirectory(), "links/" + links.getId() + "/readme.md"));
    }

    public void loadLinksOfTheWeekText(LinksOfTheWeek links, StringProperty textProperty) {
        textProperty.set((Object)this.getLinksOfTheWeekReadMe(links));
    }

    public String getTutorialReadMe(Tutorial tutorial) {
        return this.loadString(new File(DataRepository2.getRepositoryDirectory(), "tutorials/" + tutorial.getId() + "/readme.md"));
    }

    public String getDownloadReadMe(Download download) {
        return this.loadString(new File(DataRepository2.getRepositoryDirectory(), "downloads/" + download.getId() + "/readme.md"));
    }

    public String getBookReadMe(Book book) {
        return this.loadString(new File(DataRepository2.getRepositoryDirectory(), "books/" + book.getId() + "/readme.md"));
    }

    public String getPersonReadMe(Person person) {
        return this.loadString(new File(DataRepository2.getRepositoryDirectory(), "people/" + person.getId() + "/readme.md"));
    }

    public String getMemberReadMe(Member member) {
        return this.loadString(new File(DataRepository2.getRepositoryDirectory(), "members/" + member.getId() + "/readme.md"));
    }

    public String getToolReadMe(Tool tool) {
        return this.loadString(new File(DataRepository2.getRepositoryDirectory(), "tools/" + tool.getId() + "/readme.md"));
    }

    public String getUtilityReadMe(Utility utility) {
        return this.loadString(new File(DataRepository2.getRepositoryDirectory(), "utilities/" + utility.getId() + "/readme.md"));
    }

    public String getTipReadMe(Tip tip) {
        return this.loadString(new File(DataRepository2.getRepositoryDirectory(), "tips/" + tip.getId() + "/readme.md"));
    }

    public String getRealWorldReadMe(RealWorldApp app) {
        return this.loadString(new File(DataRepository2.getRepositoryDirectory(), "realworld/" + app.getId() + "/readme.md"));
    }

    public String getCompanyReadMe(Company company) {
        return this.loadString(new File(DataRepository2.getRepositoryDirectory(), "companies/" + company.getId() + "/readme.md"));
    }

    public String getLibraryReadMe(Library library) {
        return this.loadString(new File(DataRepository2.getRepositoryDirectory(), "libraries/" + library.getId() + "/readme.md"));
    }

    public String getLearnJavaFXReadMe(LearnJavaFX learnJavaFX) {
        return this.loadString(new File(DataRepository2.getRepositoryDirectory(), "learn/javafx/" + learnJavaFX.getId() + "/readme.md"));
    }

    public String getLearnMobileReadMe(LearnMobile learnMobile) {
        return this.loadString(new File(DataRepository2.getRepositoryDirectory(), "learn/mobile/" + learnMobile.getId() + "/readme.md"));
    }

    public String getLearnRaspberryPiReadMe(LearnRaspberryPi learnRaspberryPi) {
        return this.loadString(new File(DataRepository2.getRepositoryDirectory(), "learn/raspberrypi/" + learnRaspberryPi.getId() + "/readme.md"));
    }

    public String getRepositoryDirectoryURL() {
        return DataRepository2.getRepositoryDirectory().toURI().toString();
    }

    public List<Library> getLibraries() {
        return this.libraries;
    }

    public List<Blog> getBlogs() {
        return this.blogs;
    }

    public List<News> getNews() {
        return this.news;
    }

    public List<Book> getBooks() {
        return this.books;
    }

    public List<LinksOfTheWeek> getLinksOfTheWeek() {
        return this.linksOfTheWeek;
    }

    public List<Tip> getTips() {
        return this.tips;
    }

    public List<Tutorial> getTutorials() {
        return this.tutorials;
    }

    public List<Video> getVideos() {
        return this.videos;
    }

    public List<Download> getDownloads() {
        return this.downloads;
    }

    public List<RealWorldApp> getRealWorldApps() {
        return this.realWorldApps;
    }

    public List<Tool> getTools() {
        return this.tools;
    }

    public List<Utility> getUtilities() {
        return this.utilities;
    }

    public List<Company> getCompanies() {
        return this.companies;
    }

    public List<Person> getPeople() {
        return this.people;
    }

    public List<IkonliPack> getIkonliPacks() {
        return this.ikonliPacks;
    }

    public List<Member> getMembers() {
        return this.members;
    }

    public List<Documentation> getDocumentation() {
        return this.documentation;
    }

    public List<LearnJavaFX> getLearnJavaFX() {
        return this.learnJavaFX;
    }

    public List<LearnMobile> getLearnMobile() {
        return this.learnMobile;
    }

    public List<LearnRaspberryPi> getLearnRaspberryPi() {
        return this.learnRaspberryPi;
    }

    public String getHomeText() {
        return this.homeText;
    }

    public String getOpenJFXText() {
        return this.openJFXText;
    }

    private String loadString(File file) {
        LOG.fine("loading string from: " + file);
        StringBuilder sb = new StringBuilder();
        try (BufferedReader in = new BufferedReader(new FileReader(file, StandardCharsets.UTF_8));){
            String line;
            while ((line = in.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
        }
        catch (MalformedURLException e) {
            LOG.fine("Malformed URL: " + e.getMessage());
        }
        catch (IOException e) {
            LOG.fine("I/O Error: " + e.getMessage());
        }
        return sb.toString();
    }

    public StringProperty getArtifactVersion(Coordinates coordinates) {
        String groupId = coordinates.getGroupId();
        String artifactId = coordinates.getArtifactId();
        SimpleStringProperty result = new SimpleStringProperty("");
        if (StringUtils.isNotBlank((CharSequence)groupId) && StringUtils.isNotBlank((CharSequence)artifactId)) {
            this.loadArtifactVersion(groupId, artifactId, (StringProperty)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadArtifactVersion(String groupId, String artifactId, StringProperty result) {
        block13: {
            HttpURLConnection con = null;
            try {
                URL url = new URL(MessageFormat.format("https://search.maven.org/solrsearch/select?q=g:{0}+AND+a:{1}", groupId, artifactId));
                con = (HttpURLConnection)url.openConnection();
                con.setRequestMethod("GET");
                con.setUseCaches(false);
                int status = con.getResponseCode();
                if (status == 200) {
                    try (BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));){
                        String inputLine;
                        StringBuilder content = new StringBuilder();
                        while ((inputLine = in.readLine()) != null) {
                            content.append(inputLine);
                        }
                        in.close();
                        QueryResult queryResult = (QueryResult)this.gson.fromJson(content.toString(), QueryResult.class);
                        result.set((Object)queryResult.getResponse().getDocs().get(0).getLatestVersion());
                        break block13;
                    }
                }
                result.set((Object)"unknown");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (con != null) {
                    con.disconnect();
                }
            }
        }
    }

    public List<Post> loadPosts(Blog blog) {
        block9: {
            LOG.fine("loading posts for blog " + blog.getName());
            try {
                String url = blog.getFeed();
                if (!StringUtils.isNotBlank((CharSequence)url)) break block9;
                ArrayList<Post> posts = new ArrayList<Post>();
                URL urlObject = new URL(url);
                URLConnection urlConnection = urlObject.openConnection();
                try (XmlReader reader = new XmlReader(urlConnection.getInputStream());){
                    SyndFeed feed = new SyndFeedInput().build((Reader)reader);
                    List entries = feed.getEntries();
                    entries.forEach(entry -> posts.add(new Post(blog, feed, (SyndEntry)entry)));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return posts;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return Collections.emptyList();
    }

    public List<PullRequest> loadPullRequests() {
        long timeToReloadSeconds = 600L;
        long time = System.currentTimeMillis() / 1000L;
        if (this.cachedPullRequestsTime + timeToReloadSeconds > time) {
            return this.cachedPullRequests;
        }
        this.cachedPullRequestsTime = time;
        this.cachedPullRequests = this.loadPullRequestsImpl();
        return this.cachedPullRequests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private List<PullRequest> loadPullRequestsImpl() {
        LOG.fine("loading pull requests");
        HttpURLConnection con = null;
        for (int page = 1; page < 2; ++page) {
            try {
                URL url = new URL("https://api.github.com/repos/openjdk/jfx/pulls?state=all&per_page=100&page=" + page);
                con = (HttpURLConnection)url.openConnection();
                con.setRequestMethod("GET");
                con.setUseCaches(false);
                int status = con.getResponseCode();
                if (status == 200) {
                    List list;
                    try (BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));){
                        String inputLine;
                        StringBuilder content = new StringBuilder();
                        while ((inputLine = in.readLine()) != null) {
                            content.append(inputLine);
                        }
                        list = (List)this.gson.fromJson(content.toString(), new TypeToken<List<PullRequest>>(){}.getType());
                    }
                    return list;
                }
                if (con == null) continue;
                con.disconnect();
                continue;
                {
                    catch (IOException e) {
                        e.printStackTrace();
                        continue;
                    }
                }
            }
            finally {
                if (con != null) {
                    con.disconnect();
                }
            }
        }
        return Collections.emptyList();
    }
}

