/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.jfxcentral.data;

import com.dlsc.jfxcentral.data.DataRepository;
import com.dlsc.jfxcentral.data.model.Blog;
import com.dlsc.jfxcentral.data.model.Book;
import com.dlsc.jfxcentral.data.model.Company;
import com.dlsc.jfxcentral.data.model.Documentation;
import com.dlsc.jfxcentral.data.model.Download;
import com.dlsc.jfxcentral.data.model.Library;
import com.dlsc.jfxcentral.data.model.Member;
import com.dlsc.jfxcentral.data.model.News;
import com.dlsc.jfxcentral.data.model.Person;
import com.dlsc.jfxcentral.data.model.RealWorldApp;
import com.dlsc.jfxcentral.data.model.Tip;
import com.dlsc.jfxcentral.data.model.Tool;
import com.dlsc.jfxcentral.data.model.Tutorial;
import com.dlsc.jfxcentral.data.model.Utility;
import com.dlsc.jfxcentral.data.model.Video;
import com.jpro.webapi.WebAPI;
import java.io.File;
import java.net.URL;
import java.net.URLConnection;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.image.Image;
import org.apache.commons.lang3.StringUtils;

public class ImageManager {
    private static final Logger LOG = Logger.getLogger(ImageManager.class.getName());
    private static final String MISSING_USER = Objects.requireNonNull(ImageManager.class.getResource("missing-user.png")).toExternalForm();
    private static final Image MISSING_USER_IMAGE = new Image(MISSING_USER);
    private static final String MISSING = Objects.requireNonNull(ImageManager.class.getResource("missing-image.jpg")).toExternalForm();
    private static final Image MISSING_IMAGE = new Image(MISSING);
    private static final String MISSING_VIDEO = Objects.requireNonNull(ImageManager.class.getResource("missing-video.png")).toExternalForm();
    private static final Image MISSING_VIDEO_IMAGE = new Image(MISSING_VIDEO);
    private static final ImageManager instance = new ImageManager();
    private Map<String, ObjectProperty<Image>> remoteImageCache = new HashMap<String, ObjectProperty<Image>>();

    private ImageManager() {
    }

    public static synchronized ImageManager getInstance() {
        return instance;
    }

    public File newsBannerFile(News news) {
        return this.localImageFile(DataRepository.getInstance().getNewsDirectory(news), "banner.jpg");
    }

    public File downloadBannerFile(Download download) {
        return this.localImageFile(new File(DataRepository.getInstance().getRepositoryDirectory(), "downloads/" + download.getId() + "/"), "banner.jpg");
    }

    public File tipBannerFile(Tip tip) {
        return this.localImageFile(new File(DataRepository.getInstance().getRepositoryDirectory(), "tips/" + tip.getId() + "/"), "banner.jpg");
    }

    public File blogPageFile(Blog blog) {
        return this.localImageFile(new File(DataRepository.getInstance().getRepositoryDirectory(), "blogs/" + blog.getId() + "/"), "page-small.png");
    }

    public File blogIconFile(Blog blog) {
        return this.localImageFile(new File(DataRepository.getInstance().getRepositoryDirectory(), "blogs/" + blog.getId() + "/"), "icon.png");
    }

    public File realWorldAppFile(RealWorldApp app) {
        return this.localImageFile(new File(DataRepository.getInstance().getRepositoryDirectory(), "realworld/" + app.getId() + "/"), "small.jpg");
    }

    public File realWorldAppLargeFile(RealWorldApp app) {
        return this.localImageFile(new File(DataRepository.getInstance().getRepositoryDirectory(), "realworld/" + app.getId() + "/"), "large.jpg");
    }

    public File realWorldAppBannerFile(RealWorldApp app) {
        return this.localImageFile(new File(DataRepository.getInstance().getRepositoryDirectory(), "realworld/" + app.getId() + "/"), "banner.jpg");
    }

    public File blogPageLargeFile(Blog blog) {
        return this.localImageFile(new File(DataRepository.getInstance().getRepositoryDirectory(), "blogs/" + blog.getId() + "/"), "page.png");
    }

    public File personFile(Person person) {
        return this.localImageFile(new File(DataRepository.getInstance().getRepositoryDirectory(), "people/" + person.getId() + "/"), "photo.jpeg");
    }

    public File memberFile(Member member) {
        return this.localImageFile(new File(DataRepository.getInstance().getRepositoryDirectory(), "members/" + member.getId() + "/"), "photo.jpeg");
    }

    public File toolFile(Tool tool) {
        return this.localImageFile(new File(DataRepository.getInstance().getRepositoryDirectory(), "tools/" + tool.getId() + "/"), "logo.png");
    }

    public File utilityFile(Utility utility) {
        return this.localImageFile(new File(DataRepository.getInstance().getRepositoryDirectory(), "utilities/" + utility.getId() + "/"), "logo.png");
    }

    public File companyFile(Company company) {
        return this.localImageFile(new File(DataRepository.getInstance().getRepositoryDirectory(), "companies/" + company.getId() + "/"), "logo.png");
    }

    public File tutorialFile(Tutorial tutorial) {
        return this.localImageFile(new File(DataRepository.getInstance().getRepositoryDirectory(), "tutorials/" + tutorial.getId() + "/"), "small.png");
    }

    public File tutorialLargeFile(Tutorial tutorial) {
        return this.localImageFile(new File(DataRepository.getInstance().getRepositoryDirectory(), "tutorials/" + tutorial.getId() + "/"), "large.png");
    }

    public File bookCoverFile(Book book) {
        return this.localImageFile(new File(DataRepository.getInstance().getRepositoryDirectory(), "books/" + book.getId() + "/"), "cover.jpg");
    }

    public File libraryFile(Library library) {
        return this.localImageFile(new File(DataRepository.getInstance().getRepositoryDirectory(), "libraries/" + library.getId() + "/"), "logo.png");
    }

    public File documentationFile(Documentation doc) {
        return this.localImageFile(new File(DataRepository.getInstance().getRepositoryDirectory(), "documentation/" + doc.getId() + "/"), "logo.png");
    }

    private File localImageFile(File directory, String photoFileName) {
        if (StringUtils.isBlank((CharSequence)photoFileName)) {
            return null;
        }
        return new File(directory, photoFileName);
    }

    public File libraryFile(Library library, String imagePath) {
        return this.localImageFile(new File(DataRepository.getInstance().getRepositoryDirectory(), "libraries/" + library.getId() + "/"), imagePath);
    }

    public ObjectProperty<Image> newsBannerImageProperty(News news) {
        File file = this.newsBannerFile(news);
        return this.fileToImageProperty(file, MISSING_IMAGE);
    }

    public ObjectProperty<Image> downloadBannerImageProperty(Download download) {
        File file = this.downloadBannerFile(download);
        return this.fileToImageProperty(file, MISSING_IMAGE);
    }

    public ObjectProperty<Image> tipBannerImageProperty(Tip tip) {
        File file = this.tipBannerFile(tip);
        return this.fileToImageProperty(file, MISSING_IMAGE);
    }

    public ObjectProperty<Image> blogPageImageProperty(Blog blog) {
        File file = this.blogPageFile(blog);
        return this.fileToImageProperty(file, MISSING_IMAGE);
    }

    public ObjectProperty<Image> blogIconImageProperty(Blog blog) {
        File file = this.blogIconFile(blog);
        return this.fileToImageProperty(file, MISSING_IMAGE);
    }

    public ObjectProperty<Image> realWorldAppImageProperty(RealWorldApp app) {
        File file = this.realWorldAppFile(app);
        return this.fileToImageProperty(file, MISSING_IMAGE);
    }

    public ObjectProperty<Image> realWorldAppLargeImageProperty(RealWorldApp app) {
        File file = this.realWorldAppLargeFile(app);
        return this.fileToImageProperty(file, MISSING_IMAGE);
    }

    public ObjectProperty<Image> realWorldAppBannerImageProperty(RealWorldApp app) {
        File file = this.realWorldAppBannerFile(app);
        return this.fileToImageProperty(file, MISSING_IMAGE);
    }

    public ObjectProperty<Image> blogPageLargeImageProperty(Blog blog) {
        File file = this.blogPageLargeFile(blog);
        return this.fileToImageProperty(file, MISSING_IMAGE);
    }

    public ObjectProperty<Image> personImageProperty(Person person) {
        File file = this.personFile(person);
        return this.fileToImageProperty(file, null);
    }

    public ObjectProperty<Image> memberImageProperty(Member member) {
        File file = this.memberFile(member);
        return this.fileToImageProperty(file, null);
    }

    public ObjectProperty<Image> toolImageProperty(Tool tool) {
        File file = this.toolFile(tool);
        return this.fileToImageProperty(file, null);
    }

    public ObjectProperty<Image> utilityImageProperty(Utility utility) {
        File file = this.utilityFile(utility);
        return this.fileToImageProperty(file, null);
    }

    public ObjectProperty<Image> companyImageProperty(Company company) {
        File file = this.companyFile(company);
        return this.fileToImageProperty(file, MISSING_IMAGE);
    }

    public ObjectProperty<Image> tutorialImageProperty(Tutorial tutorial) {
        File file = this.tutorialFile(tutorial);
        return this.fileToImageProperty(file, MISSING_IMAGE);
    }

    public ObjectProperty<Image> tutorialImageLargeProperty(Tutorial tutorial) {
        File file = this.tutorialLargeFile(tutorial);
        return this.fileToImageProperty(file, MISSING_IMAGE);
    }

    public ObjectProperty<Image> bookCoverImageProperty(Book book) {
        File file = this.bookCoverFile(book);
        return this.fileToImageProperty(file, MISSING_IMAGE);
    }

    public ObjectProperty<Image> libraryImageProperty(Library library) {
        if (!library.isLogoAvailable()) {
            return new SimpleObjectProperty();
        }
        File file = this.libraryFile(library);
        return this.fileToImageProperty(file, MISSING_IMAGE);
    }

    public ObjectProperty<Image> libraryImageProperty(Library library, String imagePath) {
        File file = this.libraryFile(library, imagePath);
        return this.fileToImageProperty(file, MISSING_IMAGE);
    }

    public ObjectProperty<Image> libraryFeaturedImageProperty(Library library) {
        if (StringUtils.isBlank((CharSequence)library.getFeaturedImageName())) {
            return new SimpleObjectProperty();
        }
        return this.libraryImageProperty(library, library.getFeaturedImageName());
    }

    public ObjectProperty<Image> documentationImageProperty(Documentation doc) {
        File file = this.documentationFile(doc);
        return this.fileToImageProperty(file, null);
    }

    public ObjectProperty<Image> fileToImageProperty(File file, Image placeholderImage) {
        SimpleObjectProperty property = new SimpleObjectProperty();
        if (file != null && file.exists()) {
            try {
                Image image = new Image(file.toURI().toString());
                if (image.getException() != null) {
                    throw image.getException();
                }
                property.set((Object)image);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        } else {
            if (placeholderImage == null) {
                throw new RuntimeException("Image not found: " + file.getAbsolutePath());
            }
            property.set((Object)placeholderImage);
        }
        return property;
    }

    public String youTubeImageURL(Video video) {
        return "https://img.youtube.com/vi/" + video.getId() + "/0.jpg";
    }

    public ObjectProperty<Image> youTubeImageProperty(Video video) {
        return this.remoteImageProperty(this.youTubeImageURL(video), video.getId(), MISSING_VIDEO_IMAGE, 480, 360);
    }

    public ObjectProperty<Image> githubAvatarImageProperty(String loginName) {
        return this.remoteImageProperty("https://github.com/" + loginName + ".png", "&size=100", "github-" + loginName, MISSING_USER_IMAGE, 100, 100);
    }

    private ObjectProperty<Image> remoteImageProperty(String baseURL, String photoKey, Image placeholderImage, int width, int height) {
        return this.remoteImageProperty(baseURL, "", photoKey, placeholderImage, width, height);
    }

    private ObjectProperty<Image> remoteImageProperty(String imageUrl, String append, String photoKey, Image placeholderImage, int width, int height) {
        if (WebAPI.isBrowser()) {
            return new SimpleObjectProperty((Object)WebAPI.createVirtualImage((String)imageUrl, (int)width, (int)height));
        }
        if (StringUtils.isBlank((CharSequence)imageUrl) || StringUtils.isBlank((CharSequence)photoKey)) {
            return new SimpleObjectProperty((Object)placeholderImage);
        }
        return this.remoteImageCache.computeIfAbsent(photoKey, key -> {
            SimpleObjectProperty property = new SimpleObjectProperty();
            try {
                URL url = new URL(imageUrl + "?" + ZonedDateTime.now().toInstant() + append);
                URLConnection connection = url.openConnection();
                LOG.fine("loading remote image from url: " + url.toExternalForm());
                connection.connect();
                Image image = new Image(url.toExternalForm(), !DataRepository.testing);
                image.progressProperty().addListener(arg_0 -> ImageManager.lambda$remoteImageProperty$0(image, url, (ObjectProperty)property, arg_0));
                image.exceptionProperty().addListener(it -> image.getException().printStackTrace());
                if (DataRepository.testing) {
                    property.set((Object)image);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return property;
        });
    }

    private static /* synthetic */ void lambda$remoteImageProperty$0(Image image, URL url, ObjectProperty property, Observable it) {
        if (image.getProgress() == 1.0 && image.getException() == null) {
            LOG.fine("Image found for " + url);
            property.set((Object)image);
        }
    }
}

