/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.jfxcentral.data;

import com.dlsc.jfxcentral.data.DataRepository2;
import com.dlsc.jfxcentral.data.model.LinksOfTheWeek;
import com.dlsc.jfxcentral.data.model.ModelObject;
import com.dlsc.jfxcentral.data.util.DateUtils;
import com.rometools.rome.feed.synd.SyndContent;
import com.rometools.rome.feed.synd.SyndContentImpl;
import com.rometools.rome.feed.synd.SyndEntryImpl;
import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.feed.synd.SyndFeedImpl;
import com.rometools.rome.io.FeedException;
import com.rometools.rome.io.SyndFeedOutput;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;

public class RSSManager {
    private static final Logger LOG = Logger.getLogger(RSSManager.class.getName());

    public static String createRSS() {
        DataRepository2 repository = DataRepository2.getInstance();
        List<LinksOfTheWeek> links = repository.getLinksOfTheWeek();
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setFeedType("rss_2.0");
        feed.setTitle("JFX-Central Links Of The Week");
        feed.setDescription("Your weekly update on all-things-JavaFX");
        feed.setLink("https://jfx-central.com/rss/linksoftheweek");
        ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
        feed.setEntries(entries);
        List allLinksOfTheWeek = links.stream().sorted(Comparator.comparing(ModelObject::getCreatedOn).reversed()).collect(Collectors.toList());
        for (LinksOfTheWeek linksOfTheWeek : allLinksOfTheWeek) {
            SyndContentImpl description = new SyndContentImpl();
            description.setType("text/html");
            description.setValue(RSSManager.getLinksOfTheWeekAsHtml(repository, linksOfTheWeek));
            SyndEntryImpl entry = new SyndEntryImpl();
            entry.setTitle("Links Of The Week - " + linksOfTheWeek.getCreatedOn().format(DateTimeFormatter.ofPattern("dd-MM-yyyy")));
            entry.setLink("https://jfx-central.com/links");
            entry.setPublishedDate(DateUtils.asDate(linksOfTheWeek.getCreatedOn()));
            entry.setDescription((SyndContent)description);
            entries.add(entry);
        }
        try {
            return new SyndFeedOutput().outputString((SyndFeed)feed);
        }
        catch (FeedException e) {
            LOG.severe("Feed could not be generated: " + e.getMessage());
            return "";
        }
    }

    private static String getLinksOfTheWeekAsHtml(DataRepository2 repository, LinksOfTheWeek linksOfTheWeek) {
        SimpleStringProperty markdownContent = new SimpleStringProperty();
        repository.loadLinksOfTheWeekText(linksOfTheWeek, (StringProperty)markdownContent);
        if (markdownContent.get() == null || ((String)markdownContent.get()).isEmpty()) {
            LOG.warning("Markdown content not provided");
            return "";
        }
        Parser parser = Parser.builder().build();
        HtmlRenderer renderer = HtmlRenderer.builder().build();
        try {
            return renderer.render(parser.parse((String)markdownContent.get()));
        }
        catch (Exception e) {
            LOG.severe("Error while rendering markdown content: " + e.getMessage());
            return "";
        }
    }
}

