/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.jfxcentral.data.model;

import com.dlsc.jfxcentral.data.model.ModelObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Download
extends ModelObject {
    private String homepage;
    private DownloadType downloadType;
    private List<DownloadFile> files = new ArrayList<DownloadFile>();

    @Override
    public boolean matches(String searchPattern) {
        if (super.matches(searchPattern)) {
            return true;
        }
        for (DownloadFile file : this.getFiles()) {
            if (!StringUtils.containsAnyIgnoreCase((CharSequence)file.getName(), (CharSequence[])new CharSequence[]{searchPattern})) continue;
            return true;
        }
        return false;
    }

    public DownloadType getDownloadType() {
        return this.downloadType;
    }

    public void setDownloadType(DownloadType downloadType) {
        this.downloadType = downloadType;
    }

    public List<DownloadFile> getFiles() {
        return this.files;
    }

    public void setFiles(List<DownloadFile> files) {
        this.files = files;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public void setHomepage(String homepage) {
        this.homepage = homepage;
    }

    public static class DownloadFile {
        private String name;
        private String url;
        private String fileName;
        private FileType fileType;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public FileType getFileType() {
            return this.fileType;
        }

        public void setFileType(FileType fileType) {
            this.fileType = fileType;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }
    }

    public static enum FileType {
        DMG,
        PKG,
        MSI,
        ZIP,
        TXT,
        EXE,
        RPM,
        DEB,
        JAR;

    }

    public static enum DownloadType {
        APPLICATION,
        PRESENTATION,
        DOCUMENTATION;

    }
}

