/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.jfxcentral.data.model;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public abstract class ModelObject {
    private String id;
    private String name;
    private String summary;
    private String description;
    private LocalDate createdOn;
    private LocalDate modifiedOn;
    private String tags;
    private String canonicalUrl;
    private boolean hide;
    private List<String> personIds = new ArrayList<String>();
    private List<String> tutorialIds = new ArrayList<String>();
    private List<String> toolIds = new ArrayList<String>();
    private List<String> utilityIds = new ArrayList<String>();
    private List<String> libraryIds = new ArrayList<String>();
    private List<String> bookIds = new ArrayList<String>();
    private List<String> companyIds = new ArrayList<String>();
    private List<String> downloadIds = new ArrayList<String>();
    private List<String> videoIds = new ArrayList<String>();
    private List<String> appIds = new ArrayList<String>();
    private List<String> blogIds = new ArrayList<String>();
    private List<String> tipIds = new ArrayList<String>();
    private List<String> linksOfTheWeekIds = new ArrayList<String>();
    private List<String> ikonliPackIds = new ArrayList<String>();
    private List<String> memberIds = new ArrayList<String>();
    private List<String> documentationIds = new ArrayList<String>();
    private List<String> learnJavaFXIds = new ArrayList<String>();
    private List<String> learnMobileIds = new ArrayList<String>();
    private List<String> learnRaspberryPiIds = new ArrayList<String>();
    private List<String> newsIds = new ArrayList<String>();

    protected ModelObject() {
    }

    public boolean matches(String searchPattern) {
        if (this.tagsMatch(searchPattern)) {
            return true;
        }
        if (StringUtils.containsAnyIgnoreCase((CharSequence)this.getName(), (CharSequence[])new CharSequence[]{searchPattern})) {
            return true;
        }
        if (StringUtils.containsAnyIgnoreCase((CharSequence)this.getSummary(), (CharSequence[])new CharSequence[]{searchPattern})) {
            return true;
        }
        if (StringUtils.containsAnyIgnoreCase((CharSequence)this.getSummary(), (CharSequence[])new CharSequence[]{searchPattern})) {
            return true;
        }
        return StringUtils.containsAnyIgnoreCase((CharSequence)this.getDescription(), (CharSequence[])new CharSequence[]{searchPattern});
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public boolean isHide() {
        return this.hide;
    }

    public void setHide(boolean hide) {
        this.hide = hide;
    }

    protected boolean tagsMatch(String searchPattern) {
        if (StringUtils.isNotBlank((CharSequence)this.tags)) {
            StringTokenizer st = new StringTokenizer(this.getTags(), ",");
            while (st.hasMoreTokens()) {
                String tag = st.nextToken().trim();
                if (!StringUtils.containsAnyIgnoreCase((CharSequence)tag, (CharSequence[])new CharSequence[]{searchPattern})) continue;
                return true;
            }
        }
        return false;
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public String getCanonicalUrl() {
        return this.canonicalUrl;
    }

    public void setCanonicalUrl(String canonicalUrl) {
        this.canonicalUrl = canonicalUrl;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public LocalDate getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(LocalDate createdOn) {
        this.createdOn = createdOn;
    }

    public LocalDate getModifiedOn() {
        return this.modifiedOn;
    }

    public void setModifiedOn(LocalDate modifiedOn) {
        this.modifiedOn = modifiedOn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelObject that = (ModelObject)o;
        return new EqualsBuilder().append((Object)this.id, (Object)that.id).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.id).toHashCode();
    }

    public List<String> getMemberIds() {
        return this.memberIds;
    }

    public void setMemberIds(List<String> memberIds) {
        this.memberIds = memberIds;
    }

    public List<String> getPersonIds() {
        return this.personIds;
    }

    public void setPersonIds(List<String> personIds) {
        this.personIds = personIds;
    }

    public List<String> getTutorialIds() {
        return this.tutorialIds;
    }

    public void setTutorialIds(List<String> tutorialIds) {
        this.tutorialIds = tutorialIds;
    }

    public List<String> getToolIds() {
        return this.toolIds;
    }

    public void setToolIds(List<String> toolIds) {
        this.toolIds = toolIds;
    }

    public List<String> getUtilityIds() {
        return this.utilityIds;
    }

    public void setUtilityIds(List<String> utilityIds) {
        this.utilityIds = utilityIds;
    }

    public List<String> getLibraryIds() {
        return this.libraryIds;
    }

    public void setLibraryIds(List<String> libraryIds) {
        this.libraryIds = libraryIds;
    }

    public List<String> getBookIds() {
        return this.bookIds;
    }

    public void setBookIds(List<String> bookIds) {
        this.bookIds = bookIds;
    }

    public List<String> getCompanyIds() {
        return this.companyIds;
    }

    public void setCompanyIds(List<String> companyIds) {
        this.companyIds = companyIds;
    }

    public List<String> getDownloadIds() {
        return this.downloadIds;
    }

    public void setDownloadIds(List<String> downloadIds) {
        this.downloadIds = downloadIds;
    }

    public List<String> getVideoIds() {
        return this.videoIds;
    }

    public void setVideoIds(List<String> videoIds) {
        this.videoIds = videoIds;
    }

    public List<String> getAppIds() {
        return this.appIds;
    }

    public void setAppIds(List<String> appIds) {
        this.appIds = appIds;
    }

    public List<String> getNewsIds() {
        return this.newsIds;
    }

    public void setNewsIds(List<String> newsIds) {
        this.newsIds = newsIds;
    }

    public List<String> getBlogIds() {
        return this.blogIds;
    }

    public void setBlogIds(List<String> blogIds) {
        this.blogIds = blogIds;
    }

    public List<String> getTipIds() {
        return this.tipIds;
    }

    public void setTipIds(List<String> tipIds) {
        this.tipIds = tipIds;
    }

    public List<String> getLinksOfTheWeekIds() {
        return this.linksOfTheWeekIds;
    }

    public void setLinksOfTheWeekIds(List<String> linksOfTheWeekIds) {
        this.linksOfTheWeekIds = linksOfTheWeekIds;
    }

    public List<String> getIkonliPackIds() {
        return this.ikonliPackIds;
    }

    public void setIkonliPackIds(List<String> ikonliPackIds) {
        this.ikonliPackIds = ikonliPackIds;
    }

    public List<String> getDocumentationIds() {
        return this.documentationIds;
    }

    public void setDocumentationIds(List<String> documentationIds) {
        this.documentationIds = documentationIds;
    }

    public List<String> getLearnJavaFXIds() {
        return this.learnJavaFXIds;
    }

    public void setLearnJavaFXIds(List<String> learnJavaFXIds) {
        this.learnJavaFXIds = learnJavaFXIds;
    }

    public List<String> getLearnMobileIds() {
        return this.learnMobileIds;
    }

    public void setLearnMobileIds(List<String> learnMobileIds) {
        this.learnMobileIds = learnMobileIds;
    }

    public List<String> getLearnRaspberryPiIds() {
        return this.learnRaspberryPiIds;
    }

    public void setLearnRaspberryPiIds(List<String> learnRaspberryPiIds) {
        this.learnRaspberryPiIds = learnRaspberryPiIds;
    }

    public LocalDate getCreationOrUpdateDate() {
        LocalDate modifiedOn = this.getModifiedOn();
        if (modifiedOn != null) {
            return modifiedOn;
        }
        LocalDate createdOn = this.getCreatedOn();
        if (createdOn != null) {
            return createdOn;
        }
        return LocalDate.MIN;
    }
}

